/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.configurations;

import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.ultimate.JavaProfilerConfigurationsMigrator;
import com.intellij.profiler.ultimate.async.configurations.AsyncProfilerConfigurationState;
import com.intellij.profiler.ultimate.jfr.configuration.JFRConfigurationState;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/intellij/profiler/ultimate/configurations/IntellijProfilerConfigurationsMigrator;", "Lcom/intellij/profiler/ultimate/JavaProfilerConfigurationsMigrator;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "obsoleteConfigurationTypeIds", "", "getObsoleteConfigurationTypeIds", "()Ljava/util/Set;", "languageSettingsGroup", "getLanguageSettingsGroup", "indexNumber", "", "getIndexNumber", "()I", "shouldMigrate", "", "configurationState", "Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "doMigrateState", "intellij.profiler.ultimate"})
public final class IntellijProfilerConfigurationsMigrator
extends JavaProfilerConfigurationsMigrator {
    @NotNull
    private final String name;
    @NotNull
    private final Set<String> obsoleteConfigurationTypeIds = SetsKt.emptySet();
    @NotNull
    private final String languageSettingsGroup;
    private final int indexNumber;

    public IntellijProfilerConfigurationsMigrator() {
        this.name = "Async Profiler/JFR -> IntelliJ migrator";
        this.languageSettingsGroup = "Java Profiler Configuration Type";
        this.indexNumber = 3;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Set<String> getObsoleteConfigurationTypeIds() {
        return this.obsoleteConfigurationTypeIds;
    }

    @NotNull
    public String getLanguageSettingsGroup() {
        return this.languageSettingsGroup;
    }

    public int getIndexNumber() {
        return this.indexNumber;
    }

    @Override
    public boolean shouldMigrate(@NotNull ProfilerConfigurationState configurationState) {
        Intrinsics.checkNotNullParameter((Object)configurationState, (String)"configurationState");
        return configurationState instanceof AsyncProfilerConfigurationState || configurationState instanceof JFRConfigurationState;
    }

    @Override
    @NotNull
    public ProfilerConfigurationState doMigrateState(@NotNull ProfilerConfigurationState configurationState) {
        Intrinsics.checkNotNullParameter((Object)configurationState, (String)"configurationState");
        return configurationState;
    }
}

