/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.debug;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerActionListener;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.idea.AppMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemProcessHandler;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.profiler.ProfilerManager;
import com.intellij.profiler.WithFixAction;
import com.intellij.profiler.WithUserFriendlyMessage;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ultimate.ProfilerProcessCommunicator;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.async.AgentConfiguration;
import com.intellij.profiler.ultimate.async.AsyncProfilerConfigurationExtensionBase;
import com.intellij.profiler.ultimate.async.AsyncProfilerConfigurationExtensionBaseKt;
import com.intellij.profiler.ultimate.async.AsyncProfilerProcess;
import com.intellij.profiler.ultimate.async.UtilsKt;
import com.intellij.profiler.ultimate.async.configurations.AgentOptions;
import com.intellij.profiler.ultimate.async.configurations.AsyncProfilerConfigurationStateBase;
import com.intellij.profiler.ultimate.debug.ProfileOnRunToCursorListener;
import com.intellij.profiler.ultimate.debug.ProfileOnRunToCursorStateObserver;
import com.intellij.profiler.ultimate.debug.ProfilerOnDebugConfigurationState;
import com.intellij.util.system.CpuArch;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u00015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\u001e\u0010\u000e\u001a\u00020\b2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u0011\u001a\u00020\b*\u0006\u0012\u0002\b\u00030\u0010H\u0002J\"\u0010\u0012\u001a\u00020\b*\u0006\u0012\u0002\b\u00030\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\b*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J3\u0010\u001b\u001a\u00020\u001c\"\f\b\u0000\u0010\u001d*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u001e\u001a\u0002H\u001d2\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0014\u00a2\u0006\u0002\u0010\"J\u0018\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J,\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010.\u001a\u00020/H\u0014J\f\u00100\u001a\u00020\b*\u00020\u0007H\u0002R9\u0010\u0004\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b \t*\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\u0002028TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u00066"}, d2={"Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension;", "Lcom/intellij/profiler/ultimate/async/AsyncProfilerConfigurationExtensionBase;", "<init>", "()V", "JVM_IS_SUPPORTED_KEY", "Lcom/intellij/openapi/util/Key;", "Lkotlin/Pair;", "", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "isApplicableFor", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "isEnabledFor", "applicableConfiguration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "isSupportedJdk", "unsupportedJdk", "jdkHome", "reason", "Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason;", "supportedJdk", "getSettings", "Lcom/intellij/profiler/ultimate/async/configurations/AsyncProfilerConfigurationStateBase;", "executor", "Lcom/intellij/execution/Executor;", "doUpdateJavaParameters", "", "T", "configuration", "settings", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/profiler/ultimate/async/configurations/AsyncProfilerConfigurationStateBase;Lcom/intellij/execution/configurations/JavaParameters;)V", "showNotification", "project", "Lcom/intellij/openapi/project/Project;", "throwable", "", "attachToProcess", "profilerConfigurationState", "Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "profilerParameters", "Lcom/intellij/profiler/ultimate/async/AgentConfiguration;", "runConfiguration", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "containsInfoAboutIncorrectArchitecture", "mainCommand", "Lcom/intellij/profiler/ultimate/async/configurations/AgentOptions$MainCommand;", "getMainCommand", "()Lcom/intellij/profiler/ultimate/async/configurations/AgentOptions$MainCommand;", "UnsupportedJvmReason", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nIntelliJProfilerOnDebugExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntelliJProfilerOnDebugExtension.kt\ncom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,184:1\n13#2:185\n13#2:186\n*S KotlinDebug\n*F\n+ 1 IntelliJProfilerOnDebugExtension.kt\ncom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension\n*L\n74#1:185\n160#1:186\n*E\n"})
public final class IntelliJProfilerOnDebugExtension
extends AsyncProfilerConfigurationExtensionBase {
    @NotNull
    private final Key<Pair<String, Boolean>> JVM_IS_SUPPORTED_KEY;

    public IntelliJProfilerOnDebugExtension() {
        Key key = Key.create((String)"JvmIsSupportedToProfileOnDebug");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.JVM_IS_SUPPORTED_KEY = key;
    }

    @Override
    protected boolean isApplicableFor(@Nullable RunnerSettings runnerSettings) {
        return !AppMode.isRemoteDevHost() && ProfileOnRunToCursorStateObserver.Companion.getInstance().getEnabled() && runnerSettings instanceof GenericDebuggerRunnerSettings;
    }

    public boolean isEnabledFor(@NotNull RunConfigurationBase<?> applicableConfiguration, @Nullable RunnerSettings runnerSettings) {
        Intrinsics.checkNotNullParameter(applicableConfiguration, (String)"applicableConfiguration");
        return ProfileOnRunToCursorStateObserver.Companion.getInstance().getEnabled() && runnerSettings instanceof GenericDebuggerRunnerSettings && this.isApplicableFor(applicableConfiguration) && applicableConfiguration instanceof CommonJavaRunConfigurationParameters && !UtilsKt.willRunOnTarget((RunProfile)applicableConfiguration) && this.isSupportedJdk(applicableConfiguration);
    }

    private final boolean isSupportedJdk(RunConfigurationBase<?> $this$isSupportedJdk) {
        boolean bl;
        CpuArch arch;
        String jdkHome = AsyncProfilerConfigurationExtensionBaseKt.getJdkHome($this$isSupportedJdk);
        Pair pair = (Pair)$this$isSupportedJdk.getUserData(this.JVM_IS_SUPPORTED_KEY);
        if (pair != null) {
            Pair pair2 = pair;
            boolean bl2 = false;
            String cachedJdkHome = (String)pair2.component1();
            boolean isSupported = (Boolean)pair2.component2();
            if (Intrinsics.areEqual((Object)cachedJdkHome, (Object)jdkHome)) {
                return isSupported;
            }
            Pair cfr_ignored_0 = (Pair)RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)$this$isSupportedJdk), this.JVM_IS_SUPPORTED_KEY);
        }
        CharSequence charSequence = jdkHome;
        if (charSequence == null || charSequence.length() == 0) {
            return this.unsupportedJdk($this$isSupportedJdk, jdkHome, UnsupportedJvmReason.HomeNotFound.INSTANCE);
        }
        JdkVersionDetector.JdkVersionInfo version = SdkVersionUtil.getJdkVersionInfo((String)jdkHome);
        if (version == null) {
            return this.unsupportedJdk($this$isSupportedJdk, jdkHome, UnsupportedJvmReason.CantDetect.INSTANCE);
        }
        if (AsyncProfilerConfigurationExtensionBaseKt.isOpenJ9(version)) {
            return this.unsupportedJdk($this$isSupportedJdk, jdkHome, UnsupportedJvmReason.OpenJ9.INSTANCE);
        }
        CpuArch cpuArch = arch = version.arch;
        switch (cpuArch == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cpuArch.ordinal()]) {
            case 1: 
            case 2: {
                if (SystemInfo.isWindows && CpuArch.isArm64() && arch == CpuArch.X86_64) {
                    return this.unsupportedJdk($this$isSupportedJdk, jdkHome, UnsupportedJvmReason.X86OnWindowsArm.INSTANCE);
                }
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(IntelliJProfilerOnDebugExtension.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Detected JDK with a 64-bit architecture '" + arch + "'. Profiling will be turned on.");
                bl = this.supportedJdk($this$isSupportedJdk, jdkHome);
                break;
            }
            default: {
                Intrinsics.checkNotNull((Object)arch);
                bl = this.unsupportedJdk($this$isSupportedJdk, jdkHome, new UnsupportedJvmReason.UnsupportedArchitecture(arch));
            }
        }
        return bl;
    }

    private final boolean unsupportedJdk(RunConfigurationBase<?> $this$unsupportedJdk, String jdkHome, UnsupportedJvmReason reason) {
        reason.log();
        String string = jdkHome;
        if (string == null) {
            string = "";
        }
        $this$unsupportedJdk.putUserData(this.JVM_IS_SUPPORTED_KEY, (Object)TuplesKt.to((Object)string, (Object)false));
        UnsupportedJvmReason unsupportedJvmReason = reason;
        CpuArch arch = unsupportedJvmReason instanceof UnsupportedJvmReason.UnsupportedArchitecture ? ((UnsupportedJvmReason.UnsupportedArchitecture)reason).getCpuArch() : (unsupportedJvmReason instanceof UnsupportedJvmReason.X86OnWindowsArm ? CpuArch.X86_64 : CpuArch.UNKNOWN);
        ProfilerUsageTriggerCollector.INSTANCE.logAutoDisableProfileDuringRunToCursor($this$unsupportedJdk.getProject(), arch);
        ProfileOnRunToCursorStateObserver.Companion.getInstance().disableRecording();
        return false;
    }

    private final boolean supportedJdk(RunConfigurationBase<?> $this$supportedJdk, String jdkHome) {
        $this$supportedJdk.putUserData(this.JVM_IS_SUPPORTED_KEY, (Object)TuplesKt.to((Object)jdkHome, (Object)true));
        return true;
    }

    @Override
    @NotNull
    protected AsyncProfilerConfigurationStateBase getSettings(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        return new ProfilerOnDebugConfigurationState();
    }

    @Override
    protected <T extends RunConfigurationBase<?>> void doUpdateJavaParameters(@NotNull T configuration, @NotNull AsyncProfilerConfigurationStateBase settings, @NotNull JavaParameters params) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        try {
            super.doUpdateJavaParameters(configuration, settings, params);
        }
        catch (Throwable t) {
            Project project = configuration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            this.showNotification(project, t);
        }
    }

    private final void showNotification(Project project, Throwable throwable) {
        Object[] objectArray;
        String message = throwable instanceof WithUserFriendlyMessage ? ((WithUserFriendlyMessage)throwable).getUserFriendlyMessage() : throwable.getMessage();
        Object[] $this$showNotification_u24lambda_u240 = objectArray = CollectionsKt.createListBuilder();
        boolean bl = false;
        AnAction anAction = ActionManager.getInstance().getAction("profiler.DisableProfileOnRunToCursor");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.project.DumbAwareAction");
        $this$showNotification_u24lambda_u240.add((DumbAwareAction)anAction);
        if (throwable instanceof WithFixAction) {
            DumbAwareAction dumbAwareAction = DumbAwareAction.create((String)((WithFixAction)throwable).getFixActionName(), arg_0 -> IntelliJProfilerOnDebugExtension.showNotification$lambda$0$1(arg_0 -> IntelliJProfilerOnDebugExtension.showNotification$lambda$0$0(throwable, project, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction, (String)"create(...)");
            $this$showNotification_u24lambda_u240.add(dumbAwareAction);
        }
        List actions = CollectionsKt.build((List)objectArray);
        objectArray = new Object[1];
        String string = message;
        if (string == null) {
            string = UltimateProfilerBundleKt.profilerMessage("profiler.cant.attach.unknown.reason", new Object[0]);
        }
        objectArray[0] = string;
        ProfilerManager.INSTANCE.showStickyWarning(UltimateProfilerBundleKt.profilerMessage("action.profiler.profileOnRunToCursor.cant.start.message", objectArray), project, (Collection)actions);
    }

    @Override
    protected void attachToProcess(@NotNull ProfilerConfigurationState profilerConfigurationState, @NotNull AgentConfiguration profilerParameters, @NotNull RunConfigurationBase<?> runConfiguration, @NotNull ProcessHandler handler) {
        Intrinsics.checkNotNullParameter((Object)profilerConfigurationState, (String)"profilerConfigurationState");
        Intrinsics.checkNotNullParameter((Object)profilerParameters, (String)"profilerParameters");
        Intrinsics.checkNotNullParameter(runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        if (handler instanceof ExternalSystemProcessHandler) {
            return;
        }
        if (!(handler instanceof OSProcessHandler)) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(IntelliJProfilerOnDebugExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("unexpected process handler: '" + handler + "'");
            throw new ExecutionException(UltimateProfilerBundleKt.profilerMessage("profiler.exception.cant.start", new Object[0]));
        }
        ProfilerProcessCommunicator communicator = UtilsKt.doCreateProfilerCommunicator$default(runConfiguration, (OSProcessHandler)handler, null, 4, null);
        Project project = runConfiguration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        AsyncProfilerProcess process = new AsyncProfilerProcess(project, communicator, profilerConfigurationState, profilerParameters, System.currentTimeMillis());
        ProfileOnRunToCursorListener listener = new ProfileOnRunToCursorListener(process);
        handler.addProcessListener((ProcessListener)new ProcessAdapter(this, runConfiguration){
            final /* synthetic */ IntelliJProfilerOnDebugExtension this$0;
            final /* synthetic */ RunConfigurationBase<?> $runConfiguration;
            {
                this.this$0 = $receiver;
                this.$runConfiguration = $runConfiguration;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                if (outputType == ProcessOutputType.STDERR) {
                    String string = event.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    if (IntelliJProfilerOnDebugExtension.access$containsInfoAboutIncorrectArchitecture(this.this$0, string)) {
                        ProfilerManager.showStickyError$default((ProfilerManager)ProfilerManager.INSTANCE, (String)UltimateProfilerBundleKt.profilerMessage("action.profiler.profileOnRunToCursor.disabled", new Object[0]), (Project)this.$runConfiguration.getProject(), null, (int)4, null);
                    }
                }
                super.onTextAvailable(event, outputType);
            }
        });
        RunConfigurationBase<?> $this$attachToProcess_u24lambda_u240 = runConfiguration;
        boolean bl = false;
        DebuggerManager.getInstance((Project)$this$attachToProcess_u24lambda_u240.getProject()).addDebugProcessListener(handler, (DebugProcessListener)listener);
        $this$attachToProcess_u24lambda_u240.getProject().getMessageBus().connect((Disposable)process).subscribe(DebuggerActionListener.TOPIC, (Object)listener);
    }

    private final boolean containsInfoAboutIncorrectArchitecture(String $this$containsInfoAboutIncorrectArchitecture) {
        return StringsKt.contains$default((CharSequence)$this$containsInfoAboutIncorrectArchitecture, (CharSequence)"32-bit platform", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)$this$containsInfoAboutIncorrectArchitecture, (CharSequence)"libasyncProfiler", (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    protected AgentOptions.MainCommand getMainCommand() {
        return AgentOptions.MainCommand.Version.INSTANCE;
    }

    private static final Unit showNotification$lambda$0$0(Throwable $throwable, Project $project, AnActionEvent it) {
        ((WithFixAction)$throwable).fixAction($project);
        return Unit.INSTANCE;
    }

    private static final void showNotification$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$containsInfoAboutIncorrectArchitecture(IntelliJProfilerOnDebugExtension $this, String $receiver) {
        return $this.containsInfoAboutIncorrectArchitecture($receiver);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0005\n\u000b\f\r\u000eB\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0005\u000f\u0010\u0011\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason;", "", "logMessage", "", "<init>", "(Ljava/lang/String;)V", "getLogMessage", "()Ljava/lang/String;", "log", "", "HomeNotFound", "CantDetect", "UnsupportedArchitecture", "X86OnWindowsArm", "OpenJ9", "Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason$CantDetect;", "Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason$HomeNotFound;", "Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason$OpenJ9;", "Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason$UnsupportedArchitecture;", "Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason$X86OnWindowsArm;", "intellij.profiler.ultimate"})
    @SourceDebugExtension(value={"SMAP\nIntelliJProfilerOnDebugExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntelliJProfilerOnDebugExtension.kt\ncom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,184:1\n13#2:185\n*S KotlinDebug\n*F\n+ 1 IntelliJProfilerOnDebugExtension.kt\ncom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason\n*L\n180#1:185\n*E\n"})
    private static abstract sealed class UnsupportedJvmReason {
        @NotNull
        private final String logMessage;

        private UnsupportedJvmReason(String logMessage) {
            this.logMessage = logMessage;
        }

        @NotNull
        public final String getLogMessage() {
            return this.logMessage;
        }

        public final void log() {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(IntelliJProfilerOnDebugExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn(this.logMessage + "; disabling profiling to prevent possible debug sessions crashes");
        }

        public /* synthetic */ UnsupportedJvmReason(String logMessage, DefaultConstructorMarker $constructor_marker) {
            this(logMessage);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason$CantDetect;", "Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason;", "<init>", "()V", "intellij.profiler.ultimate"})
        public static final class CantDetect
        extends UnsupportedJvmReason {
            @NotNull
            public static final CantDetect INSTANCE = new CantDetect();

            private CantDetect() {
                super("Couldn't detect configuration JDK architecture", null);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason$HomeNotFound;", "Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason;", "<init>", "()V", "intellij.profiler.ultimate"})
        public static final class HomeNotFound
        extends UnsupportedJvmReason {
            @NotNull
            public static final HomeNotFound INSTANCE = new HomeNotFound();

            private HomeNotFound() {
                super("Couldn't detect configuration JDK", null);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason$OpenJ9;", "Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason;", "<init>", "()V", "intellij.profiler.ultimate"})
        public static final class OpenJ9
        extends UnsupportedJvmReason {
            @NotNull
            public static final OpenJ9 INSTANCE = new OpenJ9();

            private OpenJ9() {
                super("Profiling with OpenJ9 is not supported", null);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason$UnsupportedArchitecture;", "Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason;", "cpuArch", "Lcom/intellij/util/system/CpuArch;", "<init>", "(Lcom/intellij/util/system/CpuArch;)V", "getCpuArch", "()Lcom/intellij/util/system/CpuArch;", "intellij.profiler.ultimate"})
        public static final class UnsupportedArchitecture
        extends UnsupportedJvmReason {
            @NotNull
            private final CpuArch cpuArch;

            public UnsupportedArchitecture(@NotNull CpuArch cpuArch) {
                Intrinsics.checkNotNullParameter((Object)cpuArch, (String)"cpuArch");
                super("Unsupported configuration JDK architecture: " + cpuArch, null);
                this.cpuArch = cpuArch;
            }

            @NotNull
            public final CpuArch getCpuArch() {
                return this.cpuArch;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason$X86OnWindowsArm;", "Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason;", "<init>", "()V", "intellij.profiler.ultimate"})
        public static final class X86OnWindowsArm
        extends UnsupportedJvmReason {
            @NotNull
            public static final X86OnWindowsArm INSTANCE = new X86OnWindowsArm();

            private X86OnWindowsArm() {
                super("X86 JDKs in compatibility mode are not supported on Windows on ARM", null);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CpuArch.values().length];
            try {
                nArray[CpuArch.X86_64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.ARM64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

