/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profiler.actions.ImportProfilerResultAction;
import com.intellij.profiler.api.ProfilerDumpParserProvider;
import com.intellij.profiler.statistics.SnapshotImportEventData;
import com.intellij.profiler.statistics.SnapshotImportOrigin;
import com.intellij.profiler.statistics.SnapshotImportSource;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.hprof.HProfDumpParserProvider;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ultimate/hprof/OpenHprofDumpAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.profiler.ultimate"})
public final class OpenHprofDumpAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor().withHideIgnored(false).withTitle(UltimateProfilerBundleKt.profilerMessage("action.hprof-viewer.text", new Object[0]));
        VirtualFile virtualFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project2, null);
        if (virtualFile == null) {
            return;
        }
        VirtualFile vFile = virtualFile;
        File file = new File(vFile.getPath());
        ProfilerDumpParserProvider profilerDumpParserProvider = (ProfilerDumpParserProvider)new HProfDumpParserProvider();
        String string = e.getPlace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlace(...)");
        ImportProfilerResultAction.Companion.importProfilerDump(project2, file, profilerDumpParserProvider, null, null, new SnapshotImportEventData(SnapshotImportOrigin.OPEN_FILE, (SnapshotImportSource)new SnapshotImportSource.DedicatedActionPlace(string)));
    }
}

