/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.welcome.actions;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.ProfilerManager;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.api.monitor.JavaProcessMonitor;
import com.intellij.profiler.ultimate.JavaTargetProcess;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.threadDumpParser.ThreadDumpParser;
import com.intellij.unscramble.ThreadDumpPanel;
import com.intellij.util.text.DateFormatUtil;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\n"}, d2={"Lcom/intellij/profiler/ultimate/welcome/actions/DumpThreads;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getJavaProcess", "Lcom/intellij/profiler/ultimate/JavaTargetProcess;", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nDumpThreads.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumpThreads.kt\ncom/intellij/profiler/ultimate/welcome/actions/DumpThreads\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,40:1\n1#2:41\n*E\n"})
public abstract class DumpThreads
extends DumbAwareAction {
    public DumpThreads() {
        super(DumpThreads::_init_$lambda$0);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        JavaTargetProcess javaTargetProcess = this.getJavaProcess(e);
        if (javaTargetProcess == null) {
            return;
        }
        JavaTargetProcess process = javaTargetProcess;
        ApplicationManager.getApplication().executeOnPooledThread(() -> DumpThreads.actionPerformed$lambda$0(process, project2, e));
    }

    @Nullable
    public abstract JavaTargetProcess getJavaProcess(@NotNull AnActionEvent var1);

    private static final String _init_$lambda$0() {
        return UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.charts.dumpThreads", new Object[0]);
    }

    private static final void actionPerformed$lambda$0$0(Project $project, List $list, AnActionEvent $e, JavaTargetProcess $process) {
        ThreadDumpPanel dumpPanel = new ThreadDumpPanel($project, (ConsoleView)new ConsoleViewImpl($project, true), new DefaultActionGroup(), $list);
        String string = DateFormatUtil.formatDateTime((long)System.currentTimeMillis());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDateTime(...)");
        String time = string;
        Project project = $e.getProject();
        Intrinsics.checkNotNull((Object)project);
        Object[] objectArray = new Object[]{$process.getShortName() + " " + time};
        ProfilerToolWindowManager.Companion.getInstance(project).addTab((JComponent)dumpPanel, UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.threads.tab.text", objectArray));
    }

    private static final void actionPerformed$lambda$0(JavaTargetProcess $process, Project $project, AnActionEvent $e) {
        List list;
        try {
            String p0 = JavaProcessMonitor.Companion.connect($process.getProcessInfo()).dumpThreads();
            boolean bl = false;
            list = ThreadDumpParser.parse((String)p0);
        }
        catch (Throwable exception) {
            Object[] objectArray = new Object[]{$process.getFullName()};
            ProfilerManager.showStickyError$default((ProfilerManager)ProfilerManager.INSTANCE, (String)UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.processes.get.thread.dump.error", objectArray), (Project)$project, null, (int)4, null);
            return;
        }
        List list2 = list;
        Intrinsics.checkNotNull((Object)list2);
        List list3 = list2;
        ApplicationManager.getApplication().invokeLater(() -> DumpThreads.actionPerformed$lambda$0$0($project, list3, $e, $process));
    }
}

