/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.uast.analysis;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.analysis.Dependency;
import org.jetbrains.uast.analysis.DependencyGraphBuilder;
import org.jetbrains.uast.analysis.DependencyGraphUtilsKt;
import org.jetbrains.uast.analysis.Dependent;
import org.jetbrains.uast.analysis.UScopeObjectsState;
import org.jetbrains.uast.analysis.UastLocalUsageDependencyGraphKt;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B[\b\u0002\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00050\u0003\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eR#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R#\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/uast/analysis/UastLocalUsageDependencyGraph;", "", "dependents", "", "Lorg/jetbrains/uast/UElement;", "", "Lorg/jetbrains/uast/analysis/Dependent;", "dependencies", "Lorg/jetbrains/uast/analysis/Dependency;", "scopesObjectsStates", "Lorg/jetbrains/uast/analysis/UScopeObjectsState;", "psiAnchor", "Lcom/intellij/psi/PsiElement;", "<init>", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Lcom/intellij/psi/PsiElement;)V", "getDependents", "()Ljava/util/Map;", "getDependencies", "getScopesObjectsStates", "uAnchor", "getUAnchor", "()Lorg/jetbrains/uast/UElement;", "Companion", "MethodAndCallerMaps", "intellij.platform.uast.ide"})
@ApiStatus.Experimental
public final class UastLocalUsageDependencyGraph {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<UElement, Set<Dependent>> dependents;
    @NotNull
    private final Map<UElement, Set<Dependency>> dependencies;
    @NotNull
    private final Map<UElement, UScopeObjectsState> scopesObjectsStates;
    @Nullable
    private final PsiElement psiAnchor;
    @NotNull
    private static final Key<CachedValue<UastLocalUsageDependencyGraph>> DEPENDENCY_GRAPH_KEY;

    private UastLocalUsageDependencyGraph(Map<UElement, ? extends Set<? extends Dependent>> dependents, Map<UElement, ? extends Set<? extends Dependency>> dependencies, Map<UElement, UScopeObjectsState> scopesObjectsStates, PsiElement psiAnchor) {
        this.dependents = dependents;
        this.dependencies = dependencies;
        this.scopesObjectsStates = scopesObjectsStates;
        this.psiAnchor = psiAnchor;
    }

    @NotNull
    public final Map<UElement, Set<Dependent>> getDependents() {
        return this.dependents;
    }

    @NotNull
    public final Map<UElement, Set<Dependency>> getDependencies() {
        return this.dependencies;
    }

    @NotNull
    public final Map<UElement, UScopeObjectsState> getScopesObjectsStates() {
        return this.scopesObjectsStates;
    }

    @Nullable
    public final UElement getUAnchor() {
        return UastContextKt.toUElement((PsiElement)this.psiAnchor);
    }

    @JvmStatic
    @Nullable
    public static final UastLocalUsageDependencyGraph getGraphByUElement(@NotNull UElement element) {
        return Companion.getGraphByUElement(element);
    }

    @JvmStatic
    @Nullable
    public static final UastLocalUsageDependencyGraph connectMethodWithCaller(@NotNull UMethod method, @NotNull UastLocalUsageDependencyGraph callerGraph, @NotNull UCallExpression uCallExpression) {
        return Companion.connectMethodWithCaller(method, callerGraph, uCallExpression);
    }

    public /* synthetic */ UastLocalUsageDependencyGraph(Map dependents, Map dependencies, Map scopesObjectsStates, PsiElement psiAnchor, DefaultConstructorMarker $constructor_marker) {
        this(dependents, dependencies, scopesObjectsStates, psiAnchor);
    }

    static {
        Key key = Key.create((String)"uast.local.dependency.graph");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        DEPENDENCY_GRAPH_KEY = key;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\"\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R-\u0010\u0004\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007 \b*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/uast/analysis/UastLocalUsageDependencyGraph$Companion;", "", "<init>", "()V", "DEPENDENCY_GRAPH_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "Lorg/jetbrains/uast/analysis/UastLocalUsageDependencyGraph;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getGraphByUElement", "element", "Lorg/jetbrains/uast/UElement;", "buildFromElement", "connectMethodWithCaller", "method", "Lorg/jetbrains/uast/UMethod;", "callerGraph", "uCallExpression", "Lorg/jetbrains/uast/UCallExpression;", "intellij.platform.uast.ide"})
    @SourceDebugExtension(value={"SMAP\nUastLocalUsageDependencyGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UastLocalUsageDependencyGraph.kt\norg/jetbrains/uast/analysis/UastLocalUsageDependencyGraph$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,328:1\n23#2:329\n60#2,5:330\n60#2,5:335\n60#2,5:340\n60#2,5:345\n1606#3:350\n1617#3:351\n1924#3,2:352\n1926#3:356\n1618#3:357\n1#4:354\n1#4:355\n*S KotlinDebug\n*F\n+ 1 UastLocalUsageDependencyGraph.kt\norg/jetbrains/uast/analysis/UastLocalUsageDependencyGraph$Companion\n*L\n64#1:329\n65#1:330,5\n69#1:335,5\n65#1:340,5\n69#1:345,5\n88#1:350\n88#1:351\n88#1:352,2\n88#1:356\n88#1:357\n88#1:355\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final UastLocalUsageDependencyGraph getGraphByUElement(@NotNull UElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement psiElement = element.getSourcePsi();
            if (psiElement == null) {
                return null;
            }
            PsiElement sourcePsi = psiElement;
            return (UastLocalUsageDependencyGraph)CachedValuesManager.getCachedValue((PsiElement)sourcePsi, (Key)DEPENDENCY_GRAPH_KEY, () -> Companion.getGraphByUElement$lambda$0(sourcePsi));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final UastLocalUsageDependencyGraph buildFromElement(UElement element) {
            DependencyGraphBuilder visitor = new DependencyGraphBuilder();
            try {
                element.accept((UastVisitor)visitor);
            }
            finally {
                Logger logger;
                Logger logger2;
                Companion $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger3 = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
                Logger $this$buildFromElement_u24lambda_u240 = logger2 = logger3;
                boolean bl = false;
                Logger $this$debug_u24default$iv = $this$buildFromElement_u24lambda_u240;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv;
                    boolean bl2 = false;
                    logger.debug("graph size: dependants = " + SequencesKt.sumOfInt((Sequence)SequencesKt.map((Sequence)MapsKt.asSequence(visitor.getDependents()), Companion::buildFromElement$lambda$0$0$0)) + ", dependencies = " + SequencesKt.sumOfInt((Sequence)SequencesKt.map((Sequence)MapsKt.asSequence(visitor.getDependencies()), Companion::buildFromElement$lambda$0$0$1)), t$iv);
                }
                $this$debug_u24default$iv = $this$buildFromElement_u24lambda_u240;
                t$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv;
                    boolean bl3 = false;
                    logger.debug("visualisation:\n" + UastLocalUsageDependencyGraphKt.access$dumpDependencies(visitor.getDependencies()), t$iv);
                }
            }
            return new UastLocalUsageDependencyGraph(visitor.getDependents(), visitor.getDependencies(), visitor.getScopesStates(), element.getSourcePsi(), null);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final UastLocalUsageDependencyGraph connectMethodWithCaller(@NotNull UMethod method, @NotNull UastLocalUsageDependencyGraph callerGraph, @NotNull UCallExpression uCallExpression) {
            void $this$mapIndexedNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)callerGraph, (String)"callerGraph");
            Intrinsics.checkNotNullParameter((Object)uCallExpression, (String)"uCallExpression");
            UastLocalUsageDependencyGraph uastLocalUsageDependencyGraph = this.getGraphByUElement((UElement)method);
            if (uastLocalUsageDependencyGraph == null) {
                return null;
            }
            UastLocalUsageDependencyGraph methodGraph = uastLocalUsageDependencyGraph;
            Iterable $this$mapIndexedNotNull$iv = method.getUastParameters();
            boolean $i$f$mapIndexedNotNull = false;
            Iterable iterable = $this$mapIndexedNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapIndexedNotNullTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                Pair pair;
                void element$iv$iv;
                int n;
                if ((n = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl = false;
                UParameter uParameter = (UParameter)element$iv$iv;
                int paramIndex = index$iv$iv;
                boolean bl2 = false;
                if (uCallExpression.getArgumentForParameter(paramIndex) != null) {
                    UExpression it;
                    void param;
                    boolean bl3 = false;
                    pair = TuplesKt.to((Object)param, (Object)it);
                } else {
                    pair = null;
                }
                if (pair == null) continue;
                Pair it$iv$iv = pair;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Map parametersToValues = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            MethodAndCallerMaps methodAndCallerMaps = new MethodAndCallerMaps(method, parametersToValues, methodGraph, callerGraph);
            return new UastLocalUsageDependencyGraph(methodAndCallerMaps.getDependentsMap(), methodAndCallerMaps.getDependenciesMap(), methodGraph.getScopesObjectsStates(), callerGraph.psiAnchor, null);
        }

        private static final CachedValueProvider.Result getGraphByUElement$lambda$0(PsiElement $sourcePsi) {
            Object[] objectArray;
            try {
                UElement uElement = UastContextKt.toUElement((PsiElement)$sourcePsi);
                Intrinsics.checkNotNull((Object)uElement);
                objectArray = Companion.buildFromElement(uElement);
            }
            catch (DependencyGraphBuilder.Companion.BuildOverflowException e) {
                objectArray = null;
            }
            Object[] graph = objectArray;
            objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
            return CachedValueProvider.Result.create((Object)graph, (Object[])objectArray);
        }

        private static final int buildFromElement$lambda$0$0$0(Map.Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
            Set arr = (Set)entry.getValue();
            return arr.size();
        }

        private static final int buildFromElement$lambda$0$0$1(Map.Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
            Set arr = (Set)entry.getValue();
            return arr.size();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u000f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R#\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u000f0\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/uast/analysis/UastLocalUsageDependencyGraph$MethodAndCallerMaps;", "", "method", "Lorg/jetbrains/uast/UMethod;", "argumentValues", "", "Lorg/jetbrains/uast/UParameter;", "Lorg/jetbrains/uast/UExpression;", "methodGraph", "Lorg/jetbrains/uast/analysis/UastLocalUsageDependencyGraph;", "callerGraph", "<init>", "(Lorg/jetbrains/uast/UMethod;Ljava/util/Map;Lorg/jetbrains/uast/analysis/UastLocalUsageDependencyGraph;Lorg/jetbrains/uast/analysis/UastLocalUsageDependencyGraph;)V", "parameterUsagesDependencies", "Lorg/jetbrains/uast/UElement;", "", "Lorg/jetbrains/uast/analysis/Dependency;", "parameterValueDependents", "Lorg/jetbrains/uast/analysis/Dependent;", "dependenciesMap", "getDependenciesMap", "()Ljava/util/Map;", "dependentsMap", "getDependentsMap", "MergedMaps", "intellij.platform.uast.ide"})
    @SourceDebugExtension(value={"SMAP\nUastLocalUsageDependencyGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UastLocalUsageDependencyGraph.kt\norg/jetbrains/uast/analysis/UastLocalUsageDependencyGraph$MethodAndCallerMaps\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,328:1\n383#2,7:329\n*S KotlinDebug\n*F\n+ 1 UastLocalUsageDependencyGraph.kt\norg/jetbrains/uast/analysis/UastLocalUsageDependencyGraph$MethodAndCallerMaps\n*L\n123#1:329,7\n*E\n"})
    private static final class MethodAndCallerMaps {
        @NotNull
        private final UastLocalUsageDependencyGraph methodGraph;
        @NotNull
        private final UastLocalUsageDependencyGraph callerGraph;
        @NotNull
        private final Map<UElement, Set<Dependency>> parameterUsagesDependencies;
        @NotNull
        private final Map<UElement, Set<Dependent>> parameterValueDependents;

        /*
         * WARNING - void declaration
         */
        public MethodAndCallerMaps(@NotNull UMethod method, @NotNull Map<UParameter, ? extends UExpression> argumentValues, @NotNull UastLocalUsageDependencyGraph methodGraph, @NotNull UastLocalUsageDependencyGraph callerGraph) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter(argumentValues, (String)"argumentValues");
            Intrinsics.checkNotNullParameter((Object)methodGraph, (String)"methodGraph");
            Intrinsics.checkNotNullParameter((Object)callerGraph, (String)"callerGraph");
            this.methodGraph = methodGraph;
            this.callerGraph = callerGraph;
            Map parameterUsagesDependencies = new LinkedHashMap();
            Map parameterValueDependents = new LinkedHashMap();
            PsiElement psiElement = method.getSourcePsi();
            Intrinsics.checkNotNull((Object)psiElement);
            LocalSearchScope searchScope = new LocalSearchScope(psiElement);
            for (Map.Entry<UParameter, ? extends UExpression> entry : argumentValues.entrySet()) {
                UParameter parameter = entry.getKey();
                UExpression value = entry.getValue();
                Dependency.ConnectionDependency parameterValueAsDependency = new Dependency.ConnectionDependency(DependencyGraphUtilsKt.extractBranchesResultAsDependency(value), this.callerGraph);
                PsiElement psiElement2 = parameter.getSourcePsi();
                Intrinsics.checkNotNull((Object)psiElement2);
                for (UElement reference : SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)ReferencesSearch.search((PsiElement)psiElement2, (SearchScope)((SearchScope)searchScope)).asIterable()), MethodAndCallerMaps::_init_$lambda$0)) {
                    Map map = parameterUsagesDependencies;
                    Object object = new Dependency[]{parameterValueAsDependency};
                    object = SetsKt.mutableSetOf((Object[])object);
                    map.put(reference, object);
                    Dependent.CommonDependent referenceAsDependent = new Dependent.CommonDependent(reference);
                    for (UElement valueElement : parameterValueAsDependency.getElements()) {
                        Object object2;
                        void $this$getOrPut$iv;
                        Map map2 = parameterValueDependents;
                        UElement key$iv = valueElement;
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl = false;
                            Set answer$iv = new HashSet();
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object2 = answer$iv;
                        } else {
                            object2 = value$iv;
                        }
                        ((Set)object2).add(referenceAsDependent);
                    }
                }
            }
            this.parameterUsagesDependencies = parameterUsagesDependencies;
            this.parameterValueDependents = parameterValueDependents;
        }

        @NotNull
        public final Map<UElement, Set<Dependency>> getDependenciesMap() {
            return new MergedMaps<Dependency>(this.callerGraph.getDependencies(), this.methodGraph.getDependencies(), this.parameterUsagesDependencies);
        }

        @NotNull
        public final Map<UElement, Set<Dependent>> getDependentsMap() {
            return new MergedMaps<Dependent>(this.callerGraph.getDependents(), this.methodGraph.getDependents(), this.parameterValueDependents);
        }

        private static final UElement _init_$lambda$0(PsiReference it) {
            return UastContextKt.toUElement((PsiElement)it.getElement());
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\n\n\u0002\u0010&\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0002BU\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u0002\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u0002\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003H\u0096\u0080\u0004J\u0018\u0010\u001f\u001a\u00020\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0096\u0080\u0004J\u001a\u0010!\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00042\u0006\u0010\u001e\u001a\u00020\u0003H\u0096\u0082\u0004J\n\u0010\"\u001a\u00020\u001dH\u0096\u0080\u0004R#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR#\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR-\u0010\u000e\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u000f0\u00048VX\u0096\u0084\b\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00048VX\u0096\u0084\b\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0015\u0010\u0014\u001a\u00020\u00158VX\u0096\u0084\b\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R!\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u00198VX\u0096\u0084\b\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006#"}, d2={"Lorg/jetbrains/uast/analysis/UastLocalUsageDependencyGraph$MethodAndCallerMaps$MergedMaps;", "T", "", "Lorg/jetbrains/uast/UElement;", "", "first", "second", "connection", "<init>", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;)V", "getFirst", "()Ljava/util/Map;", "getSecond", "getConnection", "entries", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "size", "", "getSize", "()I", "values", "", "getValues", "()Ljava/util/Collection;", "containsKey", "", "key", "containsValue", "value", "get", "isEmpty", "intellij.platform.uast.ide"})
        private static final class MergedMaps<T>
        implements Map<UElement, Set<? extends T>>,
        KMappedMarker {
            @NotNull
            private final Map<UElement, Set<T>> first;
            @NotNull
            private final Map<UElement, Set<T>> second;
            @NotNull
            private final Map<UElement, Set<T>> connection;

            public MergedMaps(@NotNull Map<UElement, ? extends Set<? extends T>> first, @NotNull Map<UElement, ? extends Set<? extends T>> second, @NotNull Map<UElement, ? extends Set<? extends T>> connection) {
                Intrinsics.checkNotNullParameter(first, (String)"first");
                Intrinsics.checkNotNullParameter(second, (String)"second");
                Intrinsics.checkNotNullParameter(connection, (String)"connection");
                this.first = first;
                this.second = second;
                this.connection = connection;
            }

            @NotNull
            public final Map<UElement, Set<T>> getFirst() {
                return this.first;
            }

            @NotNull
            public final Map<UElement, Set<T>> getSecond() {
                return this.second;
            }

            @NotNull
            public final Map<UElement, Set<T>> getConnection() {
                return this.connection;
            }

            @NotNull
            public Set<Map.Entry<UElement, Set<T>>> getEntries() {
                HashSet hashSet;
                HashSet $this$_get_entries__u24lambda_u240 = hashSet = new HashSet();
                boolean bl = false;
                $this$_get_entries__u24lambda_u240.addAll(this.first.entrySet());
                $this$_get_entries__u24lambda_u240.addAll(this.second.entrySet());
                $this$_get_entries__u24lambda_u240.addAll(this.connection.entrySet());
                return hashSet;
            }

            @NotNull
            public Set<UElement> getKeys() {
                HashSet hashSet;
                HashSet $this$_get_keys__u24lambda_u240 = hashSet = new HashSet();
                boolean bl = false;
                $this$_get_keys__u24lambda_u240.addAll(this.first.keySet());
                $this$_get_keys__u24lambda_u240.addAll(this.second.keySet());
                $this$_get_keys__u24lambda_u240.addAll(this.connection.keySet());
                return hashSet;
            }

            public int getSize() {
                return this.first.size() + this.second.size() + this.connection.size();
            }

            @NotNull
            public Collection<Set<T>> getValues() {
                ArrayList<Set<T>> result = new ArrayList<Set<T>>();
                result.addAll(this.first.values());
                result.addAll(this.second.values());
                result.addAll(this.connection.values());
                return result;
            }

            public boolean containsKey(@NotNull UElement key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return this.connection.containsKey(key) || this.first.containsKey(key) || this.second.containsKey(key);
            }

            public boolean containsValue(@NotNull Set<? extends T> value) {
                Intrinsics.checkNotNullParameter(value, (String)"value");
                return this.connection.containsValue(value) || this.first.containsValue(value) || this.second.containsValue(value);
            }

            @Nullable
            public Set<T> get(@NotNull UElement key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Set<T> set = this.connection.get(key);
                if (set == null && (set = this.first.get(key)) == null) {
                    set = this.second.get(key);
                }
                return set;
            }

            @Override
            public boolean isEmpty() {
                return this.first.isEmpty() || this.second.isEmpty() || this.connection.isEmpty();
            }

            @Override
            public Set<T> put(UElement key, Set<? extends T> value) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public Set<T> remove(Object key) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public boolean remove(Object key, Object value) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public void putAll(Map<? extends UElement, ? extends Set<? extends T>> from) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public void replaceAll(BiFunction<? super UElement, ? super Set<? extends T>, ? extends Set<? extends T>> p0) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public Set<T> putIfAbsent(UElement p0, Set<? extends T> p1) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public boolean replace(UElement p0, Set<? extends T> p1, Set<? extends T> p2) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public Set<T> replace(UElement p0, Set<? extends T> p1) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public Set<T> computeIfAbsent(UElement p0, Function<? super UElement, ? extends Set<? extends T>> p1) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public Set<T> computeIfPresent(UElement p0, BiFunction<? super UElement, ? super Set<? extends T>, ? extends Set<? extends T>> p1) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public Set<T> compute(UElement p0, BiFunction<? super UElement, ? super Set<? extends T>, ? extends Set<? extends T>> p1) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public Set<T> merge(UElement p0, Set<? extends T> p1, BiFunction<? super Set<? extends T>, ? super Set<? extends T>, ? extends Set<? extends T>> p2) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        }
    }
}

