/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters;

import com.intellij.rt.coverage.instrumentation.filters.KotlinUtils;
import com.intellij.rt.coverage.instrumentation.filters.branches.AssertFilter;
import com.intellij.rt.coverage.instrumentation.filters.branches.BooleanOperatorFilter;
import com.intellij.rt.coverage.instrumentation.filters.branches.JavaStringSwitchFilter;
import com.intellij.rt.coverage.instrumentation.filters.branches.NotNullAssertionsFilter;
import com.intellij.rt.coverage.instrumentation.filters.classFilter.ClassFilter;
import com.intellij.rt.coverage.instrumentation.filters.classFilter.InheritanceCollectorFilter;
import com.intellij.rt.coverage.instrumentation.filters.classFilter.PrivateConstructorOfUtilClassFilter;
import com.intellij.rt.coverage.instrumentation.filters.classes.ClassIgnoredByAnnotationFilter;
import com.intellij.rt.coverage.instrumentation.filters.classes.ClassSignatureFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.AnnotationIgnoredMethodFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.ClosingBracesFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.CoverageFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.TryFinallyLineFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.TryWithResourcesJava8LineFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.TryWithResourcesLineFilter;
import com.intellij.rt.coverage.instrumentation.filters.methods.DeserializeLambdaFilter;
import com.intellij.rt.coverage.instrumentation.filters.methods.EnumMethodsFilter;
import com.intellij.rt.coverage.instrumentation.filters.methods.MethodFilter;
import java.util.ArrayList;
import java.util.List;

public class FilterUtils {
    /*
     * WARNING - void declaration
     */
    public static List<MethodFilter> createMethodFilters() {
        void var0;
        List<MethodFilter> result = KotlinUtils.createMethodFilters();
        result.add(new EnumMethodsFilter());
        result.add(new DeserializeLambdaFilter());
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static List<ClassSignatureFilter> createClassSignatureFilters() {
        void var0;
        ArrayList<ClassSignatureFilter> result = new ArrayList<ClassSignatureFilter>();
        result.add(new ClassIgnoredByAnnotationFilter());
        result.addAll(KotlinUtils.createClassSignatureFilters());
        if (!(result.get(0) instanceof ClassIgnoredByAnnotationFilter)) {
            throw new AssertionError((Object)"ClassIgnoredByAnnotationFilter filter should be the first one in the list of filters");
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static List<ClassFilter> createClassFilters() {
        void var0;
        List<ClassFilter> result = KotlinUtils.createClassFilters();
        result.add(new PrivateConstructorOfUtilClassFilter());
        result.add(new InheritanceCollectorFilter());
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static List<CoverageFilter> createLineFilters() {
        void var0;
        List<CoverageFilter> result = KotlinUtils.createLineFilters();
        result.add(new ClosingBracesFilter());
        result.add(new TryFinallyLineFilter());
        result.add(new TryWithResourcesLineFilter());
        result.add(new TryWithResourcesJava8LineFilter());
        result.add(new AnnotationIgnoredMethodFilter());
        List<CoverageFilter> list = result;
        if (!(list.get(list.size() - 1) instanceof AnnotationIgnoredMethodFilter)) {
            throw new AssertionError((Object)"AnnotationIgnoredMethodFilter should be the last one in the list of filters");
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static List<CoverageFilter> createBranchFilters() {
        void var0;
        List<CoverageFilter> result = KotlinUtils.createBranchFilters();
        result.add(new NotNullAssertionsFilter());
        result.add(new AssertFilter());
        result.add(new BooleanOperatorFilter());
        result.add(new JavaStringSwitchFilter());
        return var0;
    }
}

