/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.lines;

import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.data.Key;
import com.intellij.rt.coverage.instrumentation.filters.KotlinUtils;
import com.intellij.rt.coverage.instrumentation.filters.lines.CoverageFilter;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Type;

public class KotlinImplementerDefaultInterfaceMemberFilter
extends CoverageFilter {
    private static final String DEFAULT_IMPLS_SUFFIX = "$DefaultImpls";
    private byte matchedInstructions = 0;
    private int myLine = -1;
    private LineData myPreviousLineData;
    private State myState;
    private int myLoadArgsNumber;
    private int myLoadArgIndex;

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isApplicable(InstrumentationData context) {
        void var2_2;
        void var1_1;
        String[] interfaces = context.get(Key.INTERFACES);
        return KotlinUtils.isKotlinClass((InstrumentationData)var1_1) && interfaces != null && ((void)var2_2).length > 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initFilter(MethodVisitor methodVisitor, InstrumentationData context) {
        void var2_2;
        void var1_1;
        super.initFilter((MethodVisitor)var1_1, context);
        this.myState = State.UNKNOWN;
        this.myLoadArgsNumber = Type.getArgumentTypes(var2_2.getMethodDesc()).length + 1;
        this.myLoadArgIndex = 0;
    }

    private boolean completed() {
        return this.myState != State.UNKNOWN;
    }

    private void filter() {
        if (this.myPreviousLineData == null) {
            this.myContext.removeLine(this.myLine);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitLabel(Label label) {
        void var1_1;
        super.visitLabel((Label)var1_1);
        if (this.completed()) {
            return;
        }
        if (this.matchedInstructions == 0) {
            this.matchedInstructions = 1;
            return;
        }
        if (this.matchedInstructions == 5) {
            this.myState = State.SHOULD_NOT_COVER;
            this.filter();
            return;
        }
        this.myState = State.SHOULD_COVER;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitLineNumber(int line, Label start) {
        void var2_2;
        this.myPreviousLineData = this.myContext.getLineData(line);
        super.visitLineNumber(line, (Label)var2_2);
        if (this.completed()) {
            return;
        }
        if (this.matchedInstructions == 1) {
            void var1_1;
            this.matchedInstructions = (byte)2;
            this.myLine = var1_1;
            return;
        }
        this.myState = State.SHOULD_COVER;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitVarInsn(int opcode, int var) {
        void var2_2;
        void var1_1;
        super.visitVarInsn(opcode, var);
        if (this.completed()) {
            return;
        }
        if (this.matchedInstructions == 2 && KotlinImplementerDefaultInterfaceMemberFilter.isLoadOpcode((int)var1_1) && var2_2 == this.myLoadArgIndex) {
            ++this.myLoadArgIndex;
            if (this.myLoadArgIndex == this.myLoadArgsNumber) {
                this.matchedInstructions = (byte)3;
                return;
            }
        } else {
            this.myState = State.SHOULD_COVER;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        void var2_2;
        void var3_3;
        void var1_1;
        super.visitMethodInsn((int)var1_1, owner, (String)var3_3, descriptor, isInterface);
        if (this.completed()) {
            return;
        }
        if (this.matchedInstructions == 3 && var2_2.endsWith(DEFAULT_IMPLS_SUFFIX)) {
            this.matchedInstructions = (byte)4;
            return;
        }
        this.myState = State.SHOULD_COVER;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitInsn(int opcode) {
        void var1_1;
        super.visitInsn(opcode);
        if (this.completed()) {
            return;
        }
        if (this.matchedInstructions == 4 && var1_1 == 177) {
            this.matchedInstructions = (byte)5;
            return;
        }
        this.myState = State.SHOULD_COVER;
    }

    public static String removeDefaultMarkerSuffix(String internalName) {
        String string;
        if (internalName.endsWith(DEFAULT_IMPLS_SUFFIX)) {
            return internalName.substring(0, internalName.length() - 13);
        }
        return string;
    }

    private static boolean isLoadOpcode(int opcode) {
        int n;
        return 21 <= opcode && n <= 53;
    }

    private static enum State {
        SHOULD_COVER,
        SHOULD_NOT_COVER,
        UNKNOWN;

    }
}

