/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.util.LinesUtil;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.ReportSectionsUtil;
import com.intellij.rt.coverage.util.StringsPool;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;

public class ProjectDataLoader {
    public static final int REPORT_VERSION = 1;

    /*
     * WARNING - void declaration
     */
    public static ProjectData loadLocked(File sessionDataFile) {
        Serializable serializable;
        CoverageIOUtil.FileLock lock = null;
        try {
            lock = CoverageIOUtil.FileLock.lock(sessionDataFile);
            serializable = ProjectDataLoader.load(serializable);
        }
        catch (Throwable throwable) {
            void var1_2;
            CoverageIOUtil.FileLock.unlock((CoverageIOUtil.FileLock)var1_2);
            throw throwable;
        }
        CoverageIOUtil.FileLock.unlock(lock);
        return serializable;
    }

    /*
     * WARNING - void declaration
     */
    public static ProjectData load(File sessionDataFile) {
        void var1_2;
        ProjectData projectInfo = new ProjectData();
        DataInputStream in = null;
        if (sessionDataFile.length() == 0L) {
            return projectInfo;
        }
        StringsPool pool = new StringsPool();
        try {
            int c;
            in = CoverageIOUtil.openReadFile(sessionDataFile);
            TIntObjectHashMap<ClassData> dict = new TIntObjectHashMap<ClassData>(1000, 0.99f);
            int classCount = CoverageIOUtil.readINT(in);
            for (c = 0; c < classCount; ++c) {
                String className = pool.getFromPool(CoverageIOUtil.readUTFFast(in));
                ClassData classInfo = projectInfo.getOrCreateClassData(className);
                dict.put(c, classInfo);
            }
            for (c = 0; c < classCount; ++c) {
                ClassData classInfo = (ClassData)dict.get(CoverageIOUtil.readINT(in));
                int methCount = CoverageIOUtil.readINT(in);
                TIntObjectHashMap<LineData> lines = new TIntObjectHashMap<LineData>(4, 0.99f);
                int maxLine = -1;
                for (int m = 0; m < methCount; ++m) {
                    String methodSig = pool.getFromPool(ProjectDataLoader.expand(in, dict));
                    int lineCount = CoverageIOUtil.readINT(in);
                    for (int l = 0; l < lineCount; ++l) {
                        int line = CoverageIOUtil.readINT(in);
                        LineData lineInfo = lines.get(line);
                        if (lineInfo == null) {
                            lineInfo = new LineData(line, methodSig);
                            lines.put(line, lineInfo);
                            if (line > maxLine) {
                                maxLine = line;
                            }
                        }
                        classInfo.registerMethodSignature(lineInfo);
                        String testName = pool.getFromPool(CoverageIOUtil.readUTFFast(in));
                        if (testName != null && !testName.isEmpty()) {
                            lineInfo.setTestName(testName);
                        }
                        int hits = CoverageIOUtil.readINT(in);
                        lineInfo.setHits(hits);
                        if (hits > 0) {
                            int jumpsNumber = CoverageIOUtil.readINT(in);
                            for (int j = 0; j < jumpsNumber; ++j) {
                                lineInfo.setTrueHits(j, CoverageIOUtil.readINT(in));
                                lineInfo.setFalseHits(j, CoverageIOUtil.readINT(in));
                            }
                            int switchesNumber = CoverageIOUtil.readINT(in);
                            for (int s = 0; s < switchesNumber; ++s) {
                                int defaultHit = CoverageIOUtil.readINT(in);
                                int keysLength = CoverageIOUtil.readINT(in);
                                int[] keys = new int[keysLength];
                                int[] keysHits = new int[keysLength];
                                for (int k = 0; k < keysLength; ++k) {
                                    keys[k] = CoverageIOUtil.readINT(in);
                                    keysHits[k] = CoverageIOUtil.readINT(in);
                                }
                                lineInfo.setDefaultHits(s, keys, defaultHit);
                                lineInfo.setSwitchHits(s, keys, keysHits);
                            }
                        }
                        lineInfo.fillArrays();
                    }
                }
                classInfo.setLines(LinesUtil.calcLineArray(maxLine, lines));
            }
            ProjectDataLoader.loadExtraInfo(projectInfo, in, dict);
        }
        catch (Exception e) {
            try {
                File file;
                ErrorReporter.warn("Failed to load coverage data from file: " + file.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                void var2_3;
                CoverageIOUtil.close((Closeable)var2_3);
                throw throwable;
            }
            CoverageIOUtil.close(in);
        }
        CoverageIOUtil.close(in);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private static String expand(DataInputStream in, TIntObjectHashMap<ClassData> dict) throws IOException {
        void var1_1;
        return CoverageIOUtil.processWithDictionary(CoverageIOUtil.readUTFFast(in), new CoverageIOUtil.Consumer((TIntObjectHashMap)var1_1){
            final /* synthetic */ TIntObjectHashMap val$dict;
            {
                this.val$dict = tIntObjectHashMap;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected String consume(String type) {
                void var1_1;
                if (!type.isEmpty() && Character.isDigit(type.charAt(0))) {
                    try {
                        void var2_2;
                        int typeIdx = Integer.parseInt(type);
                        return ((ClassData)this.val$dict.get((int)var2_2)).getName();
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                return var1_1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static void loadExtraInfo(ProjectData projectData, DataInputStream in, TIntObjectHashMap<ClassData> dict) throws IOException {
        void var2_2;
        void var1_1;
        ProjectData projectData2;
        int version;
        try {
            version = CoverageIOUtil.readINT(in);
        }
        catch (EOFException eOFException) {
            return;
        }
        if (version > 1) {
            void var3_3;
            ErrorReporter.warn("Report version " + (int)var3_3 + " is greater than agent maximum support version 1" + "\nPlease try to update coverage agent.");
            return;
        }
        CoverageIOUtil.readUTFFast(in);
        ReportSectionsUtil.loadSections(projectData2, (DataInputStream)var1_1, (TIntObjectHashMap<ClassData>)var2_2);
    }
}

