/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.export;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.util.DiagramExportService;
import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.uml.export.BaseDiagramExporter;
import com.intellij.uml.export.GraphmlExporter;
import com.intellij.uml.export.GraphvizExporter;
import com.intellij.uml.export.MermaidExporter;
import com.intellij.uml.export.MxgraphExporter;
import com.intellij.uml.export.PlantumlExporter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0016J2\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0016J \u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J8\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00160\n\"\u0004\b\u0000\u0010\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\n0\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/uml/export/DiagramExportServiceImpl;", "Lcom/intellij/diagram/util/DiagramExportService;", "<init>", "()V", "myCurrentRequestedExportFormat", "Lcom/intellij/diagram/util/DiagramExportService$OutputFormat;", "isExportInProgress", "", "getOutputFormatForCurrentExport", "runExportAsync", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "builder", "Lcom/intellij/diagram/DiagramBuilder;", "outputFormat", "outputStreamSupplier", "Lcom/intellij/openapi/util/ThrowableComputable;", "Ljava/io/OutputStream;", "Ljava/io/IOException;", "generateUrlToOpenInWebEditorAsync", "", "runExport", "R", "run", "Lkotlin/Function0;", "findRequestedExporter", "Lcom/intellij/uml/export/BaseDiagramExporter;", "intellij.diagram.impl"})
public final class DiagramExportServiceImpl
implements DiagramExportService {
    @Nullable
    private volatile DiagramExportService.OutputFormat myCurrentRequestedExportFormat;

    @Override
    public boolean isExportInProgress() {
        return GraphExportService.getInstance().isExportMode();
    }

    @Override
    @Nullable
    public DiagramExportService.OutputFormat getOutputFormatForCurrentExport() {
        return this.myCurrentRequestedExportFormat;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> runExportAsync(@NotNull DiagramBuilder builder, @NotNull DiagramExportService.OutputFormat outputFormat, @NotNull ThrowableComputable<OutputStream, IOException> outputStreamSupplier) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)((Object)outputFormat), (String)"outputFormat");
        Intrinsics.checkNotNullParameter(outputStreamSupplier, (String)"outputStreamSupplier");
        return this.runExport(builder, outputFormat, () -> DiagramExportServiceImpl.runExportAsync$lambda$0(this, outputFormat, builder, outputStreamSupplier));
    }

    @Override
    @NotNull
    public CompletableFuture<String> generateUrlToOpenInWebEditorAsync(@NotNull DiagramBuilder builder, @NotNull DiagramExportService.OutputFormat outputFormat) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)((Object)outputFormat), (String)"outputFormat");
        return this.runExport(builder, outputFormat, () -> DiagramExportServiceImpl.generateUrlToOpenInWebEditorAsync$lambda$0(this, outputFormat, builder));
    }

    private final <R> CompletableFuture<R> runExport(DiagramBuilder builder, DiagramExportService.OutputFormat outputFormat, Function0<? extends CompletableFuture<R>> run) {
        GraphExportService.getInstance().setExportMode(true);
        this.myCurrentRequestedExportFormat = outputFormat;
        CompletionStage completionStage = ((CompletableFuture)run.invoke()).whenComplete((arg_0, arg_1) -> DiagramExportServiceImpl.runExport$lambda$1((arg_0, arg_1) -> DiagramExportServiceImpl.runExport$lambda$0(this, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"whenComplete(...)");
        return completionStage;
    }

    private final BaseDiagramExporter findRequestedExporter(DiagramExportService.OutputFormat outputFormat) {
        return switch (WhenMappings.$EnumSwitchMapping$0[outputFormat.ordinal()]) {
            case 1, 2 -> GraphvizExporter.INSTANCE;
            case 3 -> MermaidExporter.INSTANCE;
            case 4 -> MxgraphExporter.INSTANCE;
            case 5 -> GraphmlExporter.INSTANCE;
            case 6 -> PlantumlExporter.INSTANCE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final CompletableFuture runExportAsync$lambda$0(DiagramExportServiceImpl this$0, DiagramExportService.OutputFormat $outputFormat, DiagramBuilder $builder, ThrowableComputable $outputStreamSupplier) {
        return this$0.findRequestedExporter($outputFormat).runExportAsync($builder, $outputFormat, (ThrowableComputable<OutputStream, IOException>)$outputStreamSupplier);
    }

    private static final CompletableFuture generateUrlToOpenInWebEditorAsync$lambda$0(DiagramExportServiceImpl this$0, DiagramExportService.OutputFormat $outputFormat, DiagramBuilder $builder) {
        return this$0.findRequestedExporter($outputFormat).generateUrlToOpenInWebEditorAsync($builder, $outputFormat);
    }

    private static final Unit runExport$lambda$0(DiagramExportServiceImpl this$0, Object object, Throwable throwable) {
        GraphExportService.getInstance().setExportMode(false);
        this$0.myCurrentRequestedExportFormat = null;
        return Unit.INSTANCE;
    }

    private static final void runExport$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DiagramExportService.OutputFormat.values().length];
            try {
                nArray[DiagramExportService.OutputFormat.GRAPHVIZ_DOT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiagramExportService.OutputFormat.GRAPHVIZ_DOT_WITH_POSITIONS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiagramExportService.OutputFormat.MERMAID.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiagramExportService.OutputFormat.MX_GRAPH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiagramExportService.OutputFormat.GRAPHML.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiagramExportService.OutputFormat.PLANTUML.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

