/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.impl.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelMachine;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.ide.impl.wsl.WslEelDescriptor;
import com.intellij.platform.ide.impl.wsl.WslEelMachineKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0082\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u0096\u0080\u0004J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/ide/impl/wsl/WslEelMachine;", "Lcom/intellij/platform/eel/EelMachine;", "distribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "<init>", "(Lcom/intellij/execution/wsl/WSLDistribution;)V", "getDistribution", "()Lcom/intellij/execution/wsl/WSLDistribution;", "internalName", "", "getInternalName", "()Ljava/lang/String;", "toEelApi", "Lcom/intellij/platform/eel/EelApi;", "descriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "(Lcom/intellij/platform/eel/EelDescriptor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "equals", "", "other", "", "hashCode", "", "ownsPath", "path", "Ljava/nio/file/Path;", "intellij.platform.ide.impl.wsl"})
@ApiStatus.Internal
public final class WslEelMachine
implements EelMachine {
    @NotNull
    private final WSLDistribution distribution;
    @NotNull
    private final String internalName;

    public WslEelMachine(@NotNull WSLDistribution distribution) {
        Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
        this.distribution = distribution;
        this.internalName = "WSL-" + this.distribution.getId();
    }

    @NotNull
    public final WSLDistribution getDistribution() {
        return this.distribution;
    }

    @NotNull
    public String getInternalName() {
        return this.internalName;
    }

    @Nullable
    public Object toEelApi(@NotNull EelDescriptor descriptor, @NotNull Continuation<? super EelApi> $completion) {
        if (!(descriptor instanceof WslEelDescriptor && Intrinsics.areEqual((Object)((WslEelDescriptor)descriptor).getDistribution(), (Object)this.distribution))) {
            boolean bl = false;
            String string = "Wrong descriptor: " + descriptor + " for machine: " + this;
            throw new IllegalStateException(string.toString());
        }
        return WslEelMachineKt.access$getIjent(this.distribution, descriptor, $completion);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.platform.ide.impl.wsl.WslEelMachine");
        WslEelMachine cfr_ignored_0 = (WslEelMachine)object2;
        return Intrinsics.areEqual((Object)this.distribution, (Object)((WslEelMachine)other).distribution);
    }

    public int hashCode() {
        int result = this.distribution.hashCode();
        return result;
    }

    public boolean ownsPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        EelDescriptor eelDescriptor = EelProviderUtil.getEelDescriptor((Path)path);
        WslEelDescriptor wslEelDescriptor = eelDescriptor instanceof WslEelDescriptor ? (WslEelDescriptor)eelDescriptor : null;
        if (wslEelDescriptor == null) {
            return false;
        }
        WslEelDescriptor descriptor = wslEelDescriptor;
        return Intrinsics.areEqual((Object)descriptor.getDistribution(), (Object)this.distribution);
    }
}

