/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.model.psi.headers.html;

import com.intellij.model.psi.PsiSymbolDeclaration;
import com.intellij.model.psi.PsiSymbolDeclarationProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttributeValue;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.model.psi.headers.html.HtmlAnchorSymbol;
import org.intellij.plugins.markdown.model.psi.headers.html.HtmlAnchorSymbolDeclaration;
import org.intellij.plugins.markdown.model.psi.headers.html.HtmlAnchorsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/model/psi/headers/html/HtmlAnchorSymbolDeclarationProvider;", "Lcom/intellij/model/psi/PsiSymbolDeclarationProvider;", "<init>", "()V", "getDeclarations", "", "Lcom/intellij/model/psi/PsiSymbolDeclaration;", "element", "Lcom/intellij/psi/PsiElement;", "offsetInElement", "", "intellij.markdown.model"})
@SourceDebugExtension(value={"SMAP\nHtmlAnchorSymbolDeclarationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlAnchorSymbolDeclarationProvider.kt\norg/intellij/plugins/markdown/model/psi/headers/html/HtmlAnchorSymbolDeclarationProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,31:1\n1#2:32\n*E\n"})
public final class HtmlAnchorSymbolDeclarationProvider
implements PsiSymbolDeclarationProvider {
    @NotNull
    public Collection<PsiSymbolDeclaration> getDeclarations(@NotNull PsiElement element2, int offsetInElement) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (!element2.isValid()) {
            return CollectionsKt.emptyList();
        }
        if (!HtmlAnchorsKt.isInsideInjectedHtml(element2) || !(element2 instanceof XmlAttributeValue)) {
            return CollectionsKt.emptyList();
        }
        if (!HtmlAnchorsKt.isValidAnchorAttributeValue((XmlAttributeValue)element2)) {
            return CollectionsKt.emptyList();
        }
        String string = ((XmlAttributeValue)element2).getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        String value = string;
        if (((CharSequence)value).length() == 0) {
            return CollectionsKt.emptyList();
        }
        PsiFile host = HtmlAnchorsKt.findHostMarkdownFile(element2);
        if (host == null) {
            boolean $i$a$-checkNotNull-HtmlAnchorSymbolDeclarationProvider$getDeclarations$22 = false;
            String $i$a$-checkNotNull-HtmlAnchorSymbolDeclarationProvider$getDeclarations$22 = "Failed to find host Markdown file";
            throw new IllegalStateException($i$a$-checkNotNull-HtmlAnchorSymbolDeclarationProvider$getDeclarations$22.toString());
        }
        TextRange range = ((XmlAttributeValue)element2).getValueTextRange();
        Intrinsics.checkNotNull((Object)range);
        HtmlAnchorSymbol symbol = new HtmlAnchorSymbol(host, range, value);
        HtmlAnchorSymbolDeclaration declaration = new HtmlAnchorSymbolDeclaration((XmlAttributeValue)element2, symbol);
        return CollectionsKt.listOf((Object)declaration);
    }
}

