/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/util/MarkdownPsiUtil;", "", "<init>", "()V", "findNonWhiteSpacePrevSibling", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "WhiteSpaces", "intellij.markdown"})
public final class MarkdownPsiUtil {
    @NotNull
    public static final MarkdownPsiUtil INSTANCE = new MarkdownPsiUtil();

    private MarkdownPsiUtil() {
    }

    @Nullable
    public final PsiElement findNonWhiteSpacePrevSibling(@NotNull PsiFile file, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        int offset2 = offset;
        while (offset2 > 0) {
            PsiElement element2 = file.findElementAt(offset2);
            if (element2 == null) {
                --offset2;
                continue;
            }
            if (!MarkdownTokenTypeSets.WHITE_SPACES.contains(element2.getNode().getElementType())) {
                return element2;
            }
            int newOffset = element2.getTextOffset();
            if (newOffset < offset2) {
                offset2 = newOffset;
                continue;
            }
            --offset2;
        }
        return null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\t"}, d2={"Lorg/intellij/plugins/markdown/util/MarkdownPsiUtil$WhiteSpaces;", "", "<init>", "()V", "isNewLine", "", "element", "Lcom/intellij/psi/PsiElement;", "isWhiteSpace", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nMarkdownPsiUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownPsiUtil.kt\norg/intellij/plugins/markdown/util/MarkdownPsiUtil$WhiteSpaces\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,45:1\n1088#2,2:46\n*S KotlinDebug\n*F\n+ 1 MarkdownPsiUtil.kt\norg/intellij/plugins/markdown/util/MarkdownPsiUtil$WhiteSpaces\n*L\n19#1:46,2\n*E\n"})
    public static final class WhiteSpaces {
        @NotNull
        public static final WhiteSpaces INSTANCE = new WhiteSpaces();

        private WhiteSpaces() {
        }

        @JvmStatic
        public static final boolean isNewLine(@NotNull PsiElement element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            TokenSet tokenSet = MarkdownTokenTypeSets.WHITE_SPACES;
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"WHITE_SPACES");
            return PsiUtilsKt.hasType(element2, tokenSet) && Intrinsics.areEqual((Object)element2.getText(), (Object)"\n");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public static final boolean isWhiteSpace(@NotNull PsiElement element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            TokenSet tokenSet = MarkdownTokenTypeSets.WHITE_SPACES;
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"WHITE_SPACES");
            if (!PsiUtilsKt.hasType(element2, tokenSet)) return false;
            String string = element2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            CharSequence $this$all$iv = string;
            boolean $i$f$all = false;
            int n = 0;
            while (n < $this$all$iv.length()) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(n);
                boolean bl = false;
                if (!CharsKt.isWhitespace((char)it)) return false;
                if (it == '\n') return false;
                boolean bl2 = true;
                if (!bl2) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }
}

