/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.blame.helpers;

import com.intellij.code.provenance.DocumentChangesKind;
import com.intellij.code.provenance.core.ProvenanceEntry;
import com.intellij.code.provenance.core.blame.helpers.ChangeHistoryGenerator;
import com.intellij.code.provenance.core.blame.helpers.DeltaWithContent;
import com.intellij.code.provenance.core.blame.helpers.LocalHistoryIsEmpty;
import com.intellij.code.provenance.info.IssueIndicator;
import com.intellij.history.core.ChangeProcessor;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.LocalHistoryFacadeKt;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\"\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a$\u0010\b\u001a\u00020\t2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u0002\u001a\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001aR\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017H\u0080@\u00a2\u0006\u0002\u0010\u0019\u001a\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001aD\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000*\f\b\u0002\u0010\u0000\"\u00020\u00012\u00020\u0001\u00a8\u0006\u001d"}, d2={"Hash", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "mergeDocumentChanges", "", "Lcom/intellij/code/provenance/core/ProvenanceEntry$DocumentChangeLike;", "documentChanges", "verifyEmptyLocalHistory", "", "Lcom/intellij/code/provenance/core/ProvenanceEntry$DocumentChangeBase;", "metadataChanges", "Lcom/intellij/code/provenance/core/ProvenanceEntry$MetadataEntryOfDocumentChange;", "documentChangesToString", "", "generateChangeHistory", "Lcom/intellij/code/provenance/core/blame/helpers/DeltaWithContent;", "changes", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "problems", "", "Lcom/intellij/code/provenance/info/IssueIndicator;", "(Ljava/util/List;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/util/Set;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isLocalHistoryEmpty", "", "formatStatus", "intellij.code.provenance.core"})
@SourceDebugExtension(value={"SMAP\nhistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 history.kt\ncom/intellij/code/provenance/core/blame/helpers/HistoryKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,255:1\n1068#2:256\n777#2:257\n873#2,2:258\n777#2:260\n873#2,2:261\n1807#2,3:264\n1586#2:267\n1661#2,3:268\n1#3:263\n13#4:271\n*S KotlinDebug\n*F\n+ 1 history.kt\ncom/intellij/code/provenance/core/blame/helpers/HistoryKt\n*L\n32#1:256\n61#1:257\n61#1:258,2\n62#1:260\n62#1:261,2\n65#1:264,3\n81#1:267\n81#1:268,3\n27#1:271\n*E\n"})
public final class HistoryKt {
    @NotNull
    private static final Logger logger;

    private static final List<List<ProvenanceEntry.DocumentChangeLike>> mergeDocumentChanges(List<? extends ProvenanceEntry.DocumentChangeLike> documentChanges) {
        if (documentChanges.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$sortedBy$iv = documentChanges;
        boolean $i$f$sortedBy = false;
        List sorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ProvenanceEntry.DocumentChangeLike it = (ProvenanceEntry.DocumentChangeLike)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getTimestamp());
                it = (ProvenanceEntry.DocumentChangeLike)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTimestamp()));
            }
        });
        List groups = new ArrayList();
        Object[] objectArray = new ProvenanceEntry.DocumentChangeLike[]{CollectionsKt.first((List)sorted)};
        List currentGroup = CollectionsKt.mutableListOf((Object[])objectArray);
        int n = sorted.size();
        for (int i = 1; i < n; ++i) {
            ProvenanceEntry.DocumentChangeLike current = (ProvenanceEntry.DocumentChangeLike)sorted.get(i);
            ProvenanceEntry.DocumentChangeLike previous = (ProvenanceEntry.DocumentChangeLike)CollectionsKt.first((List)currentGroup);
            long timeDiff = current.getTimestamp() - previous.getTimestamp();
            if (timeDiff < Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES)) && current.getKind() == previous.getKind()) {
                currentGroup.add(current);
                continue;
            }
            groups.add(currentGroup);
            Object[] objectArray2 = new ProvenanceEntry.DocumentChangeLike[]{current};
            currentGroup = CollectionsKt.mutableListOf((Object[])objectArray2);
        }
        groups.add(currentGroup);
        return groups;
    }

    /*
     * Unable to fully structure code
     */
    private static final void verifyEmptyLocalHistory(List<? extends ProvenanceEntry.DocumentChangeBase> documentChanges, List<ProvenanceEntry.MetadataEntryOfDocumentChange> metadataChanges) {
        block12: {
            days = 2;
            duration = Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)days, (DurationUnit)DurationUnit.DAYS));
            currentTime = System.currentTimeMillis();
            $this$filter$iv = documentChanges;
            $i$f$filter = false;
            var10_9 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ProvenanceEntry.DocumentChangeBase)element$iv$iv;
                $i$a$-filter-HistoryKt$verifyEmptyLocalHistory$documentChanges$1 = false;
                if (!(it.getTimestamp() > currentTime - duration)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            documentChanges = (List)destination$iv$iv;
            $this$filter$iv = metadataChanges;
            $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            element$iv$iv = $this$filterTo$iv$iv.iterator();
            while (element$iv$iv.hasNext()) {
                element$iv$iv = element$iv$iv.next();
                it = (ProvenanceEntry.MetadataEntryOfDocumentChange)element$iv$iv;
                $i$a$-filter-HistoryKt$verifyEmptyLocalHistory$metadataChanges$1 = false;
                if (!(it.getTimestamp() > currentTime - duration && it.getKind() != DocumentChangesKind.UNKNOWN)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            metadataChanges = (List)destination$iv$iv;
            if (!(((Collection)documentChanges).isEmpty() == false)) ** GOTO lbl-1000
            $this$filterTo$iv$iv = ((Iterable)documentChanges).iterator();
            if (!$this$filterTo$iv$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            it = (ProvenanceEntry.DocumentChangeBase)$this$filterTo$iv$iv.next();
            $i$a$-maxOf-HistoryKt$verifyEmptyLocalHistory$shouldDocumentsTrigger$1 = false;
            it = it.getTimestamp();
            while ($this$filterTo$iv$iv.hasNext()) {
                it = (ProvenanceEntry.DocumentChangeBase)$this$filterTo$iv$iv.next();
                $i$a$-maxOf-HistoryKt$verifyEmptyLocalHistory$shouldDocumentsTrigger$1 = false;
                it = it.getTimestamp();
                if (it >= it) continue;
                it = it;
            }
            $i$f$filter = documentChanges;
            var20_38 = it;
            $this$filterTo$iv$iv = $i$f$filter.iterator();
            if (!$this$filterTo$iv$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            it = (ProvenanceEntry.DocumentChangeBase)$this$filterTo$iv$iv.next();
            $i$a$-minOf-HistoryKt$verifyEmptyLocalHistory$shouldDocumentsTrigger$2 = false;
            it = it.getTimestamp();
            while ($this$filterTo$iv$iv.hasNext()) {
                it = (ProvenanceEntry.DocumentChangeBase)$this$filterTo$iv$iv.next();
                $i$a$-minOf-HistoryKt$verifyEmptyLocalHistory$shouldDocumentsTrigger$2 = false;
                var14_26 = it.getTimestamp();
                if (it <= var14_26) continue;
                it = var14_26;
            }
            var22_39 = it;
            if (var20_38 - var22_39 > Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)20, (DurationUnit)DurationUnit.MINUTES))) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            shouldDocumentsTrigger = v0;
            $this$any$iv = metadataChanges;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (ProvenanceEntry.MetadataEntryOfDocumentChange)element$iv;
                    $i$a$-any-HistoryKt$verifyEmptyLocalHistory$shouldMetadataTrigger$1 = false;
                    if (!(it.getKind() != DocumentChangesKind.UNKNOWN)) continue;
                    v1 = true;
                    break block12;
                }
                v1 = shouldMetadataTrigger = false;
            }
        }
        if (shouldDocumentsTrigger || shouldMetadataTrigger) {
            HistoryKt.logger.error(HistoryKt.verifyEmptyLocalHistory$formatMessage(metadataChanges, documentChanges, days));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final String documentChangesToString(List<? extends ProvenanceEntry.DocumentChangeLike> documentChanges) {
        void $this$mapTo$iv$iv;
        List<List<ProvenanceEntry.DocumentChangeLike>> mergedDocumentChanges = HistoryKt.mergeDocumentChanges(documentChanges);
        Iterable $this$map$iv = mergedDocumentChanges;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void group;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            long duration = ((ProvenanceEntry.DocumentChangeLike)CollectionsKt.last((List)group)).getTimestamp() - ((ProvenanceEntry.DocumentChangeLike)CollectionsKt.first((List)group)).getTimestamp();
            long passedFrom = System.currentTimeMillis() - ((ProvenanceEntry.DocumentChangeLike)CollectionsKt.last((List)group)).getTimestamp();
            collection.add("(" + group.size() + " changes (" + ((ProvenanceEntry.DocumentChangeLike)CollectionsKt.first((List)group)).getKind() + ") for " + duration + "ms " + passedFrom + "ms ago)");
        }
        List groups = (List)destination$iv$iv;
        String groupsSuffix = groups.size() > 5 ? "..., " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.takeLast((List)groups, (int)5), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) : CollectionsKt.joinToString$default((Iterable)groups, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        return groupsSuffix;
    }

    @Nullable
    public static final Object generateChangeHistory(@NotNull List<? extends ProvenanceEntry.DocumentChangeBase> changes, @NotNull VirtualFile vFile, @NotNull Project project, @NotNull List<ProvenanceEntry.MetadataEntryOfDocumentChange> metadataChanges, @Nullable Set<IssueIndicator> problems, @NotNull Continuation<? super List<DeltaWithContent>> $completion) {
        return new ChangeHistoryGenerator(changes, vFile, project, metadataChanges, problems).generate($completion);
    }

    public static /* synthetic */ Object generateChangeHistory$default(List list, VirtualFile virtualFile, Project project, List list2, Set set, Continuation continuation, int n, Object object) {
        if ((n & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return HistoryKt.generateChangeHistory(list, virtualFile, project, list2, set, (Continuation<? super List<DeltaWithContent>>)continuation);
    }

    public static final boolean isLocalHistoryEmpty(@NotNull Project project, @NotNull VirtualFile vFile) {
        LocalHistoryIsEmpty processor;
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
            processor = new LocalHistoryIsEmpty(project, vFile);
            LocalHistoryImpl localHistory = LocalHistoryImpl.Companion.getInstanceImpl();
            LocalHistoryFacade localHistoryFacade = localHistory.getFacade();
            if (localHistoryFacade == null) break block0;
            String string = localHistory.getGateway().getPathOrUrl(vFile);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPathOrUrl(...)");
            LocalHistoryFacadeKt.collectChanges((LocalHistoryFacade)localHistoryFacade, (String)string, (ChangeProcessor)processor);
        }
        return !processor.getHasChanges();
    }

    @NotNull
    public static final String formatStatus(@NotNull Project project, @NotNull VirtualFile vFile, @Nullable Set<IssueIndicator> problems, @NotNull List<? extends ProvenanceEntry.DocumentChangeBase> changes, @NotNull List<ProvenanceEntry.MetadataEntryOfDocumentChange> metadataChanges) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter(metadataChanges, (String)"metadataChanges");
        return StringsKt.trimIndent((String)("\n    Local history empty: " + HistoryKt.isLocalHistoryEmpty(project, vFile) + ",\n    File size: " + vFile.getLength() + "\n    Problems Encountered: " + problems + "\n    Changes: " + changes.size() + " changes -- " + HistoryKt.documentChangesToString(changes) + "\n    Metadata Changes: " + metadataChanges.size() + " changes -- " + HistoryKt.documentChangesToString(metadataChanges) + "\n    "));
    }

    private static final String verifyEmptyLocalHistory$formatMessage(List<ProvenanceEntry.MetadataEntryOfDocumentChange> metadataChanges, List<? extends ProvenanceEntry.DocumentChangeBase> documentChanges, int days) {
        String metadataChangesString = HistoryKt.documentChangesToString(metadataChanges);
        String documentChangesString = HistoryKt.documentChangesToString(documentChanges);
        return "Detected empty local history, but there are " + metadataChanges.size() + " metadata changes: [" + metadataChangesString + "] and " + documentChanges.size() + ": [" + documentChangesString + "] in the last " + days + " days";
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ void access$verifyEmptyLocalHistory(List documentChanges, List metadataChanges) {
        HistoryKt.verifyEmptyLocalHistory(documentChanges, metadataChanges);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ChangeHistoryGenerator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        HistoryKt.logger = logger;
    }
}

