/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions.branch;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.actions.branch.GitSingleBranchAction;
import git4idea.branch.GitBranchPair;
import git4idea.config.UpdateMethod;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchPopupActions;
import git4idea.update.GitUpdateExecutionProcess;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00192\u00020\u0001:\u0003\u0019\u001a\u001bB$\b\u0004\u0012\u0011\u0010\u0002\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ.\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u0082\u0001\u0002\u001c\u001d\u00a8\u0006\u001e"}, d2={"Lgit4idea/actions/branch/GitPullBranchAction;", "Lgit4idea/actions/branch/GitSingleBranchAction;", "dynamicText", "Ljava/util/function/Supplier;", "", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "updateMethod", "Lgit4idea/config/UpdateMethod;", "<init>", "(Ljava/util/function/Supplier;Lgit4idea/config/UpdateMethod;)V", "disabledForLocal", "", "getDisabledForLocal", "()Z", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "branch", "Lgit4idea/GitBranch;", "Companion", "WithMerge", "WithRebase", "Lgit4idea/actions/branch/GitPullBranchAction$WithMerge;", "Lgit4idea/actions/branch/GitPullBranchAction$WithRebase;", "intellij.vcs.git"})
public abstract sealed class GitPullBranchAction
extends GitSingleBranchAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UpdateMethod updateMethod;
    private final boolean disabledForLocal;

    private GitPullBranchAction(Supplier<String> dynamicText, UpdateMethod updateMethod) {
        super(dynamicText);
        this.updateMethod = updateMethod;
        this.disabledForLocal = true;
    }

    @Override
    public boolean getDisabledForLocal() {
        return this.disabledForLocal;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull GitBranch branch) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        if (!(branch instanceof GitRemoteBranch)) {
            return;
        }
        GitUpdateExecutionProcess.launchUpdate(project, (Collection<? extends GitRepository>)repositories, GitPullBranchAction.Companion.configureTarget(repositories, (GitRemoteBranch)branch), this.updateMethod, false);
    }

    public /* synthetic */ GitPullBranchAction(Supplier dynamicText, UpdateMethod updateMethod, DefaultConstructorMarker $constructor_marker) {
        this(dynamicText, updateMethod);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lgit4idea/actions/branch/GitPullBranchAction$Companion;", "", "<init>", "()V", "configureTarget", "", "Lgit4idea/repo/GitRepository;", "Lgit4idea/branch/GitBranchPair;", "repositories", "", "branch", "Lgit4idea/GitRemoteBranch;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        private final Map<GitRepository, GitBranchPair> configureTarget(List<? extends GitRepository> repositories, GitRemoteBranch branch) {
            LinkedHashMap map2 = new LinkedHashMap();
            for (GitRepository gitRepository : repositories) {
                GitLocalBranch currentBranch = gitRepository.getCurrentBranch();
                if (currentBranch == null) continue;
                ((Map)map2).put(gitRepository, new GitBranchPair(currentBranch, (GitBranch)branch));
            }
            return map2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lgit4idea/actions/branch/GitPullBranchAction$WithMerge;", "Lgit4idea/actions/branch/GitPullBranchAction;", "<init>", "()V", "updateIfEnabledAndVisible", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "branch", "Lgit4idea/GitBranch;", "intellij.vcs.git"})
    public static final class WithMerge
    extends GitPullBranchAction {
        public WithMerge() {
            Supplier supplier = GitBundle.messagePointer((String)"branches.action.pull.into.branch.using.merge.selected", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
            super(supplier, UpdateMethod.MERGE, null);
        }

        @Override
        public void updateIfEnabledAndVisible(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull GitBranch branch) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
            Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
            Presentation $this$updateIfEnabledAndVisible_u24lambda_u240 = e.getPresentation();
            boolean bl = false;
            Object[] objectArray = new Object[]{GitBranchPopupActions.getCurrentBranchTruncatedPresentation(project, (Collection<? extends GitRepository>)repositories)};
            $this$updateIfEnabledAndVisible_u24lambda_u240.setText(GitBundle.message((String)"branches.action.pull.into.branch.using.merge", (Object[])objectArray));
            objectArray = new Object[]{GitBranchPopupActions.getCurrentBranchFullPresentation(project, (Collection<? extends GitRepository>)repositories)};
            $this$updateIfEnabledAndVisible_u24lambda_u240.setDescription(GitBundle.message((String)"branches.action.pull.into.branch.using.merge.description", (Object[])objectArray));
            GitBranchPopupActions.addTooltipText($this$updateIfEnabledAndVisible_u24lambda_u240, $this$updateIfEnabledAndVisible_u24lambda_u240.getDescription());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lgit4idea/actions/branch/GitPullBranchAction$WithRebase;", "Lgit4idea/actions/branch/GitPullBranchAction;", "<init>", "()V", "updateIfEnabledAndVisible", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "branch", "Lgit4idea/GitBranch;", "intellij.vcs.git"})
    public static final class WithRebase
    extends GitPullBranchAction {
        public WithRebase() {
            Supplier supplier = GitBundle.messagePointer((String)"branches.action.pull.into.branch.using.rebase.selected", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
            super(supplier, UpdateMethod.REBASE, null);
        }

        @Override
        public void updateIfEnabledAndVisible(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull GitBranch branch) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
            Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
            Presentation $this$updateIfEnabledAndVisible_u24lambda_u240 = e.getPresentation();
            boolean bl = false;
            Object[] objectArray = new Object[]{GitBranchPopupActions.getCurrentBranchTruncatedPresentation(project, (Collection<? extends GitRepository>)repositories)};
            $this$updateIfEnabledAndVisible_u24lambda_u240.setText(GitBundle.message((String)"branches.action.pull.into.branch.using.rebase", (Object[])objectArray));
            objectArray = new Object[]{GitBranchPopupActions.getCurrentBranchFullPresentation(project, (Collection<? extends GitRepository>)repositories)};
            $this$updateIfEnabledAndVisible_u24lambda_u240.setDescription(GitBundle.message((String)"branches.action.pull.into.branch.using.rebase.description", (Object[])objectArray));
            GitBranchPopupActions.addTooltipText($this$updateIfEnabledAndVisible_u24lambda_u240, $this$updateIfEnabledAndVisible_u24lambda_u240.getDescription());
        }
    }
}

