/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.annotate.AnnotationWarning;
import com.intellij.ui.AppUIUtil;
import git4idea.actions.GitUnshallowRepositoryAction;
import git4idea.annotate.GitAnnotationWarnings;
import git4idea.annotate.GitFileAnnotation;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lgit4idea/annotate/GitAnnotationWarnings;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getAnnotationWarnings", "Lcom/intellij/openapi/vcs/annotate/AnnotationWarning;", "gitFileAnnotation", "Lgit4idea/annotate/GitFileAnnotation;", "Companion", "intellij.vcs.git"})
public final class GitAnnotationWarnings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final String WARNINGS_DISMISSED_KEY = "git.annotate.shallow.warnings.dismissed";

    public GitAnnotationWarnings(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Nullable
    public final AnnotationWarning getAnnotationWarnings(@NotNull GitFileAnnotation gitFileAnnotation) {
        Intrinsics.checkNotNullParameter((Object)((Object)gitFileAnnotation), (String)"gitFileAnnotation");
        if (PropertiesComponent.getInstance((Project)this.project).getBoolean(WARNINGS_DISMISSED_KEY, false)) {
            return null;
        }
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(this.project).getRepositoryForRootQuick(gitFileAnnotation.getRoot());
        if (gitRepository == null) {
            return null;
        }
        GitRepository repository2 = gitRepository;
        if (!repository2.getInfo().isShallow()) {
            return null;
        }
        String string = GitBundle.message((String)"action.Git.Unshallow.text", (Object[])new Object[0]);
        AnnotationWarning.Action unshallowAction2 = new AnnotationWarning.Action(repository2, this, string){
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ GitAnnotationWarnings this$0;
            {
                this.$repository = $repository;
                this.this$0 = $receiver;
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1);
            }

            public void doAction(Runnable hideWarning) {
                Intrinsics.checkNotNullParameter((Object)hideWarning, (String)"hideWarning");
                GitUnshallowRepositoryAction.Companion.unshallowRepository(this.$repository, (Function0<Unit>)((Function0)() -> getAnnotationWarnings.unshallowAction.1.doAction$lambda$0(this.this$0, hideWarning)));
            }

            private static final void doAction$lambda$0$0(Runnable $hideWarning) {
                $hideWarning.run();
            }

            private static final Unit doAction$lambda$0(GitAnnotationWarnings this$0, Runnable $hideWarning) {
                AppUIUtil.invokeLaterIfProjectAlive((Project)GitAnnotationWarnings.access$getProject$p(this$0), () -> getAnnotationWarnings.unshallowAction.1.doAction$lambda$0$0($hideWarning));
                return Unit.INSTANCE;
            }
        };
        Object[] objectArray = IdeBundle.message((String)"label.dont.show", (Object[])new Object[0]);
        AnnotationWarning.Action dontShowAgainAction2 = new AnnotationWarning.Action(this, (String)objectArray){
            final /* synthetic */ GitAnnotationWarnings this$0;
            {
                this.this$0 = $receiver;
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1);
            }

            public void doAction(Runnable hideWarning) {
                Intrinsics.checkNotNullParameter((Object)hideWarning, (String)"hideWarning");
                PropertiesComponent.getInstance((Project)GitAnnotationWarnings.access$getProject$p(this.this$0)).setValue("git.annotate.shallow.warnings.dismissed", true);
                hideWarning.run();
            }
        };
        String string2 = GitBundle.message((String)"annotate.repository.is.shallow", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        objectArray = new AnnotationWarning.Action[]{unshallowAction2, dontShowAgainAction2};
        return AnnotationWarning.Companion.warning(string2, CollectionsKt.listOf((Object[])objectArray));
    }

    @JvmStatic
    @NotNull
    public static final GitAnnotationWarnings getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Project access$getProject$p(GitAnnotationWarnings $this) {
        return $this.project;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgit4idea/annotate/GitAnnotationWarnings$Companion;", "", "<init>", "()V", "WARNINGS_DISMISSED_KEY", "", "getInstance", "Lgit4idea/annotate/GitAnnotationWarnings;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GitAnnotationWarnings getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(GitAnnotationWarnings.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (GitAnnotationWarnings)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

