/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchOperation;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\fJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004J*\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lgit4idea/branch/GitUpstreamBranches;", "", "repositories", "", "Lgit4idea/repo/GitRepository;", "localBranchName", "", "git", "Lgit4idea/commands/Git;", "<init>", "(Ljava/util/Collection;Ljava/lang/String;Lgit4idea/commands/Git;)V", "upstreamBranches", "", "Lgit4idea/GitRemoteBranch;", "get", "restoreUpstream", "", "repository", "findUpstreamBranches", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitUpstreamBranches.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitUpstreamBranches.kt\ngit4idea/branch/GitUpstreamBranches\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1642#2,10:38\n1915#2:48\n1916#2:50\n1652#2:51\n1#3:49\n*S KotlinDebug\n*F\n+ 1 GitUpstreamBranches.kt\ngit4idea/branch/GitUpstreamBranches\n*L\n31#1:38,10\n31#1:48\n31#1:50\n31#1:51\n31#1:49\n*E\n"})
public final class GitUpstreamBranches {
    @NotNull
    private final String localBranchName;
    @NotNull
    private final Git git;
    @NotNull
    private final Map<GitRepository, GitRemoteBranch> upstreamBranches;

    public GitUpstreamBranches(@NotNull Collection<? extends GitRepository> repositories, @NotNull String localBranchName, @NotNull Git git) {
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)localBranchName, (String)"localBranchName");
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        this.localBranchName = localBranchName;
        this.git = git;
        this.upstreamBranches = this.findUpstreamBranches(repositories, this.localBranchName);
    }

    @NotNull
    public final Map<GitRepository, GitRemoteBranch> get() {
        return this.upstreamBranches;
    }

    public final void restoreUpstream(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        GitRemoteBranch gitRemoteBranch = this.upstreamBranches.get(repository2);
        if (gitRemoteBranch == null) {
            return;
        }
        GitRemoteBranch upstreamBranch = gitRemoteBranch;
        GitCommandResult gitCommandResult = this.git.setUpstream(repository2, upstreamBranch.getNameForLocalOperations(), this.localBranchName);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"setUpstream(...)");
        GitCommandResult result2 = gitCommandResult;
        if (!result2.success()) {
            GitBranchOperation.LOG.warn("Couldn't set " + this.localBranchName + " to track " + upstreamBranch + " in " + repository2.getRoot().getName() + ": " + result2.getErrorOutputAsJoinedString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<GitRepository, GitRemoteBranch> findUpstreamBranches(Collection<? extends GitRepository> repositories, String localBranchName) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = repositories;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            GitRepository repository2 = (GitRepository)element$iv$iv;
            boolean bl2 = false;
            if (repository2.getBranchTrackInfo(localBranchName) != null) {
                GitBranchTrackInfo trackInfo;
                boolean bl3 = false;
                pair = TuplesKt.to((Object)repository2, (Object)trackInfo.getRemoteBranch());
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }
}

