/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitHandlerListener;
import git4idea.commands.GitImplBase;
import git4idea.config.GitExecutable;
import git4idea.i18n.GitBundle;
import git4idea.util.GitVcsConsoleWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collections;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBinaryHandler
extends GitHandler {
    private static final int BUFFER_SIZE = 8192;
    @NotNull
    private final ByteArrayOutputStream myStdout;
    @NotNull
    private final ByteArrayOutputStream myStderr;
    @NotNull
    private final Semaphore mySteamSemaphore;
    @NotNull
    private final AtomicReference<VcsException> myException;

    public GitBinaryHandler(@Nullable Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command) {
        if (vcsRoot == null) {
            GitBinaryHandler.$$$reportNull$$$0(0);
        }
        if (command == null) {
            GitBinaryHandler.$$$reportNull$$$0(1);
        }
        super(project, vcsRoot, command, Collections.emptyList());
        this.myStdout = new ByteArrayOutputStream();
        this.myStderr = new ByteArrayOutputStream();
        this.mySteamSemaphore = new Semaphore(0);
        this.myException = new AtomicReference();
    }

    public GitBinaryHandler(@NotNull Path directory, @NotNull GitExecutable pathToExecutable, @NotNull GitCommand command) {
        if (directory == null) {
            GitBinaryHandler.$$$reportNull$$$0(2);
        }
        if (pathToExecutable == null) {
            GitBinaryHandler.$$$reportNull$$$0(3);
        }
        if (command == null) {
            GitBinaryHandler.$$$reportNull$$$0(4);
        }
        super(null, directory, pathToExecutable, command, Collections.emptyList());
        this.myStdout = new ByteArrayOutputStream();
        this.myStderr = new ByteArrayOutputStream();
        this.mySteamSemaphore = new Semaphore(0);
        this.myException = new AtomicReference();
    }

    @Override
    protected Process startProcess() throws ExecutionException {
        this.listeners().processStarted();
        return this.myCommandLine.createProcess();
    }

    @Override
    protected void startHandlingStreams() {
        this.handleStream(this.myProcess.getErrorStream(), this.myStderr, "Error stream copy of " + this.myCommandLine.getCommandLineString());
        this.handleStream(this.myProcess.getInputStream(), this.myStdout, "Output stream copy of " + this.myCommandLine.getCommandLineString());
    }

    private void handleStream(InputStream in, ByteArrayOutputStream out, @NotNull @NonNls String cmd) {
        if (cmd == null) {
            GitBinaryHandler.$$$reportNull$$$0(5);
        }
        Thread t = new Thread(() -> {
            try {
                int rc;
                byte[] buffer = new byte[8192];
                while ((rc = in.read(buffer)) != -1) {
                    out.write(buffer, 0, rc);
                }
            }
            catch (IOException e) {
                if (!this.myException.compareAndSet(null, new VcsException(GitBundle.message((String)"git.error.cant.process.output", (Object[])new Object[]{e.getLocalizedMessage()}), (Throwable)e))) {
                    LOG.error("Problem reading stream", (Throwable)e);
                }
            }
            finally {
                this.mySteamSemaphore.release(1);
            }
        }, cmd);
        t.setDaemon(true);
        t.start();
    }

    @Override
    protected void waitForProcess() {
        int exitCode;
        try {
            while (!this.mySteamSemaphore.tryAcquire(2, 50L, TimeUnit.MILLISECONDS)) {
                ProgressManager.checkCanceled();
            }
            while (!this.myProcess.waitFor(50L, TimeUnit.MILLISECONDS)) {
                ProgressManager.checkCanceled();
            }
            exitCode = this.myProcess.exitValue();
        }
        catch (InterruptedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring process exception: ", (Throwable)e);
            }
            exitCode = 255;
        }
        OUTPUT_LOG.debug(String.format("%s %% %s terminated (%s)", this.getCommand(), this.hashCode(), exitCode));
        this.setExitCode(exitCode);
        this.listeners().processTerminated(exitCode);
    }

    public byte @NotNull [] run() throws VcsException {
        Project project = this.project();
        final GitVcsConsoleWriter vcsConsoleWriter = project != null ? GitVcsConsoleWriter.getInstance(project) : null;
        this.addListener(new GitHandlerListener(){

            public void processTerminated(int exitCode) {
                if (exitCode != 0) {
                    VcsException e;
                    Charset cs = GitBinaryHandler.this.getCharset();
                    String message = new String(GitBinaryHandler.this.myStderr.toByteArray(), cs);
                    if (message.isEmpty()) {
                        message = GitBinaryHandler.this.myException.get() != null ? IdeCoreBundle.message((String)"finished.with.exit.code.text.message", (Object[])new Object[]{exitCode}) : null;
                    } else if (vcsConsoleWriter != null && !GitBinaryHandler.this.isStderrSuppressed()) {
                        vcsConsoleWriter.showErrorMessage(message);
                    }
                    if (message != null && (e = GitBinaryHandler.this.myException.getAndSet(new VcsException(message))) != null) {
                        GitHandler.LOG.warn("Dropping previous exception: ", (Throwable)e);
                    }
                }
            }

            public void startFailed(@NotNull Throwable exception) {
                VcsException err;
                VcsException oldErr;
                if (exception == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((oldErr = GitBinaryHandler.this.myException.getAndSet(err = new VcsException(GitBundle.message((String)"git.executable.unknown.error.message", (Object[])new Object[]{exception.getMessage()}), exception))) != null) {
                    GitHandler.LOG.warn("Dropping previous exception: ", (Throwable)oldErr);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exception", "git4idea/commands/GitBinaryHandler$1", "startFailed"));
            }
        });
        if (vcsConsoleWriter != null && !this.mySilent) {
            vcsConsoleWriter.showCommandLine("[" + GitImplBase.stringifyWorkingDir(project.getBasePath(), this.getWorkingDirectory()) + "] " + this.printableCommandLine());
        }
        try {
            this.runInCurrentThread();
        }
        catch (IOException e) {
            throw new VcsException(e.getMessage(), (Throwable)e);
        }
        if (this.myException.get() != null) {
            throw this.myException.get();
        }
        byte[] byArray = this.myStdout.toByteArray();
        if (byArray == null) {
            GitBinaryHandler.$$$reportNull$$$0(6);
        }
        return byArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToExecutable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitBinaryHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitBinaryHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "run";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleStream";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

