/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVcsOptions;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"Lgit4idea/config/GitSetupProjectConfig;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setupConfigIfNeeded", "configVar", "Lgit4idea/config/GitSetupProjectConfig$ConfigVariables;", "settings", "Lgit4idea/config/GitVcsOptions;", "ConfigVariables", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitSetupProjectConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitSetupProjectConfig.kt\ngit4idea/config/GitSetupProjectConfig\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,68:1\n13#2:69\n*S KotlinDebug\n*F\n+ 1 GitSetupProjectConfig.kt\ngit4idea/config/GitSetupProjectConfig\n*L\n48#1:69\n*E\n"})
public final class GitSetupProjectConfig
implements ProjectActivity {
    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        ProjectLevelVcsManager.Companion.getInstance(project).runAfterInitialization(() -> GitSetupProjectConfig.execute$lambda$0(this, project));
        return Unit.INSTANCE;
    }

    private final void setupConfigIfNeeded(Project project) {
        GitVcsOptions settings = (GitVcsOptions)GitVcsSettings.getInstance((Project)project).getState();
        for (ConfigVariables configVar : ConfigVariables.values()) {
            Intrinsics.checkNotNull((Object)settings);
            this.setupConfigIfNeeded(project, configVar, settings);
        }
    }

    private final void setupConfigIfNeeded(Project project, ConfigVariables configVar, GitVcsOptions settings) {
        String[] value;
        String string = (String)configVar.getSettingsGetter().invoke((Object)settings);
        if (string == null) {
            return;
        }
        String settingsValue = string;
        if (!((Boolean)configVar.getCondition().invoke((Object)project, (Object)settingsValue)).booleanValue()) {
            return;
        }
        List rootsToUpdate = new ArrayList();
        for (GitRepository repo : GitRepositoryManager.getInstance(project).getRepositories()) {
            value = GitConfigUtil.getValue(project, repo.getRoot(), configVar.getGitName());
            if (value != null) continue;
            Intrinsics.checkNotNull((Object)repo);
            rootsToUpdate.add(repo);
        }
        for (GitRepository repo : rootsToUpdate) {
            try {
                value = new String[]{"--local"};
                GitConfigUtil.setValue(project, repo.getRoot(), configVar.getGitName(), settingsValue, value);
            }
            catch (VcsException e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(GitSetupProjectConfig.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn((Throwable)e);
            }
        }
    }

    private static final void execute$lambda$0(GitSetupProjectConfig this$0, Project $project) {
        this$0.setupConfigIfNeeded($project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001Ba\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u00128\b\u0002\u0010\u0007\u001a2\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\b\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014RA\u0010\u0007\u001a2\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001b\u00a8\u0006\u001c"}, d2={"Lgit4idea/config/GitSetupProjectConfig$ConfigVariables;", "", "gitName", "", "settingsGetter", "Lkotlin/reflect/KProperty1;", "Lgit4idea/config/GitVcsOptions;", "condition", "Lkotlin/Function2;", "Lcom/intellij/openapi/project/Project;", "Lkotlin/ParameterName;", "name", "project", "value", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;Lkotlin/reflect/KProperty1;Lkotlin/jvm/functions/Function2;)V", "getGitName", "()Ljava/lang/String;", "getSettingsGetter", "()Lkotlin/reflect/KProperty1;", "getCondition", "()Lkotlin/jvm/functions/Function2;", "GC_AUTO", "CORE_FS_MONITOR", "CORE_UNTRACKED_CACHE", "CORE_LONGPATHS", "FEATURE_MANY_FILES", "intellij.vcs.git"})
    private static final class ConfigVariables
    extends Enum<ConfigVariables> {
        @NotNull
        private final String gitName;
        @NotNull
        private final KProperty1<GitVcsOptions, String> settingsGetter;
        @NotNull
        private final Function2<Project, String, Boolean> condition;
        public static final /* enum */ ConfigVariables GC_AUTO = new ConfigVariables("GC_AUTO", 0, "gc.auto", (KProperty1)2.INSTANCE, null, 4, null);
        public static final /* enum */ ConfigVariables CORE_FS_MONITOR = new ConfigVariables("core.fsmonitor", (KProperty1<GitVcsOptions, String>)((KProperty1)3.INSTANCE), (Function2<? super Project, ? super String, Boolean>)((Function2)ConfigVariables::_init_$lambda$1));
        public static final /* enum */ ConfigVariables CORE_UNTRACKED_CACHE = new ConfigVariables("CORE_UNTRACKED_CACHE", 2, "core.untrackedcache", (KProperty1)5.INSTANCE, null, 4, null);
        public static final /* enum */ ConfigVariables CORE_LONGPATHS = new ConfigVariables("core.longpaths", (KProperty1<GitVcsOptions, String>)((KProperty1)6.INSTANCE), (Function2<? super Project, ? super String, Boolean>)((Function2)ConfigVariables::_init_$lambda$2));
        public static final /* enum */ ConfigVariables FEATURE_MANY_FILES = new ConfigVariables("FEATURE_MANY_FILES", 4, "feature.manyFiles", (KProperty1)8.INSTANCE, null, 4, null);
        private static final /* synthetic */ ConfigVariables[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ConfigVariables(String gitName, KProperty1<GitVcsOptions, String> settingsGetter, Function2<? super Project, ? super String, Boolean> condition) {
            this.gitName = gitName;
            this.settingsGetter = settingsGetter;
            this.condition = condition;
        }

        /* synthetic */ ConfigVariables(String string, int n, String string2, KProperty1 kProperty1, Function2 function2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                function2 = ConfigVariables::_init_$lambda$0;
            }
            this(string2, (KProperty1<GitVcsOptions, String>)kProperty1, (Function2<? super Project, ? super String, Boolean>)function2);
        }

        @NotNull
        public final String getGitName() {
            return this.gitName;
        }

        @NotNull
        public final KProperty1<GitVcsOptions, String> getSettingsGetter() {
            return this.settingsGetter;
        }

        @NotNull
        public final Function2<Project, String, Boolean> getCondition() {
            return this.condition;
        }

        public static ConfigVariables[] values() {
            return (ConfigVariables[])$VALUES.clone();
        }

        public static ConfigVariables valueOf(String value) {
            return Enum.valueOf(ConfigVariables.class, value);
        }

        @NotNull
        public static EnumEntries<ConfigVariables> getEntries() {
            return $ENTRIES;
        }

        private static final boolean _init_$lambda$0(Project project, String string) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
            return true;
        }

        private static final boolean _init_$lambda$1(Project project, String value) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return GitConfigUtil.getBooleanValue(value) != null ? GitVersionSpecialty.SUPPORTS_BOOLEAN_FSMONITOR_OPTION.existsIn(project) : true;
        }

        private static final boolean _init_$lambda$2(Project project, String string) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
            return SystemInfo.isWindows;
        }

        static {
            $VALUES = configVariablesArray = new ConfigVariables[]{ConfigVariables.GC_AUTO, ConfigVariables.CORE_FS_MONITOR, ConfigVariables.CORE_UNTRACKED_CACHE, ConfigVariables.CORE_LONGPATHS, ConfigVariables.FEATURE_MANY_FILES};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

