/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceUtil;
import com.intellij.platform.vcs.impl.shared.telemetry.VcsScopeKt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.LogDataImpl;
import git4idea.GitCommit;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitHandlerInputProcessorUtil;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitFullDetailsCollector;
import git4idea.history.GitLogCommandParameters;
import git4idea.history.GitLogOutputSplitter;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.InternedGitLogRecordBuilder;
import git4idea.log.GitLogProvider;
import git4idea.log.GitRefManager;
import git4idea.telemetry.GitBackendTelemetrySpan;
import io.opentelemetry.api.trace.SpanBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class GitLogUtil {
    private static final Logger LOG = Logger.getInstance(GitLogUtil.class);
    public static final String GRAFTED = "grafted";
    public static final String REPLACED = "replaced";
    public static final List<String> LOG_ALL = List.of("HEAD", "--branches", "--remotes", "--tags");
    public static final String STDIN = "--stdin";
    public static final GitLogParser.GitLogOption[] COMMIT_METADATA_OPTIONS = new GitLogParser.GitLogOption[]{GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_TIME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY};

    public static void readTimedCommits(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> parameters, @Nullable java.util.function.Consumer<? super VcsUser> userConsumer, @Nullable java.util.function.Consumer<? super VcsRef> refConsumer, @NotNull java.util.function.Consumer<? super TimedVcsCommit> commitConsumer) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            GitLogUtil.$$$reportNull$$$0(2);
        }
        if (commitConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(3);
        }
        GitLogUtil.readTimedCommits(project, root, Collections.emptyList(), parameters, userConsumer, refConsumer, commitConsumer);
    }

    public static void readTimedCommits(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> configParameters, @NotNull List<String> parameters, @Nullable java.util.function.Consumer<? super VcsUser> userConsumer, @Nullable java.util.function.Consumer<? super VcsRef> refConsumer, @NotNull java.util.function.Consumer<? super TimedVcsCommit> commitConsumer) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(4);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(5);
        }
        if (configParameters == null) {
            GitLogUtil.$$$reportNull$$$0(6);
        }
        if (parameters == null) {
            GitLogUtil.$$$reportNull$$$0(7);
        }
        if (commitConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(8);
        }
        GitLogUtil.readTimedCommits(project, root, configParameters, parameters, Collections.emptyList(), userConsumer, refConsumer, commitConsumer);
    }

    public static void readTimedCommits(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> configParameters, @NotNull List<String> parameters, @NotNull List<FilePath> filePaths, @Nullable java.util.function.Consumer<? super VcsUser> userConsumer, @Nullable java.util.function.Consumer<? super VcsRef> refConsumer, @NotNull java.util.function.Consumer<? super TimedVcsCommit> commitConsumer) throws VcsException {
        VcsLogObjectsFactory factory;
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(9);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(10);
        }
        if (configParameters == null) {
            GitLogUtil.$$$reportNull$$$0(11);
        }
        if (parameters == null) {
            GitLogUtil.$$$reportNull$$$0(12);
        }
        if (filePaths == null) {
            GitLogUtil.$$$reportNull$$$0(13);
        }
        if (commitConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(14);
        }
        if ((factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            return;
        }
        GitLineHandler handler = GitLogUtil.createGitHandler(project, root, configParameters, false);
        ArrayList<GitLogParser.GitLogOption> options2 = new ArrayList<GitLogParser.GitLogOption>(Arrays.asList(GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.COMMIT_TIME));
        if (userConsumer != null) {
            options2.add(GitLogParser.GitLogOption.AUTHOR_NAME);
            options2.add(GitLogParser.GitLogOption.AUTHOR_EMAIL);
        }
        if (refConsumer != null) {
            options2.add(GitLogParser.GitLogOption.REF_NAMES);
        }
        GitLogParser<GitLogRecord> parser = GitLogParser.createDefaultParser(project, options2.toArray(new GitLogParser.GitLogOption[0]));
        handler.setStdoutSuppressed(true);
        handler.addParameters(parser.getPretty(), "--encoding=UTF-8");
        handler.addParameters("--decorate=full");
        if (parameters.contains("--")) {
            int index = parameters.indexOf("--");
            handler.addParameters(parameters.subList(0, index));
            handler.endOptions();
            handler.addParameters(parameters.subList(index + 1, parameters.size()));
        } else {
            handler.addParameters(parameters);
            handler.endOptions();
        }
        handler.addRelativePaths(filePaths);
        GitLogOutputSplitter<GitLogRecord> handlerListener = new GitLogOutputSplitter<GitLogRecord>(handler, parser, record -> {
            Hash hash = HashImpl.build((String)record.getHash());
            List parents = ContainerUtil.map((Object[])record.getParentsHashes(), arg_0 -> ((VcsLogObjectsFactory)factory).createHash(arg_0));
            commitConsumer.accept(factory.createTimedCommit(hash, parents, record.getCommitTime()));
            if (refConsumer != null) {
                for (VcsRef ref : GitLogUtil.parseRefs(record.getRefs(), hash, factory, root)) {
                    refConsumer.accept(ref);
                }
            }
            if (userConsumer != null) {
                userConsumer.accept(factory.createUser(record.getAuthorName(), record.getAuthorEmail()));
            }
        });
        Git.getInstance().runCommandWithoutCollectingOutput(handler).throwOnError(new int[0]);
        handlerListener.reportErrors();
    }

    @NotNull
    public static List<? extends VcsCommitMetadata> collectMetadata(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(15);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(16);
        }
        if (hashes == null) {
            GitLogUtil.$$$reportNull$$$0(17);
        }
        CollectConsumer collectConsumer = new CollectConsumer();
        GitLogUtil.collectMetadata(project, root, hashes, (java.util.function.Consumer<? super VcsCommitMetadata>)collectConsumer);
        return new ArrayList(collectConsumer.getResult());
    }

    public static void collectMetadata(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> hashes, @NotNull java.util.function.Consumer<? super VcsCommitMetadata> consumer) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(18);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(19);
        }
        if (hashes == null) {
            GitLogUtil.$$$reportNull$$$0(20);
        }
        if (consumer == null) {
            GitLogUtil.$$$reportNull$$$0(21);
        }
        if (hashes.isEmpty()) {
            return;
        }
        VcsLogObjectsFactory factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return;
        }
        GitLineHandler h = GitLogUtil.createGitHandler(project, root);
        GitLogParser<GitLogRecord> parser = GitLogParser.createDefaultParser(project, COMMIT_METADATA_OPTIONS);
        h.setSilent(true);
        h.addParameters(GitLogUtil.getNoWalkParameter(project));
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h.addParameters(STDIN);
        h.endOptions();
        GitLogUtil.sendHashesToStdin(hashes, h);
        GitLogOutputSplitter<GitLogRecord> outputHandler = new GitLogOutputSplitter<GitLogRecord>(h, parser, record -> {
            SmartList parents = new SmartList();
            for (String parent : record.getParentsHashes()) {
                parents.add(HashImpl.build((String)parent));
            }
            record.setUsedHandler(h);
            consumer.accept(factory.createCommitMetadata(HashImpl.build((String)record.getHash()), (List)parents, record.getCommitTime(), root, record.getSubject(), record.getAuthorName(), record.getAuthorEmail(), record.getFullMessage(), record.getCommitterName(), record.getCommitterEmail(), record.getAuthorTimeStamp()));
        });
        Git.getInstance().runCommandWithoutCollectingOutput(h).throwOnError(new int[0]);
        outputHandler.reportErrors();
    }

    @NotNull
    public static VcsLogProvider.DetailedLogData collectMetadata(@NotNull Project project, @NotNull VirtualFile root, String ... params) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(22);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(23);
        }
        return GitLogUtil.collectMetadata(project, root, new GitLogCommandParameters(Collections.emptyList(), Arrays.asList(params)));
    }

    @NotNull
    public static VcsLogProvider.DetailedLogData collectMetadata(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitLogCommandParameters parameters) throws VcsException {
        VcsLogObjectsFactory factory;
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(24);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(25);
        }
        if (parameters == null) {
            GitLogUtil.$$$reportNull$$$0(26);
        }
        if ((factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            LogDataImpl logDataImpl = LogDataImpl.empty();
            if (logDataImpl == null) {
                GitLogUtil.$$$reportNull$$$0(27);
            }
            return logDataImpl;
        }
        ObjectOpenCustomHashSet refs = new ObjectOpenCustomHashSet(GitLogProvider.DONT_CONSIDER_SHA);
        ArrayList commits = new ArrayList();
        java.util.function.Consumer<GitLogRecord> recordConsumer = arg_0 -> GitLogUtil.lambda$collectMetadata$3(root, factory, commits, (Set)refs, arg_0);
        try {
            GitLineHandler handler = GitLogUtil.createGitHandler(project, root, parameters.getConfigParameters(), false);
            GitLogParser.GitLogOption[] options2 = (GitLogParser.GitLogOption[])ArrayUtil.append((Object[])COMMIT_METADATA_OPTIONS, (Object)((Object)GitLogParser.GitLogOption.REF_NAMES));
            GitLogParser<GitLogRecord> parser = GitLogParser.createDefaultParser(project, options2);
            handler.setStdoutSuppressed(true);
            handler.addParameters(parameters.getFilterParameters());
            handler.addParameters(parser.getPretty(), "--encoding=UTF-8");
            handler.addParameters("--decorate=full");
            handler.endOptions();
            IJTracer tracer = TelemetryManager.getInstance().getTracer(VcsScopeKt.VcsScope);
            TraceUtil.runWithSpanThrows((SpanBuilder)tracer.spanBuilder(GitBackendTelemetrySpan.Log.LoadingCommitMetadata.getName()).setAttribute("rootName", root.getName()), __ -> {
                GitLogOutputSplitter handlerListener = new GitLogOutputSplitter(handler, parser, recordConsumer);
                Git.getInstance().runCommandWithoutCollectingOutput(handler).throwOnError(new int[0]);
                handlerListener.reportErrors();
            });
        }
        catch (VcsException e) {
            if (commits.isEmpty()) {
                throw e;
            }
            LOG.warn("Error during loading details, returning partially loaded commits\n", (Throwable)e);
        }
        return new LogDataImpl((Set)refs, commits);
    }

    public static void readFullDetails(@NotNull Project project, @NotNull VirtualFile root, @NotNull java.util.function.Consumer<? super GitCommit> commitConsumer, String ... parameters) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(28);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(29);
        }
        if (commitConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(30);
        }
        if (parameters == null) {
            GitLogUtil.$$$reportNull$$$0(31);
        }
        new GitFullDetailsCollector(project, root, new InternedGitLogRecordBuilder()).readFullDetails(commitConsumer, GitCommitRequirements.DEFAULT, false, parameters);
    }

    public static void readFullDetailsForHashes(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> hashes, @NotNull GitCommitRequirements requirements, @NotNull Consumer<? super GitCommit> commitConsumer) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(32);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(33);
        }
        if (hashes == null) {
            GitLogUtil.$$$reportNull$$$0(34);
        }
        if (requirements == null) {
            GitLogUtil.$$$reportNull$$$0(35);
        }
        if (commitConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(36);
        }
        if (hashes.isEmpty()) {
            return;
        }
        new GitFullDetailsCollector(project, root, new InternedGitLogRecordBuilder()).readFullDetailsForHashes(hashes, requirements, false, arg_0 -> commitConsumer.consume(arg_0));
    }

    @NotNull
    private static Collection<VcsRef> parseRefs(@NotNull Collection<String> refs, @NotNull Hash hash, @NotNull VcsLogObjectsFactory factory, @NotNull VirtualFile root) {
        if (refs == null) {
            GitLogUtil.$$$reportNull$$$0(37);
        }
        if (hash == null) {
            GitLogUtil.$$$reportNull$$$0(38);
        }
        if (factory == null) {
            GitLogUtil.$$$reportNull$$$0(39);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(40);
        }
        List list = ContainerUtil.mapNotNull(refs, refName -> {
            if (refName.equals(GRAFTED) || refName.equals(REPLACED)) {
                return null;
            }
            VcsRefType type = GitRefManager.getRefType(refName);
            return (refName = GitBranchUtil.stripRefsPrefix(refName)).equals("origin/HEAD") ? null : factory.createRef(hash, refName, type, root);
        });
        if (list == null) {
            GitLogUtil.$$$reportNull$$$0(41);
        }
        return list;
    }

    @Nullable
    public static VcsLogObjectsFactory getObjectsFactoryWithDisposeCheck(@NotNull Project project) {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(42);
        }
        return (VcsLogObjectsFactory)ReadAction.compute(() -> {
            if (!project.isDisposed()) {
                return (VcsLogObjectsFactory)project.getService(VcsLogObjectsFactory.class);
            }
            return null;
        });
    }

    @NotNull
    public static VcsCommitMetadata createMetadata(@NotNull VirtualFile root, @NotNull GitLogRecord record, @NotNull VcsLogObjectsFactory factory) {
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(43);
        }
        if (record == null) {
            GitLogUtil.$$$reportNull$$$0(44);
        }
        if (factory == null) {
            GitLogUtil.$$$reportNull$$$0(45);
        }
        List parents = ContainerUtil.map((Object[])record.getParentsHashes(), arg_0 -> ((VcsLogObjectsFactory)factory).createHash(arg_0));
        VcsCommitMetadata vcsCommitMetadata = factory.createCommitMetadata(factory.createHash(record.getHash()), parents, record.getCommitTime(), root, record.getSubject(), record.getAuthorName(), record.getAuthorEmail(), record.getFullMessage(), record.getCommitterName(), record.getCommitterEmail(), record.getAuthorTimeStamp());
        if (vcsCommitMetadata == null) {
            GitLogUtil.$$$reportNull$$$0(46);
        }
        return vcsCommitMetadata;
    }

    public static void sendHashesToStdin(@NotNull Collection<String> hashes, @NotNull GitHandler handler) {
        if (hashes == null) {
            GitLogUtil.$$$reportNull$$$0(47);
        }
        if (handler == null) {
            GitLogUtil.$$$reportNull$$$0(48);
        }
        handler.setInputProcessor(GitHandlerInputProcessorUtil.writeLines(hashes, "\n", handler.getCharset(), true));
    }

    @NotNull
    public static String getNoWalkParameter(@NotNull Project project) {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(49);
        }
        return GitVersionSpecialty.NO_WALK_UNSORTED.existsIn(project) ? "--no-walk=unsorted" : "--no-walk";
    }

    @NotNull
    public static GitLineHandler createGitHandler(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(50);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(51);
        }
        return GitLogUtil.createGitHandler(project, root, Collections.emptyList(), false);
    }

    @NotNull
    static GitLineHandler createGitHandler(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> configParameters, boolean lowPriorityProcess) {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(52);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(53);
        }
        if (configParameters == null) {
            GitLogUtil.$$$reportNull$$$0(54);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.LOG, configParameters);
        if (lowPriorityProcess) {
            handler.withLowPriority();
        }
        handler.setWithMediator(false);
        GitLineHandler gitLineHandler = handler;
        if (gitLineHandler == null) {
            GitLogUtil.$$$reportNull$$$0(55);
        }
        return gitLineHandler;
    }

    public static long parseTime(@NotNull String timeString) {
        if (timeString == null) {
            GitLogUtil.$$$reportNull$$$0(56);
        }
        return Long.parseLong(timeString.trim()) * 1000L;
    }

    private static /* synthetic */ void lambda$collectMetadata$3(VirtualFile root, VcsLogObjectsFactory factory, List commits, Set refs, GitLogRecord record) {
        VcsCommitMetadata commit = GitLogUtil.createMetadata(root, record, factory);
        commits.add(commit);
        Collection<VcsRef> refsInRecord = GitLogUtil.parseRefs(record.getRefs(), (Hash)commit.getId(), factory, root);
        for (VcsRef ref : refsInRecord) {
            if (refs.add(ref)) continue;
            VcsRef otherRef = (VcsRef)ContainerUtil.find((Iterable)refs, r -> GitLogProvider.DONT_CONSIDER_SHA.equals(r, (Object)ref));
            LOG.error("Adding duplicate element " + String.valueOf(ref) + " to the set containing " + String.valueOf(otherRef));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 27, 41, 46, 55 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 16: 
            case 19: 
            case 23: 
            case 25: 
            case 29: 
            case 33: 
            case 40: 
            case 43: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 7: 
            case 12: 
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 8: 
            case 14: 
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitConsumer";
                break;
            }
            case 6: 
            case 11: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configParameters";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 17: 
            case 20: 
            case 34: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 27: 
            case 41: 
            case 46: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/history/GitLogUtil";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirements";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 39: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/history/GitLogUtil";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMetadata";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRefs";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createMetadata";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createGitHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readTimedCommits";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "collectMetadata";
                break;
            }
            case 27: 
            case 41: 
            case 46: 
            case 55: {
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "readFullDetails";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "readFullDetailsForHashes";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "parseRefs";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getObjectsFactoryWithDisposeCheck";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createMetadata";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "sendHashesToStdin";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getNoWalkParameter";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createGitHandler";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "parseTime";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 27, 41, 46, 55 -> new IllegalStateException(string);
        };
    }
}

