/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.log;

import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsShortCommitDetails;
import git4idea.branch.GitRebaseParams;
import git4idea.config.GitVersion;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseProcess;
import git4idea.rebase.GitRebaseSpec;
import git4idea.rebase.interactive.GitInteractiveRebaseUsingLogKt;
import git4idea.rebase.log.GitCommitEditingOperationResult;
import git4idea.repo.GitRepository;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J4\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperation;", "", "repository", "Lgit4idea/repo/GitRepository;", "<init>", "(Lgit4idea/repo/GitRepository;)V", "getRepository", "()Lgit4idea/repo/GitRepository;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "rebase", "Lgit4idea/rebase/log/GitCommitEditingOperationResult;", "commits", "", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "rebaseEditor", "Lgit4idea/rebase/GitRebaseEditorHandler;", "preserveMerges", "", "initialHead", "", "GitMultipleCommitEditingProcess", "intellij.vcs.git"})
public abstract class GitCommitEditingOperation {
    @NotNull
    private final GitRepository repository;
    @NotNull
    private final Project project;

    public GitCommitEditingOperation(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        this.repository = repository2;
        Project project = this.repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
    }

    @NotNull
    protected final GitRepository getRepository() {
        return this.repository;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final GitCommitEditingOperationResult rebase(@NotNull List<? extends VcsCommitMetadata> commits, @NotNull GitRebaseEditorHandler rebaseEditor, boolean preserveMerges, @Nullable String initialHead) {
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        Intrinsics.checkNotNullParameter((Object)rebaseEditor, (String)"rebaseEditor");
        VcsCommitMetadata lastCommit = (VcsCommitMetadata)CollectionsKt.last(commits);
        GitRebaseParams.RebaseUpstream base = GitInteractiveRebaseUsingLogKt.getRebaseUpstreamFor((VcsShortCommitDetails)lastCommit);
        GitVersion gitVersion2 = this.repository.getVcs().getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)gitVersion2, (String)"getVersion(...)");
        GitRebaseParams params = GitRebaseParams.Companion.editCommits(gitVersion2, base, rebaseEditor, preserveMerges);
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        ProgressIndicator indicator = progressIndicator;
        GitRebaseSpec gitRebaseSpec = GitRebaseSpec.forNewRebase(this.project, params, CollectionsKt.listOf((Object)this.repository), indicator);
        Intrinsics.checkNotNullExpressionValue((Object)gitRebaseSpec, (String)"forNewRebase(...)");
        GitRebaseSpec spec2 = gitRebaseSpec;
        GitMultipleCommitEditingProcess process = new GitMultipleCommitEditingProcess(this.repository, params, spec2, initialHead);
        process.rebase();
        return process.getResult();
    }

    public static /* synthetic */ GitCommitEditingOperationResult rebase$default(GitCommitEditingOperation gitCommitEditingOperation, List list, GitRebaseEditorHandler gitRebaseEditorHandler, boolean bl, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: rebase");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        return gitCommitEditingOperation.rebase(list, gitRebaseEditorHandler, bl, string);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperation$GitMultipleCommitEditingProcess;", "Lgit4idea/rebase/GitRebaseProcess;", "repository", "Lgit4idea/repo/GitRepository;", "params", "Lgit4idea/branch/GitRebaseParams;", "spec", "Lgit4idea/rebase/GitRebaseSpec;", "initialHead", "", "<init>", "(Lgit4idea/repo/GitRepository;Lgit4idea/branch/GitRebaseParams;Lgit4idea/rebase/GitRebaseSpec;Ljava/lang/String;)V", "result", "Lgit4idea/rebase/log/GitCommitEditingOperationResult;", "getResult", "()Lgit4idea/rebase/log/GitCommitEditingOperationResult;", "setResult", "(Lgit4idea/rebase/log/GitCommitEditingOperationResult;)V", "notifySuccess", "", "intellij.vcs.git"})
    private static final class GitMultipleCommitEditingProcess
    extends GitRebaseProcess {
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final GitRebaseParams params;
        @NotNull
        private final String initialHead;
        @NotNull
        private GitCommitEditingOperationResult result;

        public GitMultipleCommitEditingProcess(@NotNull GitRepository repository2, @NotNull GitRebaseParams params, @NotNull GitRebaseSpec spec2, @Nullable String initialHead) {
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)spec2, (String)"spec");
            super(repository2.getProject(), spec2, null);
            this.repository = repository2;
            this.params = params;
            this.repository.update();
            String string = initialHead;
            if (string == null) {
                String string2 = this.repository.getCurrentRevision();
                string = string2;
                Intrinsics.checkNotNull((Object)string2);
            }
            this.initialHead = string;
            this.result = GitCommitEditingOperationResult.Incomplete.INSTANCE;
        }

        @NotNull
        public final GitCommitEditingOperationResult getResult() {
            return this.result;
        }

        public final void setResult(@NotNull GitCommitEditingOperationResult gitCommitEditingOperationResult) {
            Intrinsics.checkNotNullParameter((Object)gitCommitEditingOperationResult, (String)"<set-?>");
            this.result = gitCommitEditingOperationResult;
        }

        @Override
        @RequiresBackgroundThread
        protected void notifySuccess() {
            this.repository.update();
            String string = this.repository.getCurrentRevision();
            Intrinsics.checkNotNull((Object)string);
            String newHead = string;
            this.result = new GitCommitEditingOperationResult.Complete(this.repository, this.params.getUpstream(), this.initialHead, newHead, null, null, 48, null);
        }
    }
}

