/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import git4idea.GitWorkingTree;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.remoteApi.GitRepositoryFrontendSynchronizer;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryDataHolder;
import git4idea.repo.GitWorkingTreeHolder;
import git4idea.workingTrees.GitListWorktreeLineListener;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u000e\u0010\u000b\u001a\u00020\fH\u0094@\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgit4idea/repo/GitWorkingTreeHolderImpl;", "Lgit4idea/repo/GitWorkingTreeHolder;", "Lgit4idea/repo/GitRepositoryDataHolder;", "repository", "Lgit4idea/repo/GitRepository;", "<init>", "(Lgit4idea/repo/GitRepository;)V", "workingTrees", "", "Lgit4idea/GitWorkingTree;", "getWorkingTrees", "updateState", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "readWorkingTreesFromGit", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitWorkingTreeHolderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitWorkingTreeHolderImpl.kt\ngit4idea/repo/GitWorkingTreeHolderImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,44:1\n60#2,5:45\n13#2:50\n*S KotlinDebug\n*F\n+ 1 GitWorkingTreeHolderImpl.kt\ngit4idea/repo/GitWorkingTreeHolderImpl\n*L\n26#1:45,5\n42#1:50\n*E\n"})
public final class GitWorkingTreeHolderImpl
extends GitRepositoryDataHolder
implements GitWorkingTreeHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Collection<GitWorkingTree> workingTrees;
    @NotNull
    private static final Logger LOG;

    public GitWorkingTreeHolderImpl(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        super(repository2, "GitWorkingTreeHolder");
        this.workingTrees = CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Collection<GitWorkingTree> getWorkingTrees() {
        return this.workingTrees;
    }

    @Override
    @Nullable
    protected Object updateState(@NotNull Continuation<? super Unit> $completion) {
        this.workingTrees = this.readWorkingTreesFromGit();
        ((GitRepositoryFrontendSynchronizer)BackgroundTaskUtil.syncPublisher((Project)this.getRepository().getProject(), GitRepositoryFrontendSynchronizer.TOPIC)).workingTreesLoaded(this.getRepository());
        return Unit.INSTANCE;
    }

    private final Collection<GitWorkingTree> readWorkingTreesFromGit() {
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Reloading working trees for " + this.getRepository().getRoot(), t$iv);
        }
        GitListWorktreeLineListener listener2 = new GitListWorktreeLineListener(this.getRepository());
        GitLineHandlerListener[] gitLineHandlerListenerArray = new GitLineHandlerListener[]{listener2};
        GitCommandResult gitCommandResult = Git.getInstance().listWorktrees(this.getRepository(), gitLineHandlerListenerArray);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"listWorktrees(...)");
        GitCommandResult commandResult2 = gitCommandResult;
        if (!commandResult2.success()) {
            LOG.info("Failed to list worktrees: " + commandResult2 + ".errorOutputAsJoinedString");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get working trees for " + this.getRepository().getRoot() + ": " + listener2.getTrees());
        }
        return listener2.getTrees();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitWorkingTreeHolderImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/repo/GitWorkingTreeHolderImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

