/*
 * Decompiled with CFR 0.152.
 */
package git4idea.troubleshooting;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.config.GitConfigUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.troubleshooting.GitTroubleInfoCollectorKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ&\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00072\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lgit4idea/troubleshooting/GitConfigHelper;", "", "<init>", "()V", "MASKED_VALUE", "", "readGitConfig", "", "project", "Lcom/intellij/openapi/project/Project;", "filter", "config", "Inclusion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitTroubleInfoCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitTroubleInfoCollector.kt\ngit4idea/troubleshooting/GitConfigHelper\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n466#2:180\n415#2:181\n466#2:186\n415#2:187\n1266#3,4:182\n1266#3,4:188\n1068#3:206\n139#4,10:192\n221#4:202\n222#4:204\n149#4:205\n1#5:203\n*S KotlinDebug\n*F\n+ 1 GitTroubleInfoCollector.kt\ngit4idea/troubleshooting/GitConfigHelper\n*L\n136#1:180\n136#1:181\n141#1:186\n141#1:187\n136#1:182,4\n141#1:188,4\n172#1:206\n149#1:192,10\n149#1:202\n149#1:204\n149#1:205\n149#1:203\n*E\n"})
final class GitConfigHelper {
    @NotNull
    public static final GitConfigHelper INSTANCE = new GitConfigHelper();
    @NotNull
    public static final String MASKED_VALUE = "***";

    private GitConfigHelper() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Map<String, String> readGitConfig(@NotNull Project project) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            Object object2;
            List<GitRepository> list = GitRepositoryManager.getInstance(project).getRepositories();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
            GitRepository singleGitRoot = (GitRepository)CollectionsKt.singleOrNull(list);
            if (singleGitRoot != null) {
                void $this$associateByTo$iv$iv$iv;
                void $this$mapValuesTo$iv$iv;
                Map<String, List<String>> map2 = GitConfigUtil.getValues(project, singleGitRoot.getRoot(), null);
                Intrinsics.checkNotNullExpressionValue(map2, (String)"getValues(...)");
                Map<String, List<String>> $this$mapValues$iv = map2;
                boolean $i$f$mapValues = false;
                Map<String, List<String>> map3 = $this$mapValues$iv;
                destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
                destination$iv$iv$iv = destination$iv$iv;
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it;
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    var14_21 = destination$iv$iv$iv;
                    boolean bl = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    var20_29 = it$iv$iv.getKey();
                    var19_28 = var14_21;
                    boolean bl2 = false;
                    Object v = it.getValue();
                    Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                    var21_30 = (String)CollectionsKt.last((List)((List)v));
                    var19_28.put(var20_29, var21_30);
                }
                object2 = destination$iv$iv$iv;
            } else {
                void $this$associateByTo$iv$iv$iv;
                void $this$mapValuesTo$iv$iv;
                void $this$mapValues$iv;
                VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
                if (virtualFile == null) {
                    return null;
                }
                VirtualFile projectDir = virtualFile;
                Map<String, List<String>> map4 = GitConfigUtil.getValues(project, projectDir, null);
                Intrinsics.checkNotNullExpressionValue(map4, (String)"getValues(...)");
                Map<String, List<String>> $i$f$mapValues = map4;
                boolean $i$f$mapValues2 = false;
                destination$iv$iv = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                destination$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                Map destination$iv$iv$iv = destination$iv$iv;
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it;
                    void it$iv$iv;
                    var14_21 = (Map.Entry)element$iv$iv$iv;
                    Map map5 = destination$iv$iv$iv;
                    boolean bl = false;
                    Map.Entry bl2 = (Map.Entry)element$iv$iv$iv;
                    var20_29 = it$iv$iv.getKey();
                    var19_28 = map5;
                    boolean bl3 = false;
                    Object v = it.getValue();
                    Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                    var21_30 = (String)CollectionsKt.last((List)((List)v));
                    var19_28.put(var20_29, var21_30);
                }
                object2 = destination$iv$iv$iv;
            }
            object = object2;
        }
        catch (VcsException e) {
            GitTroubleInfoCollectorKt.access$getLOG$p().warn("Failed to read git config", (Throwable)e);
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> filter(@NotNull Map<String, String> config) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(config, (String)"config");
        Map<String, String> $this$mapNotNull$iv = config;
        boolean $i$f$mapNotNull = false;
        Map<String, String> map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Inclusion inclusion;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (StringsKt.startsWith$default((String)key, (String)"core.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)key, (String)"i18n.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)key, (String)"rebase.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)key, (String)"merge.", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)key, (Object)"commit.gpgSign")) {
                inclusion = Inclusion.INCLUDE;
            } else {
                Object[] objectArray = new String[]{"user.signingkey", "commit.template", "gpg.program", "credential.helper"};
                inclusion = SetsKt.setOf((Object[])objectArray).contains(key) ? Inclusion.INCLUDE_MASKED : Inclusion.SKIP;
            }
            Inclusion inclusion2 = inclusion;
            Pair pair = switch (WhenMappings.$EnumSwitchMapping$0[inclusion2.ordinal()]) {
                case 1 -> TuplesKt.to((Object)key, (Object)value);
                case 2 -> TuplesKt.to((Object)key, (Object)MASKED_VALUE);
                case 3 -> null;
                default -> throw new NoWhenBranchMatchedException();
            };
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return MapsKt.toMap((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair pair = (Pair)a;
                boolean bl = false;
                String key = (String)pair.component1();
                pair = (Pair)b;
                Comparable comparable = (Comparable)((Object)key);
                bl = false;
                key = (String)pair.component1();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)key)));
            }
        }));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/troubleshooting/GitConfigHelper$Inclusion;", "", "<init>", "(Ljava/lang/String;I)V", "INCLUDE", "INCLUDE_MASKED", "SKIP", "intellij.vcs.git"})
    public static final class Inclusion
    extends Enum<Inclusion> {
        public static final /* enum */ Inclusion INCLUDE = new Inclusion();
        public static final /* enum */ Inclusion INCLUDE_MASKED = new Inclusion();
        public static final /* enum */ Inclusion SKIP = new Inclusion();
        private static final /* synthetic */ Inclusion[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Inclusion[] values() {
            return (Inclusion[])$VALUES.clone();
        }

        public static Inclusion valueOf(String value) {
            return Enum.valueOf(Inclusion.class, value);
        }

        @NotNull
        public static EnumEntries<Inclusion> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = inclusionArray = new Inclusion[]{Inclusion.INCLUDE, Inclusion.INCLUDE_MASKED, Inclusion.SKIP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Inclusion.values().length];
            try {
                nArray[Inclusion.INCLUDE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Inclusion.INCLUDE_MASKED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Inclusion.SKIP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

