/*
 * Decompiled with CFR 0.152.
 */
package git4idea.workingTrees;

import com.intellij.codeWithMe.ClientId;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryExtKt;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerListener;
import com.intellij.platform.ide.CoreUiCoroutineScopeHolder;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.vcs.git.repo.GitRepositoriesHolder;
import com.intellij.vcs.git.repo.GitRepositoryModel;
import com.intellij.vcs.git.workingTrees.GitWorkingTreesUtil;
import git4idea.GitRemoteBranch;
import git4idea.GitWorkingTree;
import git4idea.actions.workingTree.GitWorkingTreeDialogData;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0086@\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lgit4idea/workingTrees/GitWorkingTreesService;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "repositoryToModel", "Lcom/intellij/vcs/git/repo/GitRepositoryModel;", "repository", "Lgit4idea/repo/GitRepository;", "shouldWorkingTreesTabBeShown", "", "workingTreesTabOpenedByUser", "", "workingTreesTabClosedByUser", "createWorkingTree", "Lgit4idea/workingTrees/GitWorkingTreesService$Result;", "data", "Lgit4idea/actions/workingTree/GitWorkingTreeDialogData;", "(Lgit4idea/repo/GitRepository;Lgit4idea/actions/workingTree/GitWorkingTreeDialogData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "openWorkingTreeProject", "tree", "Lgit4idea/GitWorkingTree;", "Companion", "Result", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitWorkingTreesService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitWorkingTreesService.kt\ngit4idea/workingTrees/GitWorkingTreesService\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,126:1\n42#2,3:127\n*S KotlinDebug\n*F\n+ 1 GitWorkingTreesService.kt\ngit4idea/workingTrees/GitWorkingTreesService\n*L\n122#1:127,3\n*E\n"})
public final class GitWorkingTreesService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private static final String WORKING_TREE_TAB_STATUS_PROPERTY = "Git.Working.Tree.Tab.closed.by.user";
    @NotNull
    private static final String WORKING_TREE_TAB_STATUS_OPENED_BY_USER = "opened";
    @NotNull
    private static final String WORKING_TREE_TAB_STATUS_CLOSED_BY_USER = "closed";

    public GitWorkingTreesService(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ GitWorkingTreesService this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = GitRepositoriesHolder.Companion.getInstance(this.this$0.project).getUpdates().collect(new FlowCollector(){

                                public final Object emit(GitRepositoriesHolder.UpdateType updateType, Continuation<? super Unit> $completion) {
                                    if (updateType == GitRepositoriesHolder.UpdateType.WORKING_TREES_LOADED || updateType == GitRepositoriesHolder.UpdateType.RELOAD_STATE) {
                                        ApplicationManager.getApplication().invokeLater(() -> 1.emit$lambda$0(this$0));
                                    }
                                    return Unit.INSTANCE;
                                }

                                private static final void emit$lambda$0(GitWorkingTreesService this$02) {
                                    ((ChangesViewContentManagerListener)this$02.project.getMessageBus().syncPublisher(ChangesViewContentManagerListener.TOPIC)).toolWindowMappingChanged();
                                }
                            }, (Continuation)this);
                            if (object2 != object) throw new KotlinNothingValueException();
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            throw new KotlinNothingValueException();
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    @Nullable
    public final GitRepositoryModel repositoryToModel(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        return GitRepositoriesHolder.Companion.getInstance(this.project).get(RepositoryExtKt.repositoryId((Repository)repository2));
    }

    public final boolean shouldWorkingTreesTabBeShown() {
        GitRepository gitRepository = Companion.getRepoForWorkingTreesSupport(this.project);
        if (gitRepository == null) {
            return false;
        }
        GitRepository repository2 = gitRepository;
        String value = PropertiesComponent.getInstance((Project)this.project).getValue(WORKING_TREE_TAB_STATUS_PROPERTY);
        String string = value;
        return Intrinsics.areEqual((Object)string, (Object)WORKING_TREE_TAB_STATUS_CLOSED_BY_USER) ? false : (Intrinsics.areEqual((Object)string, (Object)WORKING_TREE_TAB_STATUS_OPENED_BY_USER) ? true : repository2.getWorkingTreeHolder().getWorkingTrees().size() > 1);
    }

    public final void workingTreesTabOpenedByUser() {
        PropertiesComponent.getInstance((Project)this.project).setValue(WORKING_TREE_TAB_STATUS_PROPERTY, WORKING_TREE_TAB_STATUS_OPENED_BY_USER);
    }

    public final void workingTreesTabClosedByUser() {
        PropertiesComponent.getInstance((Project)this.project).setValue(WORKING_TREE_TAB_STATUS_PROPERTY, WORKING_TREE_TAB_STATUS_CLOSED_BY_USER);
    }

    @Nullable
    public final Object createWorkingTree(@NotNull GitRepository repository2, @NotNull GitWorkingTreeDialogData data2, @NotNull Continuation<? super Result> $completion) {
        String string = GitBundle.message((String)"progress.title.creating.worktree", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return TasksKt.withBackgroundProgress((Project)this.project, (String)string, (boolean)true, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Result>, Object>(data2, repository2, null){
            int label;
            final /* synthetic */ GitWorkingTreeDialogData $data;
            final /* synthetic */ GitRepository $repository;
            {
                this.$data = $data;
                this.$repository = $repository;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Result result2;
                        ResultKt.throwOnFailure((Object)$result);
                        String newBranchName = this.$data.getNewBranchName() != null ? this.$data.getNewBranchName() : (this.$data.getSourceBranch() instanceof GitRemoteBranch ? ((GitRemoteBranch)this.$data.getSourceBranch()).getNameForRemoteOperations() : null);
                        GitCommandResult gitCommandResult = Git.getInstance().createWorkingTree(this.$repository, this.$data.getWorkingTreePath(), this.$data.getSourceBranch(), newBranchName);
                        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"createWorkingTree(...)");
                        GitCommandResult commandResult2 = gitCommandResult;
                        if (commandResult2.success()) {
                            result2 = Result.Companion.getSUCCESS();
                        } else {
                            String string = commandResult2.getErrorOutputAsHtmlString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getErrorOutputAsHtmlString(...)");
                            result2 = Result.Companion.createFailure(string);
                        }
                        return result2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Result> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public final void openWorkingTreeProject(@NotNull GitWorkingTree tree) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        boolean $i$f$service = false;
        Class<CoreUiCoroutineScopeHolder> serviceClass$iv = CoreUiCoroutineScopeHolder.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        BuildersKt.launch$default((CoroutineScope)((CoreUiCoroutineScopeHolder)object).coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(tree, null){
            int label;
            final /* synthetic */ GitWorkingTree $tree;
            {
                this.$tree = $tree;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        String string = this.$tree.getPath().getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        Path path = Paths.get(string, new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                        this.label = 1;
                        Object object2 = ProjectUtil.openOrImportAsync$default((ProjectUtil)ProjectUtil.INSTANCE, (Path)path, null, (Continuation)((Continuation)this), (int)2, null);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgit4idea/workingTrees/GitWorkingTreesService$Companion;", "", "<init>", "()V", "WORKING_TREE_TAB_STATUS_PROPERTY", "", "WORKING_TREE_TAB_STATUS_OPENED_BY_USER", "WORKING_TREE_TAB_STATUS_CLOSED_BY_USER", "getInstance", "Lgit4idea/workingTrees/GitWorkingTreesService;", "project", "Lcom/intellij/openapi/project/Project;", "getRepoForWorkingTreesSupport", "Lgit4idea/repo/GitRepository;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GitWorkingTreesService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(GitWorkingTreesService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (GitWorkingTreesService)object;
        }

        @Nullable
        public final GitRepository getRepoForWorkingTreesSupport(@Nullable Project project) {
            if (project == null) {
                return null;
            }
            if (!GitWorkingTreesUtil.INSTANCE.isWorkingTreesFeatureEnabled()) {
                return null;
            }
            List<GitRepository> list = GitRepositoryManager.getInstance(project).getRepositories();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
            List<GitRepository> repositories = list;
            return (GitRepository)CollectionsKt.singleOrNull(repositories);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lgit4idea/workingTrees/GitWorkingTreesService$Result;", "", "success", "", "errorOutputAsHtmlString", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "<init>", "(ZLjava/lang/String;)V", "getSuccess", "()Z", "getErrorOutputAsHtmlString", "()Ljava/lang/String;", "Companion", "intellij.vcs.git"})
    public static final class Result {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean success;
        @NotNull
        private final String errorOutputAsHtmlString;
        @NotNull
        private static final Result SUCCESS = new Result(true, "");

        private Result(boolean success2, String errorOutputAsHtmlString) {
            this.success = success2;
            this.errorOutputAsHtmlString = errorOutputAsHtmlString;
        }

        public final boolean getSuccess() {
            return this.success;
        }

        @NotNull
        public final String getErrorOutputAsHtmlString() {
            return this.errorOutputAsHtmlString;
        }

        public /* synthetic */ Result(boolean success2, String errorOutputAsHtmlString, DefaultConstructorMarker $constructor_marker) {
            this(success2, errorOutputAsHtmlString);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\b\u001a\u00020\u00052\r\b\u0001\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lgit4idea/workingTrees/GitWorkingTreesService$Result$Companion;", "", "<init>", "()V", "SUCCESS", "Lgit4idea/workingTrees/GitWorkingTreesService$Result;", "getSUCCESS", "()Lgit4idea/workingTrees/GitWorkingTreesService$Result;", "createFailure", "errorOutputAsHtmlString", "", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.vcs.git"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Result getSUCCESS() {
                return SUCCESS;
            }

            @NotNull
            public final Result createFailure(@NlsContexts.NotificationContent @NotNull String errorOutputAsHtmlString) {
                Intrinsics.checkNotNullParameter((Object)errorOutputAsHtmlString, (String)"errorOutputAsHtmlString");
                return new Result(false, errorOutputAsHtmlString, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

