/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.de.Capitalization;
import ai.grazie.rules.de.GermanTreePatterns;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodePattern;
import com.google.common.collect.Iterables;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

enum AdjDeclination {
    DEF,
    IND,
    SOL;

    static final NodePattern datFusedPreposition;
    static final NodePattern accFusedPreposition;
    static final NodePattern anyFusedPreposition;
    static final NodePattern adjDetAmbiguity;
    static final NodePattern ambiguous;
    private static final NodePattern possiblyMisparsedRelativePronoun;
    private static final NodePattern possiblyNonAgreeingAdj;
    static final NodePattern nonDet;
    private static final NodePattern withDefiniteDeterminer;
    private static final NodePattern indefiniteDeterminer;
    private static final NodePattern solDeclensionDet;
    private static final NodePattern withSolDeclension;
    private static final NodePattern misparsedDet;
    static final NodePattern recognizableGenitive;
    static final NodePattern wegen;
    static final NodePattern anStatt;
    static final NodePattern waehrend;
    static final NodePattern recognizableGenOrDatPreposition;
    static final NodePattern featureSharingConj;
    static final NodePattern substantivatedNeutralAdj;
    static final NodePattern withDetInsideAmodConj;

    @Nullable
    static AdjDeclination fromNPHead(Node main) {
        AdjDeclination ownResult;
        if (substantivatedNeutralAdj.matches(main)) {
            return SOL;
        }
        if (withDefiniteDeterminer.matches(main)) {
            return DEF;
        }
        Node det = AdjDeclination.findOwnDet(main);
        if (solDeclensionDet.matches(det) || det == null && withSolDeclension.matches(main)) {
            return SOL;
        }
        if (indefiniteDeterminer.matches(det)) {
            return IND;
        }
        if (ambiguous.matches(main)) {
            return null;
        }
        AdjDeclination adjDeclination = ownResult = det == null ? SOL : null;
        if (det == null && GermanTreePatterns.findPreposition(main) == null && featureSharingConj.matches(main)) {
            AdjDeclination headDeclination = AdjDeclination.fromNPHead(main.head());
            return headDeclination == ownResult ? ownResult : null;
        }
        return ownResult;
    }

    @Nullable
    static Node findOwnDet(Node main) {
        Node amod;
        Node det = main.findDependents("det.*").stream().filter(NodePattern.not(nonDet)::matches).findFirst().orElse(null);
        Node nmod = main.hasDependent("nmod") ? (Node)Iterables.getLast((Iterable)StreamEx.of(main.findDependents("nmod")).filter(dep -> dep.isBefore(main)), null) : null;
        Node nummod = main.hasDependent("nummod") ? main.findDependents("nummod").getFirst() : null;
        Node node = amod = withDetInsideAmodConj.matches(main) ? (Node)main.findDependents("amod").getFirst().findDependents("conj").stream().findAny().orElse(null) : null;
        return det != null ? det : (misparsedDet.matches(nmod) ? nmod : (misparsedDet.matches(nummod) ? nummod : amod));
    }

    static {
        datFusedPreposition = NodePattern.N.form("am|aufm|beim|im|vom|vorm|zu[mr]|(ue|\u00fc)berm|unterm|hinterm");
        accFusedPreposition = NodePattern.N.form("(an|in|um|auf|durch|f(ue|\u00fc)r)s|(ue|\u00fc)ber[ns]");
        anyFusedPreposition = NodePattern.or(datFusedPreposition, accFusedPreposition);
        adjDetAmbiguity = NodePattern.N.form("(s(\u00e4|ae)mtliche|solche|andere|beide)[mnsr]?");
        ambiguous = NodePattern.N.withDependent("det|amod", adjDetAmbiguity.markAs("Ambig")).andOr(NodePattern.N.withDependent("amod", NodePattern.not(NodePattern.N.alreadyMarkedAs("Ambig"))), CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("amod")));
        possiblyMisparsedRelativePronoun = NodePattern.N.form("der").withHead(GermanTreePatterns.firstInPhraseAfterCommasOrConj.withHead(NodePattern.N.withHeadRelation("acl")).withDependent("amod", NodePattern.N.form(".*e[rm]?")));
        possiblyNonAgreeingAdj = NodePattern.N.beforeHead().withDependent("conj", NodePattern.N.form("(ander|\u00e4hnlich).*").withOnlyDependents(NodePattern.N.withHeadRelation("cc")));
        nonDet = NodePattern.or(NodePattern.N.form("das").directlyBefore(NodePattern.N.withHeadRelation("amod").form(".+es")).markAs("Das").directlyAfter(NodePattern.or(NodePattern.N.withHead("cop|aux(:pass)|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis", CommonPatterns.possiblySkipUp("cop|aux(:pass)", NodePattern.N.noDependents("[cn]subj(:pass)?|expl").and(CommonPatterns.possiblySkipDown("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.withDependent("det", NodePattern.N.alreadyMarkedAs("Das")))))), NodePattern.ROOT.andOr(NodePattern.N.lemma("sein"), NodePattern.N.pos("VER:[123].*").noDependents("nsubj(:pass)?|expl")).noDependents("dep"))), NodePattern.N.form("der").withNextSibling(NodePattern.N.form(".+er").withHead("amod", NodePattern.N.pos("SUB:GEN.*").andNot(NodePattern.N.withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.withDependent("case"))))).directlyAfter(NodePattern.N.withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.lemma("\u00e4hneln"))).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("case"))), NodePattern.N.form("die").directlyAfter(NodePattern.N.pos("SUB.*PLU.*").directlyAfter(NodePattern.N.withHeadRelation("mark"))).withNextSibling(NodePattern.N.withHead("amod", CommonPatterns.closestDepToHead.beforeHead().pos("SUB.*PLU.*").withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.withHeadRelation("csubj:pass"))).form(".+e")), NodePattern.N.pos("ART:DEF.*").markAs("Det").withHead(NodePattern.N.withDependent("det", NodePattern.not(NodePattern.N.alreadyMarkedAs("Det")).pos("ART:DEF.*"))), NodePattern.N.afterHead(), NodePattern.N.form("ihr").andOr(NodePattern.N.directlyAfter(NodePattern.N.pos("VER:[123].*")), NodePattern.N.withHead(NodePattern.or(NodePattern.N.withHeadRelation("vocative|parataxis|appos"), NodePattern.ROOT).pos("SUB:NOM:PLU.*")).directlyBeforeHead(), NodePattern.N.withDependent("case")), NodePattern.N.lemma("beid").withNextSibling(NodePattern.N.pos("ART:DEF.*")), NodePattern.N.onlyPos("(SUB|PRO:PER|VER):.*").noForm("ihr"), possiblyMisparsedRelativePronoun, NodePattern.N.pos("ADJ.*").noPos("(PRO|ART).*"), NodePattern.N.form("[wd]essen|deren|denen|solch"), NodePattern.N.pos("ART:DEF.*").withHead("det", NodePattern.N.markAs("Head")).withDependent("punct", CommonPatterns.comma.noMatchUntil("Head", CommonPatterns.comma)).andNot(NodePattern.N.withHead("det", CommonPatterns.severalDependents("amod"))), NodePattern.N.inFormSequence(0, 1, "ein", "bi(ss|\u00df)chen|wenig|paar"), NodePattern.N.withHead("det", NodePattern.N.withDependent("amod", possiblyNonAgreeingAdj)), NodePattern.N.form("alle.?").directlyAfterHead().withHead("det", NodePattern.N.pos("PRO.*")), NodePattern.N.lemma("beid").withHead(NodePattern.N.withDependent("conj", NodePattern.not(GermanTreePatterns.clause))));
        withDefiniteDeterminer = NodePattern.or(NodePattern.N.withDependent("det|amod", NodePattern.N.form("der|die|das|des|dem|den|diese.?|d..selbe.?|je[dn]e.?|welche.?|alle.?").andNot(possiblyMisparsedRelativePronoun).andNot(nonDet)), NodePattern.N.noPos(".*PLU.*").withDependent("det|amod", NodePattern.N.form("manche.?")), NodePattern.N.withDependent("case", anyFusedPreposition), NodePattern.N.withDependent("amod", NodePattern.N.withDependent("mark", NodePattern.N.form("zu").andNot(NodePattern.N.withPrevSibling(NodePattern.N))).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("amod")))));
        indefiniteDeterminer = NodePattern.N.form("[mdsk]?eine?.?|ihre?.?|unse?re?.?|euere?.?|eure.?");
        solDeclensionDet = NodePattern.N.lemma("viel|einig|wenig|andere");
        withSolDeclension = NodePattern.or(NodePattern.N.withDependent("nummod"), NodePattern.N.withDependent("amod", solDeclensionDet));
        misparsedDet = NodePattern.N.beforeHead().and(CommonPatterns.lowercasedHasPos("PRO:IND.*")).noDependents("det|case").andNot(NodePattern.N.lemma("all"));
        recognizableGenitive = NodePattern.or(NodePattern.N.withDependent("det.*|amod"), NodePattern.N.onlyPos("SUB.*GEN.*"));
        wegen = NodePattern.N.form("wegen");
        anStatt = NodePattern.N.form("(an)?statt");
        waehrend = NodePattern.N.form("w(ae|\u00e4)hrend");
        recognizableGenOrDatPreposition = NodePattern.or(wegen, anStatt, waehrend);
        featureSharingConj = NodePattern.N.markAs("Conj").withHead("conj", NodePattern.N.withHeadRelation("nsubj.*|i?obj|obl.*|nmod.*|root").withPhraseStart(NodePattern.N.noForm(":")).noDependents("appos", NodePattern.N.before("Conj")).andOr(NodePattern.N.noDependents("case"), NodePattern.N.withDependent("case", NodePattern.N.noForm("am").markAs("case")).noDependents("case", NodePattern.not(NodePattern.N.alreadyMarkedAs("case"))))).noDependents("cop").andNot(NodePattern.not(recognizableGenitive).withHead(NodePattern.N.withDependent("case", recognizableGenOrDatPreposition)));
        substantivatedNeutralAdj = NodePattern.N.withHeadRelation("xcomp|obl").withDependent("case").withDependent("nmod|det", Capitalization.etwasNichtsVielWenig);
        withDetInsideAmodConj = NodePattern.N.noDependents("det(:poss)?").withDependent("amod", NodePattern.N.beforeHead().withDependent("conj", NodePattern.N.lemma("kein")));
    }
}

