/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.EnglishValences;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.TenseChanges;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.ReportingKind;
import java.time.LocalDateTime;

class TenseAdverbials {
    private static final String FUTURE_TENSE_MSG = " typically goes with Future tense";
    private static final NodePattern infinitiveExpected = NodePattern.N.withDependent("mark", NodePattern.N.form("to"));
    private static final NodePattern withTenselessModal = NodePattern.N.withDependent("aux", NodePattern.N.pos("MD").noLemma("can"));
    private static final NodePattern futureYear = EnglishTreePatterns.singleYearCD.and(node -> TenseAdverbials.currentYear() < Integer.parseInt(node.form()));
    static final NodePattern inYear = EnglishTreePatterns.singleYearCD.andNot(NodePattern.custom(node -> node.hasForm(String.valueOf(TenseAdverbials.currentYear())))).noDependents(NodePattern.N.lemma("of|like")).withDependent("case", NodePattern.N.form("in|over|between").markAs("Prep"));
    private static final NodePattern anyToPastSimple = NodePattern.custom((predicate, match) -> {
        Node have = TenseChanges.findPerfectHave(predicate);
        return have != null ? TenseChanges.perfectToSimple(predicate, match, have) : TenseChanges.nonPastToPast(predicate, match);
    }).andNot(infinitiveExpected);
    private static final NodePattern perfectShouldBePastSimple = NodePattern.custom((predicate, match) -> {
        Node have = TenseChanges.findPerfectHave(predicate);
        return have != null ? TenseChanges.perfectToSimple(predicate, match, have) : null;
    }).andNot(EnglishTreePatterns.withModal).andNot(infinitiveExpected);
    private static final String REQUIRES_PAST_SIMPLE = " requires Past Simple";
    private static final NodePattern pastPerfect = NodePattern.N.withDependent("aux", NodePattern.N.pos("VBD").lemma("have"));

    TenseAdverbials() {
    }

    private static int currentYear() {
        return LocalDateTime.now().getYear();
    }

    private static NodePattern useFuture() {
        NodePattern headToFuture = NodePattern.or(NodePattern.N.lemma("see|call|create|try|tell|ask|find|add|offer|happen|hear|check|win|lose|identify|encourage|mention|miss|discover|surprise|experience|knock|ring"), NodePattern.N.lemma("think|decide|plan|consider|understand|believe|remember|know|realize|feel|miss|dream|fear|enjoy|hope|ensure|agree|disagree|determine|recognize|approve|want|care").noDependents("obl", NodePattern.N.withDependent("case", NodePattern.N.form("about")).before("Adverbial")), NodePattern.N.lemma("study|practice|research|prepare|clean|pack|paint|play|fix|repair|install|download|upload|keep|save|watch|avoid|recommend|learn|store").withDependent("obj").andOptionally(NodePattern.N.noDependents("aux.*").noHeadRelation("[xc]comp|advcl").and(TenseChanges::presentToGoingTo)));
        NodePattern allowNonFuture = NodePattern.or(NodePattern.N.lemma("want|wish|intend|plan|envision"), EnglishTreePatterns.withModal, NodePattern.N.lemma("need").withDependent("xcomp"), infinitiveExpected, CommonPatterns.withQuestionMark, NodePattern.N.withHeadRelation("advcl").andOr(NodePattern.N.withDependent("mark"), NodePattern.N.withDependent("advmod", CommonPatterns.firstChildPhrase.form("when"))), NodePattern.N.withHead("ccomp", NodePattern.N.lemma("think|decide|plan|consider|understand|believe|remember|know|realize|feel|miss|dream|fear|enjoy|hope|ensure|agree|disagree|determine|recognize|approve|want|care")));
        NodePattern misattachedNonFuture = NodePattern.N.withPrevSibling(NodePattern.N.withDependent("acl", infinitiveExpected));
        NodePattern tomorrow = NodePattern.N.form("tomorrow").markAs("Adverbial").withHead("obl:tmod", NodePattern.or(NodePattern.N.pos("VB[ZP]").and(headToFuture), NodePattern.N.pos("VBN?").withDependent("aux").and(headToFuture), NodePattern.N.pos("VBD")).andNot(allowNonFuture).and(TenseChanges::toFuture)).message("'tomorrow' typically goes with Future tense");
        NodePattern nextTimeUnit = NodePattern.or(Semantics.timeUnits, NodePattern.N.form("time")).afterHead().markAs("Adverbial").withDependent("amod", NodePattern.N.form("next").includeIntoReport(ReportingKind.Hover)).noDependents("det").withHead("obl:tmod", NodePattern.N.pos("VB[ZP]").and(headToFuture).andNot(allowNonFuture).and(TenseChanges::toFuture)).message("'next $Adverbial' typically goes with Future tense");
        NodePattern inFuture = NodePattern.or(NodePattern.N.form("future").andOr(NodePattern.N.withDependent("det", NodePattern.N.form("the")).withDependent("amod", NodePattern.N.markAs("Adj")).message("'in the $Adj future' typically goes with Future tense"), NodePattern.N.message("'in future' typically goes with Future tense")), NodePattern.or(NodePattern.N.form("hours|days|weeks|months|years|decades|ages|eons|yonks"), NodePattern.N.lemma("version|release|edition|update|publication").pos("NN.*")).markAs("HeadNoun").withDependent("amod", NodePattern.N.form("future")).message("'in future $HeadNoun' typically goes with Future tense")).withDependent("case", NodePattern.N.form("in").markAs("In")).withHead("obl", NodePattern.N.pos("VB[ZP]").andNot(allowNonFuture).noHeadRelation("acl:relcl").andNot(NodePattern.N.lemma("think|decide|plan|consider|understand|believe|remember|know|realize|feel|miss|dream|fear|enjoy|hope|ensure|agree|disagree|determine|recognize|approve|want|care").withDependent("[xc]comp|advcl")).noLemma("see|anticipate|expect|envision|occur|happen|transpire|unfold").andNot(NodePattern.N.inFormSequence(0, "takes?", "place")).and(TenseChanges::toFuture)).reportRangeTo("In", ReportingKind.Hover);
        return NodePattern.or(tomorrow, nextTimeUnit, inFuture).andNot(misattachedNonFuture).includeIntoReport(ReportingKind.Hover);
    }

    private static NodePattern usePastSimple() {
        NodePattern forNP = NodePattern.N.withDependent("case", NodePattern.N.form("for"));
        NodePattern prep = inYear.reportEverythingTouched(ReportingKind.Hover).withHead(perfectShouldBePastSimple.noDependents("amod", NodePattern.N.lemma("recent|last")).andNot(pastPerfect.withDependent("obl", forNP))).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withDependent("case", NodePattern.N.form("since")).afterHead())).message("'$Prep $_' requires Past Simple");
        NodePattern prep_Year = NodePattern.N.lemma("year").withDependent("case", NodePattern.N.form("at|in").markAs("Prep")).andOr(NodePattern.N.withDependent("amod", NodePattern.N.form("selected")).message("'$Prep selected $_' requires Past Simple"), NodePattern.N.withDependent("nummod", NodePattern.N.pos("CD").afterHead().markAs("Num").includeIntoReport(ReportingKind.Hover)).message("'$Prep $_ $Num' requires Past Simple")).reportRangeTo("Prep", ReportingKind.Hover).and(CommonPatterns.skipUp("nmod", NodePattern.N.withHead(perfectShouldBePastSimple.noDependents(CommonPatterns.firstWord.form("had")))));
        NodePattern attachmentAmbiguity = NodePattern.or(NodePattern.N.withPrevSiblingIncludingOtherSide(NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound").andOr(NodePattern.N.withDependent("amod|nmod.*"), Semantics.event)), NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("advcl").markAs("Advcl")).withPhraseStart(NodePattern.N.directlyAfter("Advcl")), NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("obl").withDependent("compound:prt")).trace("misparsed acl 'set up some time ago'"), NodePattern.N.withHead("obl:tmod", NodePattern.N.pos("NN.*").withDependent("cop")));
        NodePattern nummodAttachmentAmbiguity = NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound").withDependent("nummod"));
        NodePattern lastEtcClause = NodePattern.or(NodePattern.markedNodeMatches("TimeUnit", NodePattern.N.beforeHead()), EnglishValences.definitelyIntransitive, NodePattern.N.lemma("go|be"), NodePattern.N.withDependent("obj|cop"), NodePattern.N.withDependent("obl|xcomp", NodePattern.N.afterHead().before("TimeUnit"))).and(anyToPastSimple);
        NodePattern lastFirstSecondTimePeriod = Semantics.timeUnits.andNot(attachmentAmbiguity).andNot(nummodAttachmentAmbiguity).markAs("TimeUnit").andOr(NodePattern.N.pos("NN").noDependents("det", NodePattern.N.form("the")).andOr(NodePattern.N.withHead("obl:tmod", lastEtcClause), NodePattern.N.withHead("nmod:tmod", NodePattern.N.withHead("xcomp", lastEtcClause).andNot(EnglishTreePatterns.clause))).noDependents("case").withDependent("amod", NodePattern.N.lemma("last|initial").markAs("Adj")).reportRangeTo("Adj", ReportingKind.Hover).message("'$Adj $_' requires Past Simple"), NodePattern.N.pos("NN.*").withHead("obl", perfectShouldBePastSimple).withDependent("amod", NodePattern.N.lemma("first|second|third|initial").markAs("Adj")).withDependent("case", NodePattern.N.lemma("at|in|during").markAs("Prep")).reportRangeTo("Prep", ReportingKind.Hover).message("'$Prep $Adj $_' requires Past Simple")).noDependents("cop");
        NodePattern suspiciousRelCl = NodePattern.N.withHeadRelation("acl:relcl").withDependent("xcomp", EnglishTreePatterns.withToMark.noPos("VB"));
        NodePattern ago = NodePattern.N.lemma("ago").noDependents(CommonPatterns.possiblySkipDown("case", NodePattern.N.form("since|like|than|from"))).andNot(CommonPatterns.possiblySkipDown("obl:npmod", NodePattern.N.withDependent("mark|case", NodePattern.N.form("as")))).noDependents("obl.*", NodePattern.N.withDependent("advmod", NodePattern.N.form("less|more|fewer"))).withHead("advmod", anyToPastSimple.andNot(withTenselessModal).andNot(suspiciousRelCl).markAs("Head")).noMatchUntil("Head", NodePattern.N.pos("VBD")).andOr(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("obj")), NodePattern.not(attachmentAmbiguity)).andNot(CommonPatterns.quotedWord).includeIntoReport(ReportingKind.Hover).message("'ago' requires Past Simple");
        NodePattern graphLike = NodePattern.N.lemma("graph|diagram|table|section|period|tendency|chart");
        NodePattern numberLike = NodePattern.N.lemma("number|percentage|proportion|ratio");
        NodePattern changeLike = NodePattern.N.lemma("increase|decrease|change");
        NodePattern withGraphLikeAround = NodePattern.or(graphLike, numberLike, NodePattern.N.withDependent("nsubj.*", NodePattern.or(graphLike, changeLike)), NodePattern.N.pos("JJR"));
        NodePattern future = NodePattern.N.withDependent("aux", NodePattern.N.lemma("will|shall"));
        NodePattern withTyposAround = NodePattern.N.withDependent("nsubj", NodePattern.N.directlyBeforeHead().noPos().andNot(CommonPatterns.capitalized));
        NodePattern since_from_to = EnglishTreePatterns.singleYearCD.markAs("Year1").withDependent("case", NodePattern.N.form("from|since").andNot(EnglishTreePatterns.afterAposOrQuote).markAs("From")).directlyBefore(NodePattern.N.form("to|till").markAs("To").directlyBefore(EnglishTreePatterns.singleYearCD.andNot(futureYear).markAs("Year2"))).reportEverythingTouched(ReportingKind.Hover).and(CommonPatterns.skipUp("nmod", NodePattern.or(NodePattern.N.withHead(anyToPastSimple.andNot(future).andNot(withGraphLikeAround).andNot(withTyposAround)), NodePattern.N.withDependent(".*", anyToPastSimple.andNot(NodePattern.N.withHeadRelation("cop|aux|aux:pass")).andNot(withGraphLikeAround).andNot(withTyposAround))).andNot(graphLike).andNot(changeLike).andNot(NodePattern.N.withPrevSibling(graphLike)))).andNot(attachmentAmbiguity).message("'$From $Year1 $To $Year2' requires Past Simple");
        NodePattern yesterday = NodePattern.N.form("yesterday").withHead("obl:tmod", anyToPastSimple.andNot(withTenselessModal)).andNot(attachmentAmbiguity).andNot(CommonPatterns.quotedWord).includeIntoReport(ReportingKind.Hover).message("'$_' requires Past Simple");
        return NodePattern.or(prep, prep_Year, ago, since_from_to, yesterday, lastFirstSecondTimePeriod);
    }

    private static NodePattern usePresentPerfect() {
        NodePattern misparsedReason = NodePattern.N.withDependent("amod", NodePattern.N.potentialPos("VB.*").withPrevSibling(NodePattern.N.withHeadRelation("compound|nmod:poss"))).trace("since X returned Y");
        NodePattern everSince = NodePattern.N.inFormSequence(1, "ever", "since");
        NodePattern sinceWithMessage = NodePattern.N.form("since").includeIntoReport(ReportingKind.Hover).andNot(EnglishTreePatterns.beforeAposOrQuote).andOr(NodePattern.N.directlyAfter(NodePattern.N.form("ever").includeIntoReport(ReportingKind.Hover)).message("Use the Present Perfect tense with 'ever since'"), CommonPatterns.firstChildPhrase.message("Use the Present Perfect tense with 'since'")).andNot(CommonPatterns.capitalizedMiddle);
        NodePattern sinceClauseFinalHost = CommonPatterns.possiblyConj(NodePattern.ROOT).noDependents("aux", NodePattern.N.noLemma("do")).noDependents("cop|aux|aux:pass", NodePattern.N.form("been")).and((node, match) -> TenseChanges.simpleToPerfect(node, match));
        NodePattern withEndPoint = NodePattern.or(NodePattern.N.withNeighbor(2, NodePattern.N.pos("CD").withDependent("case")), NodePattern.N.withDependent("nummod", NodePattern.N.withDependent("nmod", NodePattern.N.pos("CD").withDependent("case"))));
        NodePattern firstX = NodePattern.N.withDependent("amod", NodePattern.or(NodePattern.N.form("first|second"), NodePattern.N.pos("ORD"))).trace("first X since Y");
        NodePattern sinceNominalDependent = NodePattern.N.withHead("obl|advmod|nmod", NodePattern.N.noHeadRelation("advcl").andOr(EnglishTreePatterns.verbalClause.noLemma("include|contain|consist|incorporate|constitute|have").noDependents("aux(:pass)?").and((node, match) -> TenseChanges.simpleToPerfect(node, match)), CommonPatterns.skipUp("xcomp", NodePattern.ROOT.andOr(NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.N.lemma("be").noForm("been").andNot(EnglishTreePatterns.apostropheS)).andNot(firstX).noDependents("case"), NodePattern.N.withDependent("aux", NodePattern.N.lemma("do"))).and((node, match) -> TenseChanges.simpleToPerfect(node, match)))).andNot(EnglishTreePatterns.withModal).andNot(Semantics.directSpeech).noDependents("conj", NodePattern.N.after("SinceHost").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("after|then")))).noDependents("obl", NodePattern.or(NodePattern.N.pos("CD"), NodePattern.N.withDependent("nummod")).withDependent("case", NodePattern.N.form("from"))).noDependents(NodePattern.N.afterHead().before("SinceHost").and(EnglishTreePatterns.clause).andNot(EnglishTreePatterns.withToMark)).noDependents("advcl|acl", NodePattern.N.pos("VBG?").after("SinceHost")));
        NodePattern clausePresentTense = EnglishTreePatterns.clause.andOr(NodePattern.N.pos("VB[ZP]").noDependents("aux"), NodePattern.N.pos("VB").withDependent("aux", NodePattern.N.lemma("do").pos("VB[ZP]")), NodePattern.N.pos("NN.*").withDependent("case", NodePattern.N.pos("RB")).withDependent("cop", NodePattern.N.pos("VB[ZP]")));
        NodePattern sinceHost = NodePattern.N.anyPos().markAs("SinceHost").andOr(sinceNominalDependent.noLemma("version|release|edition|update|publication").noForm("then").andNot(Questions.whPhrase).andNot(withEndPoint), CommonPatterns.possiblySkipDown("cop", NodePattern.N.pos("VBD")).withHead("advcl", clausePresentTense.andNot(NodePattern.N.anyMatchUntil("SinceHost", NodePattern.PUNCT.andNot(EnglishTreePatterns.aposOrQuote))).andNot(Semantics.toHaveOpinion.withHeadRelation("acl:relcl")).and(TenseChanges::simpleToPerfect)), NodePattern.N.withDependent("mark", everSince).withHead("advcl", EnglishTreePatterns.verbalClause.noDependents("aux(:pass)?", NodePattern.N.noLemma("do")).and(TenseChanges::simpleToPerfect))).andNot(misparsedReason).andNot(NodePattern.N.withHead(Semantics.raisingVerb)).andNot(NodePattern.N.withHead(NodePattern.N.withDependent("advmod", NodePattern.N.form("now|currently")))).andNot(NodePattern.N.withPrevSibling(firstX)).andNot(EnglishParameters.VARIANT.withValue("GB.*").withHead(NodePattern.N.withDependent("nsubj", NodePattern.N.form("it")).withDependent("cop")));
        NodePattern since = sinceWithMessage.andOr(CommonPatterns.lastChildPhrase.andNot(CommonPatterns.lastToken).withHead("advmod", sinceClauseFinalHost), NodePattern.N.withHead("case|mark", sinceHost));
        NodePattern thisIsNthTime = NodePattern.N.inFormSequence(3, "['\u2019`\u2018i]s", "the", ".+", "time").withDependent("nsubj", NodePattern.N.form("this|that|it").markAs("Subj")).withDependent("amod", NodePattern.or(NodePattern.N.pos("ORD"), NodePattern.N.form("first")).directlyBeforeHead().markAs("Ordinal")).andNot(NodePattern.N.inPhrase(NodePattern.N.withDependent("aux", NodePattern.N.lemma("will").form(".+ll")))).withDependent("acl:relcl", NodePattern.N.pos("VB[ZP]").noDependents("aux").noDependents("advmod", NodePattern.N.form("ever")).and((node, match) -> TenseChanges.simpleToPerfect(node, match))).message("Use Present Perfect with '$Subj is the $Ordinal time'");
        NodePattern specificSubject = NodePattern.or(NodePattern.N.pos("NNP|DT|PRP"), NodePattern.N.withDependent("det", NodePattern.N.form("the")), NodePattern.N.withDependent("nmod:poss"));
        NodePattern forYears = NodePattern.N.form("for").withHead("case", NodePattern.N.form("hours|days|weeks|months|years|decades|ages|eons|yonks").markAs("TimeUnit").noDependents(NodePattern.N.afterHead()).withHead("obl", NodePattern.or(NodePattern.N.lemma("go|walk|drive|sleep|live|work|store|expand|run"), EnglishTreePatterns.negated.lemma("see|call|create|try|tell|ask|find|add|offer|happen|hear|check|win|lose|identify|encourage|mention|miss|discover|surprise|experience|knock|ring|put|place|lay|locate|position|bury|leave|step|stomp|park|stack")).withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", specificSubject).noDependents(Semantics.frequencyAdverb).noDependents("advcl", NodePattern.N.after("TimeUnit")).and(clausePresentTense.and(TenseChanges::simpleToPerfect).and(TenseChanges::nonPastToPast)))).reportRangeTo("TimeUnit", ReportingKind.Hover).message("Use Present Perfect or Past Simple with 'for $TimeUnit'");
        return NodePattern.or(since, forYears, thisIsNthTime);
    }

    static NodePattern pattern() {
        return NodePattern.or(TenseAdverbials.usePastSimple(), TenseAdverbials.useFuture(), TenseAdverbials.usePresentPerfect()).andNot(NodePattern.N.afterHead().withPhraseStart(CommonPatterns.openingParen));
    }
}

