/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.StyleFlavor;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.en.AdverbAdjectiveConfusion;
import ai.grazie.rules.en.AgreementSet;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.MissingVerb;
import ai.grazie.rules.en.NegativePhrases;
import ai.grazie.rules.en.Number;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.SubjectVerbAgreement;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.ReportingKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

class Wordiness {
    private static final String WHETHER_MSG = "'whether' is enough";
    private static final String STUDENT_BODY_MSG = "'student body' is too wordy";
    private static final String ONE_MSG = "'one' seems unnecessary";
    private static final String SHORTER_VERB_MSG = "Use a shorter verb?";
    private static final String SHORTER_EXPRESSION_MSG = "Use a shorter expression?";
    private static final String REDUNDANT_OF_MSG = "Consider removing 'of' to be more concise";

    Wordiness() {
    }

    static List<Rule.PatternRule> rules() {
        return List.of(new Rule.PatternRule("Style.REDUNDANT_OF", "Avoid \u201cof\u201d when redundant", "There are many situations where the preposition <i>of</i> can be removed without changing the meaning of the phrase.", null, () -> Wordiness.redundantOf(), new Example("I\u2019ve heard his office is <b>inside of</b> that building.", "I\u2019ve heard his office is <b>inside</b> that building."), new Example("She is partially responsible for <b>all of the</b> wonderful things.", "She is partially responsible for <b>all the</b> wonderful things.")).styleFlavor(StyleFlavor.Readability).coveringLTRules("OUTSIDE_OF", "SOME_OF_THE", "ALL_OF_THE"), new Rule.PatternRule("Style.REDUCIBLE_RELATIVE_CLAUSE", "Shorten relative clauses", "You can often remove relative clauses starting with <i>that is</i>, <i>who were</i>, or similar expressions\nwithout changing the meaning of the sentence.\nThis only applies to restrictive (defining) relative clauses\nwhere the predicate is a verb in the continuous form, in the passive voice, or a prepositional phrase.\n", "https://centralschool.ie/english-grammar/reduced-relative-clauses/", () -> Wordiness.reduceRelativeClause(), new Example("The man <b>who is</b> driving the Fiat is my uncle.", "The <b>man driving</b> the Fiat is my uncle.")).styleFlavor(StyleFlavor.Readability).honorCrazyParses(), new Rule.PatternRule("Style.WORDINESS", "Avoid wordiness", "  Make your text more concise.\n  Replace wordy expressions with shorter and clearer alternatives.\n  Remove words that don\u2019t contribute to the meaning of the sentence.\n", "https://advice.writing.utoronto.ca/revising/wordiness/", () -> NodePattern.or(Wordiness.wordyExpressions(), Wordiness.unnecessaryIntensifiers()), new Example("The stress caused a chain reaction of political <b>nature</b>.", "The stress caused a chain <b>political reaction</b>."), new Example("<b>Members of the student body</b> arrived.", "<b>Students</b> arrived."), new Example("<b>As to whether or not</b> this will happen remains unclear.", "<b>Whether</b> this will happen remains unclear."), new Example("This book is <b>a good one</b>.", "This book is <b>good</b>.")).styleFlavor(StyleFlavor.Readability).honorCrazyParses().coveringLTRules("WHETHER", "EVERY_NOW_AND_THEN", "IN_ORDER_TO", "DUE_TO_THE_FACT", "HAVE_A_TENDENCY", "BE_A_X_ONE", "BY_MEANS_OF", "BASIS_ON_A", "FOR_THE_PURPOSE_OF", "HAVE_THE_ABILITY_TO", "EACH_AND_EVERY_NOUN", "WITH_THE_EXCEPTION_OF", "BECAUSE", "DESPITE_THE_FACT", "AS_A_MATTER_OF_FACT", "ALONG_THE_LINES_OF", "IN_A_MANNER_OF_SPEAKING", "FIRST_OF_ALL", "IN_A_X_MANNER"));
    }

    private static NodePattern reduceRelativeClause() {
        NodePattern rootNP = NodePattern.ROOT.pos("NN.*").andNot(EnglishTreePatterns.clause).noDependents("case");
        NodePattern possiblyNonRestrictiveWithoutComma = NodePattern.N.inPhrase(NodePattern.N.withHead("nsubj", NodePattern.N.withDependent("expl")));
        NodePattern itIsAThatIsB = NodePattern.N.withHead("acl:relcl", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl", NodePattern.N.inFormSequence(0, "it", "['\u2019`\u2018i]s")));
        NodePattern relativizer = NodePattern.N.form("that|who");
        NodePattern relclConj = NodePattern.N.withHeadRelation("conj").withDependent("aux(:pass)?|cop").andOr(NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl"), NodePattern.N.withDependent(".*", relativizer));
        NodePattern relcl = NodePattern.N.withHeadRelation("acl:relcl").andOr(NodePattern.N.pos("VB[NG]").withDependent("advmod|i?obj|obl.*|nmod|advcl|xcomp", NodePattern.not(EnglishTreePatterns.negation)).andOr(NodePattern.N.withDependent(".*", NodePattern.N.afterHead()), NodePattern.N.withHead(EnglishTreePatterns.someAnyEveryNoX)).noDependents("conj").andNot(NodePattern.N.form("going").withDependent("xcomp")).andNot(CommonPatterns.possiblySkipUp("acl:relcl", NodePattern.N.withNextSibling(relclConj))).noForm("set").noForm("raced|caught"), NodePattern.N.pos("NN.*").withDependent("case", NodePattern.N.beforeHead().markAs("Prep")).andOr(NodePattern.markedNodeMatches("Prep", NodePattern.or(NodePattern.N.form("beside|without|about|before|of|in|at"), NodePattern.N.inFormSequence(0, "out", "of"))), NodePattern.N.withHead(EnglishTreePatterns.someAnyEveryNoX)).noDependents("advcl.*|obl").andNot(NodePattern.markedNodeMatches("Prep", NodePattern.N.form("in|at")).andOr(Semantics.physicalPlace, EnglishTreePatterns.namedITPlace)).andNot(itIsAThatIsB)).noDependents("cop|aux|aux:pass", NodePattern.N.after("Be")).andNot(possiblyNonRestrictiveWithoutComma).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("nmod").alreadyMarkedAs("Prev")));
        return relativizer.directlyAfter(NodePattern.N.pos("NN.*").markAs("NP").andNot(rootNP).noForm("one").noDependents("det", EnglishTreePatterns.demonstratives)).directlyBefore(NodePattern.N.lemma("be").pos("VB[ZD]").beforeHead().markAs("Be").withHead("cop|aux|aux:pass", relcl.markAs("RelCl")).andNot(NodePattern.N.form(".s").withHead(NodePattern.N.pos("VBN").withDependent("obj"))).andNot(NodePattern.N.pos("VBD").withHead(NodePattern.N.inPhrase(EnglishTreePatterns.addAuxVerbs(NodePattern.N.pos("VBP")))))).andNot(NodePattern.N.inFormSequence(1, "fact", "that")).and((node, match) -> {
            List<Node> hosts = EnglishTreePatterns.findRelativeClauseHostCandidates(node, match.getMarkedNode("RelCl"));
            Node np = match.getMarkedNode("NP");
            return !hosts.isEmpty() && hosts.stream().allMatch(n -> n == np || n == np.head() && np.hasHeadRelation("conj")) ? match : null;
        }).andNot(SubjectVerbAgreement.errorPattern).and(NodePattern.custom((node, match) -> {
            Node be = match.getMarkedNode("Be");
            String infix = EnglishTreePatterns.startsWithApostrophe.matches(be) ? "" : " ";
            return match.withMessage("'" + node.presentableText() + infix + be.presentableText() + "' seems unnecessary");
        })).andOr(NodePattern.N.withNeighbor(2, EnglishTreePatterns.contractedNot).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), "not")), NodePattern.N.correct(NodeCorrector.removeNodes(NodePointer.anchor(), NodePointer.neighbor(1))));
    }

    private static NodePattern redundantOf() {
        NodePattern demonstrativePronounOrNonProperNoun = NodePattern.N.pos("DT|NNS?");
        return NodePattern.or(NodePattern.N.inFormSequence(0, "inside|outside", "of").withHeadRelation("advmod|case|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").andNot(NodePattern.N.directlyAfter(EnglishTreePatterns.quotations)).andNot(NodePattern.N.form("outside").andOr(NodePattern.N.withHead("case", NodePattern.N.withDependent("cc", NodePattern.N.form("but").withPrevSibling(CommonPatterns.comma))), EnglishParameters.VARIANT.withValue("|US").andOr(NodePattern.N.withHead("advmod", NodePattern.not(EnglishTreePatterns.imperativeVB)).withDependent("obl|nmod", demonstrativePronounOrNonProperNoun), NodePattern.N.withHead("case", NodePattern.or(demonstrativePronounOrNonProperNoun.withHeadRelation("obl"), NodePattern.N.withHead("nmod", NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound").pos("NNS?"))))))).reportEverythingTouched().correct(NodeCorrector.replace(NodePointer.neighbor(1), "")), NodePattern.N.inFormSequence(0, "some|all", "of", "the").reportEverythingTouched().markAs("Det").withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound").withNeighbor(2, NodePattern.N.withHead("det", NodePattern.or(NodePattern.N.pos("NNS"), Semantics.possiblyUncountableForm).noLemma("time").withHead("nmod", NodePattern.N.alreadyMarkedAs("Det")).markAs("Noun"))).andOr(NodePattern.N.form("all").correct(NodeCorrector.replace(NodePointer.neighbor(1), "")), NodePattern.N.form("some").withNeighbor(3, NodePattern.N.alreadyMarkedAs("Noun").noDependents("acl.*").andNot(NodePattern.N.directlyBefore(CommonPatterns.skipForward(CommonPatterns.comma, NodePattern.N.form("that"))))).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(1), NodePointer.neighbor(2), "")))).message(REDUNDANT_OF_MSG);
    }

    private static NodePattern unnecessaryIntensifiers() {
        return EnglishTreePatterns.adverbRel("absolutely", NodePattern.N.form("essential|certain|guaranteed|sure|necessary")).withHead(NodePattern.N.noDependents("mark", NodePattern.N.form("if|unless"))).correct(NodeCorrector.replace("")).message("An adverb '$_' is unnecessary and can be removed from the sentence");
    }

    private static NodePattern wordyExpressions() {
        NodePattern availableToUse = NodePattern.N.inFormSequence(0, "available", "to", "be").and(CommonPatterns.afterSkipping(EnglishTreePatterns.negation.markAs("Not"), NodePattern.N.lemma("be").pos("VB[PDZ]").markAs("FirstBe"))).and((node, match) -> {
            Node be = match.getMarkedNode("FirstBe");
            List<String> replacements = Wordiness.suggestCan(be, match.findMarkedNode("Not"), false);
            String space = EnglishTreePatterns.startsWithApostrophe.matches(be) ? " " : "";
            return match.withCorrector(NodeCorrector.replaceNodes(be, node.neighbor(1), () -> replacements.stream().map(s -> space + s).toList()));
        }).message("'available to be' may be too wordy");
        NodePattern ifYouHaveItAdjective = NodePattern.N.inFormSequence(2, "if", "they|you|s?he|we", "have|has", "it").withHead("advcl", EnglishTreePatterns.clause).markAs("Have").withNeighbor(2, NodePattern.N.pos("JJ").withHead("xcomp", NodePattern.N.alreadyMarkedAs("Have"))).message(SHORTER_EXPRESSION_MSG).correct(NodeCorrector.removeNodes(NodePointer.neighbor(-1), NodePointer.neighbor(1)));
        NodePattern actOfNature = NodePattern.N.lemma("act|action|activity|operation|plan|reaction|response|deed|move").markAs("NOUN").withDependent("nmod", NodePattern.N.form("nature|character|essence|quality|type|sort|description|aspect|kind|tone|caliber").markAs("RedNoun").includeIntoReport().message("'$_' is redundant").withDependent("case", NodePattern.N.form("of").markAs("RedOf")).withDependent("amod", NodePattern.N.pos("JJ").markAs("ADJ"))).and((node, match) -> {
            Node noun = match.getMarkedNode("NOUN");
            String adjText = match.getMarkedNode("ADJ").phraseText();
            NodeCorrector corrector = NodeCorrector.replaceNodes(match.getMarkedNode("RedOf"), match.getMarkedNode("RedNoun"), "").join(NodeCorrector.insertBefore(noun, adjText + " "));
            return match.withCorrector(corrector.join(Articles.fixArticle(noun, adjText)));
        });
        NodePattern replaceWithAdverb = NodePattern.N.pos("JJ").markAs("Adj").andOr(NodePattern.N.inFormSequence(2, "on", "an?", ".+", "basis"), NodePattern.N.inFormSequence(2, "in", "an?", ".+", "manner|way")).reportEverythingTouched().andNot(NodePattern.N.withNeighbor(-3, NodePattern.N.form(".+ly").withHeadRelation("advmod"))).directlyAfter(NodePattern.N.markAs("Det")).andNot(CommonPatterns.capitalizedMiddle).withHead("amod", NodePattern.N.andOr(NodePattern.N.form("basis").withHead(EnglishTreePatterns.clause.markAs("NounHead")).message("'on $Det $Adj $_' may be too wordy"), NodePattern.N.form("manner|way").withHead(EnglishTreePatterns.verbalClause.noDependents("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").markAs("NounHead")).message("'in $Det $Adj $_' may be too wordy"))).andOr(NodePattern.N.form("daily").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.neighbor(1), "daily", "every day")), NodePattern.N.form("annual").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.neighbor(1), "annually", "every year")), NodePattern.N.form("nightly|weekly|monthly|quarterly|yearly|hourly").and((node, match) -> {
            String everyX = "every " + node.form().replace("ly", "");
            return match.withCorrectors(List.of(NodeCorrector.replaceNodes(node.neighbor(-2), node.neighbor(1), node.form()), NodeCorrector.replaceNodes(node.neighbor(-2), node.neighbor(1), everyX)));
        }), NodePattern.N.noPotentialPos("VBG").noForm("competitive|conditional|ordinary|particular|certain|specific|right|simple|traditional|tricky|modern|reasonable").andNot(NodePattern.N.form("experimental").and(NodePattern.markedNodeMatches("NounHead", NodePattern.N.withDependent("aux:pass")))).andNot(NodePattern.N.inFormSequence(0, "good|bad", "way").and(NodePattern.markedNodeMatches("NounHead", NodePattern.N.lemma("show|see|change|think")))).and((node, match) -> {
            String adv = AdverbAdjectiveConfusion.adjToAdv(node.form());
            if (!node.tree().treeSupport().tagToken(adv).hasPos("RB")) {
                return null;
            }
            if (node.tree().treeSupport().isAcceptedBySpellchecker(adv)) {
                return match.withCorrector(NodeCorrector.replaceNodes(node.neighbor(-2), node.neighbor(1), adv));
            }
            return null;
        })).andOptionally(NodePattern.N.withHead(NodePattern.N.form("basis")).withNeighbor(-3, NodePattern.N.pos("NN.*").withHeadRelation("obj").noDependents(NodePattern.N.beforeHead()).markAs("Obj").includeIntoReport()).and((adj, match) -> match.withCorrector(NodeCorrector.insertBefore(match.getMarkedNode("Obj"), adj.form() + " ").join(NodeCorrector.replaceNodes(adj.neighbor(-2), adj.neighbor(1), "")))));
        NodePattern whetherOrNot = NodePattern.N.form("whether").andOr(NodePattern.N.directlyBefore(NodePattern.N.inFormSequence(0, "or", "not")).withNeighbor(2, NodePattern.N.markAs("End")), NodePattern.N.markAs("End")).andOr(NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.inFormSequence(3, "the", "question", "as", "to").withNeighbor(-3, NodePattern.N.markAs("Start")), NodePattern.N.inFormSequence(1, "as", "to").withNeighbor(-1, NodePattern.N.markAs("Start")), NodePattern.N.inFormSequence(1, "the", "question").withNeighbor(-1, NodePattern.N.markAs("Start")), NodePattern.N.inFormSequence(2, "the", "question", "of").withNeighbor(-2, NodePattern.N.markAs("Start")))), NodePattern.N.markAs("Start")).andNot(NodePattern.N.alreadyMarkedAs("Start").alreadyMarkedAs("End")).andNot(CommonPatterns.firstChildPhrase.withHead("mark", NodePattern.N.withHeadRelation("advcl"))).correct(NodeCorrector.replaceNodes(NodePointer.marked("Start"), NodePointer.marked("End"), "whether")).message(WHETHER_MSG);
        NodePattern studentBody = NodePattern.N.form("body").directlyAfter(NodePattern.N.form("student").markAs("Student")).message(STUDENT_BODY_MSG).andOr(NodePattern.N.withDependent("case", NodePattern.N.form("of").beforeHead()).withHead("nmod", NodePattern.N.form("members?").markAs("Member")).correct(NodeCorrector.regexReplace(NodePointer.marked("Member"), "member(s?)", "student$1").join(NodeCorrector.removeNodes(NodePointer.neighbor("Member", 1), NodePointer.anchor()))), NodePattern.N.withHead(NodePattern.N.noForm("president")).and((body, match) -> {
            Node main = NodePattern.N.withHead("nmod", NodePattern.N.lemma("part|half|third|quarter|most|rest|majority|minority")).matches(body) ? Objects.requireNonNull(body.head()) : body;
            List toPlural = (List)new AgreementSet(main, Number.plural).changeNumber(Set.of(main)).getLeft();
            NodeCorrector toStudents = NodeCorrector.replaceNodes(match.getMarkedNode("Student"), body, "students");
            if (toPlural.isEmpty()) {
                return match.withCorrector(toStudents);
            }
            return match.withCorrectors(toPlural.stream().map(c -> c.join(toStudents)).toList());
        })).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.quotations).withNeighbor(-2, EnglishTreePatterns.quotations));
        NodePattern theFactThatSequence = NodePattern.N.inFormSequence(1, "the", "fact", "that");
        NodePattern theFactThat = NodePattern.N.withDependent("acl", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?")).andOr(NodePattern.N.inFormSequence(3, "owing|due", "to", "the", "fact", "that").and(Wordiness.replaceFactWithBecauseSince(NodePointer.neighbor(-3), NodePointer.neighbor(1))), NodePattern.N.inFormSequence(4, "in", "light", "of", "the", "fact", "that").and(Wordiness.replaceFactWithBecauseSince(NodePointer.neighbor(-4), NodePointer.neighbor(1))), NodePattern.N.inFormSequence(4, "by", "reason", "of", "the", "fact", "that").and(Wordiness.replaceFactWithBecauseSince(NodePointer.neighbor(-4), NodePointer.neighbor(1))), NodePattern.N.inFormSequence(2, "despite", "the", "fact", "that").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.neighbor(1), "although", "even though", "though")), NodePattern.N.inFormSequence(4, "in", "spite", "of", "the", "fact", "that").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-4), NodePointer.neighbor(1), "although", "even though", "though")), NodePattern.N.inFormSequence(4, "in", "view", "of", "the", "fact", "that").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-4), NodePointer.anchor(), "given", "considering"))).message(SHORTER_EXPRESSION_MSG);
        NodePattern priorTo = NodePattern.N.inFormSequence(0, "prior", "to").withHead("mark", NodePattern.N.pos("VBG").withHeadRelation("advcl")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "before")).message("'prior to' may be too wordy");
        NodePattern unlikelyPredicativeAdj = NodePattern.or(Semantics.attributiveOnlyAdj, NodePattern.N.form("default"));
        NodePattern isSomebodyWho = NodePattern.N.form("some(one|body|thing)").markAs("SomeX").withDependent("cop", NodePattern.N.directlyBeforeHead()).noDependents("appos", NodePattern.N.sameWordAs("SomeX")).and(CommonPatterns.skipUp("xcomp", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.noDependents("det", NodePattern.N.form("an?")).markAs("Subj")))).andNot(NodePattern.N.form("some(one|body)").and(NodePattern.markedNodeMatches("Subj", NodePattern.N.form("it")))).andOr(NodePattern.N.withDependent("acl:relcl", NodePattern.N.withDependent("nsubj", NodePattern.or(NodePattern.N.pos("WP"), NodePattern.N.form("that")).directlyAfter("SomeX")).andOr(NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.N.lemma("be").noForm("be").markAs("Be")).andNot(NodePattern.N.withDependent("aux", NodePattern.N.lemma("have")).andNot(CommonPatterns.severalDependents("aux"))).and(NodePattern.custom((node, match) -> {
            Node be = match.getMarkedNode("Be");
            Node someX = match.getMarkedNode("SomeX");
            return match.withCorrector(NodeCorrector.replaceNodes(someX, be, ""));
        })), NodePattern.markedNodeMatches("SomeX", NodePattern.custom((node, match) -> {
            Node firstCopAux = node.findDependents("cop|aux|aux:pass").getFirst();
            return match.withCorrector(NodeCorrector.replaceNodes(firstCopAux, node.neighbor(1), ""));
        }))).message("Consider removing an unnecessary relative clause")), NodePattern.N.withDependent("amod", NodePattern.N.markAs("Adj").noForm("else").andNot(unlikelyPredicativeAdj).afterHead()).noDependents("acl(:relcl)?", NodePattern.N.after("Adj")).correct(NodeCorrector.replace("")).message("'$_' seems unnecessary"));
        return NodePattern.or(availableToUse, ifYouHaveItAdjective, actOfNature, studentBody, whetherOrNot, theFactThat, priorTo, isSomebodyWho, replaceWithAdverb, Wordiness.haveAbstractNoun(), Wordiness.giveAbstractNounTo(), Wordiness.forNounOf(), Wordiness.makeAdj(), NodePattern.N.inFormSequence(2, "for", "the", "purposes?", "of").andOptionally(NodePattern.N.withDependent("acl", NodePattern.N.pos("VBG").markAs("Gerund")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.neighbor(1), "to ").join(NodeCorrector.inflect(NodePointer.marked("Gerund"), "VBG", "VB")))).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.neighbor(1), "")).message("'for the $_ of' may be too wordy"), NodePattern.N.form("proximity").withDependent("case", NodePattern.N.form("(with)?in").markAs("In")).andOr(CommonPatterns.lastChildPhrase.noDependents(NodePattern.N.afterHead()).correct(NodeCorrector.replaceNodes(NodePointer.marked("In"), NodePointer.anchor(), "nearby", "near", "close")).message("'$In proximity' may be too wordy"), NodePattern.N.directlyBefore(NodePattern.N.form("to|with").markAs("Prep").withHeadRelation("case")).andOr(NodePattern.N.noDependents("amod|compound").correct(NodeCorrector.replaceNodes(NodePointer.marked("In"), NodePointer.marked("Prep"), "close to", "near")).message("'$In proximity $Prep' may be too wordy"), NodePattern.N.withDependent("amod", NodePattern.N.form("close")).correct(NodeCorrector.replace(NodePointer.marked("In"), "").join(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("Prep"), "to"))).correct(NodeCorrector.replaceNodes(NodePointer.marked("In"), NodePointer.marked("Prep"), "near")).message("'$In close proximity $Prep' may be too wordy"))), NodePattern.N.inFormSequence(2, "along", "the", "lines", "of").andOr(NodePattern.N.withDependent("nmod").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.neighbor(1), "like", "similar to")), NodePattern.N.withDependent("acl").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.neighbor(1), "like", "such as"))).message("'along the lines of' may be too wordy"), NodePattern.N.inFormSequence(2, "as", "a", "matter", "of", "fact").and((node, match) -> EnglishTreePatterns.removeWithSurroundingPunctuation(node.neighbor(-2), node.neighbor(2), match)).message("'as a matter of fact' may be too wordy"), NodePattern.N.inFormSequence(0, "any", "and", "all").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), "any", "all")).message("'any and all' may be too wordy"), NodePattern.N.inFormSequence(0, "each", "and", "every").beforeHead().correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), "every", "each")).message("'each and every' may be too wordy"), NodePattern.N.inFormSequence(0, "in", "a", "manner", "of", "speaking").and((node, match) -> EnglishTreePatterns.removeWithSurroundingPunctuation(node, node.neighbor(4), match)).message("'in a manner of speaking' may be too wordy"), NodePattern.N.inFormSequence(0, "every", "now", "and", "then").correct(NodeCorrector.replace("")).correct(NodeCorrector.replaceNodes(NodeMatch::anchor, NodePointer.neighbor(3), "sometimes", "occasionally", "sporadically")).message("Consider removing 'every' or using a less wordy alternative"), NodePattern.N.inFormSequence(1, "every", "time", "when").and(CommonPatterns.firstPhrase).withDependent("acl:relcl").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.neighbor(1), "whenever")).message("'every time when' may be too wordy"), NodePattern.N.inFormSequence(0, "to", "be").reportEverythingTouched().directlyAfter(NodePattern.N.lemma("seem").markAs("Raising").includeIntoReport(ReportingKind.Hover)).withNeighbor(2, CommonPatterns.skipUp("advmod", NodePattern.N.noForm("more|none").pos("JJ.*").noPos("CD").withHead("xcomp", NodePattern.N.alreadyMarkedAs("Raising"))).noPos("VBG")).message("'to be' seems redundant").correct(NodeCorrector.removeNodes(NodePointer.anchor(), NodePointer.neighbor(1))), NodePattern.N.inFormSequence(0, "in", "order", "to").reportEverythingTouched().andNot(NodePattern.N.withNeighbor(3, NodePattern.N.pos("VB")).withNeighbor(-1, EnglishTreePatterns.withToMark.sameWordAs(4))).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("to"))).andNot(NodePattern.N.withNeighbor(3, NodePattern.N.form("scale|date|go").noDependents(NodePattern.N.afterHead()))).message("'in order to' may be wordy").correct(NodeCorrector.removeNodes(NodePointer.anchor(), NodePointer.neighbor(1))), NodePattern.N.inFormSequence(1, "by", "means", "of").reportEverythingTouched().message("'by means of' may be wordy").correct(NodeCorrector.removeNodes(NodePointer.anchor(), NodePointer.neighbor(1))).andOr(NodePattern.N.withDependent("acl", NodePattern.N.markAs("Acl")).andOptionally(NodePattern.markedNodeMatches("Acl", NodePattern.N.form("using")).correct(NodeCorrector.removeNodes(NodePointer.neighbor(-1), NodePointer.neighbor(1)))), NodePattern.N.withDependent("nmod", NodePattern.not(CommonPatterns.capitalizedMiddle)).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.neighbor(1), "through", "with"))), NodePattern.N.inFormSequence(1, "by", "reason", "of").reportEverythingTouched().withDependent("nmod", NodePattern.not(theFactThatSequence)).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "because")).message("'by reason of' may be wordy"), NodePattern.N.inFormSequence(1, "in", "view", "of").reportEverythingTouched().withDependent("nmod", NodePattern.not(theFactThatSequence)).andOr(NodePattern.N.beforeHead().correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.neighbor(1), "given", "considering")), NodePattern.N.correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.neighbor(1), "because of", "due to"))).message("'by reason of' may be wordy"), NodePattern.N.inFormSequence(2, "with", "the", "exception", "of").withDependent("nmod").andOptionally(NodePattern.N.afterHead().correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.neighbor(1), "except"))).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.neighbor(1), "except for")).message("'with the exception of' may be wordy"), NodePattern.N.inFormSequence(3, "in", "the", "near", "future").andOr(CommonPatterns.firstPhrase.directlyBefore(CommonPatterns.comma.markAs("End")), NodePattern.N.markAs("End")).andOr(NodePattern.N.inPhrase(EnglishTreePatterns.clause.markAs("Clause")).markAs("Future").and(NodePattern.markedNodeMatches("Clause", CommonPatterns.possiblySkipUp("ccomp", NegativePhrases.negativeClause.before("Future")))).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-3), NodePointer.marked("End"), "anytime soon")), NodePattern.N.correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-3), NodePointer.marked("End"), "soon"))).message("'in the near future' may be wordy"), NodePattern.N.inFormSequence(2, "during", "the", "course", "of").withDependent("nmod", NodePattern.N.afterHead()).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.neighbor(1), "")).message("'during the course of' may be wordy"), NodePattern.N.inFormSequence(4, "at", "the", "top|bottom", "of", "it|them").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "")).message("'of $_' seems redundant"), EnglishTreePatterns.copAdjOne.withDependent("det", NodePattern.N.form("an?").markAs("An")).reportRangeTo("An").correct(NodeCorrector.replace(NodePointer.marked("An"), "").join(NodeCorrector.replace(""))).message(ONE_MSG), NodePattern.N.inFormSequence(0, "first", "of", "all").noDependents("det|cop").withNeighbor(2, NodePattern.N.afterHead()).andOr(NodePattern.N.directlyAfterHead().withNextSibling(NodePattern.N.withHeadRelation("i?obj|obl")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), "mainly")), NodePattern.N.withNeighbor(3, NodePattern.N.pos("NNP?S")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), "first,")), NodePattern.N.correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), "first"))).andNot(CommonPatterns.insideQuotes).message("'first of all' may be too wordy"));
    }

    private static NodePattern forNounOf() {
        return NodePattern.N.form(MissingVerb.nounsToVerbs.keySet()).directlyAfter(NodePattern.N.form("for")).withHead("obl", NodePattern.N.pos("V.*")).markAs("Noun").withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("of").directlyAfter("Noun")).andNot(CommonPatterns.possiblySkipDown("compound", EnglishTreePatterns.typeSynonyms))).and((noun, match) -> {
            for (String verb : MissingVerb.nounsToVerbs.get(noun.lowForm())) {
                match = match.withCorrector(NodeCorrector.replaceNodes(noun.neighbor(-1), noun.neighbor(1), "to " + verb));
            }
            return match;
        }).message("Use a verb instead of '$_'?");
    }

    private static NodePattern makeAdj() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("broad", "broaden");
        map.put("clear", "clarify");
        map.put("complicated", "complicate");
        map.put("deep", "deepen");
        map.put("diverse", "diversify");
        map.put("intense", "intensify");
        map.put("short", "shorten");
        map.put("simple", "simplify");
        map.put("soft", "soften");
        map.put("weak", "weaken");
        map.put("wide", "widen");
        NodePattern withMarkedSubclause = NodePattern.N.withDependent("advcl|ccomp", NodePattern.or(NodePattern.N.withDependent("mark"), NodePattern.N.withDependent("advmod", NodePattern.N.form("where")))).trace("withMarkedSubclause");
        return NodePattern.N.lemma("make").markAs("Make").noDependents("parataxis").andOr(NodePattern.N.withDependent("obj", NodePattern.N.markAs("Obj")), NodePattern.N.withDependent("expl", NodePattern.N.directlyAfterHead().markAs("Obj"))).withDependent("xcomp|advmod", NodePattern.N.lemma(map.keySet()).andOr(NodePattern.N.pos("JJR"), NodePattern.N.pos("JJ").withDependent("amod|advmod", NodePattern.N.form("more").markAs("More"))).noDependents("conj").andNot(withMarkedSubclause).noDependents(NodePattern.N.beforeHead().noForm("more")).andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE)).and(NodePattern.custom((adj, match) -> {
            NodeCorrector removeExpletive;
            Node make = match.getMarkedNode("Make");
            Node more = match.findMarkedNode("More");
            Optional<String> adjLemma = StreamEx.of(adj.tokenReadings()).findFirst(r -> r.hasPos("JJR?")).map(r -> r.lemma());
            Node obj = match.getMarkedNode("Obj");
            NodeCorrector nodeCorrector = removeExpletive = obj.hasForm("it") && adj.hasDependent("ccomp") ? NodeCorrector.replace(obj, "") : null;
            if (adjLemma.isPresent() && map.containsKey(adjLemma.get())) {
                NodeCorrector replaceMakeByTable = EnglishTreePatterns.changeVerbLemma((String)map.get(adjLemma.get())).corrector(make);
                return match.withCorrector((more != null ? NodeCorrector.replaceNodes(more, adj, "") : NodeCorrector.removeNode(adj)).join(replaceMakeByTable).join(removeExpletive));
            }
            return null;
        }))).andNot(withMarkedSubclause).message(SHORTER_EXPRESSION_MSG);
    }

    private static NodePattern replaceFactWithBecauseSince(NodePointer start, NodePointer end) {
        return NodePattern.or(NodePattern.ROOT.correct(NodeCorrector.replaceNodes(start, end, "because")), NodePattern.N.andOptionally(NodePattern.N.afterHead().correct(NodeCorrector.replaceNodes(start, end, "because"))).correct(NodeCorrector.replaceNodes(start, end, "since")));
    }

    private static NodePattern haveOptionAbility() {
        return NodePattern.N.inFormSequence(0, "has|have|had", "an|the|no", "option|ability", "to").reportEverythingTouched().andOr(NodePattern.or(EnglishTreePatterns.withToMark, CommonPatterns.skipConjUp(NodePattern.N.withDependent("aux", NodePattern.or(EnglishTreePatterns.baseAux.noLemma("do"), CommonPatterns.capitalized.potentialPos("MD"))))).andOr(NodePattern.N.withNeighbor(1, NodePattern.N.form("no")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), "not be able")), NodePattern.N.correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), "be able"))), NodePattern.or(NodePattern.N.withDependent("aux", NodePattern.N.lemma("do|have").markAs("Finite")).reportRangeTo("Finite").andOptionally(NodePattern.N.directlyAfter(EnglishTreePatterns.negation.markAs("Negation"))), NodePattern.N.markAs("Finite")).and((node, match) -> {
            Node finite = match.getMarkedNode("Finite");
            Node not = match.findMarkedNode("Negation");
            boolean noProblem = node.neighbor(1).hasForm("no");
            Node prev = finite.prevNode();
            boolean moveAdv = prev != null && prev.hasHeadRelation("advmod") && prev.head() == finite;
            String suffix = moveAdv ? " " + prev.phraseText() : "";
            Node replacementStart = moveAdv ? prev.phraseStart() : finite;
            List<String> replacements = Wordiness.suggestCan(finite, not, noProblem);
            return match.withCorrector(NodeCorrector.replaceNodes(replacementStart, node.neighbor(3), () -> replacements.stream().map(r -> r + suffix).toList())).withReportedNode(moveAdv ? prev : null);
        }));
    }

    private static List<String> suggestCan(Node finite, @Nullable Node not, boolean customNegation) {
        boolean present = !finite.hasPos("VBD") && (!finite.hasHeadRelation("aux") || !finite.hasLemma("have"));
        boolean finiteContracted = EnglishTreePatterns.startsWithApostrophe.matches(finite);
        if (not != null || customNegation) {
            boolean notContracted = not != null && !not.hasForm("not");
            ArrayList<String> replacements = new ArrayList<String>();
            if (!(finiteContracted || not != null && notContracted || !EnglishParameters.suggestFullForms.matches(finite))) {
                replacements.add(present ? "cannot" : "could not");
            }
            if (finiteContracted || notContracted || not == null && EnglishParameters.suggestContractedForms.matches(finite)) {
                char apos = notContracted ? (char)not.form().charAt(1) : (finiteContracted ? (char)finite.form().charAt(0) : (char)'\u2019');
                replacements.add((present ? "ca" : "could") + "n" + apos + "t");
            }
            return replacements;
        }
        return List.of(present ? "can" : (finiteContracted ? " could" : "could"));
    }

    private static NodePattern giveAbstractNounTo() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("ability", List.of("allow"));
        map.put("permission", List.of("permit", "allow"));
        return NodePattern.N.lemma("give").withDependent("iobj").withDependent("obj", NodePattern.N.form("permission|ability").markAs("Noun").withDependent("acl", NodePattern.N.withDependent("mark", NodePattern.N.form("to").directlyAfter("Noun")))).and((node, match) -> {
            Node noun = match.getMarkedNode("Noun");
            List suggestions = (List)map.get(noun.lowForm());
            List correctors = StreamEx.of((Collection)suggestions).map(s -> EnglishTreePatterns.changeVerbLemma(s).corrector(node).join(NodeCorrector.replaceNodes(noun.phraseStart(), noun, ""))).toList();
            return match.withCorrectors(correctors);
        }).message(SHORTER_VERB_MSG);
    }

    private static NodePattern haveAbstractNoun() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tendency", "tend");
        map.put("inclination", "incline");
        map.put("effect", "affect");
        return NodePattern.or(Wordiness.haveOptionAbility(), NodePattern.N.lemma("have").withDependent("obj", NodePattern.N.andOr(NodePattern.N.form("tendency|inclination").withDependent("acl", EnglishTreePatterns.withToMark), NodePattern.N.lemma("effect").noDependents("amod", NodePattern.N.noForm("substantial|significant|great|strong")).withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("upon|on").markAs("Prep")))).markAs("haveAbstractNoun").withDependent("det", NodePattern.N.form("an?"))).and((node, match) -> {
            Node noun = match.getMarkedNode("haveAbstractNoun");
            Node prep = match.findMarkedNode("Prep");
            String replacement = (String)map.get(noun.lowForm());
            return match.withCorrector(EnglishTreePatterns.changeVerbLemma(replacement).corrector(node).join(NodeCorrector.replaceNodes(noun.phraseStart(), prep == null ? noun : prep, "")));
        })).message(SHORTER_VERB_MSG);
    }
}

