/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.uk;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.KnownPhrases;
import ai.grazie.rules.common.MultiWordSpelling;
import ai.grazie.rules.common.ProperNames;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.uk.UkrainianTreePatterns;
import ai.grazie.rules.uk.WordSeparation;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

class SpellingRules {
    private static final String LATIN_MSG = "\u0417\u043c\u0456\u043d\u0438\u0442\u0438 \u043b\u0456\u0442\u0435\u0440\u0443 \u043d\u0430 \u0443\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0443?";
    private static final String DIACRITIC_MSG = "\u0417\u043c\u0456\u043d\u0438\u0442\u0438 \u043b\u0456\u0442\u0435\u0440\u0443 \u0437 \u0434\u0456\u0430\u043a\u0440\u0438\u0442\u0438\u043a\u043e\u044e \u043d\u0430 \u0437\u0432\u0438\u0447\u0430\u0439\u043d\u0443 \u043b\u0456\u0442\u0435\u0440\u0443?";

    SpellingRules() {
    }

    static List<Rule> rules() {
        return List.of(new Rule.PatternRule("Spelling.MISPLACED_SPACE", "\u041f\u0440\u043e\u0431\u0456\u043b \u0443 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u043c\u0443 \u043c\u0456\u0441\u0446\u0456", "\u041f\u0440\u043e\u0431\u0456\u043b \u043c\u0456\u0436 \u0441\u043b\u043e\u0432\u0430\u043c\u0438 \u043d\u0435 \u043f\u043e\u0442\u0440\u0456\u0431\u0435\u043d \u0430\u0431\u043e \u0437\u043d\u0430\u0445\u043e\u0434\u0438\u0442\u044c\u0441\u044f \u0432 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u043c\u0443 \u043c\u0456\u0441\u0446\u0456.", null, () -> CommonPatterns.misplacedSpace("\u0412\u0438 \u043c\u0430\u043b\u0438 \u043d\u0430 \u0443\u0432\u0430\u0437\u0456 \u00ab%s\u00bb?", NodePattern.or(new NodePattern[0])), new Example("\u041f\u0440\u043e\u0431\u0456\u043b <b>\u0431\u0443 \u0432\u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0439</b> \u043d\u0435\u0432\u0456\u0440\u043d\u043e", "\u041f\u0440\u043e\u0431\u0456\u043b <b>\u0431\u0443\u0432 \u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0439</b> \u043d\u0435\u0432\u0456\u0440\u043d\u043e")).enableInFlatTrees(), new Rule.PatternRule("Spelling.MULTI_WORD", "\u041f\u0440\u0430\u0432\u043e\u043f\u0438\u0441 \u0434\u0435\u043a\u0456\u043b\u044c\u043a\u043e\u0445 \u0441\u043b\u0456\u0432", "\u0412\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u0430\u043d\u043d\u044f \u0432\u0435\u043b\u0438\u043a\u0438\u0445 \u043b\u0456\u0442\u0435\u0440 \u0442\u0430 \u0434\u0440\u0443\u043a\u0430\u0440\u0441\u044c\u043a\u0456 \u043f\u043e\u043c\u0438\u043b\u043a\u0438 \u0432 \u0440\u0456\u0437\u043d\u0438\u0445 \u0432\u0438\u0441\u043b\u043e\u0432\u043b\u044e\u0432\u0430\u043d\u043d\u044f\u0445, \u0449\u043e \u0441\u043a\u043b\u0430\u0434\u0430\u044e\u0442\u044c\u0441\u044f \u0437 \u0434\u0435\u043a\u0456\u043b\u044c\u043a\u043e\u0445 \u0441\u043b\u0456\u0432.", null, () -> NodePattern.or(CommonPatterns.googleProducts("\u0412\u0438 \u043c\u0430\u043b\u0438 \u043d\u0430 \u0443\u0432\u0430\u0437\u0456 \u00ab%s\u00bb?"), ProperNames.fixFritzProducts.message("\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u0438 \u00abFritz!\u00bb \u043f\u0438\u0448\u0443\u0442\u044c\u0441\u044f \u0437\u0456 \u0437\u043d\u0430\u043a\u043e\u043c \u043e\u043a\u043b\u0438\u043a\u0443"), ProperNames.openAI.message("\u0412\u0438 \u043c\u0430\u043b\u0438 \u043d\u0430 \u0443\u0432\u0430\u0437\u0456 \u043a\u043e\u043c\u043f\u0430\u043d\u0456\u044e \u00abOpenAI\u00bb?"), new MultiWordSpelling(KnownPhrases.forLanguage(Language.UKRAINIAN)).pattern("\u0412\u0438 \u043c\u0430\u043b\u0438 \u043d\u0430 \u0443\u0432\u0430\u0437\u0456 \u00ab%s\u00bb?", "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u0435 \u043d\u0430\u043f\u0438\u0441\u0430\u043d\u043d\u044f \u2013 \u00ab%s\u00bb").noForm("\u0433\\.")), new Example("\u042f \u0437 <b>\u0406\u0432\u0430\u043d\u043e\u0444\u0440\u0430\u043d\u043a\u0456\u0432\u0441\u044c\u043a\u0430</b>.", "\u042f \u0437 <b>\u0406\u0432\u0430\u043d\u043e-\u0424\u0440\u0430\u043d\u043a\u0456\u0432\u0441\u044c\u043a\u0430</b>.")).enableInFlatTrees(), new Rule.PatternRule("Spelling.SIMILAR_WORD_CONFUSION", "\u041f\u043e\u043c\u0438\u043b\u043a\u043e\u0432\u0435 \u0432\u0436\u0438\u0432\u0430\u043d\u043d\u044f \u0441\u0445\u043e\u0436\u0438\u0445 \u0441\u043b\u0456\u0432", "\u0406\u043c\u043e\u0432\u0456\u0440\u043d\u043e \u0432\u0436\u0438\u0442\u043e \u0441\u0445\u043e\u0436\u0435 \u0441\u043b\u043e\u0432\u043e, \u044f\u043a\u0435 \u043d\u0435 \u043f\u0456\u0434\u0445\u043e\u0434\u0438\u0442\u044c \u0443 \u0446\u044c\u043e\u043c\u0443 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0456.", null, () -> SpellingRules.similarWordConfusion().andNot(CommonPatterns.quotedWord), new Example("\u0411\u0435\u0437\u0441\u0443\u043c\u043d\u0456\u0432\u043d\u043e, \u043a\u043e\u0436\u043d\u0438\u0439 \u0437 \u043d\u0430\u0441 \u0440\u043e\u0437\u0443\u043c\u0456\u0454 \u0442\u0443 \u0432\u0435\u043b\u0438\u0447\u0435\u0437\u043d\u0443 \u0440\u043e\u043b\u044c, \u044f\u043a\u0443 \u0432 \u043d\u0430\u0448\u043e\u043c\u0443 <b>\u0436\u0438\u0442\u0456</b> \u0432\u0456\u0434\u0456\u0433\u0440\u0430\u044e\u0442\u044c \u043a\u0430\u043d\u0446\u0435\u043b\u044f\u0440\u0441\u044c\u043a\u0456 \u043f\u0440\u0438\u043b\u0430\u0434\u0434\u044f.", "\u0411\u0435\u0437\u0441\u0443\u043c\u043d\u0456\u0432\u043d\u043e, \u043a\u043e\u0436\u043d\u0438\u0439 \u0437 \u043d\u0430\u0441 \u0440\u043e\u0437\u0443\u043c\u0456\u0454 \u0442\u0443 \u0432\u0435\u043b\u0438\u0447\u0435\u0437\u043d\u0443 \u0440\u043e\u043b\u044c, \u044f\u043a\u0443 \u0432 \u043d\u0430\u0448\u043e\u043c\u0443 <b>\u0436\u0438\u0442\u0442\u0456</b> \u0432\u0456\u0434\u0456\u0433\u0440\u0430\u044e\u0442\u044c \u043a\u0430\u043d\u0446\u0435\u043b\u044f\u0440\u0441\u044c\u043a\u0456 \u043f\u0440\u0438\u043b\u0430\u0434\u0434\u044f.")), new Rule.PatternRule("Spelling.NON_UKRAINIAN_LETTERS", "\u041b\u0430\u0442\u0438\u043d\u0441\u044c\u043a\u0456 \u043b\u0456\u0442\u0435\u0440\u0438 \u0437\u0430\u043c\u0456\u0441\u0442\u044c \u0443\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0438\u0445 \u0442\u0430 \u043d\u0430\u0432\u043f\u0430\u043a\u0438", "\u041b\u0430\u0442\u0438\u043d\u0441\u044c\u043a\u0456 \u043b\u0456\u0442\u0435\u0440\u0438 \u0437\u0430\u043c\u0456\u0441\u0442\u044c \u0432\u0456\u0434\u043f\u043e\u0432\u0456\u0434\u043d\u0438\u0445 \u0443\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0438\u0445 \u0442\u0430 \u0430\u043d\u0433\u043b\u0456\u0439\u0441\u044c\u043a\u0456 \u0441\u043b\u043e\u0432\u0430, \u043d\u0430\u043f\u0438\u0441\u0430\u043d\u0456 \u0443\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0438\u043c\u0438 \u043b\u0456\u0442\u0435\u0440\u0430\u043c\u0438.", null, () -> NodePattern.or(SpellingRules.latinLetters(), SpellingRules.diacriticLetters()), new Example("\u0441\u0438\u0441\u0442\u0435\u043c\u0438 \u043a\u0435\u0440\u0443\u0432\u0430\u043d\u043d\u044f \u043d\u0430 \u0445\u0456\u043c\u0456\u0447\u043d\u0438\u0445 <b>i </b>\u043d\u0430\u0444\u0442\u043e\u043f\u0435\u0440\u0435\u0440\u043e\u0431\u043d\u0438\u0445 \u0432\u0438\u0440\u043e\u0431\u043d\u0438\u0446\u0442\u0432\u0430\u0445.", "\u0441\u0438\u0441\u0442\u0435\u043c\u0438 \u043a\u0435\u0440\u0443\u0432\u0430\u043d\u043d\u044f \u043d\u0430 \u0445\u0456\u043c\u0456\u0447\u043d\u0438\u0445 <b>\u0456 </b>\u043d\u0430\u0444\u0442\u043e\u043f\u0435\u0440\u0435\u0440\u043e\u0431\u043d\u0438\u0445 \u0432\u0438\u0440\u043e\u0431\u043d\u0438\u0446\u0442\u0432\u0430\u0445."), new Example("\u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440 <b>\u043f\u043e\u0434\u0456\u0438\u0306</b>", "\u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440 <b>\u043f\u043e\u0434\u0456\u0439</b>")), WordSeparation.rule());
    }

    private static NodePattern similarWordConfusion() {
        return NodePattern.or(SpellingRules.similarWordReplacement("\u0436\u0438\u0442\u0456", "\u0436\u0438\u0442\u0442\u0456").withDependent("det").withDependent("case", NodePattern.N.form("[\u0443\u0432]")), SpellingRules.similarWordReplacement("\u0432\u0456\u0434", "\u0432\u0456\u043d").withHeadRelation("nsubj"), SpellingRules.similarWordReplacement("\u0437\u043e", "\u0449\u043e").withHeadRelation("mark"), SpellingRules.similarWordReplacement("\u0442\u043e\u043d", "\u0442\u043e\u043d\u043d").directlyAfter(NodePattern.N.pos("num.*")), SpellingRules.similarWordReplacement("\u043f\u0456\u0434\u0447\u0430\u0441", "\u043f\u0456\u0434 \u0447\u0430\u0441").withHeadRelation("case"));
    }

    private static NodePattern similarWordReplacement(String word, String replacement) {
        return NodePattern.N.form(word).message("\u0412\u0438 \u043c\u0430\u043b\u0438 \u043d\u0430 \u0443\u0432\u0430\u0437\u0456 \u00ab" + replacement + "\u00bb?").correct(NodeCorrector.replace(replacement));
    }

    private static NodePattern latinLetters() {
        NodePattern allowLatinMath = NodePattern.N.form("[<>=+)(]");
        String latinLetters = "ABCEHIKMOPTXaceiopxy";
        String ukrainianLetters = "\u0410\u0412\u0421\u0415\u041d\u0406\u041a\u041c\u041e\u0420\u0422\u0425\u0430\u0441\u0435\u0456\u043e\u0440\u0445\u0443";
        NodePattern latinAbbrevsUK = NodePattern.N.formCaseSensitive("([\u0412\u0421]2[\u0412\u0421]|\u0412\u0412\u0421|\u0440\u041d|\u0410\u0406|\u0406\u0420\u041e?|\u041c\u0410\u0421|\u0406\u0412\u041c|\u041c\u0406\u0422)");
        NodePattern eInsteadOfU = NodePattern.N.form("e").withHeadRelation("case");
        return NodePattern.or(NodePattern.N.form(".*[" + latinLetters + "].*").noPos().andOr(NodePattern.custom(node -> node.tree().treeSupport().tagToken(StringUtils.replaceChars((String)node.form(), (String)latinLetters, (String)ukrainianLetters)).hasPos(".*")), NodePattern.N.form("pp?|c|o").directlyBefore(CommonPatterns.dot)).noHeadRelation("flat:foreign").andNot(CommonPatterns.latin.andOr(CommonPatterns.upperCase, CommonPatterns.capitalizedMiddle).noHeadRelation("discourse")).andNot(NodePattern.N.directlyAfter(UkrainianTreePatterns.anyQuotation)).andNot(NodePattern.N.directlyBefore(UkrainianTreePatterns.anyQuotation)).andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE.noSpaceBefore())).andNot(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_NODE.noSpaceAfter())).andNot(NodePattern.or(NodePattern.N.directlyBefore(allowLatinMath), NodePattern.N.directlyAfter(allowLatinMath))).andNot(NodePattern.N.noFormCaseSensitive("[iy]").directlyBefore(CommonPatterns.latin).andOr(NodePattern.N.directlyAfter(NodePattern.or(CommonPatterns.latin, NodePattern.N.form("&"), NodePattern.PUNCT)), CommonPatterns.firstWord)).andNot(eInsteadOfU).andNot(NodePattern.N.form("Me").directlyBefore(CommonPatterns.comma)).andNot(NodePattern.N.form("[aei]").directlyBefore(CommonPatterns.dot)).noForm("pH").and((node, match) -> {
            match = match.withCorrector(NodeCorrector.replace(node, StringUtils.replaceChars((String)node.form(), (String)latinLetters, (String)ukrainianLetters)));
            if (node.form().length() == 1) {
                return CommonPatterns.highlightPlusOneChar.match(node, match);
            }
            return match;
        }).message(LATIN_MSG), latinAbbrevsUK.andNot(NodePattern.N.directlyBefore(CommonPatterns.noSpaceHyphen.directlyBefore(NodePattern.N.form("\\d.*")))).and((node, match) -> match.withCorrector(NodeCorrector.replace(node, StringUtils.replaceChars((String)node.form(), (String)ukrainianLetters, (String)latinLetters)))).andOptionally(NodePattern.N.formCaseSensitive("\u0412\u0412\u0421").noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_NODE).correct(NodeCorrector.replace("\u0411\u0456-\u0411\u0456-\u0421\u0456"))).message("\u0417\u043c\u0456\u043d\u0438\u0442\u0438 \u043b\u0456\u0442\u0435\u0440\u0438 \u043d\u0430 \u043b\u0430\u0442\u0438\u043d\u0438\u0446\u044e?"), eInsteadOfU.correct(NodeCorrector.replace("\u0443")).and(CommonPatterns.highlightPlusOneChar).message("\u0412\u0438 \u043c\u0430\u043b\u0438 \u043d\u0430 \u0443\u0432\u0430\u0437\u0456 \u00ab\u0443\u00bb?"));
    }

    private static NodePattern diacriticLetters() {
        return NodePattern.or(NodePattern.N.form(".*(\u0438\u0306|\u0439\u0306).*").correct(NodeCorrector.regexReplace("(\u0438\u0306|\u0439\u0306)", "\u0439")), NodePattern.N.form(".*\u0456\u0308.*").correct(NodeCorrector.regexReplace("\u0456\u0308", "\u0457"))).message(DIACRITIC_MSG);
    }
}

