/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.UnorderedPair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.data.index.ChangeKind;
import com.intellij.vcs.log.history.AdditionDeletion;
import com.intellij.vcs.log.history.CommitFileState;
import com.intellij.vcs.log.history.EdgeData;
import com.intellij.vcs.log.history.FileHistoryKt;
import com.intellij.vcs.log.history.Rename;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\bJ+\u0010#\u001a\u00020\u00002\u001c\u0010$\u001a\u0018\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0015j\u0002`\u00160\u0014\u0012\u0004\u0012\u00020\u00170\u0013H\u0000\u00a2\u0006\u0002\b%J\u0012\u0010&\u001a\u0004\u0018\u00010\u00172\u0006\u0010'\u001a\u00020(H\u0002J\u0006\u0010#\u001a\u00020\u0000J<\u0010)\u001a\u00020*2\u001e\u0010+\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u000e0\u00112\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020*0-H\u0002J!\u0010)\u001a\u00020*2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020*0-H\u0000\u00a2\u0006\u0002\b.J&\u0010/\u001a\u0002002\n\u00101\u001a\u00060\u0015j\u0002`\u00162\n\u00102\u001a\u00060\u0015j\u0002`\u00162\u0006\u00103\u001a\u000200J&\u00104\u001a\u0002002\n\u00101\u001a\u00060\u0015j\u0002`\u00162\n\u00102\u001a\u00060\u0015j\u0002`\u00162\u0006\u00105\u001a\u000200J$\u00106\u001a\u00020\u001b2\n\u00101\u001a\u00060\u0015j\u0002`\u00162\u0006\u00107\u001a\u0002002\b\b\u0002\u00108\u001a\u00020\u001bJ\u0010\u0010<\u001a\f\u0012\b\u0012\u00060\u0015j\u0002`\u00160 J\u0016\u0010=\u001a\u0012\u0012\b\u0012\u00060\u0015j\u0002`\u0016\u0012\u0004\u0012\u0002000\u0011J,\u0010>\u001a\u00020*2$\u0010,\u001a \u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0004\u0012\u00020*0?J\u0018\u0010@\u001a\u00020*2\u0010\u0010+\u001a\f\u0012\b\u0012\u00060\u0015j\u0002`\u00160AJ8\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010B2\n\u00102\u001a\u00060\u0015j\u0002`\u00162\n\u0010C\u001a\u00060\u0015j\u0002`\u00162\u0006\u00107\u001a\u00020\u00042\u0006\u0010D\u001a\u00020\u001bH&J\u001c\u0010E\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u000e2\u0006\u00107\u001a\u00020\u0004H&R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0086\u0001\u0010\u000b\u001az\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00040\u0004\u0012$\u0012\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e \r*\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u00010\u000e0\u000e \r*;\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00040\u0004\u0012$\u0012\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e \r*\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u00010\u000e0\u000e0\u0011\u00a2\u0006\u0002\b\u00100\f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u0018\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0015j\u0002`\u00160\u0014\u0012\u0004\u0012\u00020\u00170\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010+\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\b:\u0010;\u00a8\u0006F"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryData;", "", "startPaths", "", "Lcom/intellij/openapi/vcs/FilePath;", "<init>", "(Ljava/util/Collection;)V", "startPath", "(Lcom/intellij/openapi/vcs/FilePath;)V", "getStartPaths$intellij_platform_vcs_log_impl", "()Ljava/util/Collection;", "affectedCommits", "", "kotlin.jvm.PlatformType", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lcom/intellij/vcs/log/data/index/ChangeKind;", "Lorg/jetbrains/annotations/NotNull;", "", "commitToRename", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/util/UnorderedPair;", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "Lcom/intellij/vcs/log/history/Rename;", "getCommitToRename$intellij_platform_vcs_log_impl", "()Lcom/intellij/util/containers/MultiMap;", "isEmpty", "", "()Z", "hasRenames", "getHasRenames", "files", "", "getFiles", "()Ljava/util/Set;", "build", "oldRenames", "build$intellij_platform_vcs_log_impl", "findRename", "ad", "Lcom/intellij/vcs/log/history/AdditionDeletion;", "iterateUnmatchedAdditionsDeletions", "", "commits", "action", "Lkotlin/Function1;", "iterateUnmatchedAdditionsDeletions$intellij_platform_vcs_log_impl", "getFileStateInParentRevision", "Lcom/intellij/vcs/log/history/CommitFileState;", "commit", "parent", "childState", "getFileStateInChildRevision", "parentState", "affects", "path", "verify", "Lit/unimi/dsi/fastutil/ints/IntSet;", "getCommits", "()Lit/unimi/dsi/fastutil/ints/IntSet;", "getCommitsWithRenames", "buildFileStatesMap", "forEach", "Lkotlin/Function3;", "removeAll", "", "Lcom/intellij/vcs/log/history/EdgeData;", "child", "isChildPath", "getAffectedCommits", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFileHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistory.kt\ncom/intellij/vcs/log/history/FileHistoryData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,511:1\n1315#2,4:512\n1661#2,3:516\n1915#2:522\n1807#2,3:523\n1916#2:526\n221#3,2:519\n1#4:521\n*S KotlinDebug\n*F\n+ 1 FileHistory.kt\ncom/intellij/vcs/log/history/FileHistoryData\n*L\n249#1:512,4\n365#1:516,3\n278#1:522\n283#1:523,3\n278#1:526\n379#1:519,2\n*E\n"})
public abstract class FileHistoryData {
    @NotNull
    private final Collection<FilePath> startPaths;
    @NotNull
    private final Map<FilePath, Int2ObjectMap<Int2ObjectMap<ChangeKind>>> affectedCommits;
    @NotNull
    private final MultiMap<UnorderedPair<Integer>, Rename> commitToRename;

    public FileHistoryData(@NotNull Collection<? extends FilePath> startPaths) {
        Intrinsics.checkNotNullParameter(startPaths, (String)"startPaths");
        this.startPaths = startPaths;
        Map map = CollectionFactory.createCustomHashingStrategyMap(FileHistoryKt.FILE_PATH_HASHING_STRATEGY);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createCustomHashingStrategyMap(...)");
        this.affectedCommits = map;
        this.commitToRename = new MultiMap();
    }

    @NotNull
    public final Collection<FilePath> getStartPaths$intellij_platform_vcs_log_impl() {
        return this.startPaths;
    }

    @NotNull
    public final MultiMap<UnorderedPair<Integer>, Rename> getCommitToRename$intellij_platform_vcs_log_impl() {
        return this.commitToRename;
    }

    public final boolean isEmpty() {
        return this.affectedCommits.isEmpty();
    }

    public final boolean getHasRenames() {
        return !this.commitToRename.isEmpty();
    }

    @NotNull
    public final Set<FilePath> getFiles() {
        return this.affectedCommits.keySet();
    }

    public FileHistoryData(@NotNull FilePath startPath) {
        Intrinsics.checkNotNullParameter((Object)startPath, (String)"startPath");
        this(CollectionsKt.listOf((Object)startPath));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FileHistoryData build$intellij_platform_vcs_log_impl(@NotNull MultiMap<UnorderedPair<Integer>, Rename> oldRenames) {
        Intrinsics.checkNotNullParameter(oldRenames, (String)"oldRenames");
        Set set = CollectionFactory.createCustomHashingStrategySet(FileHistoryKt.FILE_PATH_HASHING_STRATEGY);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createCustomHashingStrategySet(...)");
        Set newPaths = set;
        newPaths.addAll(this.startPaths);
        while (!((Collection)newPaths).isEmpty()) {
            void $this$associateWithTo$iv;
            Map commits;
            Intrinsics.checkNotNullExpressionValue((Object)CollectionFactory.createCustomHashingStrategyMap(FileHistoryKt.FILE_PATH_HASHING_STRATEGY), (String)"createCustomHashingStrategyMap(...)");
            Iterable iterable = newPaths;
            Map destination$iv = commits;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv : $this$associateWithTo$iv) {
                void it;
                FilePath filePath = (FilePath)element$iv;
                Object t = element$iv;
                Map map = destination$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Int2ObjectMap<Int2ObjectMap<ChangeKind>> int2ObjectMap = this.getAffectedCommits((FilePath)it);
                map.put(t, int2ObjectMap);
            }
            this.affectedCommits.putAll(commits);
            newPaths.clear();
            this.iterateUnmatchedAdditionsDeletions(commits, (Function1<? super AdditionDeletion, Unit>)((Function1)arg_0 -> FileHistoryData.build$lambda$1(oldRenames, this, newPaths, arg_0)));
        }
        return this;
    }

    private final Rename findRename(AdditionDeletion ad) {
        Rename rename;
        EdgeData<FilePath> edgeData = this.findRename(ad.getParent(), ad.getChild(), ad.getFilePath(), ad.isAddition());
        if (edgeData != null) {
            EdgeData<FilePath> files = edgeData;
            boolean bl = false;
            rename = new Rename((FilePath)files.parent, (FilePath)files.child, ad.getParent(), ad.getChild());
        } else {
            rename = null;
        }
        return rename;
    }

    @NotNull
    public final FileHistoryData build() {
        MultiMap multiMap = MultiMap.empty();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"empty(...)");
        return this.build$intellij_platform_vcs_log_impl((MultiMap<UnorderedPair<Integer>, Rename>)multiMap);
    }

    private final void iterateUnmatchedAdditionsDeletions(Map<FilePath, ? extends Int2ObjectMap<Int2ObjectMap<ChangeKind>>> commits, Function1<? super AdditionDeletion, Unit> action) {
        FileHistoryKt.forEach(commits, (Function3<? super FilePath, ? super Integer, ? super Int2ObjectMap<ChangeKind>, Unit>)((Function3)(arg_0, arg_1, arg_2) -> FileHistoryData.iterateUnmatchedAdditionsDeletions$lambda$0(this, action, arg_0, arg_1, arg_2)));
    }

    public final void iterateUnmatchedAdditionsDeletions$intellij_platform_vcs_log_impl(@NotNull Function1<? super AdditionDeletion, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.iterateUnmatchedAdditionsDeletions(this.affectedCommits, (Function1<? super AdditionDeletion, Unit>)((Function1)arg_0 -> FileHistoryData.iterateUnmatchedAdditionsDeletions$lambda$1(action, arg_0)));
    }

    @NotNull
    public final CommitFileState getFileStateInParentRevision(int commit, int parent, @NotNull CommitFileState childState) {
        Intrinsics.checkNotNullParameter((Object)childState, (String)"childState");
        FilePath childFilePath = childState.getFilePath();
        Object object = this.affectedCommits.get(childFilePath);
        if (object == null || (object = (Int2ObjectMap)object.get(commit)) == null || (object = (ChangeKind)((Object)object.get(parent))) == null) {
            return childState;
        }
        Object changeKind = object;
        if (changeKind == ChangeKind.NOT_CHANGED) {
            return childState;
        }
        Collection collection = this.commitToRename.get((Object)new UnorderedPair((Object)commit, (Object)parent));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Collection renames = collection;
        if (!childState.getDeleted()) {
            FilePath otherPath = (FilePath)FileHistoryKt.access$firstNotNull(renames, arg_0 -> FileHistoryData.getFileStateInParentRevision$lambda$0(commit, childFilePath, arg_0));
            if (otherPath != null) {
                return new CommitFileState(otherPath);
            }
            return new CommitFileState(childFilePath, changeKind == ChangeKind.ADDED);
        }
        if (changeKind == ChangeKind.REMOVED && FileHistoryKt.access$firstNotNull(renames, arg_0 -> FileHistoryData.getFileStateInParentRevision$lambda$1(parent, childFilePath, arg_0)) != null) {
            return childState;
        }
        return new CommitFileState(childFilePath, changeKind != ChangeKind.REMOVED);
    }

    @NotNull
    public final CommitFileState getFileStateInChildRevision(int commit, int parent, @NotNull CommitFileState parentState) {
        Intrinsics.checkNotNullParameter((Object)parentState, (String)"parentState");
        FilePath parentFilePath = parentState.getFilePath();
        Object object = this.affectedCommits.get(parentFilePath);
        if (object == null || (object = (Int2ObjectMap)object.get(commit)) == null || (object = (ChangeKind)((Object)object.get(parent))) == null) {
            return parentState;
        }
        Object changeKind = object;
        if (changeKind == ChangeKind.NOT_CHANGED) {
            return parentState;
        }
        Collection collection = this.commitToRename.get((Object)new UnorderedPair((Object)commit, (Object)parent));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Collection renames = collection;
        if (!parentState.getDeleted()) {
            FilePath otherPath = (FilePath)FileHistoryKt.access$firstNotNull(renames, arg_0 -> FileHistoryData.getFileStateInChildRevision$lambda$0(parent, parentFilePath, arg_0));
            if (otherPath != null) {
                return new CommitFileState(otherPath);
            }
            return new CommitFileState(parentFilePath, changeKind == ChangeKind.REMOVED);
        }
        if (changeKind == ChangeKind.ADDED && FileHistoryKt.access$firstNotNull(renames, arg_0 -> FileHistoryData.getFileStateInChildRevision$lambda$1(commit, parentFilePath, arg_0)) != null) {
            return parentState;
        }
        return new CommitFileState(parentFilePath, changeKind != ChangeKind.ADDED);
    }

    public final boolean affects(int commit, @NotNull CommitFileState path, boolean verify) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Int2ObjectMap int2ObjectMap = this.affectedCommits.get(path.getFilePath());
        if (int2ObjectMap == null || (int2ObjectMap = (Int2ObjectMap)int2ObjectMap.get(commit)) == null) {
            return false;
        }
        Int2ObjectMap changes = int2ObjectMap;
        if (path.getDeleted()) {
            if (!changes.containsValue((Object)ChangeKind.REMOVED)) {
                return false;
            }
            if (!verify) {
                return true;
            }
            ObjectIterator objectIterator = changes.int2ObjectEntrySet().iterator();
            Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
            ObjectIterator objectIterator2 = objectIterator;
            while (objectIterator2.hasNext()) {
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectIterator2.next();
                int parent = entry.getIntKey();
                Collection collection = this.commitToRename.get((Object)new UnorderedPair((Object)commit, (Object)parent));
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
                if (FileHistoryKt.access$firstNotNull(collection, arg_0 -> FileHistoryData.affects$lambda$0(parent, path, arg_0)) == null) continue;
                return false;
            }
            return true;
        }
        return !changes.containsValue((Object)ChangeKind.REMOVED);
    }

    public static /* synthetic */ boolean affects$default(FileHistoryData fileHistoryData, int n, CommitFileState commitFileState, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: affects");
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return fileHistoryData.affects(n, commitFileState, bl);
    }

    @NotNull
    public final IntSet getCommits() {
        IntOpenHashSet result = new IntOpenHashSet();
        FileHistoryKt.forEach(this.affectedCommits, (Function3<? super FilePath, ? super Integer, ? super Int2ObjectMap<ChangeKind>, Unit>)((Function3)(arg_0, arg_1, arg_2) -> FileHistoryData._get_commits_$lambda$0(result, arg_0, arg_1, arg_2)));
        return (IntSet)result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Integer> getCommitsWithRenames() {
        void var2_2;
        void $this$mapTo$iv;
        Collection collection = this.commitToRename.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        Iterable iterable = collection;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void rename;
            Rename rename2 = (Rename)item$iv;
            Collection collection2 = destination$iv;
            boolean bl = false;
            collection2.add(rename.getChildCommit());
        }
        return (Set)var2_2;
    }

    @NotNull
    public final Map<Integer, CommitFileState> buildFileStatesMap() {
        Map result = new LinkedHashMap();
        FileHistoryKt.forEach(this.affectedCommits, (Function3<? super FilePath, ? super Integer, ? super Int2ObjectMap<ChangeKind>, Unit>)((Function3)(arg_0, arg_1, arg_2) -> FileHistoryData.buildFileStatesMap$lambda$0(result, arg_0, arg_1, arg_2)));
        return result;
    }

    public final void forEach(@NotNull Function3<? super FilePath, ? super Integer, ? super Int2ObjectMap<ChangeKind>, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        FileHistoryKt.forEach(this.affectedCommits, action);
    }

    public final void removeAll(@NotNull List<Integer> commits) {
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        Map<FilePath, Int2ObjectMap<Int2ObjectMap<ChangeKind>>> $this$forEach$iv = this.affectedCommits;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<FilePath, Int2ObjectMap<Int2ObjectMap<ChangeKind>>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<FilePath, Int2ObjectMap<Int2ObjectMap<ChangeKind>>> element$iv;
            Map.Entry<FilePath, Int2ObjectMap<Int2ObjectMap<ChangeKind>>> entry = element$iv = iterator.next();
            boolean bl = false;
            Int2ObjectMap<Int2ObjectMap<ChangeKind>> commitsMap = entry.getValue();
            Intrinsics.checkNotNull(commitsMap);
            FileHistoryKt.removeAll(commitsMap, commits);
        }
    }

    @Nullable
    public abstract EdgeData<FilePath> findRename(int var1, int var2, @NotNull FilePath var3, boolean var4);

    @NotNull
    public abstract Int2ObjectMap<Int2ObjectMap<ChangeKind>> getAffectedCommits(@NotNull FilePath var1);

    private static final Unit build$lambda$1(MultiMap $oldRenames, FileHistoryData this$0, Set $newPaths, AdditionDeletion ad) {
        Rename rename;
        Rename rename2;
        Object v1;
        block4: {
            Intrinsics.checkNotNullParameter((Object)ad, (String)"ad");
            Collection collection = $oldRenames.get(ad.getCommits());
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            Iterable iterable = collection;
            for (Object t : iterable) {
                Rename it = (Rename)t;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!ad.matches(it)) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        if ((rename2 = (Rename)v1) == null) {
            rename2 = this$0.findRename(ad);
        }
        if ((rename = rename2) != null) {
            this$0.commitToRename.putValue(ad.getCommits(), (Object)rename);
            FilePath filePath = rename.getOtherPath(ad);
            Intrinsics.checkNotNull((Object)filePath);
            FilePath otherPath = filePath;
            if (!this$0.affectedCommits.containsKey(otherPath)) {
                $newPaths.add(otherPath);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit iterateUnmatchedAdditionsDeletions$lambda$0(FileHistoryData this$0, Function1 $action, FilePath path, int commit, Int2ObjectMap changes) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        ObjectSet objectSet = changes.int2ObjectEntrySet();
        Intrinsics.checkNotNullExpressionValue((Object)objectSet, (String)"int2ObjectEntrySet(...)");
        Iterable $this$forEach$iv = (Iterable)objectSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            AdditionDeletion ad;
            block4: {
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)element$iv;
                boolean bl2 = false;
                int parent = entry.getIntKey();
                ChangeKind change = (ChangeKind)((Object)entry.getValue());
                if (parent == commit || change != ChangeKind.ADDED && change != ChangeKind.REMOVED) continue;
                ad = new AdditionDeletion(path, commit, parent, change == ChangeKind.ADDED);
                Collection collection = this$0.commitToRename.get(ad.getCommits());
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        Rename rename = (Rename)element$iv2;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)rename);
                        if (!ad.matches(rename)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            $action.invoke((Object)ad);
        }
        ProgressManager.checkCanceled();
        return Unit.INSTANCE;
    }

    private static final Unit iterateUnmatchedAdditionsDeletions$lambda$1(Function1 $action, AdditionDeletion it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $action.invoke((Object)it);
        return Unit.INSTANCE;
    }

    private static final FilePath getFileStateInParentRevision$lambda$0(int $commit, FilePath $childFilePath, Rename rename) {
        return rename.getOtherPath($commit, $childFilePath);
    }

    private static final FilePath getFileStateInParentRevision$lambda$1(int $parent, FilePath $childFilePath, Rename rename) {
        return rename.getOtherPath($parent, $childFilePath);
    }

    private static final FilePath getFileStateInChildRevision$lambda$0(int $parent, FilePath $parentFilePath, Rename rename) {
        return rename.getOtherPath($parent, $parentFilePath);
    }

    private static final FilePath getFileStateInChildRevision$lambda$1(int $commit, FilePath $parentFilePath, Rename rename) {
        return rename.getOtherPath($commit, $parentFilePath);
    }

    private static final FilePath affects$lambda$0(int $parent, CommitFileState $path, Rename rename) {
        return rename.getOtherPath($parent, $path.getFilePath());
    }

    private static final Unit _get_commits_$lambda$0(IntOpenHashSet $result, FilePath filePath, int commit, Int2ObjectMap int2ObjectMap) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)int2ObjectMap, (String)"<unused var>");
        $result.add(commit);
        return Unit.INSTANCE;
    }

    private static final Unit buildFileStatesMap$lambda$0(Map $result, FilePath filePath, int commit, Int2ObjectMap changes) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        $result.put(commit, new CommitFileState(filePath, changes.containsValue((Object)ChangeKind.REMOVED)));
        return Unit.INSTANCE;
    }
}

