/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryTabsManager;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.history.FileHistoryUtil;
import com.intellij.vcs.log.history.VcsLogFileHistoryUiProvider;
import com.intellij.vcs.log.history.VcsLogFileHistoryUiProviderKt;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J2\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/vcs/log/history/VcsLogSingleFileHistoryProvider;", "Lcom/intellij/vcs/log/history/VcsLogFileHistoryUiProvider;", "<init>", "()V", "canShowFileHistory", "", "project", "Lcom/intellij/openapi/project/Project;", "paths", "", "Lcom/intellij/openapi/vcs/FilePath;", "revisionNumber", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "showFileHistoryUi", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "selectRow", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogFileHistoryUiProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogFileHistoryUiProvider.kt\ncom/intellij/vcs/log/history/VcsLogSingleFileHistoryProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,168:1\n1#2:169\n30#3,2:170\n*S KotlinDebug\n*F\n+ 1 VcsLogFileHistoryUiProvider.kt\ncom/intellij/vcs/log/history/VcsLogSingleFileHistoryProvider\n*L\n139#1:170,2\n*E\n"})
final class VcsLogSingleFileHistoryProvider
implements VcsLogFileHistoryUiProvider {
    @NotNull
    public static final VcsLogSingleFileHistoryProvider INSTANCE = new VcsLogSingleFileHistoryProvider();

    private VcsLogSingleFileHistoryProvider() {
    }

    @Override
    public boolean canShowFileHistory(@NotNull Project project, @NotNull Collection<? extends FilePath> paths, @Nullable VcsRevisionNumber revisionNumber) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        if (!VcsLogFileHistoryUiProviderKt.isNewHistoryEnabled() || paths.size() != 1) {
            return false;
        }
        VirtualFile virtualFile = VcsLogUtil.getActualRoot(project, (FilePath)CollectionsKt.single((Iterable)paths));
        if (virtualFile == null) {
            return false;
        }
        VirtualFile root = virtualFile;
        FilePath correctedPath = FileHistoryUtil.INSTANCE.getCorrectedPath(project, (FilePath)CollectionsKt.single((Iterable)paths), revisionNumber != null);
        if (correctedPath.isDirectory()) {
            return false;
        }
        Object object = VcsProjectLog.Companion.getInstance(project).getDataManager();
        VcsLogProvider logProvider = object != null && (object = ((VcsLogData)object).getLogProviders()) != null ? (VcsLogProvider)object.get(root) : null;
        return VcsLogFileHistoryUiProviderKt.isNewFileHistoryAvailable(project, logProvider);
    }

    @Override
    @Nullable
    public VcsLogUiEx showFileHistoryUi(@NotNull Project project, @NotNull Collection<? extends FilePath> paths, @Nullable VcsRevisionNumber revisionNumber, boolean selectRow) {
        boolean firstTime;
        Hash hash;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        if (paths.size() != 1) {
            return null;
        }
        VirtualFile virtualFile = VcsLogUtil.getActualRoot(project, (FilePath)CollectionsKt.first((Iterable)paths));
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile root = virtualFile;
        FilePath path = FileHistoryUtil.INSTANCE.getCorrectedPath(project, (FilePath)CollectionsKt.single((Iterable)paths), revisionNumber != null);
        if (path.isDirectory()) {
            return null;
        }
        Object object = revisionNumber;
        if (object != null && (object = object.asString()) != null) {
            Object it = object;
            boolean bl = false;
            hash = HashImpl.build((String)it);
        } else {
            hash = null;
        }
        Hash hash2 = hash;
        VcsLogFileHistoryUiProvider.Companion.triggerFileHistoryUsage(project, paths, hash2);
        VcsLogManager vcsLogManager = VcsProjectLog.Companion.getInstance(project).getLogManager();
        Intrinsics.checkNotNull((Object)vcsLogManager);
        VcsLogManager logManager = vcsLogManager;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<FileHistoryTabsManager> serviceClass$iv = FileHistoryTabsManager.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        FileHistoryTabsManager tabsManager = (FileHistoryTabsManager)object2;
        FileHistoryUi fileHistoryUi = tabsManager.findUi(true, (Function1<? super FileHistoryUi, Boolean>)((Function1)arg_0 -> VcsLogSingleFileHistoryProvider.showFileHistoryUi$lambda$1(path, hash2, arg_0)));
        boolean bl = firstTime = fileHistoryUi == null;
        if (firstTime) {
            fileHistoryUi = tabsManager.openFileHistoryTab(logManager, path, root, hash2);
        }
        if (selectRow) {
            VcsLogFileHistoryUiProviderKt.access$selectRowWhenOpen(logManager, hash2, root, fileHistoryUi, firstTime);
        }
        return fileHistoryUi;
    }

    private static final boolean showFileHistoryUi$lambda$1(FilePath $path, Hash $hash, FileHistoryUi ui) {
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        return ui.matches($path, $hash);
    }
}

