/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.textCompletion.DefaultTextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import com.intellij.util.ui.CheckboxIcon;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.vcs.log.VcsLogAggregatedStoredRefs;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.actions.TextFieldWithProgress;
import com.intellij.vcs.log.ui.actions.VcsRefCompletionProvider;
import com.intellij.vcs.log.visible.filters.HashSeparatorCharFilter;
import com.intellij.vcsUtil.VcsImplUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class GoToHashOrRefPopup {
    private static final Logger LOG = Logger.getInstance(GoToHashOrRefPopup.class);
    @NotNull
    private final TextFieldWithProgress myTextField;
    @NotNull
    private final Function<? super String, ? extends Future> myOnSelectedHash;
    @NotNull
    private final Function<? super VcsRef, ? extends Future> myOnSelectedRef;
    @NotNull
    private final JBPopup myPopup;
    @Nullable
    private Future myFuture;
    @Nullable
    private VcsRef mySelectedRef;

    public GoToHashOrRefPopup(@NotNull Project project, @NotNull VcsLogAggregatedStoredRefs variants, @NotNull Collection<? extends VirtualFile> roots, @NotNull Function<? super String, ? extends Future> onSelectedHash, @NotNull Function<? super VcsRef, ? extends Future> onSelectedRef, @NotNull VcsLogColorManager colorManager, @NotNull Comparator<? super VcsRef> comparator) {
        if (project == null) {
            GoToHashOrRefPopup.$$$reportNull$$$0(0);
        }
        if (variants == null) {
            GoToHashOrRefPopup.$$$reportNull$$$0(1);
        }
        if (roots == null) {
            GoToHashOrRefPopup.$$$reportNull$$$0(2);
        }
        if (onSelectedHash == null) {
            GoToHashOrRefPopup.$$$reportNull$$$0(3);
        }
        if (onSelectedRef == null) {
            GoToHashOrRefPopup.$$$reportNull$$$0(4);
        }
        if (colorManager == null) {
            GoToHashOrRefPopup.$$$reportNull$$$0(5);
        }
        if (comparator == null) {
            GoToHashOrRefPopup.$$$reportNull$$$0(6);
        }
        this.myOnSelectedHash = onSelectedHash;
        this.myOnSelectedRef = onSelectedRef;
        VcsRefDescriptor vcsRefDescriptor = new VcsRefDescriptor(project, colorManager, comparator, roots);
        VcsRefCompletionProvider completionProvider = new VcsRefCompletionProvider(variants, roots, (TextCompletionValueDescriptor<VcsRef>)vcsRefDescriptor);
        this.myTextField = new TextFieldWithProgress(project, (TextCompletionProvider)completionProvider){

            @Override
            public void onOk() {
                if (GoToHashOrRefPopup.this.myFuture == null) {
                    Future future;
                    String refText = StringUtil.trim((String)this.getText(), (CharFilter)HashSeparatorCharFilter.invert());
                    GoToHashOrRefPopup.this.myFuture = future = GoToHashOrRefPopup.this.mySelectedRef == null || !GoToHashOrRefPopup.this.mySelectedRef.getName().equals(refText) ? GoToHashOrRefPopup.this.myOnSelectedHash.apply(refText) : GoToHashOrRefPopup.this.myOnSelectedRef.apply((VcsRef)GoToHashOrRefPopup.this.mySelectedRef);
                    this.showProgress();
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        try {
                            future.get();
                            GoToHashOrRefPopup.this.okPopup();
                        }
                        catch (InterruptedException | CancellationException ex) {
                            GoToHashOrRefPopup.this.cancelPopup();
                        }
                        catch (ExecutionException ex) {
                            LOG.error((Throwable)ex);
                            GoToHashOrRefPopup.this.cancelPopup();
                        }
                    });
                }
            }
        };
        this.myTextField.setAlignmentX(0.0f);
        this.myTextField.setBorder(JBUI.Borders.empty((int)3));
        JBLabel label = new JBLabel(VcsLogBundle.message("vcs.log.go.to.hash.popup.label", new Object[0]));
        label.setFont(StartupUiUtil.getLabelFont().deriveFont(1));
        label.setAlignmentX(0.0f);
        JPanel panel = new JPanel();
        BoxLayout layout = new BoxLayout(panel, 3);
        panel.setLayout(layout);
        panel.add((Component)label);
        panel.add(this.myTextField);
        panel.setBorder(JBUI.Borders.empty((int)2));
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, this.myTextField.getPreferableFocusComponent()).setCancelOnClickOutside(true).setCancelOnWindowDeactivation(true).setCancelKeyEnabled(true).setRequestFocus(true).createPopup();
        this.myPopup.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!event.isOk() && GoToHashOrRefPopup.this.myFuture != null) {
                    GoToHashOrRefPopup.this.myFuture.cancel(true);
                }
                GoToHashOrRefPopup.this.myFuture = null;
                GoToHashOrRefPopup.this.myTextField.hideProgress();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$2", "onClosed"));
            }
        });
    }

    private void cancelPopup() {
        ApplicationManager.getApplication().invokeLater(() -> this.myPopup.cancel());
    }

    private void okPopup() {
        ApplicationManager.getApplication().invokeLater(() -> this.myPopup.closeOk(null));
    }

    public void show(@NotNull JComponent anchor) {
        if (anchor == null) {
            GoToHashOrRefPopup.$$$reportNull$$$0(7);
        }
        this.myPopup.showInCenterOf((Component)anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSelectedHash";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSelectedRef";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class VcsRefDescriptor
    extends DefaultTextCompletionValueDescriptor<VcsRef> {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VcsLogColorManager myColorManager;
        @NotNull
        private final Comparator<? super VcsRef> myReferenceComparator;
        @NotNull
        private final Map<VirtualFile, String> myCachedRootNames;

        private VcsRefDescriptor(@NotNull Project project, @NotNull VcsLogColorManager manager, @NotNull Comparator<? super VcsRef> comparator, Collection<? extends VirtualFile> roots) {
            if (project == null) {
                VcsRefDescriptor.$$$reportNull$$$0(0);
            }
            if (manager == null) {
                VcsRefDescriptor.$$$reportNull$$$0(1);
            }
            if (comparator == null) {
                VcsRefDescriptor.$$$reportNull$$$0(2);
            }
            if (roots == null) {
                VcsRefDescriptor.$$$reportNull$$$0(3);
            }
            this.myCachedRootNames = new HashMap<VirtualFile, String>();
            this.myProject = project;
            this.myColorManager = manager;
            this.myReferenceComparator = comparator;
            for (VirtualFile virtualFile : roots) {
                String text = VcsImplUtil.getShortVcsRootName((Project)this.myProject, (VirtualFile)virtualFile);
                this.myCachedRootNames.put(virtualFile, text);
            }
        }

        @NotNull
        public LookupElementBuilder createLookupBuilder(@NotNull VcsRef item) {
            if (item == null) {
                VcsRefDescriptor.$$$reportNull$$$0(4);
            }
            LookupElementBuilder lookupBuilder = super.createLookupBuilder((Object)item);
            if (this.myColorManager.hasMultiplePaths()) {
                ColorIcon icon = CheckboxIcon.createAndScale((Color)this.myColorManager.getRootColor(item.getRoot()));
                lookupBuilder = lookupBuilder.withTypeText(this.getTypeText(item), (Icon)icon, true).withTypeIconRightAligned(true);
            }
            LookupElementBuilder lookupElementBuilder = lookupBuilder;
            if (lookupElementBuilder == null) {
                VcsRefDescriptor.$$$reportNull$$$0(5);
            }
            return lookupElementBuilder;
        }

        @NotNull
        public String getLookupString(@NotNull VcsRef item) {
            if (item == null) {
                VcsRefDescriptor.$$$reportNull$$$0(6);
            }
            String string = item.getName();
            if (string == null) {
                VcsRefDescriptor.$$$reportNull$$$0(7);
            }
            return string;
        }

        @Nullable
        protected String getTailText(@NotNull VcsRef item) {
            if (item == null) {
                VcsRefDescriptor.$$$reportNull$$$0(8);
            }
            if (!this.myColorManager.hasMultiplePaths()) {
                return null;
            }
            return "";
        }

        @Nullable
        protected String getTypeText(@NotNull VcsRef item) {
            if (item == null) {
                VcsRefDescriptor.$$$reportNull$$$0(9);
            }
            if (!this.myColorManager.hasMultiplePaths()) {
                return null;
            }
            String text = this.myCachedRootNames.get(item.getRoot());
            if (text == null) {
                return VcsImplUtil.getShortVcsRootName((Project)this.myProject, (VirtualFile)item.getRoot());
            }
            return text;
        }

        public int compare(VcsRef item1, VcsRef item2) {
            return this.myReferenceComparator.compare((VcsRef)item1, (VcsRef)item2);
        }

        @NotNull
        protected InsertHandler<LookupElement> createInsertHandler(@NotNull VcsRef item) {
            if (item == null) {
                VcsRefDescriptor.$$$reportNull$$$0(10);
            }
            InsertHandler insertHandler = (context, item1) -> {
                GoToHashOrRefPopup.this.mySelectedRef = (VcsRef)item1.getObject();
                ApplicationManager.getApplication().invokeLater(() -> GoToHashOrRefPopup.this.myTextField.onOk());
            };
            if (insertHandler == null) {
                VcsRefDescriptor.$$$reportNull$$$0(11);
            }
            return insertHandler;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 7, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comparator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 5: 
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefDescriptor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLookupBuilder";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createInsertHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createLookupBuilder";
                    break;
                }
                case 5: 
                case 7: 
                case 11: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getLookupString";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getTailText";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getTypeText";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "createInsertHandler";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 7, 11 -> new IllegalStateException(string);
            };
        }
    }
}

