/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vcs.changes.ui.BranchPresentation;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableCellState;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.paint.GraphCellPainter;
import com.intellij.vcs.log.ui.VcsBookmarkRef;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import com.intellij.vcs.log.ui.render.GraphCommitCellUtil;
import com.intellij.vcs.log.ui.render.LabelIconCache;
import com.intellij.vcs.log.ui.render.LabelPainter;
import com.intellij.vcs.log.ui.render.TypeSafeTableCellRenderer;
import com.intellij.vcs.log.ui.render.VcsLogLabelPainter;
import com.intellij.vcs.log.ui.table.GraphCommitCellController;
import com.intellij.vcs.log.ui.table.VcsLogCellController;
import com.intellij.vcs.log.ui.table.VcsLogCellRenderer;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.ui.table.column.Commit;
import com.intellij.vcs.log.ui.table.column.VcsLogColumnManager;
import com.intellij.vcs.log.ui.table.links.VcsLinksRenderer;
import com.intellij.vcs.log.visible.filters.VcsLogTextFilterWithMatches;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 62\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u00043456B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ8\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0014J\"\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0015\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%H\u0002J\u000e\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020\u0017J\u000e\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020\u0017J\u000e\u0010/\u001a\u00020#2\u0006\u00100\u001a\u00020\u0017J\b\u00101\u001a\u000202H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010(\u00a8\u00067"}, d2={"Lcom/intellij/vcs/log/ui/render/GraphCommitCellRenderer;", "Lcom/intellij/vcs/log/ui/render/TypeSafeTableCellRenderer;", "Lcom/intellij/vcs/log/ui/render/GraphCommitCell;", "Lcom/intellij/vcs/log/ui/table/VcsLogCellRenderer;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "painter", "Lcom/intellij/vcs/log/paint/GraphCellPainter;", "graphTable", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "<init>", "(Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/vcs/log/paint/GraphCellPainter;Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;)V", "component", "Lcom/intellij/vcs/log/ui/render/GraphCommitCellRenderer$RealCommitRendererComponent;", "templateComponent", "wipComponent", "Lcom/intellij/vcs/log/ui/render/GraphCommitCellRenderer$WipCommitRendererComponent;", "getTableCellRendererComponentImpl", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "isSelected", "", "hasFocus", "row", "", "column", "getTooltip", "Ljavax/swing/JComponent;", "", "point", "Ljava/awt/Point;", "getTooltipXCoordinate", "prepareTemplateComponent", "", "cell", "Lcom/intellij/vcs/log/ui/render/GraphCommitCell$RealCommit;", "columnWidth", "getColumnWidth", "()I", "preferredHeight", "getPreferredHeight", "setCompactReferencesView", "compact", "setShowTagsNames", "showTagNames", "setLeftAligned", "leftAligned", "getCellController", "Lcom/intellij/vcs/log/ui/table/VcsLogCellController;", "RealCommitRendererComponent", "WipCommitRendererComponent", "VcsLogTableCellState", "Companion", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGraphCommitCellRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphCommitCellRenderer.kt\ncom/intellij/vcs/log/ui/render/GraphCommitCellRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,373:1\n1#2:374\n*E\n"})
public final class GraphCommitCellRenderer
extends TypeSafeTableCellRenderer<GraphCommitCell>
implements VcsLogCellRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsLogData logData;
    @NotNull
    private final VcsLogGraphTable graphTable;
    @NotNull
    private final RealCommitRendererComponent component;
    @NotNull
    private final RealCommitRendererComponent templateComponent;
    @NotNull
    private final WipCommitRendererComponent wipComponent;

    public GraphCommitCellRenderer(@NotNull VcsLogData logData, @NotNull GraphCellPainter painter, @NotNull VcsLogGraphTable graphTable) {
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Intrinsics.checkNotNullParameter((Object)painter, (String)"painter");
        Intrinsics.checkNotNullParameter((Object)graphTable, (String)"graphTable");
        this.logData = logData;
        this.graphTable = graphTable;
        this.wipComponent = new WipCommitRendererComponent(this.graphTable, painter);
        LabelIconCache iconCache = new LabelIconCache();
        this.component = new RealCommitRendererComponent(this.logData, painter, this.graphTable, iconCache);
        this.templateComponent = new RealCommitRendererComponent(this.logData, painter, this.graphTable, iconCache);
    }

    @Override
    @NotNull
    protected Component getTableCellRendererComponentImpl(@NotNull JTable table, @NotNull GraphCommitCell value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        GraphCommitCell graphCommitCell = value;
        if (graphCommitCell instanceof GraphCommitCell.RealCommit) {
            RealCommitRendererComponent realCommitRendererComponent;
            RealCommitRendererComponent $this$getTableCellRendererComponentImpl_u24lambda_u240 = realCommitRendererComponent = this.component;
            boolean bl = false;
            $this$getTableCellRendererComponentImpl_u24lambda_u240.customize((GraphCommitCell.RealCommit)value, isSelected, hasFocus, row, column);
            component = (Component)((Object)realCommitRendererComponent);
        } else if (graphCommitCell instanceof GraphCommitCell.NewCommit) {
            WipCommitRendererComponent wipCommitRendererComponent;
            WipCommitRendererComponent $this$getTableCellRendererComponentImpl_u24lambda_u241 = wipCommitRendererComponent = this.wipComponent;
            boolean bl = false;
            $this$getTableCellRendererComponentImpl_u24lambda_u241.customize((GraphCommitCell.NewCommit)value, isSelected, hasFocus, row, column);
            component = (Component)((Object)wipCommitRendererComponent);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return component;
    }

    private final JComponent getTooltip(Object value, Point point, int row) {
        Object t = this.getValue(value);
        Intrinsics.checkNotNullExpressionValue(t, (String)"getValue(...)");
        GraphCommitCell cell = (GraphCommitCell)t;
        if (!(cell instanceof GraphCommitCell.RealCommit)) {
            return null;
        }
        Collection<VcsRef> refs = ((GraphCommitCell.RealCommit)cell).getRefsToThisCommit();
        Collection<VcsBookmarkRef> bookmarks = ((GraphCommitCell.RealCommit)cell).getBookmarksToThisCommit();
        if (refs.isEmpty() && bookmarks.isEmpty()) {
            return null;
        }
        this.prepareTemplateComponent(row, (GraphCommitCell.RealCommit)cell);
        if (this.templateComponent.getReferencePainter().isLeftAligned()) {
            if ((double)this.templateComponent.getGraphWidth() < point.getX() && point.getX() <= (double)(this.templateComponent.getGraphWidth() + this.templateComponent.getReferencesWidth())) {
                return this.templateComponent.getReferencePainter().createTooltip(this.logData, refs, bookmarks, point.getX() - (double)this.templateComponent.getGraphWidth());
            }
        } else if ((double)(this.getColumnWidth() - this.templateComponent.getReferencesWidth()) <= point.getX()) {
            return this.templateComponent.getReferencePainter().createTooltip(this.logData, refs, bookmarks, point.getX() - (double)this.getColumnWidth() + (double)this.templateComponent.getReferencesWidth());
        }
        return null;
    }

    private final int getTooltipXCoordinate(int row) {
        Object t = this.getValue(this.graphTable.getModel().getValueAt(row, Commit.INSTANCE));
        Intrinsics.checkNotNullExpressionValue(t, (String)"getValue(...)");
        GraphCommitCell cell = (GraphCommitCell)t;
        if (!(cell instanceof GraphCommitCell.RealCommit)) {
            return this.getColumnWidth() / 2;
        }
        if (((GraphCommitCell.RealCommit)cell).getRefsToThisCommit().isEmpty() && ((GraphCommitCell.RealCommit)cell).getBookmarksToThisCommit().isEmpty()) {
            return this.getColumnWidth() / 2;
        }
        this.prepareTemplateComponent(row, (GraphCommitCell.RealCommit)cell);
        int referencesWidth = this.templateComponent.getReferencesWidth();
        if (this.templateComponent.getReferencePainter().isLeftAligned()) {
            return this.templateComponent.getGraphWidth() + referencesWidth / 2;
        }
        return this.getColumnWidth() - referencesWidth / 2;
    }

    private final void prepareTemplateComponent(int row, GraphCommitCell.RealCommit cell) {
        this.templateComponent.customize(cell, this.graphTable.isRowSelected(row), this.graphTable.hasFocus(), row, VcsLogColumnManager.Companion.getInstance().getModelIndex(Commit.INSTANCE));
    }

    private final int getColumnWidth() {
        return this.graphTable.getCommitColumn().getWidth();
    }

    public final int getPreferredHeight() {
        return this.component.getPreferredHeight();
    }

    public final void setCompactReferencesView(boolean compact) {
        this.component.getReferencePainter().setCompact(compact);
        this.templateComponent.getReferencePainter().setCompact(compact);
    }

    public final void setShowTagsNames(boolean showTagNames) {
        this.component.getReferencePainter().setShowTagNames(showTagNames);
        this.templateComponent.getReferencePainter().setShowTagNames(showTagNames);
    }

    public final void setLeftAligned(boolean leftAligned) {
        this.component.getReferencePainter().setLeftAligned(leftAligned);
        this.templateComponent.getReferencePainter().setLeftAligned(leftAligned);
    }

    @Override
    @NotNull
    public VcsLogCellController getCellController() {
        VcsLogData vcsLogData = this.logData;
        VcsLogGraphTable vcsLogGraphTable = this.graphTable;
        GraphCellPainter graphCellPainter2 = this.component.getPainter();
        return new GraphCommitCellController(this, vcsLogData, vcsLogGraphTable, graphCellPainter2){
            final /* synthetic */ GraphCommitCellRenderer this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            protected int getTooltipXCoordinate(int row) {
                return GraphCommitCellRenderer.access$getTooltipXCoordinate(this.this$0, row);
            }

            protected JComponent getTooltip(Object value, Point point, int row) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)point, (String)"point");
                return GraphCommitCellRenderer.access$getTooltip(this.this$0, value, point, row);
            }
        };
    }

    @NotNull
    public static final Font getLabelFont() {
        return Companion.getLabelFont();
    }

    public static final /* synthetic */ int access$getTooltipXCoordinate(GraphCommitCellRenderer $this, int row) {
        return $this.getTooltipXCoordinate(row);
    }

    public static final /* synthetic */ JComponent access$getTooltip(GraphCommitCellRenderer $this, Object value, Point point, int row) {
        return $this.getTooltip(value, point, row);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/vcs/log/ui/render/GraphCommitCellRenderer$Companion;", "", "<init>", "()V", "labelFont", "Ljava/awt/Font;", "getLabelFont$annotations", "getLabelFont", "()Ljava/awt/Font;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Font getLabelFont() {
            return StartupUiUtil.getLabelFont();
        }

        @JvmStatic
        public static /* synthetic */ void getLabelFont$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 B2\u00020\u0001:\u0001BB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J.\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u00020\u001e2\u0006\u00103\u001a\u00020\u001eJ(\u00104\u001a\u00020)2\u0006\u0010-\u001a\u00020.2\u0006\u00105\u001a\u0002062\u0006\u0010/\u001a\u0002002\u0006\u00107\u001a\u000200H\u0002J\u0018\u00108\u001a\u00020\u001e2\u0006\u00103\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\b\u00109\u001a\u00020\u001eH\u0002J\b\u0010:\u001a\u00020\u001eH\u0002J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u001cH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010;\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010!R\u0011\u0010@\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010!\u00a8\u0006C"}, d2={"Lcom/intellij/vcs/log/ui/render/GraphCommitCellRenderer$RealCommitRendererComponent;", "Lcom/intellij/ui/SimpleColoredRenderer;", "data", "Lcom/intellij/vcs/log/data/VcsLogData;", "painter", "Lcom/intellij/vcs/log/paint/GraphCellPainter;", "table", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "iconCache", "Lcom/intellij/vcs/log/ui/render/LabelIconCache;", "<init>", "(Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/vcs/log/paint/GraphCellPainter;Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;Lcom/intellij/vcs/log/ui/render/LabelIconCache;)V", "getPainter", "()Lcom/intellij/vcs/log/paint/GraphCellPainter;", "issueLinkRenderer", "Lcom/intellij/openapi/vcs/changes/issueLinks/IssueLinkRenderer;", "vcsLinksRenderer", "Lcom/intellij/vcs/log/ui/table/links/VcsLinksRenderer;", "referencePainter", "Lcom/intellij/vcs/log/ui/render/VcsLogLabelPainter;", "getReferencePainter", "()Lcom/intellij/vcs/log/ui/render/VcsLogLabelPainter;", "printElements", "", "Lcom/intellij/vcs/log/graph/PrintElement;", "commitStyle", "Lcom/intellij/vcs/log/VcsLogHighlighter$VcsCommitStyle;", "fontInner", "Ljava/awt/Font;", "heightInner", "", "graphWidth", "getGraphWidth", "()I", "setGraphWidth", "(I)V", "affineTransform", "Ljava/awt/geom/AffineTransform;", "getPreferredSize", "Ljava/awt/Dimension;", "paintComponent", "", "g", "Ljava/awt/Graphics;", "customize", "cell", "Lcom/intellij/vcs/log/ui/render/GraphCommitCell$RealCommit;", "isSelected", "", "hasFocus", "row", "column", "appendText", "style", "Lcom/intellij/ui/SimpleTextAttributes;", "renderLinks", "getAvailableWidth", "calculateHeight", "calculateRowContentHeight", "preferredHeight", "getPreferredHeight", "getFontMetrics", "Ljava/awt/FontMetrics;", "font", "referencesWidth", "getReferencesWidth", "Companion", "intellij.platform.vcs.log.impl"})
    @SourceDebugExtension(value={"SMAP\nGraphCommitCellRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphCommitCellRenderer.kt\ncom/intellij/vcs/log/ui/render/GraphCommitCellRenderer$RealCommitRendererComponent\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,373:1\n106#2:374\n78#2,22:375\n*S KotlinDebug\n*F\n+ 1 GraphCommitCellRenderer.kt\ncom/intellij/vcs/log/ui/render/GraphCommitCellRenderer$RealCommitRendererComponent\n*L\n250#1:374\n250#1:375,22\n*E\n"})
    private static final class RealCommitRendererComponent
    extends SimpleColoredRenderer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final GraphCellPainter painter;
        @NotNull
        private final VcsLogGraphTable table;
        @NotNull
        private final IssueLinkRenderer issueLinkRenderer;
        @NotNull
        private final VcsLinksRenderer vcsLinksRenderer;
        @NotNull
        private final VcsLogLabelPainter referencePainter;
        @NotNull
        private Collection<? extends PrintElement> printElements;
        @NotNull
        private VcsLogHighlighter.VcsCommitStyle commitStyle;
        @NotNull
        private Font fontInner;
        private int heightInner;
        private int graphWidth;
        @Nullable
        private AffineTransform affineTransform;
        private static final int DISPLAYED_MESSAGE_PART = 80;

        public RealCommitRendererComponent(@NotNull VcsLogData data, @NotNull GraphCellPainter painter, @NotNull VcsLogGraphTable table, @NotNull LabelIconCache iconCache) {
            GraphicsConfiguration configuration;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)painter, (String)"painter");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)iconCache, (String)"iconCache");
            this.painter = painter;
            this.table = table;
            this.issueLinkRenderer = new IssueLinkRenderer(data.getProject(), (SimpleColoredComponent)this);
            this.vcsLinksRenderer = new VcsLinksRenderer(data.getProject(), (SimpleColoredComponent)this);
            this.referencePainter = new VcsLogLabelPainter(data, (JComponent)((Object)this.table), iconCache);
            this.printElements = CollectionsKt.emptyList();
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)vcsCommitStyle, (String)"DEFAULT");
            this.commitStyle = vcsCommitStyle;
            this.setCellState(new VcsLogTableCellState());
            this.fontInner = Companion.getLabelFont();
            GraphicsConfiguration graphicsConfiguration = configuration = this.table.getGraphicsConfiguration();
            this.affineTransform = graphicsConfiguration != null ? graphicsConfiguration.getDefaultTransform() : null;
            this.heightInner = this.calculateHeight();
        }

        @NotNull
        public final GraphCellPainter getPainter() {
            return this.painter;
        }

        @NotNull
        public final VcsLogLabelPainter getReferencePainter() {
            return this.referencePainter;
        }

        public final int getGraphWidth() {
            return this.graphWidth;
        }

        public final void setGraphWidth(int n) {
            this.graphWidth = n;
        }

        @NotNull
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
            Dimension preferredSize = dimension;
            int referencesSize = this.referencePainter.isLeftAligned() ? 0 : this.referencePainter.getSize().width;
            return new Dimension(preferredSize.width + referencesSize, this.getPreferredHeight());
        }

        public void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Object object = InternalUICustomization.Companion.getInstance();
            if (object == null || (object = object.preserveGraphics(g)) == null) {
                object = g;
            }
            Graphics2D g2d = (Graphics2D)object;
            super.paintComponent((Graphics)g2d);
            if (!this.referencePainter.isLeftAligned()) {
                int start2 = (int)Math.max((double)this.graphWidth, (double)(this.getWidth() - this.referencePainter.getSize().width));
                this.referencePainter.paint(g2d, start2, 0, this.getHeight());
            } else {
                this.referencePainter.paint(g2d, this.graphWidth, 0, this.getHeight());
            }
            this.painter.paint(g2d, this.commitStyle, this.printElements);
        }

        public final void customize(@NotNull GraphCommitCell.RealCommit cell, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean renderLinks;
            Color color;
            Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
            this.clear();
            this.setPaintFocusBorder(false);
            this.acquireState((JTable)((Object)this.table), isSelected, hasFocus, row, column);
            this.getCellState().updateRenderer((JComponent)((Object)this));
            this.printElements = cell.getPrintElements();
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = this.table.getStyle(row, column, hasFocus, isSelected, row == TableHoverListener.getHoveredRow((JTable)((JTable)((Object)this.table))));
            Intrinsics.checkNotNullExpressionValue((Object)vcsCommitStyle, (String)"getStyle(...)");
            this.commitStyle = vcsCommitStyle;
            this.graphWidth = GraphCommitCellUtil.getGraphWidth(this.table, this.printElements);
            SimpleTextAttributes simpleTextAttributes = this.table.applyHighlighters((Component)((Object)this), row, column, hasFocus, isSelected);
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"applyHighlighters(...)");
            SimpleTextAttributes style = simpleTextAttributes;
            Collection<VcsRef> refs = cell.getRefsToThisCommit();
            Collection<VcsBookmarkRef> bookmarks = cell.getBookmarksToThisCommit();
            if (ExperimentalUI.Companion.isNewUI()) {
                JBColor jBColor = JBColor.namedColor((String)"VersionControl.Log.Commit.Reference.foreground", (Color)((Color)BranchPresentation.TEXT_COLOR));
                Intrinsics.checkNotNull((Object)jBColor);
                color = (Color)jBColor;
            } else if (isSelected) {
                Color color2 = this.table.getBaseStyle(row, column, hasFocus, isSelected).getForeground();
                color = color2;
                Intrinsics.checkNotNull((Object)color2);
            } else {
                color = (Color)BranchPresentation.TEXT_COLOR;
            }
            Color labelForeground = color;
            this.append("");
            boolean bl = renderLinks = !cell.isLoading();
            if (this.referencePainter.isLeftAligned()) {
                Color color3 = this.getBackground();
                Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"getBackground(...)");
                this.referencePainter.customizePainter(refs, bookmarks, color3, labelForeground, isSelected, this.getAvailableWidth(column, this.graphWidth));
                int referencesWidth = this.referencePainter.getSize().width;
                if (referencesWidth > 0) {
                    referencesWidth += LabelPainter.RIGHT_PADDING.get();
                }
                this.appendTextPadding(this.graphWidth + referencesWidth);
                this.appendText(cell, style, isSelected, renderLinks);
            } else {
                this.appendTextPadding(this.graphWidth);
                this.appendText(cell, style, isSelected, renderLinks);
                Color color4 = this.getBackground();
                Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"getBackground(...)");
                this.referencePainter.customizePainter(refs, bookmarks, color4, labelForeground, isSelected, this.getAvailableWidth(column, this.graphWidth));
            }
        }

        private final void appendText(GraphCommitCell.RealCommit cell, SimpleTextAttributes style, boolean isSelected, boolean renderLinks) {
            VcsLogTextFilter textFilter;
            String string = StringUtil.replace((String)cell.getText(), (String)"\t", (String)" ");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replace(...)");
            String $this$trim$iv = string;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String cellText = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            CommitId commitId = cell.getCommitId();
            if (renderLinks) {
                if (VcsLinksRenderer.Companion.isEnabled()) {
                    this.vcsLinksRenderer.appendTextWithLinks(cellText, style, commitId);
                } else {
                    this.issueLinkRenderer.appendTextWithLinks(cellText, style);
                }
            } else {
                this.append(cellText, style);
            }
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)((JComponent)((Object)this.table)), (SimpleColoredComponent)((SimpleColoredComponent)this), (boolean)false, (boolean)isSelected);
            if (Registry.Companion.is("vcs.log.filter.text.highlight.matches") && (textFilter = (VcsLogTextFilter)this.table.getModel().getVisiblePack().getFilters().get(VcsLogFilterCollection.TEXT_FILTER)) instanceof VcsLogTextFilterWithMatches) {
                String text = ((Object)this.getCharSequence(false)).toString();
                SpeedSearchUtil.applySpeedSearchHighlighting((SimpleColoredComponent)((SimpleColoredComponent)this), ((VcsLogTextFilterWithMatches)textFilter).matchingRanges(text), (boolean)isSelected);
            }
        }

        private final int getAvailableWidth(int column, int graphWidth) {
            int textAndLabelsWidth = this.table.getColumnModel().getColumn(column).getWidth() - graphWidth;
            int freeSpace = textAndLabelsWidth - super.getPreferredSize().width;
            int allowedSpace = this.referencePainter.isCompact() ? (int)Math.min((double)freeSpace, (double)(textAndLabelsWidth / 3)) : (int)Math.max((double)freeSpace, Math.max((double)(textAndLabelsWidth / 2), (double)(textAndLabelsWidth - JBUIScale.scale((int)80))));
            return (int)Math.max(0.0, (double)allowedSpace);
        }

        private final int calculateHeight() {
            int rowContentHeight = this.calculateRowContentHeight();
            return ExperimentalUI.Companion.isNewUI() ? (int)Math.max((double)rowContentHeight, (double)JBUI.CurrentTheme.VersionControl.Log.rowHeight()) : rowContentHeight;
        }

        private final int calculateRowContentHeight() {
            return (int)Math.max((double)this.referencePainter.getSize().height, (double)(this.getFontMetrics(this.fontInner).getHeight() + JBUI.scale((int)JBUI.CurrentTheme.VersionControl.Log.verticalPadding())));
        }

        public final int getPreferredHeight() {
            Font font = Companion.getLabelFont();
            GraphicsConfiguration configuration = this.table.getGraphicsConfiguration();
            if (this.fontInner != font || configuration != null && !Intrinsics.areEqual((Object)this.affineTransform, (Object)configuration.getDefaultTransform())) {
                this.fontInner = font;
                GraphicsConfiguration graphicsConfiguration = configuration;
                this.affineTransform = graphicsConfiguration != null ? graphicsConfiguration.getDefaultTransform() : null;
                this.heightInner = this.calculateHeight();
            }
            return this.heightInner;
        }

        @NotNull
        public FontMetrics getFontMetrics(@NotNull Font font) {
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            FontMetrics fontMetrics = this.table.getFontMetrics(font);
            Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
            return fontMetrics;
        }

        public final int getReferencesWidth() {
            return this.referencePainter.getSize().width;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/vcs/log/ui/render/GraphCommitCellRenderer$RealCommitRendererComponent$Companion;", "", "<init>", "()V", "DISPLAYED_MESSAGE_PART", "", "intellij.platform.vcs.log.impl"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0014J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/vcs/log/ui/render/GraphCommitCellRenderer$VcsLogTableCellState;", "Lcom/intellij/ui/TableCellState;", "<init>", "()V", "getBorder", "Ljavax/swing/border/Border;", "isSelected", "", "hasFocus", "getSelectionForeground", "Ljava/awt/Color;", "table", "Ljavax/swing/JTable;", "intellij.platform.vcs.log.impl"})
    public static final class VcsLogTableCellState
    extends TableCellState {
        @Nullable
        protected Border getBorder(boolean isSelected, boolean hasFocus) {
            return null;
        }

        @NotNull
        protected Color getSelectionForeground(@NotNull JTable table, boolean isSelected) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            if (!isSelected) {
                Color color = super.getSelectionForeground(table, isSelected);
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getSelectionForeground(...)");
                return color;
            }
            Color color = VcsLogGraphTable.getSelectionForeground(RenderingUtil.isFocused((JComponent)table));
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getSelectionForeground(...)");
            return color;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/log/ui/render/GraphCommitCellRenderer$WipCommitRendererComponent;", "Lcom/intellij/ui/SimpleColoredRenderer;", "table", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "painter", "Lcom/intellij/vcs/log/paint/GraphCellPainter;", "<init>", "(Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;Lcom/intellij/vcs/log/paint/GraphCellPainter;)V", "printElements", "", "Lcom/intellij/vcs/log/graph/PrintElement;", "commitStyle", "Lcom/intellij/vcs/log/VcsLogHighlighter$VcsCommitStyle;", "customize", "", "cell", "Lcom/intellij/vcs/log/ui/render/GraphCommitCell$NewCommit;", "isSelected", "", "hasFocus", "row", "", "column", "paintComponent", "g", "Ljava/awt/Graphics;", "intellij.platform.vcs.log.impl"})
    private static final class WipCommitRendererComponent
    extends SimpleColoredRenderer {
        @NotNull
        private final VcsLogGraphTable table;
        @NotNull
        private final GraphCellPainter painter;
        @NotNull
        private Collection<? extends PrintElement> printElements;
        @NotNull
        private VcsLogHighlighter.VcsCommitStyle commitStyle;

        public WipCommitRendererComponent(@NotNull VcsLogGraphTable table, @NotNull GraphCellPainter painter) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)painter, (String)"painter");
            this.table = table;
            this.painter = painter;
            this.printElements = CollectionsKt.emptyList();
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)vcsCommitStyle, (String)"DEFAULT");
            this.commitStyle = vcsCommitStyle;
            this.setCellState(new VcsLogTableCellState());
        }

        public final void customize(@NotNull GraphCommitCell.NewCommit cell, boolean isSelected, boolean hasFocus, int row, int column) {
            Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
            this.clear();
            this.printElements = cell.getPrintElements();
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = this.table.getStyle(row, column, hasFocus, isSelected, row == TableHoverListener.getHoveredRow((JTable)((JTable)((Object)this.table))));
            Intrinsics.checkNotNullExpressionValue((Object)vcsCommitStyle, (String)"getStyle(...)");
            this.commitStyle = vcsCommitStyle;
            int graphWidth = GraphCommitCellUtil.getGraphWidth(this.table, this.printElements);
            SimpleTextAttributes simpleTextAttributes = this.table.applyHighlighters((Component)((Object)this), row, column, hasFocus, isSelected);
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"applyHighlighters(...)");
            SimpleTextAttributes style = simpleTextAttributes;
            this.append("");
            this.appendTextPadding(graphWidth);
            this.append(VcsLogBundle.message("vcs.log.wip.label", new Object[0]), style);
        }

        protected void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Object object = InternalUICustomization.Companion.getInstance();
            if (object == null || (object = object.preserveGraphics(g)) == null) {
                object = g;
            }
            Graphics2D g2d = (Graphics2D)object;
            super.paintComponent(g);
            this.painter.paint(g2d, this.commitStyle, this.printElements);
        }
    }
}

