/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.frontend.portForwarding;

import com.intellij.cwm.frontend.CodeWithMeFrontendBundle;
import com.intellij.cwm.plugin.common.portForwarding.PortForwardingToolWindowManager;
import com.intellij.cwm.plugin.common.toolWindow.CodeWithMeToolWindowManager;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ApplicationKt;
import com.jetbrains.codeWithMe.model.PortForwardingModel;
import com.jetbrains.codeWithMe.model.PortForwardingModel_GeneratedKt;
import com.jetbrains.codeWithMe.model.RdForwardedPort;
import com.jetbrains.codeWithMe.model.RdPortState;
import com.jetbrains.codeWithMe.model.RdPortType;
import com.jetbrains.codeWithMe.model.RdSocketAddress;
import com.jetbrains.codeWithMe.model.SocketState;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.connection.ClientSessionListener;
import com.jetbrains.thinclient.SessionUtilKt;
import com.jetbrains.thinclient.portForwarding.ThinClientPortForwardingManager;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.table.AbstractTableModel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0004\u0014\u0015\u0016\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\u0013\u001a\u00020\u000bH\u0016R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/cwm/frontend/portForwarding/FrontendPortForwardingToolWindowManager;", "Lcom/intellij/cwm/plugin/common/portForwarding/PortForwardingToolWindowManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "onPortForwardingEnabled", "", "enabledLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "myScrollPane", "Ljavax/swing/JComponent;", "getMyScrollPane", "()Ljavax/swing/JComponent;", "myScrollPane$delegate", "Lkotlin/Lazy;", "myComponent", "getMyComponent", "myComponent$delegate", "getComponent", "Companion", "PortForwardingClientSessionListener", "ThinClientPortForwardingTableModel", "MyTable", "intellij.cwm.frontend"})
public final class FrontendPortForwardingToolWindowManager
extends PortForwardingToolWindowManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy myScrollPane$delegate;
    @NotNull
    private final Lazy myComponent$delegate;

    public FrontendPortForwardingToolWindowManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.myScrollPane$delegate = LazyKt.lazy(() -> FrontendPortForwardingToolWindowManager.myScrollPane_delegate$lambda$0(this));
        this.myComponent$delegate = LazyKt.lazy(() -> FrontendPortForwardingToolWindowManager.myComponent_delegate$lambda$0(this));
    }

    private final void onPortForwardingEnabled(Lifetime enabledLifetime) {
        BoolPropertyExKt.whenTrue((IViewable)((IViewable)CodeWithMeToolWindowManager.Companion.getInstance(this.getProject()).getToolWindowRegistered()), (Lifetime)enabledLifetime, arg_0 -> FrontendPortForwardingToolWindowManager.onPortForwardingEnabled$lambda$0(this, arg_0));
    }

    private final JComponent getMyScrollPane() {
        Lazy lazy = this.myScrollPane$delegate;
        return (JComponent)lazy.getValue();
    }

    private final JComponent getMyComponent() {
        Lazy lazy = this.myComponent$delegate;
        return (JComponent)lazy.getValue();
    }

    @NotNull
    public JComponent getComponent() {
        return this.getMyComponent();
    }

    private static final void onPortForwardingEnabled$lambda$0$0$0(FrontendPortForwardingToolWindowManager this$0) {
        if (this$0.getProject().isDisposed()) {
            return;
        }
        this$0.removePanelFromToolWindow();
    }

    private static final Unit onPortForwardingEnabled$lambda$0$0(FrontendPortForwardingToolWindowManager this$0) {
        ApplicationKt.getApplication().invokeLater(() -> FrontendPortForwardingToolWindowManager.onPortForwardingEnabled$lambda$0$0$0(this$0));
        return Unit.INSTANCE;
    }

    private static final Unit onPortForwardingEnabled$lambda$0(FrontendPortForwardingToolWindowManager this$0, Lifetime it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.addPanelToToolWindow();
        it.onTermination(() -> FrontendPortForwardingToolWindowManager.onPortForwardingEnabled$lambda$0$0(this$0));
        return Unit.INSTANCE;
    }

    private static final JBScrollPane myScrollPane_delegate$lambda$0(FrontendPortForwardingToolWindowManager this$0) {
        PortForwardingModel model = PortForwardingModel_GeneratedKt.getPortForwardingModel((IProtocol)FrontendSessionsUtilKt.getProtocol((ClientAppSession)SessionUtilKt.getFrontendAppSession()));
        return new JBScrollPane((Component)((Object)new MyTable(new ThinClientPortForwardingTableModel(model, this$0.getServiceLifetime()))));
    }

    private static final JComponent myComponent_delegate$lambda$0(FrontendPortForwardingToolWindowManager this$0) {
        return this$0.getMyScrollPane();
    }

    public static final /* synthetic */ void access$onPortForwardingEnabled(FrontendPortForwardingToolWindowManager $this, Lifetime enabledLifetime) {
        $this.onPortForwardingEnabled(enabledLifetime);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/cwm/frontend/portForwarding/FrontendPortForwardingToolWindowManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/cwm/frontend/portForwarding/FrontendPortForwardingToolWindowManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.cwm.frontend"})
    @SourceDebugExtension(value={"SMAP\nFrontendPortForwardingToolWindowManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendPortForwardingToolWindowManager.kt\ncom/intellij/cwm/frontend/portForwarding/FrontendPortForwardingToolWindowManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,166:1\n30#2,2:167\n*S KotlinDebug\n*F\n+ 1 FrontendPortForwardingToolWindowManager.kt\ncom/intellij/cwm/frontend/portForwarding/FrontendPortForwardingToolWindowManager$Companion\n*L\n33#1:167,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrontendPortForwardingToolWindowManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<PortForwardingToolWindowManager> serviceClass$iv = PortForwardingToolWindowManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.cwm.frontend.portForwarding.FrontendPortForwardingToolWindowManager");
            return (FrontendPortForwardingToolWindowManager)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/cwm/frontend/portForwarding/FrontendPortForwardingToolWindowManager$MyTable;", "Lcom/intellij/ui/table/JBTable;", "model_", "Lcom/intellij/cwm/frontend/portForwarding/FrontendPortForwardingToolWindowManager$ThinClientPortForwardingTableModel;", "<init>", "(Lcom/intellij/cwm/frontend/portForwarding/FrontendPortForwardingToolWindowManager$ThinClientPortForwardingTableModel;)V", "getColumnName", "", "column", "", "intellij.cwm.frontend"})
    public static final class MyTable
    extends JBTable {
        public MyTable(@NotNull ThinClientPortForwardingTableModel model_) {
            Intrinsics.checkNotNullParameter((Object)model_, (String)"model_");
            this.setModel(model_);
            this.setShowColumns(true);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e == null) {
                        return;
                    }
                    int col = this.columnAtPoint(e.getPoint());
                    if (col == 3) {
                        int row = this.rowAtPoint(e.getPoint());
                        Object object = this.getModel().getValueAt(row, col);
                        String string = object instanceof String ? (String)object : null;
                        if (string == null) {
                            return;
                        }
                        String value = string;
                        if (StringsKt.startsWith$default((String)value, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value, (String)"https://", (boolean)false, (int)2, null)) {
                            BrowserUtil.browse((String)value);
                        }
                    }
                }
            });
        }

        @NotNull
        public String getColumnName(int column) {
            String string = this.getModel().getColumnName(column);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getColumnName(...)");
            return string;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/cwm/frontend/portForwarding/FrontendPortForwardingToolWindowManager$PortForwardingClientSessionListener;", "Lcom/jetbrains/rdclient/connection/ClientSessionListener;", "<init>", "()V", "projectSessionInitialized", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "intellij.cwm.frontend"})
    public static final class PortForwardingClientSessionListener
    implements ClientSessionListener {
        public void projectSessionInitialized(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Project project = session.getProject();
            FrontendPortForwardingToolWindowManager manager = Companion.getInstance(project);
            BoolPropertyExKt.whenTrue((IViewable)((IViewable)ThinClientPortForwardingManager.Companion.getInstance(session.getAppSession()).getPortForwardingEnabled()), (Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)), (Function1)((Function1)new Function1<Lifetime, Unit>((Object)manager){

                public final void invoke(Lifetime p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    FrontendPortForwardingToolWindowManager.access$onPortForwardingEnabled((FrontendPortForwardingToolWindowManager)((Object)this.receiver), p0);
                }
            }));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\b\u0010\u0013\u001a\u00020\rH\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/intellij/cwm/frontend/portForwarding/FrontendPortForwardingToolWindowManager$ThinClientPortForwardingTableModel;", "Ljavax/swing/table/AbstractTableModel;", "model", "Lcom/jetbrains/codeWithMe/model/PortForwardingModel;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/jetbrains/codeWithMe/model/PortForwardingModel;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getModel", "()Lcom/jetbrains/codeWithMe/model/PortForwardingModel;", "getColumnName", "", "column", "", "isCellEditable", "", "rowIndex", "columnIndex", "getRowCount", "getColumnCount", "getValueAt", "", "intellij.cwm.frontend"})
    public static final class ThinClientPortForwardingTableModel
    extends AbstractTableModel {
        @NotNull
        private final PortForwardingModel model;

        public ThinClientPortForwardingTableModel(@NotNull PortForwardingModel model, @NotNull Lifetime lifetime) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            this.model = model;
            this.model.getPorts().view(lifetime, (arg_0, arg_1, arg_2) -> ThinClientPortForwardingTableModel._init_$lambda$0(this, arg_0, arg_1, arg_2));
        }

        @NotNull
        public final PortForwardingModel getModel() {
            return this.model;
        }

        @Override
        @NotNull
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return CodeWithMeFrontendBundle.INSTANCE.message("portForwarding.tableHeader.hostPort", new Object[0]);
                }
                case 1: {
                    return CodeWithMeFrontendBundle.INSTANCE.message("portForwarding.tableHeader.localPort", new Object[0]);
                }
                case 2: {
                    return CodeWithMeFrontendBundle.INSTANCE.message("portForwarding.tableHeader.portType", new Object[0]);
                }
                case 3: {
                    return CodeWithMeFrontendBundle.INSTANCE.message("portForwarding.tableHeader.url", new Object[0]);
                }
            }
            throw new IllegalStateException("column index must be 0, 1, 2 or 3".toString());
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public int getRowCount() {
            return this.model.getPorts().size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        @Nullable
        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                return switch (columnIndex) {
                    case 0 -> ((RdForwardedPort)this.model.getPorts().get(rowIndex)).getPortNumber();
                    case 1 -> {
                        RdPortState rdPortState = (RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)((RdForwardedPort)this.model.getPorts().get(rowIndex)).getRdPortState()));
                        switch (WhenMappings.$EnumSwitchMapping$0[rdPortState.getSocketState().ordinal()]) {
                            case 1: {
                                yield "Not assigned yet";
                            }
                            case 2: {
                                RdSocketAddress v1 = rdPortState.getSocketAddress();
                                Intrinsics.checkNotNull((Object)v1);
                                yield v1.getPort();
                            }
                            case 3: {
                                yield "Failed to assign (" + rdPortState.getFailedReason() + ")";
                            }
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    case 2 -> {
                        switch (WhenMappings.$EnumSwitchMapping$1[((RdForwardedPort)this.model.getPorts().get(rowIndex)).getType().ordinal()]) {
                            case 1: {
                                yield "Local TCP";
                            }
                            case 2: {
                                yield "TCP (auto)";
                            }
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    case 3 -> {
                        RdForwardedPort rdPort = (RdForwardedPort)this.model.getPorts().get(rowIndex);
                        RdPortState rdPortState = (RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)rdPort.getRdPortState()));
                        switch (WhenMappings.$EnumSwitchMapping$0[rdPortState.getSocketState().ordinal()]) {
                            case 1: {
                                yield "Not assigned yet";
                            }
                            case 2: {
                                switch (WhenMappings.$EnumSwitchMapping$1[rdPort.getType().ordinal()]) {
                                    case 1: 
                                    case 2: {
                                        break;
                                    }
                                    default: {
                                        throw new NoWhenBranchMatchedException();
                                    }
                                }
                                String protocolName = "tcp";
                                RdSocketAddress v2 = rdPortState.getSocketAddress();
                                Intrinsics.checkNotNull((Object)v2);
                                String v3 = v2.getNetworkInterface();
                                RdSocketAddress v4 = rdPortState.getSocketAddress();
                                Intrinsics.checkNotNull((Object)v4);
                                yield protocolName + "://" + v3 + ":" + v4.getPort();
                            }
                            case 3: {
                                yield "Failed to assign (" + rdPortState.getFailedReason() + ")";
                            }
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    default -> throw new IllegalStateException("column index must be 0, 1, 2 or 3".toString());
                };
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }

        private static final Unit lambda$0$0(ThinClientPortForwardingTableModel this$0, RdPortState it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.fireTableDataChanged();
            return Unit.INSTANCE;
        }

        private static final Unit lambda$0$1(ThinClientPortForwardingTableModel this$0) {
            this$0.fireTableDataChanged();
            return Unit.INSTANCE;
        }

        private static final Unit lambda$0$2(ThinClientPortForwardingTableModel this$0) {
            this$0.fireTableDataChanged();
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$0(ThinClientPortForwardingTableModel this$0, Lifetime lt, int ind, RdForwardedPort rdPort) {
            Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
            Intrinsics.checkNotNullParameter((Object)rdPort, (String)"rdPort");
            rdPort.getRdPortState().advise(lt, arg_0 -> ThinClientPortForwardingTableModel.lambda$0$0(this$0, arg_0));
            lt.bracketIfAlive(() -> ThinClientPortForwardingTableModel.lambda$0$1(this$0), () -> ThinClientPortForwardingTableModel.lambda$0$2(this$0));
            return Unit.INSTANCE;
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[SocketState.values().length];
                try {
                    nArray[SocketState.NOT_INITIALIZED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SocketState.LISTENING.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SocketState.FAILED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[RdPortType.values().length];
                try {
                    nArray[RdPortType.TCP.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RdPortType.NON_USER_TCP.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

