/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.frontend.ui;

import com.intellij.cwm.frontend.ui.HostUnderModalityExtListenerKt;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.messages.MessageDialog;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.Alarm;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.ide.model.HostModality;
import com.jetbrains.rd.ide.model.HostModalityStateModel;
import com.jetbrains.rd.platform.codeWithMe.PlatformSplitBundle;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.protocol.ModalUiUtilsKt;
import com.jetbrains.thinclient.PlatformFrontendSplitBundle;
import com.jetbrains.thinclient.SessionUtilKt;
import java.awt.Component;
import java.awt.Container;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JRootPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\"\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0002J\"\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0002J*\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/cwm/frontend/ui/HostUnderModalityExtListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rd/ide/model/HostModalityStateModel;", "<init>", "()V", "delayMs", "", "showing", "", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "showDialogIfAppActive", "modalityLifetime", "project", "Lcom/intellij/openapi/project/Project;", "message", "", "showModalDialog", "showDialogAndCheck", "rootPane", "Ljavax/swing/JRootPane;", "intellij.cwm.frontend"})
@SourceDebugExtension(value={"SMAP\nHostUnderModalityExtListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HostUnderModalityExtListener.kt\ncom/intellij/cwm/frontend/ui/HostUnderModalityExtListener\n+ 2 Reenterability.kt\ncom/jetbrains/rd/platform/util/ReenterabilityKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,140:1\n19#2,9:141\n60#3,5:150\n*S KotlinDebug\n*F\n+ 1 HostUnderModalityExtListener.kt\ncom/intellij/cwm/frontend/ui/HostUnderModalityExtListener\n*L\n114#1:141,9\n90#1:150,5\n*E\n"})
public final class HostUnderModalityExtListener
implements SolutionExtListener<HostModalityStateModel> {
    private final int delayMs;
    private boolean showing;

    public HostUnderModalityExtListener() {
        this.delayMs = 1000;
    }

    public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull HostModalityStateModel model) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
        InterfacesKt.viewNotNull((IViewable)((IViewable)model.getHostUnderModality()), (Lifetime)lifetime, (arg_0, arg_1) -> HostUnderModalityExtListener.extensionCreated$lambda$0(alarm, this, session, arg_0, arg_1));
    }

    private final void showDialogIfAppActive(Lifetime modalityLifetime, Project project, @NlsContexts.DialogMessage String message) {
        if (RLifetimeKt.isNotAlive((Lifetime)modalityLifetime)) {
            return;
        }
        if (ApplicationKt.getApplication().isActive()) {
            this.showModalDialog(modalityLifetime, project, message);
        } else {
            MessageBusConnection connection = ApplicationKt.getApplication().getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)modalityLifetime, null, (int)1, null));
            Topic topic = ApplicationActivationListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            connection.subscribe(topic, (Object)new ApplicationActivationListener(this, modalityLifetime, project, message){
                final /* synthetic */ HostUnderModalityExtListener this$0;
                final /* synthetic */ Lifetime $modalityLifetime;
                final /* synthetic */ Project $project;
                final /* synthetic */ String $message;
                {
                    this.this$0 = $receiver;
                    this.$modalityLifetime = $modalityLifetime;
                    this.$project = $project;
                    this.$message = $message;
                }

                public void applicationActivated(IdeFrame ideFrame) {
                    Intrinsics.checkNotNullParameter((Object)ideFrame, (String)"ideFrame");
                    HostUnderModalityExtListener.access$showModalDialog(this.this$0, this.$modalityLifetime, this.$project, this.$message);
                }
            });
        }
    }

    private final void showModalDialog(Lifetime modalityLifetime, Project project, @NlsContexts.DialogMessage String message) {
        Container container = WindowManager.getInstance().getFrame(project);
        if (container == null || (container = container.getRootPane()) == null) {
            return;
        }
        Container rootPane = container;
        FrontendSessionsUtilKt.isConnected((ClientAppSession)SessionUtilKt.getFrontendAppSession()).view(modalityLifetime, (arg_0, arg_1) -> HostUnderModalityExtListener.showModalDialog$lambda$0(this, project, message, (JRootPane)rootPane, arg_0, arg_1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void showDialogAndCheck(Lifetime lifetime, Project project, @NlsContexts.DialogMessage String message, JRootPane rootPane) {
        if (RLifetimeKt.isNotAlive((Lifetime)lifetime) || this.showing) {
            return;
        }
        AtomicReference<Object> dialog = new AtomicReference<Object>(null);
        lifetime.onTermination(() -> HostUnderModalityExtListener.showDialogAndCheck$lambda$0(dialog));
        boolean continueShowing = false;
        continueShowing = true;
        while (RLifetimeKt.isAlive((Lifetime)lifetime) && continueShowing) {
            MessageDialog messageDialog;
            MessageDialog $this$showDialogAndCheck_u24lambda_u241 = messageDialog = new MessageDialog(project, message, PlatformSplitBundle.INSTANCE.message("product.name", new Object[0]), new String[0], -1, null, false);
            boolean bl = false;
            $this$showDialogAndCheck_u24lambda_u241.setModal(true);
            MessageDialog dialogToShow = messageDialog;
            dialog.set(dialogToShow);
            KMutableProperty0 flag$iv = (KMutableProperty0)new MutablePropertyReference0Impl(this){

                public Object get() {
                    return HostUnderModalityExtListener.access$getShowing$p((HostUnderModalityExtListener)this.receiver);
                }

                public void set(Object value) {
                    HostUnderModalityExtListener.access$setShowing$p((HostUnderModalityExtListener)this.receiver, (Boolean)value);
                }
            };
            boolean $i$f$noReenter = false;
            if (((Boolean)flag$iv.get()).booleanValue()) continue;
            flag$iv.set((Object)true);
            try {
                boolean bl2 = false;
                ModalUiUtilsKt.showProtocolBasedDialog((DialogWrapper)((DialogWrapper)dialogToShow));
                if (RLifetimeKt.isNotAlive((Lifetime)lifetime)) {
                    continueShowing = false;
                    continue;
                }
                boolean disconnect = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(PlatformSplitBundle.INSTANCE.message("product.name", new Object[0]), PlatformFrontendSplitBundle.INSTANCE.message("message.disconnect.from.host", new Object[0])).yesText(PlatformFrontendSplitBundle.INSTANCE.message("message.disconnect.from.host.disconnect", new Object[0]))).noText(PlatformFrontendSplitBundle.INSTANCE.message("message.disconnect.from.host.wait", new Object[0]))).ask((Component)rootPane);
                if (!disconnect) continue;
                ProjectManagerEx it = ProjectManagerEx.Companion.getInstanceEx();
                boolean bl3 = false;
                if (!it.closeAndDispose(project)) {
                    it.forceCloseProject(project);
                }
                ApplicationKt.getApplication().invokeLater(HostUnderModalityExtListener::showDialogAndCheck$lambda$2$1);
            }
            finally {
                flag$iv.set((Object)false);
            }
        }
    }

    private static final void extensionCreated$lambda$0$0(HostUnderModalityExtListener this$0, Lifetime $modalityLifetime, ClientProjectSession $session, HostModality $underModality) {
        this$0.showDialogIfAppActive($modalityLifetime, $session.getProject(), $underModality.getMessage());
    }

    private static final Unit extensionCreated$lambda$0(Alarm $alarm, HostUnderModalityExtListener this$0, ClientProjectSession $session, Lifetime modalityLifetime, HostModality underModality) {
        Intrinsics.checkNotNullParameter((Object)modalityLifetime, (String)"modalityLifetime");
        Intrinsics.checkNotNullParameter((Object)underModality, (String)"underModality");
        $alarm.cancelAllRequests();
        $alarm.addRequest(() -> HostUnderModalityExtListener.extensionCreated$lambda$0$0(this$0, modalityLifetime, $session, underModality), this$0.delayMs);
        return Unit.INSTANCE;
    }

    private static final void showModalDialog$lambda$0$0(HostUnderModalityExtListener this$0, Lifetime $connectedValueLifetime, Project $project, String $message, JRootPane $rootPane) {
        this$0.showDialogAndCheck($connectedValueLifetime, $project, $message, $rootPane);
    }

    private static final Unit showModalDialog$lambda$0(HostUnderModalityExtListener this$0, Project $project, String $message, JRootPane $rootPane, Lifetime connectedValueLifetime, boolean isConnected) {
        Intrinsics.checkNotNullParameter((Object)connectedValueLifetime, (String)"connectedValueLifetime");
        if (!isConnected) {
            return Unit.INSTANCE;
        }
        ApplicationKt.getApplication().invokeLater(() -> HostUnderModalityExtListener.showModalDialog$lambda$0$0(this$0, connectedValueLifetime, $project, $message, $rootPane));
        return Unit.INSTANCE;
    }

    private static final void showDialogAndCheck$lambda$0$1(MessageDialog $dialogToTerminate) {
        $dialogToTerminate.close(1);
    }

    private static final void showDialogAndCheck$lambda$2$1() {
        ApplicationKt.getApplication().exit(true, true, false);
    }

    private static final Unit showDialogAndCheck$lambda$0(AtomicReference $dialog) {
        MessageDialog messageDialog = (MessageDialog)$dialog.get();
        if (messageDialog == null) {
            return Unit.INSTANCE;
        }
        MessageDialog dialogToTerminate = messageDialog;
        if (dialogToTerminate.isShowing()) {
            Logger $this$debug_u24default$iv = HostUnderModalityExtListenerKt.access$getLogger$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Client Modality. Close dialog: " + dialogToTerminate.getTitle(), t$iv);
            }
            UIUtil.invokeLaterIfNeeded(() -> HostUnderModalityExtListener.showDialogAndCheck$lambda$0$1(dialogToTerminate));
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$showModalDialog(HostUnderModalityExtListener $this, Lifetime modalityLifetime, Project project, String message) {
        $this.showModalDialog(modalityLifetime, project, message);
    }

    public static final /* synthetic */ boolean access$getShowing$p(HostUnderModalityExtListener $this) {
        return $this.showing;
    }

    public static final /* synthetic */ void access$setShowing$p(HostUnderModalityExtListener $this, boolean bl) {
        $this.showing = bl;
    }
}

