/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.sqlite.model.SqliteCheck;
import com.intellij.database.dialects.sqlite.model.SqliteCollation;
import com.intellij.database.dialects.sqlite.model.SqliteIndex;
import com.intellij.database.dialects.sqlite.model.SqliteKey;
import com.intellij.database.dialects.sqlite.model.SqliteRoot;
import com.intellij.database.dialects.sqlite.model.SqliteTable;
import com.intellij.database.dialects.sqlite.model.SqliteTableColumn;
import com.intellij.database.dialects.sqlite.model.SqliteTrigger;
import com.intellij.database.dialects.sqlite.model.SqliteVirtualTable;
import com.intellij.database.dialects.sqlite.model.properties.SqliteOnConflictAlgorithm;
import com.intellij.database.dialects.sqlite.sql.SqliteTypes;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModLikeCheck;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicModTypedElement;
import com.intellij.database.model.basic.BasicModView;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.ColumnKind;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.sql.psi.SqlWhenClause;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.sql.psi.impl.SqlConditionDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import com.intellij.sql.psi.stubs.elementStubs.SqlDefinitionStub;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J \u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020 H\u0002J \u0010!\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\"2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010#\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020$2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010%\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020&2\u0006\u0010\b\u001a\u00020'2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010(\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020)2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010*\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020+2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010,\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020.H\u0002J \u0010/\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u0001002\n\u00102\u001a\u0006\u0012\u0002\b\u000303H\u0002J1\u00104\u001a\u0004\u0018\u0001H5\"\b\b\u0000\u00105*\u0002062\b\u00101\u001a\u0004\u0018\u0001002\f\u00102\u001a\b\u0012\u0004\u0012\u0002H503H\u0002\u00a2\u0006\u0002\u00107J\u0018\u00108\u001a\n\u0012\u0004\u0012\u000200\u0018\u0001092\u0006\u0010:\u001a\u00020;H\u0002J\u0012\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010>\u001a\u00020?H\u0002J\u0012\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010>\u001a\u00020?H\u0002J\u0014\u0010B\u001a\u0004\u0018\u00010;2\b\u0010:\u001a\u0004\u0018\u00010;H\u0002J\u0014\u0010C\u001a\u0004\u0018\u00010D2\b\u0010\u0012\u001a\u0004\u0018\u00010;H\u0002\u00a8\u0006E"}, d2={"Lcom/intellij/database/dialects/sqlite/SqliteObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "<init>", "()V", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/database/model/SqlObjectBuilder$Context;", "getCompactDefinition", "Lcom/intellij/openapi/util/TextRange;", "path", "Lcom/intellij/database/util/ObjectPath;", "text", "Lcom/intellij/database/model/properties/CompositeText;", "def", "Lcom/intellij/database/model/PsiObject;", "buildTable", "Lcom/intellij/database/dialects/sqlite/model/SqliteTable;", "buildViewSource", "Lcom/intellij/database/model/basic/BasicModView;", "buildCheck", "Lcom/intellij/database/model/basic/BasicModLikeCheck;", "buildCheckFromConstraintDefinition", "Lcom/intellij/database/dialects/sqlite/model/SqliteCheck;", "buildColumn", "Lcom/intellij/database/dialects/sqlite/model/SqliteTableColumn;", "isIdentity", "", "Lcom/intellij/sql/psi/SqlColumnDefinition;", "buildVirtualTable", "Lcom/intellij/database/dialects/sqlite/model/SqliteVirtualTable;", "buildKey", "Lcom/intellij/database/model/basic/BasicModKey;", "buildKeyFromTableKeyDefinition", "Lcom/intellij/database/dialects/sqlite/model/SqliteKey;", "Lcom/intellij/sql/psi/SqlTableKeyDefinition;", "buildTrigger", "Lcom/intellij/database/model/basic/BasicModTrigger;", "buildIndex", "Lcom/intellij/database/model/basic/BasicModIndex;", "isDesc", "expr", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "fixName", "", "name", "src", "Lcom/intellij/database/model/families/Family;", "findObject", "T", "Lcom/intellij/database/model/basic/BasicElement;", "(Ljava/lang/String;Lcom/intellij/database/model/families/Family;)Lcom/intellij/database/model/basic/BasicElement;", "getColumns", "", "el", "Lcom/intellij/psi/PsiElement;", "getEvent", "Lcom/intellij/database/model/TrigEvent;", "type", "Lcom/intellij/psi/tree/IElementType;", "getTurn", "Lcom/intellij/database/model/TrigTurn;", "skipUnsignificant", "getConflictResolution", "Lcom/intellij/database/dialects/sqlite/model/properties/SqliteOnConflictAlgorithm;", "intellij.database.dialects.sqlite"})
@SourceDebugExtension(value={"SMAP\nSqliteObjectBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqliteObjectBuilder.kt\ncom/intellij/database/dialects/sqlite/SqliteObjectBuilder\n+ 2 SqlObjectBuilderImpl.kt\ncom/intellij/database/dialects/base/SqlObjectBuilderImpl\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,346:1\n702#2,5:347\n691#2,10:352\n702#2,5:362\n702#2,5:367\n691#2,10:372\n721#2:383\n737#2,6:384\n702#2,5:390\n721#2:395\n737#2,6:396\n721#2:402\n737#2,6:403\n702#2,5:413\n702#2,5:418\n702#2,5:423\n1#3:382\n11705#4:409\n12052#4,3:410\n11705#4:430\n12052#4,3:431\n1401#4,2:434\n296#5,2:428\n*S KotlinDebug\n*F\n+ 1 SqliteObjectBuilder.kt\ncom/intellij/database/dialects/sqlite/SqliteObjectBuilder\n*L\n83#1:347,5\n90#1:352,10\n112#1:362,5\n123#1:367,5\n134#1:372,10\n168#1:383\n168#1:384,6\n177#1:390,5\n183#1:395\n183#1:396,6\n184#1:402\n184#1:403,6\n201#1:413,5\n211#1:418,5\n260#1:423,5\n186#1:409\n186#1:410,3\n317#1:430\n317#1:431,3\n342#1:434,2\n312#1:428,2\n*E\n"})
public final class SqliteObjectBuilder
extends SqlObjectBuilderImpl {
    public void build(@NotNull BasicModElement obj, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModElement basicModElement = obj;
        if (basicModElement instanceof SqliteTable) {
            this.buildTable((SqliteTable)obj, source, context);
        } else if (basicModElement instanceof SqliteTableColumn) {
            this.buildColumn((SqliteTableColumn)obj, source, context);
        } else if (basicModElement instanceof SqliteVirtualTable) {
            this.buildVirtualTable((SqliteVirtualTable)obj, source, context);
        } else if (basicModElement instanceof SqliteTrigger) {
            this.buildTrigger((BasicModTrigger)obj, source, context);
        } else {
            super.build(obj, source, context);
        }
    }

    @Nullable
    public TextRange getCompactDefinition(@NotNull ObjectPath path, @NotNull CompositeText text, @Nullable PsiObject def) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ObjectKind objectKind = path.kind;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW) ? this.getViewQueryRange(def) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TRIGGER) ? this.getTriggerBodyRange(def) : super.getCompactDefinition(path, text, def));
    }

    /*
     * WARNING - void declaration
     */
    private final void buildTable(SqliteTable obj, DasObject source, SqlObjectBuilder.Context context) {
        SqliteTable stubbed;
        BasicElement basicElement;
        if (!context.isIntrospector()) {
            this.buildBasicElement((BasicModElement)obj, source, context);
        }
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed2 = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof SqliteTable) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof SqliteTable)) {
                object = null;
            }
            basicElement = (BasicElement)((SqliteTable)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (SqliteTable)basicElement) != null) {
            obj.setWithoutRowId(stubbed.isWithoutRowId());
        } else {
            void this_$iv;
            boolean withoutRowId = false;
            boolean strict = false;
            SqlObjectBuilderImpl $i$f$stubbed2 = this;
            PsiElement el$iv = (PsiElement)(source instanceof SqlCreateTableStatement ? (SqlCreateTableStatement)source : null);
            boolean $i$f$forEachChild = false;
            void var10_14 = this_$iv;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                boolean bl = false;
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)it);
                if (Intrinsics.areEqual((Object)iElementType, (Object)SqliteTypes.SQLITE_WITHOUT_ROWID_CLAUSE)) {
                    withoutRowId = true;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)SqliteTypes.SQLITE_STRICT)) continue;
                strict = true;
            }
            obj.setWithoutRowId(withoutRowId);
            obj.setStrict(strict);
        }
    }

    protected void buildViewSource(@NotNull BasicModView obj, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.assignSources((BasicModSourceAware)obj, context, () -> SqliteObjectBuilder.buildViewSource$lambda$0(source, this));
    }

    protected void buildCheck(@NotNull BasicModLikeCheck obj, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(obj instanceof SqliteCheck)) {
            super.buildCheck(obj, source, context);
            return;
        }
        this.buildCheckFromConstraintDefinition((SqliteCheck)obj, source, context);
    }

    private final void buildCheckFromConstraintDefinition(SqliteCheck obj, DasObject source, SqlObjectBuilder.Context context) {
        SqliteCheck stubbed;
        BasicElement basicElement;
        if (!context.isIntrospector()) {
            super.buildCheck((BasicModLikeCheck)obj, source, context);
        }
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof SqliteCheck) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof SqliteCheck)) {
                object = null;
            }
            basicElement = (BasicElement)((SqliteCheck)object);
        } else {
            basicElement = null;
        }
        SqliteCheck sqliteCheck = stubbed = (SqliteCheck)basicElement;
        obj.setOnConflict(sqliteCheck != null ? sqliteCheck.getOnConflict() : this.getConflictResolution((PsiElement)(source instanceof SqlConditionDefinition ? (SqlConditionDefinition)source : null)));
    }

    /*
     * WARNING - void declaration
     */
    private final void buildColumn(SqliteTableColumn obj, DasObject source, SqlObjectBuilder.Context context) {
        String defaultExpression;
        block16: {
            Object object;
            SqliteTableColumn sqliteTableColumn;
            block18: {
                String collationName;
                block17: {
                    void it;
                    void it2;
                    void this_$iv;
                    Object object2;
                    DasObject dasObject;
                    block15: {
                        SqliteTableColumn stubbed;
                        BasicElement basicElement;
                        this.buildTypedType((BasicModTypedElement)obj, source, context);
                        if (!context.isIntrospector()) {
                            this.buildTypedNotNull((BasicModTypedElement)obj, source, context);
                            this.buildArranged((BasicModArrangedElement)obj, source, context);
                        }
                        defaultExpression = null;
                        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
                        DasObject $this$stubbed$iv = source;
                        boolean $i$f$stubbed = false;
                        dasObject = $this$stubbed$iv;
                        if (dasObject instanceof SqliteTableColumn) {
                            basicElement = (BasicElement)$this$stubbed$iv;
                        } else if (dasObject instanceof SqlStubbedElement) {
                            object2 = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
                            SqlDefinitionStub sqlDefinitionStub = object2 instanceof SqlDefinitionStub ? (SqlDefinitionStub)object2 : null;
                            Object object3 = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
                            if (!(object3 instanceof SqliteTableColumn)) {
                                object3 = null;
                            }
                            basicElement = (BasicElement)((SqliteTableColumn)object3);
                        } else {
                            basicElement = null;
                        }
                        if ((stubbed = (SqliteTableColumn)basicElement) == null) break block15;
                        obj.setCollationRef(stubbed.getCollationRef());
                        obj.setSequenceIdentity(stubbed.getSequenceIdentity());
                        obj.setColumnKind(stubbed.getColumnKind());
                        defaultExpression = stubbed.getDefaultExpression();
                        break block16;
                    }
                    collationName = null;
                    SqliteOnConflictAlgorithm conflictResolution = null;
                    ColumnKind columnKind = null;
                    columnKind = ColumnKind.NORMAL;
                    dasObject = this;
                    PsiElement el$iv = (PsiElement)(source instanceof SqlColumnDefinition ? (SqlColumnDefinition)source : null);
                    boolean $i$f$forEachChild22 = false;
                    void var12_14 = this_$iv;
                    PsiElement psiElement = el$iv;
                    PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
                    boolean $i$f$forEachSibling = false;
                    for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                        PsiElement it3 = tmp$iv$iv;
                        boolean bl = false;
                        if (it3 instanceof LeafPsiElement) continue;
                        IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)it3);
                        if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_DEFAULT_CONSTRAINT_DEFINITION)) {
                            SqlExpression defExpression;
                            SqlConstraintDefinition sqlConstraintDefinition = it3 instanceof SqlConstraintDefinition ? (SqlConstraintDefinition)it3 : null;
                            SqlExpression sqlExpression = defExpression = sqlConstraintDefinition != null ? (SqlExpression)sqlConstraintDefinition.getConstraintParameter(SqlConstraintDefinition.EXPRESSION) : null;
                            defaultExpression = sqlExpression != null ? sqlExpression.getText() : null;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_COLLATE_CONSTRAINT_DEFINITION)) {
                            SqlExpression collationRef;
                            SqlConstraintDefinition sqlConstraintDefinition = it3 instanceof SqlConstraintDefinition ? (SqlConstraintDefinition)it3 : null;
                            SqlExpression sqlExpression = collationRef = sqlConstraintDefinition != null ? (SqlExpression)sqlConstraintDefinition.getConstraintParameter(SqlConstraintDefinition.EXPRESSION) : null;
                            collationName = sqlExpression != null ? sqlExpression.getText() : null;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_NULLABLE_CONSTRAINT_DEFINITION)) {
                            conflictResolution = this.getConflictResolution(it3);
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_CLAUSE)) continue;
                        boolean isStored = SqlImplUtil.getChildOfType((PsiElement)it3, (IElementType)SqliteTypes.SQLITE_STORED) != null;
                        columnKind = isStored ? ColumnKind.GENERATED_STORED : ColumnKind.GENERATED_VIRTUAL;
                        SqlExpression sqlExpression = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)it3, SqlExpression.class);
                        defaultExpression = sqlExpression != null ? sqlExpression.getText() : null;
                    }
                    if (StringsKt.equals((String)"binary", collationName, (boolean)true)) {
                        collationName = null;
                    }
                    obj.setColumnKind(columnKind);
                    obj.setOnNullConflict(conflictResolution);
                    Object $i$f$forEachChild22 = object2 = obj;
                    SqliteTableColumn sqliteTableColumn2 = obj;
                    boolean bl = false;
                    boolean bl2 = it2 instanceof BasicDataObject;
                    sqliteTableColumn = sqliteTableColumn2;
                    object = !bl2 ? object2 : null;
                    if (object == null || (object = (BasicModModel)object.getModel()) == null) break block17;
                    first$iv$iv = object;
                    sqliteTableColumn2 = sqliteTableColumn;
                    boolean bl3 = false;
                    BasicRoot basicRoot = it.getRoot();
                    Intrinsics.checkNotNull((Object)basicRoot, (String)"null cannot be cast to non-null type com.intellij.database.dialects.sqlite.model.SqliteRoot");
                    ModNamingFamily<? extends SqliteCollation> modNamingFamily = ((SqliteRoot)basicRoot).getCollations();
                    Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getCollations(...)");
                    String string = this.fixName(collationName, (Family)modNamingFamily);
                    sqliteTableColumn = sqliteTableColumn2;
                    object = string;
                    if (string != null) break block18;
                }
                object = collationName;
            }
            sqliteTableColumn.setCollationRef((BasicReference)BasicNameReference.create((String)object));
            obj.setSequenceIdentity(source instanceof SqlColumnDefinition && this.isIdentity((SqlColumnDefinition)source) ? SequenceIdentity.UNKNOWN : null);
        }
        if (!context.isIntrospector() || obj.getColumnKind() != ColumnKind.NORMAL) {
            obj.setDefaultExpression(defaultExpression);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isIdentity(SqlColumnDefinition obj) {
        List refs;
        SqlReferenceList refList;
        PsiElement psiElement;
        block7: {
            void el$iv;
            void this_$iv;
            PsiElement psiElement2;
            PsiElement this_$iv2;
            block6: {
                PsiElement psiElement3 = (PsiElement)obj;
                SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE;
                Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE");
                if (this.findChild(psiElement3, (IElementType)sqlCompositeElementType) != null) {
                    return true;
                }
                SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
                SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this;
                PsiElement el$iv2 = obj.getParent();
                boolean $i$f$findChild2 = false;
                void var7_8 = this_$iv2;
                PsiElement psiElement4 = el$iv2;
                PsiElement element$iv$iv = psiElement4 != null ? psiElement4.getFirstChild() : null;
                boolean $i$f$findSibling = false;
                for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    PsiElement it$iv = tmp$iv$iv;
                    boolean bl = false;
                    if (!(it$iv instanceof SqlTableKeyDefinition)) continue;
                    psiElement2 = tmp$iv$iv;
                    break block6;
                }
                psiElement2 = null;
            }
            this_$iv2 = (PsiElement)((SqlTableKeyDefinition)psiElement2);
            boolean $i$f$findChild = false;
            void $i$f$findChild2 = this_$iv;
            void v4 = el$iv;
            PsiElement element$iv$iv = v4 != null ? v4.getFirstChild() : null;
            boolean $i$f$findSibling = false;
            for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it$iv = tmp$iv$iv;
                boolean bl = false;
                if (!(it$iv instanceof SqlReferenceList)) continue;
                psiElement = tmp$iv$iv;
                break block7;
            }
            psiElement = null;
        }
        SqlReferenceList sqlReferenceList = refList = (SqlReferenceList)psiElement;
        List list = refs = sqlReferenceList != null ? sqlReferenceList.getReferenceList() : null;
        if (refs == null || refs.size() != 1) {
            return false;
        }
        PsiElement psiElement5 = (PsiElement)refs.get(0);
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE");
        if (this.findSibling(psiElement5, (IElementType)sqlCompositeElementType) == null) {
            return false;
        }
        Object e = refs.get(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        String string = this.extractName((PsiElement)e);
        if (string == null) {
            string = "";
        }
        return StringsKt.equals((String)string, (String)obj.getName(), (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildVirtualTable(SqliteVirtualTable obj, DasObject source, SqlObjectBuilder.Context context) {
        SqliteVirtualTable stubbed;
        StubElement stubElement;
        BasicElement basicElement;
        if (!context.isIntrospector()) {
            this.buildNamedElement((BasicModNamedElement)obj, source, context);
        }
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof SqliteVirtualTable) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof SqliteVirtualTable)) {
                object = null;
            }
            basicElement = (BasicElement)((SqliteVirtualTable)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (SqliteVirtualTable)basicElement) != null) {
            obj.setArguments(stubbed.getArguments());
            obj.setModuleRef(stubbed.getModuleRef());
        } else {
            List list;
            PsiElement psiElement;
            PsiElement element$iv$iv;
            SqlClause moduleClause;
            block14: {
                void this_$iv;
                PsiElement psiElement2;
                PsiElement element$iv$iv2;
                PsiElement el$iv;
                block13: {
                    void this_$iv2;
                    $this$stubbed$iv = this;
                    el$iv = (PsiElement)(source instanceof SqlCreateStatement ? (SqlCreateStatement)source : null);
                    boolean $i$f$findChild = false;
                    stubElement = this_$iv2;
                    PsiElement psiElement3 = el$iv;
                    element$iv$iv2 = psiElement3 != null ? psiElement3.getFirstChild() : null;
                    boolean $i$f$findSibling = false;
                    for (PsiElement tmp$iv$iv = element$iv$iv2; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                        PsiElement it$iv = tmp$iv$iv;
                        boolean bl = false;
                        if (!(it$iv instanceof SqlClause)) continue;
                        psiElement2 = tmp$iv$iv;
                        break block13;
                    }
                    psiElement2 = null;
                }
                moduleClause = (SqlClause)psiElement2;
                el$iv = this;
                PsiElement el$iv2 = (PsiElement)moduleClause;
                boolean $i$f$findChild = false;
                element$iv$iv2 = this_$iv;
                PsiElement psiElement4 = el$iv2;
                element$iv$iv = psiElement4 != null ? psiElement4.getFirstChild() : null;
                boolean $i$f$findSibling = false;
                for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    PsiElement it$iv = tmp$iv$iv;
                    boolean bl = false;
                    if (!(it$iv instanceof SqlReferenceExpression)) continue;
                    psiElement = tmp$iv$iv;
                    break block14;
                }
                psiElement = null;
            }
            SqlReferenceExpression moduleRef = (SqlReferenceExpression)psiElement;
            SqlClause[] moduleArguments = (SqlClause[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)moduleClause), SqlClause.class);
            SqliteVirtualTable sqliteVirtualTable = obj;
            if (moduleArguments != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                SqlClause[] $i$f$findChild = moduleArguments;
                SqliteVirtualTable sqliteVirtualTable2 = sqliteVirtualTable;
                boolean $i$f$map = false;
                element$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var17_30 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getText());
                }
                list = (List)destination$iv$iv;
                sqliteVirtualTable = sqliteVirtualTable2;
            } else {
                list = CollectionsKt.emptyList();
            }
            sqliteVirtualTable.setArguments(list);
            SqlReferenceExpression sqlReferenceExpression = moduleRef;
            obj.setModuleRef((BasicReference)BasicNameReference.create((String)(sqlReferenceExpression != null ? sqlReferenceExpression.getName() : null)));
        }
    }

    protected void buildKey(@NotNull BasicModKey obj, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(source instanceof SqlTableKeyDefinition) || !(obj instanceof SqliteKey)) {
            super.buildKey(obj, source, context);
            return;
        }
        this.buildKeyFromTableKeyDefinition((SqliteKey)obj, (SqlTableKeyDefinition)source, context);
    }

    private final void buildKeyFromTableKeyDefinition(SqliteKey obj, SqlTableKeyDefinition source, SqlObjectBuilder.Context context) {
        SqliteKey stubbed;
        BasicElement basicElement;
        if (!context.isIntrospector()) {
            this.buildBasicElement((BasicModElement)obj, (DasObject)source, context);
        }
        if (!context.isStubBuilder()) {
            obj.setPrimary(source.isPrimary());
        }
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = (DasObject)source;
        boolean $i$f$stubbed = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof SqliteKey) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof SqliteKey)) {
                object = null;
            }
            basicElement = (BasicElement)((SqliteKey)object);
        } else {
            basicElement = null;
        }
        SqliteKey sqliteKey = stubbed = (SqliteKey)basicElement;
        obj.setOnConflict(sqliteKey != null ? sqliteKey.getOnConflict() : this.getConflictResolution((PsiElement)source));
    }

    protected void buildTrigger(@NotNull BasicModTrigger obj, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        SqliteTrigger stubbed;
        BasicElement basicElement;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(obj instanceof SqliteTrigger)) {
            super.buildTrigger(obj, source, context);
            return;
        }
        if (!context.isIntrospector()) {
            this.buildBasicElement((BasicModElement)obj, source, context);
        }
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof SqliteTrigger) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof SqliteTrigger)) {
                object = null;
            }
            basicElement = (BasicElement)((SqliteTrigger)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (SqliteTrigger)basicElement) != null) {
            ((SqliteTrigger)obj).setColNames(stubbed.getColNames());
            ((SqliteTrigger)obj).setEvents(stubbed.getEvents());
            ((SqliteTrigger)obj).setTurn(stubbed.getTurn());
            ((SqliteTrigger)obj).setCondition(stubbed.getCondition());
        } else {
            SqlWhenClause whenClause;
            TrigTurn trigTurn;
            PsiElement element;
            SqlNameElement name2;
            TrigTurn turn = null;
            TrigEvent event = null;
            List<String> cols = null;
            SqlCreateTriggerStatement sqlCreateTriggerStatement = source instanceof SqlCreateTriggerStatement ? (SqlCreateTriggerStatement)source : null;
            SqlNameElement sqlNameElement = name2 = sqlCreateTriggerStatement != null ? sqlCreateTriggerStatement.getNameElement() : null;
            PsiElement afterName = this.skipUnsignificant((PsiElement)(sqlNameElement != null ? sqlNameElement.getNextSibling() : null));
            if (afterName instanceof SqlClause && (element = this.skipUnsignificant(((SqlClause)afterName).getFirstChild())) != null) {
                IElementType iElementType = element.getNode().getElementType();
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
                IElementType type = iElementType;
                event = this.getEvent(type);
                if (event == null) {
                    turn = this.getTurn(type);
                    PsiElement nextClause = this.skipUnsignificant(((SqlClause)afterName).getNextSibling());
                    if (nextClause instanceof SqlClause && (element = this.skipUnsignificant(((SqlClause)nextClause).getFirstChild())) != null) {
                        IElementType iElementType2 = element.getNode().getElementType();
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"getElementType(...)");
                        event = this.getEvent(iElementType2);
                        cols = this.getColumns(nextClause);
                    }
                } else {
                    cols = this.getColumns(afterName);
                }
            }
            if ((trigTurn = turn) == null) {
                trigTurn = TrigTurn.BEFORE_ROW;
            }
            turn = trigTurn;
            SqlWhenClause sqlWhenClause = whenClause = (SqlWhenClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)(source instanceof SqlCreateTriggerStatement ? (SqlCreateTriggerStatement)source : null)), SqlWhenClause.class);
            SqlExpression whenExpr = sqlWhenClause != null ? sqlWhenClause.getExpression() : null;
            SqlExpression sqlExpression = whenExpr;
            ((SqliteTrigger)obj).setCondition(sqlExpression != null ? sqlExpression.getText() : null);
            ((SqliteTrigger)obj).setTurn(turn);
            SqliteTrigger sqliteTrigger = (SqliteTrigger)obj;
            List<String> list = cols;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            sqliteTrigger.setColNames(list);
            TrigEvent trigEvent = event;
            ((SqliteTrigger)obj).setEvents(trigEvent == null ? SetsKt.emptySet() : SetsKt.setOf((Object)trigEvent));
        }
        this.assignSources((BasicModSourceAware)obj, context, () -> SqliteObjectBuilder.buildTrigger$lambda$0(source, this));
    }

    /*
     * WARNING - void declaration
     */
    protected void buildIndex(@NotNull BasicModIndex obj, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        block14: {
            SqlTableColumnsList columnsList;
            SqlReferenceExpression tableRef;
            SqliteIndex stubbed;
            BasicElement basicElement;
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!(obj instanceof SqliteIndex)) {
                super.buildIndex(obj, source, context);
                return;
            }
            if (!context.isIntrospector()) {
                this.buildNamedElement((BasicModNamedElement)obj, source, context);
            }
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
            DasObject $this$stubbed$iv = source;
            boolean $i$f$stubbed22 = false;
            DasObject dasObject = $this$stubbed$iv;
            if (dasObject instanceof SqliteIndex) {
                basicElement = (BasicElement)$this$stubbed$iv;
            } else if (dasObject instanceof SqlStubbedElement) {
                StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
                SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
                Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
                if (!(object instanceof SqliteIndex)) {
                    object = null;
                }
                basicElement = (BasicElement)((SqliteIndex)object);
            } else {
                basicElement = null;
            }
            if ((stubbed = (SqliteIndex)basicElement) != null) {
                ((SqliteIndex)obj).setCondition(stubbed.getCondition());
            } else {
                SqlWhereClause where = (SqlWhereClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)(source instanceof SqlCreateIndexStatement ? (SqlCreateIndexStatement)source : null)), SqlWhereClause.class);
                SqlExpression whereExpr = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)where), SqlExpression.class);
                SqlExpression sqlExpression = whereExpr;
                ((SqliteIndex)obj).setCondition(sqlExpression != null ? sqlExpression.getText() : null);
            }
            ((SqliteIndex)obj).setUnique(this.buildIndexUnique(source));
            if (context.isStubBuilder()) {
                return;
            }
            SqlCreateIndexStatement sqlCreateIndexStatement = source instanceof SqlCreateIndexStatement ? (SqlCreateIndexStatement)source : null;
            SqlReferenceExpression sqlReferenceExpression = tableRef = sqlCreateIndexStatement != null ? sqlCreateIndexStatement.getTargetReference() : null;
            PsiElement $i$f$stubbed22 = sqlReferenceExpression != null ? sqlReferenceExpression.getParent() : null;
            SqlTableColumnsList sqlTableColumnsList = columnsList = $i$f$stubbed22 instanceof SqlTableColumnsList ? (SqlTableColumnsList)$i$f$stubbed22 : null;
            Object columns = sqlTableColumnsList != null ? sqlTableColumnsList.getColumnsReferenceList() : null;
            SqlExpression[] columnExprs = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)columns), SqlExpression.class);
            if (columnExprs == null) break block14;
            ArrayList<Object> newNames = new ArrayList<Object>(columnExprs.length);
            LinkedHashSet newRev = new LinkedHashSet();
            for (SqlExpression expr : columnExprs) {
                boolean curRev;
                block18: {
                    block15: {
                        Object object;
                        ArrayList<Object> arrayList;
                        block17: {
                            block16: {
                                void it;
                                curRev = false;
                                if (!(expr instanceof SqlReferenceExpression)) break block15;
                                arrayList = newNames;
                                object = ((SqliteIndex)obj).getTable();
                                if (object == null || (object = object.getColumns()) == null) break block16;
                                ModPositioningNamingFamily<? extends SqliteTableColumn> modPositioningNamingFamily = object;
                                ArrayList<Object> arrayList2 = arrayList;
                                boolean bl = false;
                                String string = this.fixName(((SqlReferenceExpression)expr).getName(), (Family)it);
                                arrayList = arrayList2;
                                object = string;
                                if (string != null) break block17;
                            }
                            String string = ((SqlReferenceExpression)expr).getName();
                            object = string;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        }
                        arrayList.add(object);
                        curRev = this.isDesc((SqlReferenceExpression)expr);
                        break block18;
                    }
                    newNames.add(expr.getText());
                }
                if (!curRev) continue;
                newRev.add(newNames.get(newNames.size() - 1));
            }
            ((SqliteIndex)obj).setColNames(newNames);
            ((SqliteIndex)obj).setReverseColNames(newRev);
        }
    }

    private final boolean isDesc(SqlReferenceExpression expr) {
        for (PsiElement tmp = expr.getNextSibling(); tmp != null && !(tmp instanceof SqlExpression); tmp = tmp.getNextSibling()) {
            IElementType type = PsiTreeUtilKt.getElementType((PsiElement)tmp);
            if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_ASC)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_DESC)) continue;
            return true;
        }
        return false;
    }

    private final String fixName(String name2, Family<?> src) {
        Object object = this.findObject(name2, src);
        if (object == null || (object = ((DasNamed)object).getName()) == null) {
            object = name2;
        }
        return object;
    }

    private final <T extends BasicElement> T findObject(String name2, Family<T> src) {
        Object v0;
        block2: {
            if (name2 == null) {
                return null;
            }
            Iterable $this$firstOrNull$iv = (Iterable)src;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                BasicElement it = (BasicElement)element$iv;
                boolean bl = false;
                if (!StringsKt.equals((String)name2, (String)((DasNamed)it).getName(), (boolean)true)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return (T)((BasicElement)v0);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getColumns(PsiElement el) {
        List list;
        SqlReferenceExpression[] sqlReferenceExpressionArray = (SqlReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)el, SqlReferenceExpression.class);
        if (sqlReferenceExpressionArray != null) {
            void $this$mapTo$iv$iv;
            SqlReferenceExpression[] $this$map$iv = sqlReferenceExpressionArray;
            boolean $i$f$map = false;
            SqlReferenceExpression[] sqlReferenceExpressionArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    private final TrigEvent getEvent(IElementType type) {
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_INSERT)) {
            return TrigEvent.INSERT;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_DELETE)) {
            return TrigEvent.DELETE;
        }
        return Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_UPDATE) ? TrigEvent.UPDATE : null;
    }

    private final TrigTurn getTurn(IElementType type) {
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_BEFORE)) {
            return TrigTurn.BEFORE_ROW;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_AFTER)) {
            return TrigTurn.AFTER_ROW;
        }
        return Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_INSTEAD) ? TrigTurn.INSTEAD_OF : null;
    }

    private final PsiElement skipUnsignificant(PsiElement el) {
        PsiElement tmp = el;
        while (tmp instanceof PsiWhiteSpace || tmp instanceof PsiComment) {
            tmp = tmp.getNextSibling();
        }
        return tmp;
    }

    private final SqliteOnConflictAlgorithm getConflictResolution(PsiElement def) {
        SqliteOnConflictAlgorithm algo;
        block3: {
            SqliteOnConflictAlgorithm sqliteOnConflictAlgorithm;
            IElementType iElementType = SqliteTypes.SQLITE_CONFLICT_CLAUSE;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"SQLITE_CONFLICT_CLAUSE");
            PsiElement psiElement = this.findChild(def, iElementType);
            if (psiElement == null) {
                return null;
            }
            PsiElement onConflict = psiElement;
            PsiElement psiElement2 = PsiTreeUtil.getDeepestLast((PsiElement)onConflict);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getDeepestLast(...)");
            PsiElement how = psiElement2;
            String text = how.getText();
            SqliteOnConflictAlgorithm[] $this$firstOrNull$iv = SqliteOnConflictAlgorithm.values();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                SqliteOnConflictAlgorithm element$iv;
                SqliteOnConflictAlgorithm it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!StringsKt.equals((String)it.toString(), (String)text, (boolean)true)) continue;
                sqliteOnConflictAlgorithm = element$iv;
                break block3;
            }
            sqliteOnConflictAlgorithm = algo = null;
        }
        if (algo == SqliteOnConflictAlgorithm.ABORT) {
            return null;
        }
        return algo;
    }

    private static final CompositeText buildViewSource$lambda$0(DasObject $source, SqliteObjectBuilder this$0) {
        String string;
        SqlCreateViewStatement sqlCreateViewStatement = $source instanceof SqlCreateViewStatement ? (SqlCreateViewStatement)$source : null;
        return (CompositeText)(sqlCreateViewStatement != null && (string = this$0.wholeStatement((SqlTableDefinition)sqlCreateViewStatement)) != null ? SqlObjectBuilderImpl.asComposite$default((SqlObjectBuilderImpl)this$0, (String)string, null, (int)1, null) : null);
    }

    private static final CompositeText buildTrigger$lambda$0(DasObject $source, SqliteObjectBuilder this$0) {
        String string;
        SqlCreateTriggerStatement sqlCreateTriggerStatement = $source instanceof SqlCreateTriggerStatement ? (SqlCreateTriggerStatement)$source : null;
        return (CompositeText)(sqlCreateTriggerStatement != null && (string = sqlCreateTriggerStatement.getText()) != null ? SqlObjectBuilderImpl.asComposite$default((SqlObjectBuilderImpl)this$0, (String)string, null, (int)1, null) : null);
    }
}

