/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.xml;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageLoadErrorReporter;
import com.intellij.coverage.CoverageLoadingResult;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.xml.XMLReportEngine;
import com.intellij.coverage.xml.XMLReportRunnerKt;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.rt.coverage.report.XMLCoverageReport;
import com.intellij.rt.coverage.report.XMLProjectData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0012\u0010\f\u001a\f0\r\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/coverage/xml/XMLReportRunner;", "Lcom/intellij/coverage/CoverageRunner;", "<init>", "()V", "loadCoverageData", "Lcom/intellij/coverage/CoverageLoadingResult;", "sessionDataFile", "Ljava/io/File;", "baseCoverageSuite", "Lcom/intellij/coverage/CoverageSuite;", "reporter", "Lcom/intellij/coverage/CoverageLoadErrorReporter;", "getPresentableName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getId", "getDataFileExtension", "acceptsCoverageEngine", "", "engine", "Lcom/intellij/coverage/CoverageEngine;", "canBeLoaded", "candidate", "Lcom/intellij/rt/coverage/report/XMLProjectData;", "xmlFile", "intellij.java.coverage"})
public final class XMLReportRunner
extends CoverageRunner {
    @NotNull
    protected CoverageLoadingResult loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite, @NotNull CoverageLoadErrorReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)sessionDataFile, (String)"sessionDataFile");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        throw new IllegalStateException("Should not be called".toString());
    }

    @NotNull
    public String getPresentableName() {
        String string = JavaCoverageBundle.message("coverage.xml.report.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getId() {
        return "jacoco_xml_report";
    }

    @NotNull
    public String getDataFileExtension() {
        return "xml";
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        return engine instanceof XMLReportEngine;
    }

    public boolean canBeLoaded(@NotNull File candidate) {
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        return XMLCoverageReport.canReadFile((File)candidate);
    }

    @Nullable
    public final XMLProjectData loadCoverageData(@NotNull File xmlFile) {
        XMLProjectData xMLProjectData;
        Intrinsics.checkNotNullParameter((Object)xmlFile, (String)"xmlFile");
        try {
            xMLProjectData = new XMLCoverageReport().read((InputStream)new FileInputStream(xmlFile));
        }
        catch (IOException e) {
            XMLReportRunnerKt.access$getLOG$p().info((Throwable)e);
            xMLProjectData = null;
        }
        return xMLProjectData;
    }
}

