/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.ir.cfg;

import com.intellij.rml.dfa.impl.ir.cfg.IrBoolExprSimplifier;
import com.intellij.rml.dfa.impl.ir.cfg.IrCfgCombiner;
import com.intellij.rml.dfa.ir.ast.IrCondition;
import com.intellij.rml.dfa.ir.cfg.IrBoolExpr;
import com.intellij.rml.dfa.ir.cfg.IrBoolExprGraph;
import com.intellij.rml.dfa.ir.cfg.IrBoolExprProvider;
import com.intellij.rml.dfa.ir.cfg.IrCFGBlock;
import com.intellij.rml.dfa.ir.cfg.IrCfg;
import com.intellij.rml.dfa.ir.cfg.IrCfgBuilderKt;
import com.intellij.rml.dfa.ir.cfg.IrCfgRegionBuilder;
import com.intellij.rml.dfa.ir.cfg.IrConditionalJump;
import com.intellij.rml.dfa.ir.cfg.IrJump;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0002J4\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00028\u00002\u001f\b\u0002\u0010\u000e\u001a\u0019\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000f\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\u0010\u0014R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/rml/dfa/impl/ir/cfg/IrBoolExprSimplifier;", "T", "", "provider", "Lcom/intellij/rml/dfa/ir/cfg/IrBoolExprProvider;", "<init>", "(Lcom/intellij/rml/dfa/ir/cfg/IrBoolExprProvider;)V", "getProvider", "()Lcom/intellij/rml/dfa/ir/cfg/IrBoolExprProvider;", "simplifyBoolExpr", "Lcom/intellij/rml/dfa/ir/cfg/IrBoolExprGraph;", "boolExpr", "Lcom/intellij/rml/dfa/ir/cfg/IrBoolExpr;", "expr", "consumer", "Lkotlin/Function2;", "Lcom/intellij/rml/dfa/ir/cfg/IrCfgRegionBuilder;", "", "", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Lcom/intellij/rml/dfa/ir/cfg/IrBoolExprGraph;", "intellij.rml.dfa.impl"})
public final class IrBoolExprSimplifier<T> {
    @NotNull
    private final IrBoolExprProvider<T> provider;

    public IrBoolExprSimplifier(@NotNull IrBoolExprProvider<T> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        this.provider = provider;
    }

    @NotNull
    public final IrBoolExprProvider<T> getProvider() {
        return this.provider;
    }

    private final IrBoolExprGraph simplifyBoolExpr(IrBoolExpr<T> boolExpr) {
        IrBoolExpr<T> irBoolExpr = boolExpr;
        if (irBoolExpr instanceof IrBoolExpr.Not) {
            return this.simplifyBoolExpr(((IrBoolExpr.Not)boolExpr).getOperand()).invert();
        }
        if (irBoolExpr instanceof IrBoolExpr.And) {
            IrCfgCombiner builder = new IrCfgCombiner();
            IrBoolExprGraph leftOperandGraph = this.simplifyBoolExpr(((IrBoolExpr.And)boolExpr).getLeft());
            IrBoolExprGraph rightOperandGraph = this.simplifyBoolExpr(((IrBoolExpr.And)boolExpr).getRight());
            builder.addSubCfg(leftOperandGraph);
            builder.addSubCfg(rightOperandGraph);
            builder.setUnconditionalJump(leftOperandGraph.getTrueBranch(), rightOperandGraph.getConditionEnterNode());
            IrCFGBlock falseBranchMergeNode = builder.createBlock();
            builder.setUnconditionalJump(leftOperandGraph.getFalseBranch(), falseBranchMergeNode);
            builder.setUnconditionalJump(rightOperandGraph.getFalseBranch(), falseBranchMergeNode);
            return builder.build(leftOperandGraph.getConditionEnterNode(), rightOperandGraph.getTrueBranch(), falseBranchMergeNode);
        }
        if (irBoolExpr instanceof IrBoolExpr.Or) {
            IrCfgCombiner builder = new IrCfgCombiner();
            IrBoolExprGraph leftOperandGraph = this.simplifyBoolExpr(((IrBoolExpr.Or)boolExpr).getLeft());
            IrBoolExprGraph rightOperandGraph = this.simplifyBoolExpr(((IrBoolExpr.Or)boolExpr).getRight());
            builder.addSubCfg(leftOperandGraph);
            builder.addSubCfg(rightOperandGraph);
            builder.setUnconditionalJump(leftOperandGraph.getFalseBranch(), rightOperandGraph.getConditionEnterNode());
            IrCFGBlock trueBranchMergeNode = builder.createBlock();
            builder.setUnconditionalJump(leftOperandGraph.getTrueBranch(), trueBranchMergeNode);
            builder.setUnconditionalJump(rightOperandGraph.getTrueBranch(), trueBranchMergeNode);
            return builder.build(leftOperandGraph.getConditionEnterNode(), trueBranchMergeNode, rightOperandGraph.getFalseBranch());
        }
        if (irBoolExpr instanceof IrBoolExpr.Condition) {
            IrCfgRegionBuilder conditionBuilder = IrCfgRegionBuilder.Companion.invoke();
            IrCondition irCondition = this.provider.translate(((IrBoolExpr.Condition)boolExpr).getCondition(), conditionBuilder);
            IrCfg conditionCfg = conditionBuilder.build();
            IrCfgCombiner builder = new IrCfgCombiner();
            IrCFGBlock trueBranch = builder.createBlock();
            IrCFGBlock falseBranch = builder.createBlock();
            builder.addSubCfg(conditionCfg);
            builder.setJump(conditionCfg.getExitBlock(), (IrJump)new IrConditionalJump(irCondition, trueBranch, falseBranch));
            return builder.build(conditionCfg.getStartBlock(), trueBranch, falseBranch);
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public final IrBoolExprGraph simplifyBoolExpr(T expr, @NotNull Function2<? super IrCfgRegionBuilder, ? super Boolean, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        IrBoolExpr boolExpr = this.provider.parse(expr);
        IrBoolExprGraph boolExprGraph = this.simplifyBoolExpr(boolExpr);
        IrCfgCombiner builder = new IrCfgCombiner();
        builder.addSubCfg(boolExprGraph);
        IrCfg trueBranchCfg2 = IrCfgBuilderKt.buildCfgRegion((Function1)((Function1)new Function1<IrCfgRegionBuilder, Unit>(consumer){
            final /* synthetic */ Function2<IrCfgRegionBuilder, Boolean, Unit> $consumer;
            {
                this.$consumer = $consumer;
                super(1);
            }

            public final void invoke(IrCfgRegionBuilder $this$buildCfgRegion) {
                Intrinsics.checkNotNullParameter((Object)$this$buildCfgRegion, (String)"$this$buildCfgRegion");
                this.$consumer.invoke((Object)$this$buildCfgRegion, (Object)true);
            }
        }));
        IrCfg falseBranchCfg2 = IrCfgBuilderKt.buildCfgRegion((Function1)((Function1)new Function1<IrCfgRegionBuilder, Unit>(consumer){
            final /* synthetic */ Function2<IrCfgRegionBuilder, Boolean, Unit> $consumer;
            {
                this.$consumer = $consumer;
                super(1);
            }

            public final void invoke(IrCfgRegionBuilder $this$buildCfgRegion) {
                Intrinsics.checkNotNullParameter((Object)$this$buildCfgRegion, (String)"$this$buildCfgRegion");
                this.$consumer.invoke((Object)$this$buildCfgRegion, (Object)false);
            }
        }));
        builder.addSubCfg(trueBranchCfg2);
        builder.addSubCfg(falseBranchCfg2);
        builder.setUnconditionalJump(boolExprGraph.getTrueBranch(), trueBranchCfg2.getStartBlock());
        builder.setUnconditionalJump(boolExprGraph.getFalseBranch(), falseBranchCfg2.getStartBlock());
        return builder.build(boolExprGraph.getConditionEnterNode(), trueBranchCfg2.getExitBlock(), falseBranchCfg2.getExitBlock());
    }

    public static /* synthetic */ IrBoolExprGraph simplifyBoolExpr$default(IrBoolExprSimplifier irBoolExprSimplifier, Object object, Function2 function2, int n, Object object2) {
        if ((n & 2) != 0) {
            function2 = simplifyBoolExpr.1.INSTANCE;
        }
        return irBoolExprSimplifier.simplifyBoolExpr(object, (Function2<IrCfgRegionBuilder, Boolean, Unit>)function2);
    }
}

