/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.legacy;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.rml.dfa.impl.DfaStorageError;
import com.intellij.rml.dfa.impl.domains.DomainTypeManager;
import com.intellij.rml.dfa.impl.legacy.RmlProvidersDiskStorage;
import com.intellij.rml.dfa.impl.providers.RMLImmutableInstancesProvider;
import com.intellij.rml.dfa.impl.providers.RMLInstancesProviderBase;
import com.intellij.rml.dfa.impl.providers.RmlProviderDescriptor;
import com.intellij.rml.dfa.impl.providers.RmlProvidersStorage;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/rml/dfa/impl/legacy/RmlProvidersDiskStorageService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "storageFile", "Ljava/nio/file/Path;", "storageMap", "Lcom/intellij/util/io/PersistentHashMap;", "Lcom/intellij/rml/dfa/impl/providers/RmlProviderDescriptor;", "Lcom/intellij/rml/dfa/impl/providers/RMLInstancesProviderBase;", "getProvidersStorage", "Lcom/intellij/rml/dfa/impl/providers/RmlProvidersStorage;", "typeManager", "Lcom/intellij/rml/dfa/impl/domains/DomainTypeManager;", "Companion", "intellij.rml.dfa.impl"})
public final class RmlProvidersDiskStorageService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Path storageFile;
    @Nullable
    private PersistentHashMap<RmlProviderDescriptor, RMLInstancesProviderBase> storageMap;

    public RmlProvidersDiskStorageService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.storageFile = ProjectUtil.getProjectDataPath((Project)this.project, (String)"rml-dfa/summaries.bin");
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final RmlProvidersStorage getProvidersStorage(@NotNull DomainTypeManager typeManager) {
        Intrinsics.checkNotNullParameter((Object)typeManager, (String)"typeManager");
        try {
            PersistentHashMap<RmlProviderDescriptor, RMLInstancesProviderBase> persistentHashMap = this.storageMap;
            if (persistentHashMap != null) {
                persistentHashMap.closeAndClean();
            }
            this.storageMap = new PersistentHashMap(this.storageFile, (KeyDescriptor)new KeyDescriptor<RmlProviderDescriptor>(){

                public boolean isEqual(RmlProviderDescriptor desc1, RmlProviderDescriptor desc2) {
                    Intrinsics.checkNotNullParameter((Object)desc1, (String)"desc1");
                    Intrinsics.checkNotNullParameter((Object)desc2, (String)"desc2");
                    return Intrinsics.areEqual((Object)desc1, (Object)desc2);
                }

                public int getHashCode(RmlProviderDescriptor descriptor) {
                    Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                    return descriptor.hashCode();
                }

                public void save(DataOutput stream, RmlProviderDescriptor descriptor) {
                    Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                    Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                    descriptor.save(stream);
                }

                public RmlProviderDescriptor read(DataInput stream) {
                    Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                    return RmlProviderDescriptor.Companion.load(stream);
                }
            }, (DataExternalizer)new DataExternalizer<RMLInstancesProviderBase>(typeManager){
                final /* synthetic */ DomainTypeManager $typeManager;
                {
                    this.$typeManager = $typeManager;
                }

                public void save(DataOutput stream, RMLInstancesProviderBase provider) {
                    Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                    Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
                    provider.save(stream);
                }

                public RMLInstancesProviderBase read(DataInput stream) {
                    Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                    return RMLImmutableInstancesProvider.Companion.load(this.$typeManager, stream);
                }
            });
            File file = this.storageFile.toFile().getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
            PersistentHashMap<RmlProviderDescriptor, RMLInstancesProviderBase> persistentHashMap2 = this.storageMap;
            Intrinsics.checkNotNull(persistentHashMap2);
            return new RmlProvidersDiskStorage(file, persistentHashMap2);
        }
        catch (IOException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            throw new DfaStorageError(null, string);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/intellij/rml/dfa/impl/legacy/RmlProvidersDiskStorageService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/rml/dfa/impl/legacy/RmlProvidersDiskStorageService;", "kotlin.jvm.PlatformType", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rml.dfa.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final RmlProvidersDiskStorageService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return (RmlProvidersDiskStorageService)project.getService(RmlProvidersDiskStorageService.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

