/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.utils.concurrency;

import com.intellij.openapi.util.Ref;
import com.intellij.rml.dfa.impl.ui.ThreadCallback;
import com.intellij.rml.dfa.impl.utils.concurrency.DAGCancellationCallbackWrapper;
import com.intellij.rml.dfa.impl.utils.concurrency.DAGCancellationException;
import com.intellij.rml.dfa.impl.utils.concurrency.DAGTask;
import com.intellij.rml.dfa.impl.utils.concurrency.ExecutorServiceFactory;
import com.intellij.rml.dfa.impl.utils.graph.GraphAlgorithmsImplKt;
import com.intellij.rml.dfa.utils.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B7\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u001cJ>\u0010\u001d\u001a\u00020\u001926\u0010\u001e\u001a2\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u00190\u0017J*\u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00050$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002JM\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00028\u00002\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00010\u00062\u0018\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00050+2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010,J.\u0010-\u001a\u00020\u00192\u0018\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00050+2\n\u0010.\u001a\u00060/j\u0002`0H\u0002J7\u00101\u001a\u00020\u00192\u0006\u0010!\u001a\u00028\u00002\u0006\u0010\"\u001a\u00020\u00182\u0018\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00050+H\u0002\u00a2\u0006\u0002\u00102R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000e0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00110\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0015\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/rml/dfa/impl/utils/concurrency/DAGThreadPoolExecutor;", "ID", "T", "", "tasks", "", "Lcom/intellij/rml/dfa/impl/utils/concurrency/DAGTask;", "dependencies", "Lcom/intellij/rml/dfa/utils/graph/Graph;", "executorsServiceFactory", "Lcom/intellij/rml/dfa/impl/utils/concurrency/ExecutorServiceFactory;", "<init>", "(Ljava/util/Map;Lcom/intellij/rml/dfa/utils/graph/Graph;Lcom/intellij/rml/dfa/impl/utils/concurrency/ExecutorServiceFactory;)V", "uncompletedTaskCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "dependentUncompletedTaskCount", "taskResult", "Lcom/intellij/openapi/util/Ref;", "parentTasks", "isCompleted", "Ljava/util/concurrent/atomic/AtomicBoolean;", "progressObservers", "", "Lkotlin/Function2;", "", "", "execute", "callback", "Lcom/intellij/rml/dfa/impl/ui/ThreadCallback;", "onTaskComplete", "progressObserver", "Lkotlin/ParameterName;", "name", "taskID", "ordinalNumber", "executeAsync", "Ljava/util/concurrent/Future;", "executor", "Ljava/util/concurrent/Executor;", "sendTask", "id", "t", "mainResultFuture", "Ljava/util/concurrent/CompletableFuture;", "(Ljava/lang/Object;Lcom/intellij/rml/dfa/impl/utils/concurrency/DAGTask;Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/Executor;Lcom/intellij/rml/dfa/impl/ui/ThreadCallback;)V", "completeWithException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "informProgress", "(Ljava/lang/Object;ILjava/util/concurrent/CompletableFuture;)V", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nDAGThreadPoolExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DAGThreadPoolExecutor.kt\ncom/intellij/rml/dfa/impl/utils/concurrency/DAGThreadPoolExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,204:1\n1300#2,2:205\n1315#2,4:207\n1300#2,2:211\n1315#2,4:213\n1915#2,2:224\n1586#2:226\n1661#2,3:227\n1266#2,4:232\n491#3,7:217\n466#3:230\n415#3:231\n*S KotlinDebug\n*F\n+ 1 DAGThreadPoolExecutor.kt\ncom/intellij/rml/dfa/impl/utils/concurrency/DAGThreadPoolExecutor\n*L\n37#1:205,2\n37#1:207,4\n40#1:211,2\n40#1:213,4\n131#1:224,2\n91#1:226\n91#1:227,3\n115#1:232,4\n75#1:217,7\n115#1:230\n115#1:231\n*E\n"})
public final class DAGThreadPoolExecutor<ID, T> {
    @NotNull
    private final Map<ID, DAGTask<T>> tasks;
    @NotNull
    private final Graph<ID> dependencies;
    @NotNull
    private final ExecutorServiceFactory executorsServiceFactory;
    @NotNull
    private final AtomicInteger uncompletedTaskCount;
    @NotNull
    private final Map<ID, AtomicInteger> dependentUncompletedTaskCount;
    @NotNull
    private final Map<ID, Ref<T>> taskResult;
    @NotNull
    private final Graph<ID> parentTasks;
    @NotNull
    private final AtomicBoolean isCompleted;
    @NotNull
    private final List<Function2<ID, Integer, Unit>> progressObservers;

    public DAGThreadPoolExecutor(@NotNull Map<ID, ? extends DAGTask<T>> tasks, @NotNull Graph<ID> dependencies, @NotNull ExecutorServiceFactory executorsServiceFactory) {
        AtomicInteger atomicInteger;
        Object it;
        Map map2;
        Object t;
        Object element$iv$iv;
        Iterable $this$associateWithTo$iv$iv;
        Iterable $this$associateWith$iv;
        Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter((Object)executorsServiceFactory, (String)"executorsServiceFactory");
        this.tasks = tasks;
        this.dependencies = dependencies;
        this.executorsServiceFactory = executorsServiceFactory;
        this.uncompletedTaskCount = new AtomicInteger(this.tasks.size());
        Iterable iterable = this.tasks.keySet();
        DAGThreadPoolExecutor dAGThreadPoolExecutor = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void var7_8 = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        Iterator iterator = $this$associateWithTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object t2 = element$iv$iv = iterator.next();
            t = element$iv$iv;
            map2 = destination$iv$iv;
            boolean bl = false;
            atomicInteger = new AtomicInteger(this.dependencies.get(it).size());
            map2.put(t, atomicInteger);
        }
        dAGThreadPoolExecutor.dependentUncompletedTaskCount = destination$iv$iv;
        $this$associateWith$iv = this.tasks.keySet();
        dAGThreadPoolExecutor = this;
        $i$f$associateWith = false;
        result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        $this$associateWithTo$iv$iv = $this$associateWith$iv;
        destination$iv$iv = result$iv;
        $i$f$associateWithTo = false;
        iterator = $this$associateWithTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            it = element$iv$iv = iterator.next();
            t = element$iv$iv;
            map2 = destination$iv$iv;
            boolean bl = false;
            atomicInteger = new Ref();
            map2.put(t, atomicInteger);
        }
        dAGThreadPoolExecutor.taskResult = destination$iv$iv;
        this.parentTasks = GraphAlgorithmsImplKt.inverted(this.dependencies);
        this.isCompleted = new AtomicBoolean(false);
        this.progressObservers = new ArrayList();
    }

    @NotNull
    public final Map<ID, T> execute(@NotNull ThreadCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        ExecutorService executor = this.executorsServiceFactory.createExecutorService();
        DAGCancellationCallbackWrapper cancellableCallback = new DAGCancellationCallbackWrapper(callback2);
        try {
            Map<ID, T> map2 = this.executeAsync(executor, cancellableCallback).get();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"get(...)");
            return map2;
        }
        catch (ExecutionException e) {
            executor.shutdownNow();
            cancellableCallback.cancel();
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            Throwable throwable = e.getCause();
            Intrinsics.checkNotNull((Object)throwable);
            throw throwable;
        }
    }

    public final void onTaskComplete(@NotNull Function2<? super ID, ? super Integer, Unit> progressObserver) {
        Intrinsics.checkNotNullParameter(progressObserver, (String)"progressObserver");
        this.progressObservers.add(progressObserver);
    }

    private final Future<Map<ID, T>> executeAsync(Executor executor, ThreadCallback callback2) {
        Map<ID, DAGTask<T>> $this$filterKeys$iv = this.tasks;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<ID, DAGTask<T>> result$iv = new LinkedHashMap<ID, DAGTask<T>>();
        for (Map.Entry<ID, DAGTask<T>> entry$iv : $this$filterKeys$iv.entrySet()) {
            ID id = entry$iv.getKey();
            boolean bl = false;
            if (!this.dependencies.get(id).isEmpty()) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map initialTasks = result$iv;
        CompletableFuture<Map<ID, T>> mainResultFuture = new CompletableFuture<Map<ID, T>>();
        for (Map.Entry entry : initialTasks.entrySet()) {
            Object id = entry.getKey();
            DAGTask task = (DAGTask)entry.getValue();
            this.sendTask(id, task, mainResultFuture, executor, callback2);
        }
        return mainResultFuture;
    }

    private final void sendTask(ID id, DAGTask<T> t, CompletableFuture<Map<ID, T>> mainResultFuture, Executor executor, ThreadCallback callback2) {
        if (this.isCompleted.get()) {
            return;
        }
        try {
            executor.execute(() -> DAGThreadPoolExecutor.sendTask$lambda$0(this, id, t, callback2, mainResultFuture, executor));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    private final void completeWithException(CompletableFuture<Map<ID, T>> mainResultFuture, Exception e) {
        if (this.isCompleted.compareAndSet(false, true)) {
            mainResultFuture.completeExceptionally(e);
        }
    }

    private final void informProgress(ID taskID, int ordinalNumber, CompletableFuture<Map<ID, T>> mainResultFuture) {
        try {
            Iterable $this$forEach$iv = this.progressObservers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function2 it = (Function2)element$iv;
                boolean bl = false;
                it.invoke(taskID, (Object)ordinalNumber);
            }
        }
        catch (Exception e) {
            this.completeWithException(mainResultFuture, e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void sendTask$lambda$0(DAGThreadPoolExecutor this$0, Object $id, DAGTask $t, ThreadCallback $callback, CompletableFuture $mainResultFuture, Executor $executor) {
        Object $i$f$map2;
        Iterable it;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this$0.dependencies.get($id);
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            object = destination$iv$iv;
            boolean bl = false;
            Ref ref = this$0.taskResult.get(it);
            Intrinsics.checkNotNull(ref);
            object.add(ref.get());
        }
        List input = (List)destination$iv$iv;
        try {
            $i$f$map2 = $t.execute(input, $callback);
        }
        catch (DAGCancellationException dAGCancellationException) {
            return;
        }
        catch (Exception e) {
            this$0.completeWithException($mainResultFuture, e);
            return;
        }
        Object result = $i$f$map2;
        Ref ref = this$0.taskResult.get($id);
        Intrinsics.checkNotNull(ref);
        ref.set(result);
        for (Object parentTaskID : this$0.parentTasks.get($id)) {
            AtomicInteger atomicInteger = this$0.dependentUncompletedTaskCount.get(parentTaskID);
            Intrinsics.checkNotNull((Object)atomicInteger);
            if (atomicInteger.decrementAndGet() != 0) continue;
            DAGTask dAGTask = this$0.tasks.get(parentTaskID);
            Intrinsics.checkNotNull(dAGTask);
            this$0.sendTask(parentTaskID, dAGTask, $mainResultFuture, $executor, $callback);
        }
        int restTaskCount = this$0.uncompletedTaskCount.decrementAndGet();
        this$0.informProgress($id, this$0.tasks.size() - restTaskCount, $mainResultFuture);
        if (restTaskCount == 0 && this$0.isCompleted.compareAndSet(false, true)) {
            void $this$associateByTo$iv$iv$iv;
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Object parentTaskID;
            parentTaskID = this$0.taskResult;
            object = $mainResultFuture;
            boolean $i$f$mapValues = false;
            void $i$f$mapTo2 = $this$mapValues$iv;
            Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            it = $this$mapValuesTo$iv$iv.entrySet();
            Map destination$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it2;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                Object object2 = ((Ref)it2.getValue()).get();
                map3.put(k, object2);
            }
            ((CompletableFuture)object).complete(destination$iv$iv$iv);
        }
    }
}

