/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.utils.graph;

import com.intellij.rml.dfa.ir.ast.IrFunctionDecl;
import com.intellij.rml.dfa.ir.cfg.IrCFGBlock;
import com.intellij.rml.dfa.utils.graph.CFGAlgorithms;
import com.intellij.rml.dfa.utils.graph.ControlFlowGraph;
import com.intellij.rml.dfa.utils.graph.Graph;
import com.intellij.rml.dfa.utils.graph.GraphAlgorithmsFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"dominanceFrontier", "", "Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;", "", "function", "Lcom/intellij/rml/dfa/ir/ast/IrFunctionDecl;", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nDominanceFrontier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DominanceFrontier.kt\ncom/intellij/rml/dfa/impl/utils/graph/DominanceFrontierKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n1#2:41\n383#3,7:42\n383#3,7:49\n777#4:56\n873#4,2:57\n777#4:59\n873#4,2:60\n*S KotlinDebug\n*F\n+ 1 DominanceFrontier.kt\ncom/intellij/rml/dfa/impl/utils/graph/DominanceFrontierKt\n*L\n20#1:42,7\n32#1:49,7\n32#1:56\n32#1:57,2\n35#1:59\n35#1:60,2\n*E\n"})
public final class DominanceFrontierKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<IrCFGBlock, Set<IrCFGBlock>> dominanceFrontier(@NotNull IrFunctionDecl function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        ControlFlowGraph cfg2 = function2.getBody().toControlFlowGraph();
        Graph graph2 = cfg2.getGraph();
        CFGAlgorithms algorithms = GraphAlgorithmsFactory.Companion.getInstance().createAlgorithms(cfg2);
        Map frontier = new LinkedHashMap();
        Map dominatorTree = new LinkedHashMap();
        List postOrder = new ArrayList();
        for (IrCFGBlock node : graph2.nodes()) {
            Object object;
            void $this$getOrPut$iv;
            IrCFGBlock it;
            if ((IrCFGBlock)algorithms.getDominators().get(node) == null) continue;
            boolean bl = false;
            Map map2 = dominatorTree;
            IrCFGBlock key$iv = it;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Collection)object).add(node);
        }
        DominanceFrontierKt.dominanceFrontier$evaluatePostOrder(dominatorTree, postOrder, (IrCFGBlock)cfg2.getStartNode());
        for (IrCFGBlock node : postOrder) {
            void $this$filterTo$iv$iv;
            Object object;
            void $this$getOrPut$iv;
            Iterator iterator = frontier;
            IrCFGBlock key$iv = node;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            iterator = (Collection)object;
            Iterable $this$filter$iv = graph2.get((Object)node);
            boolean $i$f$filter = false;
            value$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IrCFGBlock it = (IrCFGBlock)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual(algorithms.getDominators().get(it), (Object)node))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)((Object)iterator), (Iterable)$this$filter$iv);
            Set set = (Set)dominatorTree.get(node);
            if (set == null) {
                set = SetsKt.emptySet();
            }
            for (IrCFGBlock z : set) {
                void $this$filterTo$iv$iv2;
                Object v = frontier.get(node);
                Intrinsics.checkNotNull(v);
                Collection collection = (Collection)v;
                Object v2 = frontier.get(z);
                Intrinsics.checkNotNull(v2);
                Iterable $this$filter$iv2 = (Iterable)v2;
                boolean $i$f$filter2 = false;
                Iterable $i$f$filterTo2 = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    IrCFGBlock it = (IrCFGBlock)element$iv$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual(algorithms.getDominators().get(it), (Object)node))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                Iterable iterable = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            }
        }
        return frontier;
    }

    private static final void dominanceFrontier$evaluatePostOrder(Map<IrCFGBlock, Set<IrCFGBlock>> dominatorTree, List<IrCFGBlock> postOrder, IrCFGBlock block) {
        Set set = dominatorTree.get(block);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        for (IrCFGBlock next : set) {
            DominanceFrontierKt.dominanceFrontier$evaluatePostOrder(dominatorTree, postOrder, next);
        }
        ((Collection)postOrder).add(block);
    }
}

