/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.utils.graph;

import com.intellij.rml.dfa.utils.graph.ControlFlowGraph;
import com.intellij.rml.dfa.utils.graph.Graph;
import com.intellij.rml.dfa.utils.graph.GraphBuilder;
import com.intellij.rml.dfa.utils.graph.GraphImpl;
import com.intellij.rml.dfa.utils.graph.GraphKt;
import com.intellij.rml.dfa.utils.graph.IntGraph;
import com.intellij.rml.dfa.utils.graph.IntGraphBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0001\u001a\n\u0010\u0000\u001a\u00020\u0003*\u00020\u0003\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0004\u001a*\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0007\u001a*\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\u00020\u00032\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00020\n\u001a6\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\f0\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\f*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\f0\u000e\u001a6\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\f0\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\f*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\f0\n\u001a0\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00110\n\u001a6\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\f0\u0004\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\f*\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\f0\u000e\u00a8\u0006\u0012"}, d2={"inverted", "Lcom/intellij/rml/dfa/utils/graph/Graph;", "T", "Lcom/intellij/rml/dfa/utils/graph/IntGraph;", "Lcom/intellij/rml/dfa/utils/graph/ControlFlowGraph;", "removeBackEdges", "sortedNodes", "", "map", "nodeTransform", "Lkotlin/Function1;", "", "R", "nodeMapping", "", "filter", "predicate", "", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nGraphAlgorithmsImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphAlgorithmsImpl.kt\ncom/intellij/rml/dfa/impl/utils/graph/GraphAlgorithmsImplKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,294:1\n1205#2,2:295\n1282#2,4:297\n1300#2,2:301\n1315#2,4:303\n*S KotlinDebug\n*F\n+ 1 GraphAlgorithmsImpl.kt\ncom/intellij/rml/dfa/impl/utils/graph/GraphAlgorithmsImplKt\n*L\n33#1:295,2\n33#1:297,4\n60#1:301,2\n60#1:303,4\n*E\n"})
public final class GraphAlgorithmsImplKt {
    @NotNull
    public static final <T> Graph<T> inverted(@NotNull Graph<T> $this$inverted) {
        Intrinsics.checkNotNullParameter($this$inverted, (String)"<this>");
        return GraphKt.buildGraph((Function1)new Function1<GraphBuilder<T>, Unit>($this$inverted){
            final /* synthetic */ Graph<T> $this_inverted;
            {
                this.$this_inverted = $receiver;
                super(1);
            }

            public final void invoke(GraphBuilder<T> $this$buildGraph) {
                Intrinsics.checkNotNullParameter($this$buildGraph, (String)"$this$buildGraph");
                Iterable $this$forEach$iv = this.$this_inverted.nodes();
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    T element$iv;
                    T it = element$iv = iterator.next();
                    boolean bl = false;
                    $this$buildGraph.addNode(it);
                }
                $this$forEach$iv = this.$this_inverted.edges();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    Object from = pair.component1();
                    Object to = pair.component2();
                    $this$buildGraph.addEdge(to, from);
                }
            }
        });
    }

    @NotNull
    public static final IntGraph inverted(@NotNull IntGraph $this$inverted) {
        Intrinsics.checkNotNullParameter((Object)$this$inverted, (String)"<this>");
        return GraphKt.buildIntGraph((Function1)((Function1)new Function1<IntGraphBuilder, Unit>($this$inverted){
            final /* synthetic */ IntGraph $this_inverted;
            {
                this.$this_inverted = $receiver;
                super(1);
            }

            public final void invoke(IntGraphBuilder $this$buildIntGraph) {
                Intrinsics.checkNotNullParameter((Object)$this$buildIntGraph, (String)"$this$buildIntGraph");
                Iterable $this$forEach$iv = this.$this_inverted.nodes();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl = false;
                    $this$buildIntGraph.addNode(it);
                }
                $this$forEach$iv = this.$this_inverted.edges();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    int from = ((Number)pair.component1()).intValue();
                    int to = ((Number)pair.component2()).intValue();
                    $this$buildIntGraph.addEdge(to, from);
                }
            }
        }));
    }

    @NotNull
    public static final <T> ControlFlowGraph<T> inverted(@NotNull ControlFlowGraph<T> $this$inverted) {
        Intrinsics.checkNotNullParameter($this$inverted, (String)"<this>");
        return new ControlFlowGraph(GraphAlgorithmsImplKt.inverted($this$inverted.getGraph()), $this$inverted.getExitNode(), $this$inverted.getStartNode());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> Graph<T> removeBackEdges(@NotNull Graph<T> $this$removeBackEdges, @NotNull List<? extends T> sortedNodes) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$removeBackEdges, (String)"<this>");
        Intrinsics.checkNotNullParameter(sortedNodes, (String)"sortedNodes");
        Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)sortedNodes);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            IndexedValue indexedValue = (IndexedValue)element$iv$iv;
            boolean bl = false;
            int idx = indexedValue.component1();
            Object func = indexedValue.component2();
            indexedValue = new Pair(func, (Object)idx);
            map2.put(indexedValue.getFirst(), indexedValue.getSecond());
        }
        Map order = destination$iv$iv;
        return GraphKt.buildGraph((Function1)new Function1<GraphBuilder<T>, Unit>($this$removeBackEdges, order){
            final /* synthetic */ Graph<T> $this_removeBackEdges;
            final /* synthetic */ Map<T, Integer> $order;
            {
                this.$this_removeBackEdges = $receiver;
                this.$order = $order;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(GraphBuilder<T> $this$buildGraph) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                T element$iv2;
                Intrinsics.checkNotNullParameter($this$buildGraph, (String)"$this$buildGraph");
                Iterable $this$forEach$iv = this.$this_removeBackEdges.nodes();
                boolean $i$f$forEach22 = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    T it = element$iv2 = iterator.next();
                    boolean bl = false;
                    $this$buildGraph.addNode(it);
                }
                $this$forEach$iv = this.$this_removeBackEdges.edges();
                Map<T, Integer> $i$f$forEach22 = this.$order;
                boolean $i$f$filter = false;
                element$iv2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    Pair pair = (Pair)element$iv$iv;
                    boolean bl = false;
                    Object from = pair.component1();
                    Object to = pair.component2();
                    Integer n = $i$f$forEach22.get(from);
                    Intrinsics.checkNotNull((Object)n);
                    int n2 = ((Number)n).intValue();
                    Integer n3 = $i$f$forEach22.get(to);
                    Intrinsics.checkNotNull((Object)n3);
                    if (!(n2 > ((Number)n3).intValue())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (T element$iv2 : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv2;
                    boolean bl = false;
                    Object from = pair.component1();
                    Object to = pair.component2();
                    $this$buildGraph.addEdge(from, to);
                }
            }
        });
    }

    @NotNull
    public static final <T> Graph<T> map(@NotNull IntGraph $this$map, @NotNull Function1<? super Integer, ? extends T> nodeTransform) {
        Intrinsics.checkNotNullParameter((Object)$this$map, (String)"<this>");
        Intrinsics.checkNotNullParameter(nodeTransform, (String)"nodeTransform");
        Map nodeToId = new LinkedHashMap();
        Map idToNode = new LinkedHashMap();
        Iterator iterator = $this$map.nodes().iterator();
        while (iterator.hasNext()) {
            int node = ((Number)iterator.next()).intValue();
            Object transformed = nodeTransform.invoke((Object)node);
            nodeToId.put(transformed, node);
            idToNode.put(node, transformed);
        }
        return (Graph)new GraphImpl($this$map, nodeToId, idToNode);
    }

    @NotNull
    public static final <T, R> Graph<R> map(@NotNull Graph<T> $this$map, @NotNull Map<T, ? extends R> nodeMapping) {
        Intrinsics.checkNotNullParameter($this$map, (String)"<this>");
        Intrinsics.checkNotNullParameter(nodeMapping, (String)"nodeMapping");
        return GraphKt.buildGraph((Function1)new Function1<GraphBuilder<R>, Unit>($this$map, nodeMapping){
            final /* synthetic */ Graph<T> $this_map;
            final /* synthetic */ Map<T, R> $nodeMapping;
            {
                this.$this_map = $receiver;
                this.$nodeMapping = $nodeMapping;
                super(1);
            }

            public final void invoke(GraphBuilder<R> $this$buildGraph) {
                Iterable $this$forEach$iv;
                Intrinsics.checkNotNullParameter($this$buildGraph, (String)"$this$buildGraph");
                Iterable iterable = this.$this_map.nodes();
                Map<T, R> map2 = this.$nodeMapping;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    T element$iv;
                    T it = element$iv = iterator.next();
                    boolean bl = false;
                    R r = map2.get(it);
                    Intrinsics.checkNotNull(r);
                    $this$buildGraph.addNode(r);
                }
                $this$forEach$iv = this.$this_map.edges();
                map2 = this.$nodeMapping;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    Object from = pair.component1();
                    Object to = pair.component2();
                    R r = map2.get(from);
                    Intrinsics.checkNotNull(r);
                    R r2 = map2.get(to);
                    Intrinsics.checkNotNull(r2);
                    $this$buildGraph.addEdge(r, r2);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, R> Graph<R> map(@NotNull Graph<T> $this$map, @NotNull Function1<? super T, ? extends R> nodeMapping) {
        void $this$associateWithTo$iv$iv;
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter($this$map, (String)"<this>");
        Intrinsics.checkNotNullParameter(nodeMapping, (String)"nodeMapping");
        Iterable iterable = $this$map.nodes();
        Graph<T> graph2 = $this$map;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void var5_6 = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        Iterator iterator = $this$associateWithTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object element$iv$iv;
            Object t = element$iv$iv = iterator.next();
            Object t2 = element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object object = nodeMapping.invoke((Object)it);
            map2.put(t2, object);
        }
        return GraphAlgorithmsImplKt.map(graph2, destination$iv$iv);
    }

    @NotNull
    public static final <T> Graph<T> filter(@NotNull Graph<T> $this$filter, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$filter, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return GraphKt.buildGraph((Function1)new Function1<GraphBuilder<T>, Unit>($this$filter, predicate){
            final /* synthetic */ Graph<T> $this_filter;
            final /* synthetic */ Function1<T, Boolean> $predicate;
            {
                this.$this_filter = $receiver;
                this.$predicate = $predicate;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(GraphBuilder<T> $this$buildGraph) {
                Object it;
                T element$iv2;
                Object it2;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter($this$buildGraph, (String)"$this$buildGraph");
                Iterable iterable = this.$this_filter.nodes();
                Function1<T, Boolean> function1 = this.$predicate;
                boolean $i$f$filter22 = false;
                void var5_11 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                Iterator<T> iterator = $this$filterTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    T element$iv$iv;
                    it2 = element$iv$iv = iterator.next();
                    boolean bl = false;
                    if (!((Boolean)function1.invoke(it2)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach22 = false;
                Iterator<T> $i$f$filter22 = $this$forEach$iv.iterator();
                while ($i$f$filter22.hasNext()) {
                    it = element$iv2 = $i$f$filter22.next();
                    boolean bl = false;
                    $this$buildGraph.addNode(it);
                }
                $this$forEach$iv = this.$this_filter.edges();
                Function1<T, Boolean> $i$f$forEach22 = this.$predicate;
                boolean $i$f$filter = false;
                element$iv2 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it2 = (Pair)element$iv$iv;
                    boolean bl = false;
                    if (!((Boolean)$i$f$forEach22.invoke(it2.getFirst()) != false && (Boolean)$i$f$forEach22.invoke(it2.getSecond()) != false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (T element$iv2 : $this$forEach$iv) {
                    it = (Pair)element$iv2;
                    boolean bl = false;
                    $this$buildGraph.addEdge(it.getFirst(), it.getSecond());
                }
            }
        });
    }

    @NotNull
    public static final <T, R> ControlFlowGraph<R> map(@NotNull ControlFlowGraph<T> $this$map, @NotNull Map<T, ? extends R> nodeMapping) {
        Intrinsics.checkNotNullParameter($this$map, (String)"<this>");
        Intrinsics.checkNotNullParameter(nodeMapping, (String)"nodeMapping");
        Graph<? extends R> graph2 = GraphAlgorithmsImplKt.map($this$map.getGraph(), nodeMapping);
        R r = nodeMapping.get($this$map.getStartNode());
        Intrinsics.checkNotNull(r);
        R r2 = nodeMapping.get($this$map.getExitNode());
        Intrinsics.checkNotNull(r2);
        return new ControlFlowGraph(graph2, r, r2);
    }
}

