/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ProblemDescriptor
extends CommonProblemDescriptor {
    public static final ProblemDescriptor[] EMPTY_ARRAY = new ProblemDescriptor[0];

    public PsiElement getPsiElement();

    public PsiElement getStartElement();

    public PsiElement getEndElement();

    public TextRange getTextRangeInElement();

    @NlsContexts.Tooltip
    @NotNull
    default public String getTooltipTemplate() {
        String string = this.getDescriptionTemplate();
        if (string == null) {
            ProblemDescriptor.$$$reportNull$$$0(0);
        }
        return string;
    }

    public int getLineNumber();

    @NotNull
    public ProblemHighlightType getHighlightType();

    public boolean isAfterEndOfLine();

    public void setTextAttributes(TextAttributesKey var1);

    @Nullable
    public ProblemGroup getProblemGroup();

    public void setProblemGroup(@Nullable ProblemGroup var1);

    public boolean showTooltip();

    @NotNull
    default public ProblemDescriptor getDescriptorForPreview(@NotNull PsiFile target) {
        PsiElement psi;
        PsiElement end;
        PsiElement start;
        if (target == null) {
            ProblemDescriptor.$$$reportNull$$$0(1);
        }
        try {
            start = PsiTreeUtil.findSameElementInCopy((PsiElement)this.getStartElement(), (PsiFile)target);
            end = PsiTreeUtil.findSameElementInCopy((PsiElement)this.getEndElement(), (PsiFile)target);
            psi = PsiTreeUtil.findSameElementInCopy((PsiElement)this.getPsiElement(), (PsiFile)target);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to obtain element copy for preview; descriptor: " + this.getDescriptionTemplate(), e);
        }
        final ProblemDescriptor pd = this;
        return new ProblemDescriptor(){

            @Override
            public PsiElement getPsiElement() {
                return psi;
            }

            @Override
            public PsiElement getStartElement() {
                return start;
            }

            @Override
            public PsiElement getEndElement() {
                return end;
            }

            @Override
            public TextRange getTextRangeInElement() {
                return pd.getTextRangeInElement();
            }

            @Override
            public int getLineNumber() {
                return pd.getLineNumber();
            }

            @Override
            @NotNull
            public ProblemHighlightType getHighlightType() {
                ProblemHighlightType problemHighlightType = pd.getHighlightType();
                if (problemHighlightType == null) {
                    1.$$$reportNull$$$0(0);
                }
                return problemHighlightType;
            }

            @Override
            public boolean isAfterEndOfLine() {
                return pd.isAfterEndOfLine();
            }

            @Override
            public void setTextAttributes(TextAttributesKey key) {
            }

            @Override
            @Nullable
            public ProblemGroup getProblemGroup() {
                return pd.getProblemGroup();
            }

            @Override
            public void setProblemGroup(@Nullable ProblemGroup problemGroup) {
            }

            @Override
            public boolean showTooltip() {
                return pd.showTooltip();
            }

            @Override
            @NotNull
            public String getDescriptionTemplate() {
                String string = pd.getDescriptionTemplate();
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            public @NotNull QuickFix @Nullable [] getFixes() {
                return QuickFix.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/codeInspection/ProblemDescriptor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHighlightType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDescriptionTemplate";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ProblemDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipTemplate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ProblemDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorForPreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

