/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.persistent.BatchingFileSystem;
import com.intellij.util.containers.CollectionFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArchiveFileSystem
extends NewVirtualFileSystem
implements BatchingFileSystem {
    private static final Key<VirtualFile> LOCAL_FILE = Key.create((String)"vfs.archive.local.file");
    private final Function<VirtualFile, FileAttributes> myAttrGetter = ManagingFS.getInstance().accessDiskWithCheckCanceled(file -> this.getHandler((VirtualFile)file).getAttributes(this.getRelativePath((VirtualFile)file)));
    private final Function<Pair<VirtualFile, Set<String>>, Map<@NotNull String, @NotNull FileAttributes>> myListWithAttrGetter = ManagingFS.getInstance().accessDiskWithCheckCanceled(dirAndNames -> {
        VirtualFile dir = (VirtualFile)dirAndNames.first;
        Set childNames = (Set)dirAndNames.second;
        return this.childrenWithAttributes(dir, childNames);
    });
    private final Function<VirtualFile, String[]> myChildrenGetter = ManagingFS.getInstance().accessDiskWithCheckCanceled(file -> this.getHandler((VirtualFile)file).list(this.getRelativePath((VirtualFile)file)));
    private final Function<VirtualFile, Pair<byte[], IOException>> myContentGetter = ManagingFS.getInstance().accessDiskWithCheckCanceled(file -> {
        try {
            return Pair.pair((Object)this.getHandler((VirtualFile)file).contentsToByteArray(this.getRelativePath((VirtualFile)file)), null);
        }
        catch (IOException e) {
            return Pair.pair(null, (Object)e);
        }
    });

    @Nullable
    public VirtualFile getRootByLocal(@NotNull VirtualFile file) {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(0);
        }
        return this.isCorrectFileType(file) ? this.findFileByPath(this.getRootPathByLocal(file)) : null;
    }

    @NotNull
    public String getRootPathByLocal(@NotNull VirtualFile file) {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(1);
        }
        String string = this.composeRootPath(file.getPath());
        if (string == null) {
            ArchiveFileSystem.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public VirtualFile getRootByEntry(@NotNull VirtualFile entry) {
        if (entry == null) {
            ArchiveFileSystem.$$$reportNull$$$0(3);
        }
        return entry.getFileSystem() == this ? VfsUtilCore.getRootFile((VirtualFile)entry) : null;
    }

    @Nullable
    public VirtualFile getLocalByEntry(@NotNull VirtualFile entry) {
        if (entry == null) {
            ArchiveFileSystem.$$$reportNull$$$0(4);
        }
        if (entry.getFileSystem() != this) {
            return null;
        }
        VirtualFile root = this.getRootByEntry(entry);
        assert (root != null) : entry;
        VirtualFile local = (VirtualFile)LOCAL_FILE.get((UserDataHolder)root);
        if (local == null) {
            String localPath = this.extractLocalPath(root.getPath());
            local = StandardFileSystems.local().findFileByPath(localPath);
            if (local != null) {
                LOCAL_FILE.set((UserDataHolder)root, (Object)local);
            }
        }
        return local;
    }

    @NotNull
    protected abstract String extractLocalPath(@NotNull String var1);

    @NotNull
    protected abstract String composeRootPath(@NotNull String var1);

    @NotNull
    protected abstract ArchiveHandler getHandler(@NotNull VirtualFile var1);

    @Override
    public int getRank() {
        return LocalFileSystem.getInstance().getRank() + 1;
    }

    @Override
    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(5);
        }
        if (newParent == null) {
            ArchiveFileSystem.$$$reportNull$$$0(6);
        }
        if (copyName == null) {
            ArchiveFileSystem.$$$reportNull$$$0(7);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Override
    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        if (parent == null) {
            ArchiveFileSystem.$$$reportNull$$$0(8);
        }
        if (dir == null) {
            ArchiveFileSystem.$$$reportNull$$$0(9);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", parent.getUrl()));
    }

    @Override
    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file) throws IOException {
        if (parent == null) {
            ArchiveFileSystem.$$$reportNull$$$0(10);
        }
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(11);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", parent.getUrl()));
    }

    @Override
    public void deleteFile(Object requestor, @NotNull VirtualFile file) throws IOException {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(12);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Override
    public void moveFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent) throws IOException {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(13);
        }
        if (newParent == null) {
            ArchiveFileSystem.$$$reportNull$$$0(14);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Override
    public void renameFile(Object requestor, @NotNull VirtualFile file, @NotNull String newName) throws IOException {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(15);
        }
        if (newName == null) {
            ArchiveFileSystem.$$$reportNull$$$0(16);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @NotNull
    protected String getRelativePath(@NotNull VirtualFile file) {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(17);
        }
        String relativePath = file.getPath().substring(VfsUtilCore.getRootFile((VirtualFile)file).getPath().length());
        String string = StringUtil.trimLeading((String)relativePath, (char)'/');
        if (string == null) {
            ArchiveFileSystem.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Override
    @Nullable
    public FileAttributes getAttributes(@NotNull VirtualFile file) {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(19);
        }
        return this.myAttrGetter.apply(file);
    }

    @NotNull
    private @NotNull Map<@NotNull String, @NotNull FileAttributes> childrenWithAttributes(@NotNull VirtualFile dir, @Nullable Set<String> childNames) {
        String directoryRelativePath;
        if (dir == null) {
            ArchiveFileSystem.$$$reportNull$$$0(20);
        }
        String normalizedDirectoryPath = (directoryRelativePath = this.getRelativePath(dir)).isEmpty() ? "" : StringUtil.trimTrailing((String)directoryRelativePath, (char)'/') + "/";
        ArchiveHandler handler = this.getHandler(dir);
        if (childNames == null) {
            childNames = CollectionFactory.createFilePathSet((String[])handler.list(directoryRelativePath), (boolean)true);
        }
        Map childrenWithAttributes = CollectionFactory.createFilePathMap((int)childNames.size(), (boolean)true);
        for (String childName : childNames) {
            String childRelativePath = normalizedDirectoryPath + childName;
            FileAttributes childAttributes = handler.getAttributes(childRelativePath);
            if (childAttributes == null) continue;
            childrenWithAttributes.put(childName, childAttributes);
        }
        Map map = childrenWithAttributes;
        if (map == null) {
            ArchiveFileSystem.$$$reportNull$$$0(21);
        }
        return map;
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public @NotNull Map<@NotNull String, @NotNull FileAttributes> listWithAttributes(@NotNull VirtualFile dir, @Nullable Set<String> childrenNames) {
        if (dir == null) {
            ArchiveFileSystem.$$$reportNull$$$0(22);
        }
        if (childrenNames != null && childrenNames.isEmpty()) {
            Map<String, FileAttributes> map = Collections.emptyMap();
            if (map == null) {
                ArchiveFileSystem.$$$reportNull$$$0(23);
            }
            return map;
        }
        Map<String, FileAttributes> map = this.myListWithAttrGetter.apply((Pair<VirtualFile, Set<String>>)new Pair((Object)dir, childrenNames));
        if (map == null) {
            ArchiveFileSystem.$$$reportNull$$$0(24);
        }
        return map;
    }

    @ApiStatus.Internal
    @NotNull
    public FileAttributes getArchiveRootAttributes(@NotNull VirtualFile file) {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(25);
        }
        this.getHandler(file);
        FileAttributes fileAttributes = ArchiveHandler.DIRECTORY_ATTRIBUTES;
        if (fileAttributes == null) {
            ArchiveFileSystem.$$$reportNull$$$0(26);
        }
        return fileAttributes;
    }

    public String @NotNull [] list(@NotNull VirtualFile file) {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(27);
        }
        String[] stringArray = this.myChildrenGetter.apply(file);
        if (stringArray == null) {
            ArchiveFileSystem.$$$reportNull$$$0(28);
        }
        return stringArray;
    }

    public boolean exists(@NotNull VirtualFile file) {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(29);
        }
        return file.getParent() == null ? this.getLocalByEntry(file) != null : this.getAttributes(file) != null;
    }

    public boolean isDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(30);
        }
        if (file.getParent() == null) {
            return true;
        }
        FileAttributes attributes = this.getAttributes(file);
        return attributes == null || attributes.isDirectory();
    }

    public boolean isWritable(@NotNull VirtualFile file) {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(31);
        }
        return false;
    }

    public long getTimeStamp(@NotNull VirtualFile file) {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(32);
        }
        if (file.getParent() == null) {
            VirtualFile host = this.getLocalByEntry(file);
            if (host != null) {
                return host.getTimeStamp();
            }
        } else {
            FileAttributes attributes = this.getAttributes(file);
            if (attributes != null) {
                return attributes.lastModified;
            }
        }
        return -1L;
    }

    public long getLength(@NotNull VirtualFile file) {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(33);
        }
        if (file.getParent() == null) {
            VirtualFile host = this.getLocalByEntry(file);
            if (host != null) {
                return host.getLength();
            }
        } else {
            FileAttributes attributes = this.getAttributes(file);
            if (attributes != null) {
                return attributes.length;
            }
        }
        return 0L;
    }

    public byte @NotNull [] contentsToByteArray(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(34);
        }
        Pair<byte[], IOException> pair = this.myContentGetter.apply(file);
        IOException exception = (IOException)pair.second;
        if (exception != null) {
            exception.addSuppressed(new Throwable("Caller thread's stacktrace"));
            throw exception;
        }
        byte[] byArray = (byte[])pair.first;
        if (byArray == null) {
            ArchiveFileSystem.$$$reportNull$$$0(35);
        }
        return byArray;
    }

    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(36);
        }
        InputStream inputStream = this.getHandler(file).getInputStream(this.getRelativePath(file));
        if (inputStream == null) {
            ArchiveFileSystem.$$$reportNull$$$0(37);
        }
        return inputStream;
    }

    public void setTimeStamp(@NotNull VirtualFile file, long timeStamp) throws IOException {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(38);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    public void setWritable(@NotNull VirtualFile file, boolean writableFlag) throws IOException {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(39);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @NotNull
    public OutputStream getOutputStream(@NotNull VirtualFile file, Object requestor, long modStamp, long l) throws IOException {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(40);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Nullable
    public VirtualFile findLocalByRootPath(@NotNull String rootPath) {
        if (rootPath == null) {
            ArchiveFileSystem.$$$reportNull$$$0(41);
        }
        String localPath = this.extractLocalPath(rootPath);
        VirtualFile local = StandardFileSystems.local().findFileByPath(localPath);
        return local != null && this.isCorrectFileType(local) ? local : null;
    }

    protected boolean isCorrectFileType(@NotNull VirtualFile local) {
        if (local == null) {
            ArchiveFileSystem.$$$reportNull$$$0(42);
        }
        return FileTypeRegistry.getInstance().getFileTypeByFileName(local.getNameSequence()) == ArchiveFileType.INSTANCE;
    }

    @ApiStatus.Internal
    public final void clearArchiveCache(@NotNull VirtualFile sampleEntry) {
        if (sampleEntry == null) {
            ArchiveFileSystem.$$$reportNull$$$0(43);
        }
        this.getHandler(sampleEntry).clearCaches();
    }

    @ApiStatus.Internal
    @NotNull
    public static String getLocalPath(@NotNull ArchiveFileSystem vfs, @NotNull String entryPath) {
        if (vfs == null) {
            ArchiveFileSystem.$$$reportNull$$$0(44);
        }
        if (entryPath == null) {
            ArchiveFileSystem.$$$reportNull$$$0(45);
        }
        String string = vfs.extractLocalPath(entryPath);
        if (string == null) {
            ArchiveFileSystem.$$$reportNull$$$0(46);
        }
        return string;
    }

    @ApiStatus.Internal
    @NotNull
    public static String composeRootPath(@NotNull ArchiveFileSystem fileSystem, @NotNull String localPath) {
        if (fileSystem == null) {
            ArchiveFileSystem.$$$reportNull$$$0(47);
        }
        if (localPath == null) {
            ArchiveFileSystem.$$$reportNull$$$0(48);
        }
        String string = fileSystem.composeRootPath(localPath);
        if (string == null) {
            ArchiveFileSystem.$$$reportNull$$$0(49);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 18, 21, 23, 24, 26, 28, 35, 37, 46, 49 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 35: 
            case 37: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleEntry";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfs";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryPath";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootPathByLocal";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "childrenWithAttributes";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "listWithAttributes";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getArchiveRootAttributes";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalPath";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "composeRootPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootByLocal";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRootPathByLocal";
                break;
            }
            case 2: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 35: 
            case 37: 
            case 46: 
            case 49: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRootByEntry";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLocalByEntry";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "childrenWithAttributes";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "listWithAttributes";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getArchiveRootAttributes";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setTimeStamp";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setWritable";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getOutputStream";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findLocalByRootPath";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isCorrectFileType";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "clearArchiveCache";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getLocalPath";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "composeRootPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 18, 21, 23, 24, 26, 28, 35, 37, 46, 49 -> new IllegalStateException(string);
        };
    }
}

