/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.util.containers.FList;
import com.intellij.util.text.NameUtilCore;
import com.intellij.util.text.matching.AsciiUtils;
import com.intellij.util.text.matching.CharArrayUtilKt;
import com.intellij.util.text.matching.MatchedFragment;
import com.intellij.util.text.matching.MatchedFragmentKt;
import com.intellij.util.text.matching.MatchingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0018\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001:\u0005@ABCDB!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\fH\u0002J$\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010%\u001a\u00020#H\u0002J(\u0010&\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\f2\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"H\u0016J*\u0010&\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\f2\u0010\u0010(\u001a\f\u0012\u0006\b\u0001\u0012\u00020*\u0018\u00010)H\u0017J@\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u00020\f2\u0006\u00101\u001a\u00020\f2\u0006\u00102\u001a\u00020\u001cH\u0002J\u0018\u00103\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"2\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\u0018\u00104\u001a\n\u0012\u0004\u0012\u00020*\u0018\u00010)2\u0006\u0010\u001e\u001a\u00020\u0003H\u0017J\u0010\u00105\u001a\u00020\f2\u0006\u00106\u001a\u00020\u001cH\u0002J\u000f\u00107\u001a\u00070\u0003\u00a2\u0006\u0002\b8H\u0097\u0080\u0004J\u0017\u0010<\u001a\u0004\u0018\u00010\u001c2\u0006\u0010=\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010>J\u0017\u0010?\u001a\u0004\u0018\u00010\u001c2\u0006\u0010=\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010>R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\n0:X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010;\u00a8\u0006E"}, d2={"Lcom/intellij/psi/codeStyle/TypoTolerantMatcher;", "Lcom/intellij/psi/codeStyle/MinusculeMatcher;", "pattern", "", "myMatchingMode", "Lcom/intellij/util/text/matching/MatchingMode;", "hardSeparators", "<init>", "(Ljava/lang/String;Lcom/intellij/util/text/matching/MatchingMode;Ljava/lang/String;)V", "myPattern", "", "myMixedCase", "", "myHasSeparators", "myHasDots", "isLowerCase", "", "isUpperCase", "isWordSeparator", "toUpperCase", "toLowerCase", "myMeaningfulCharacters", "myMinNameLength", "", "myHardSeparators", "getPattern", "()Ljava/lang/String;", "c", "", "nextWord", "name", "start", "isAsciiName", "appendRange", "", "Lcom/intellij/util/text/matching/MatchedFragment;", "ranges", "range", "matchingDegree", "valueStartCaseMatch", "fragments", "Lcom/intellij/util/containers/FList;", "Lcom/intellij/openapi/util/TextRange;", "evaluateCaseMatching", "valuedStartMatch", "patternIndex", "humpStartMatchedUpperCase", "nameIndex", "afterGap", "isHumpStart", "nameChar", "match", "matchingFragments", "isWildcard", "ch", "toString", "Lorg/jetbrains/annotations/NonNls;", "keyboard", "", "[[C", "leftMiss", "aChar", "(C)Ljava/lang/Character;", "rightMiss", "Session", "ErrorWithIndex", "ErrorState", "Error", "Fragment", "intellij.platform.util.text.matching"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTypoTolerantMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypoTolerantMatcher.kt\ncom/intellij/psi/codeStyle/TypoTolerantMatcher\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,902:1\n14205#2,3:903\n*S KotlinDebug\n*F\n+ 1 TypoTolerantMatcher.kt\ncom/intellij/psi/codeStyle/TypoTolerantMatcher\n*L\n60#1:903,3\n*E\n"})
public final class TypoTolerantMatcher
extends MinusculeMatcher {
    @NotNull
    private final MatchingMode myMatchingMode;
    @NotNull
    private final char[] myPattern;
    private final boolean myMixedCase;
    private final boolean myHasSeparators;
    private final boolean myHasDots;
    @NotNull
    private final boolean[] isLowerCase;
    @NotNull
    private final boolean[] isUpperCase;
    @NotNull
    private final boolean[] isWordSeparator;
    @NotNull
    private final char[] toUpperCase;
    @NotNull
    private final char[] toLowerCase;
    @NotNull
    private final char[] myMeaningfulCharacters;
    private final int myMinNameLength;
    @NotNull
    private final char[] myHardSeparators;
    @NotNull
    private final char[][] keyboard;

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public TypoTolerantMatcher(@NotNull String pattern, @NotNull MatchingMode myMatchingMode, @NotNull String hardSeparators) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)((Object)myMatchingMode), (String)"myMatchingMode");
        Intrinsics.checkNotNullParameter((Object)hardSeparators, (String)"hardSeparators");
        this.myMatchingMode = myMatchingMode;
        char[] cArray = hardSeparators.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        this.myHardSeparators = cArray;
        char[] cArray2 = StringsKt.removeSuffix((String)pattern, (CharSequence)"* ").toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"toCharArray(...)");
        this.myPattern = cArray2;
        this.isLowerCase = new boolean[this.myPattern.length];
        this.isUpperCase = new boolean[this.myPattern.length];
        this.isWordSeparator = new boolean[this.myPattern.length];
        this.toUpperCase = new char[this.myPattern.length];
        this.toLowerCase = new char[this.myPattern.length];
        List meaningful = new ArrayList();
        boolean seenNonWildcard = false;
        boolean seenLowerCase = false;
        boolean seenUpperCaseNotImmediatelyAfterWildcard = false;
        boolean hasDots = false;
        boolean hasSeparators = false;
        char[] $this$forEachIndexed$iv = this.myPattern;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (char item$iv : $this$forEachIndexed$iv) {
            void c;
            int n = index$iv++;
            char c2 = item$iv;
            int k = n;
            boolean bl = false;
            boolean isWordSeparator = this.isWordSeparator((char)c);
            boolean isUpperCase = Character.isUpperCase((char)c);
            boolean isLowerCase = Character.isLowerCase((char)c);
            char toUpperCase = Character.toUpperCase((char)c);
            char toLowerCase = Character.toLowerCase((char)c);
            if (isLowerCase) {
                seenLowerCase = true;
            }
            if (c == 46) {
                hasDots = true;
            }
            if (seenNonWildcard && isUpperCase) {
                seenUpperCaseNotImmediatelyAfterWildcard = true;
            }
            if (!this.isWildcard((char)c)) {
                seenNonWildcard = true;
                meaningful.add(Character.valueOf(toLowerCase));
                meaningful.add(Character.valueOf(toUpperCase));
            }
            if (seenNonWildcard && isWordSeparator) {
                hasSeparators = true;
            }
            this.isWordSeparator[k] = isWordSeparator;
            this.isUpperCase[k] = isUpperCase;
            this.isLowerCase[k] = isLowerCase;
            this.toUpperCase[k] = toUpperCase;
            this.toLowerCase[k] = toLowerCase;
        }
        this.myHasDots = hasDots;
        this.myMixedCase = seenLowerCase && seenUpperCaseNotImmediatelyAfterWildcard;
        this.myHasSeparators = hasSeparators;
        this.myMeaningfulCharacters = CollectionsKt.toCharArray((Collection)meaningful);
        this.myMinNameLength = this.myMeaningfulCharacters.length / 2;
        char[][] cArrayArray = new char[3][];
        char[] cArray3 = new char[]{'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p'};
        cArrayArray[0] = cArray3;
        cArray3 = new char[]{'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l'};
        cArrayArray[1] = cArray3;
        cArray3 = new char[]{'z', 'x', 'c', 'v', 'b', 'n', 'm'};
        cArrayArray[2] = cArray3;
        this.keyboard = cArrayArray;
    }

    @Override
    @NotNull
    public String getPattern() {
        return StringsKt.concatToString((char[])this.myPattern);
    }

    private final boolean isWordSeparator(char c) {
        return CharsKt.isWhitespace((char)c) || c == '_' || c == '-' || c == ':' || c == '+' || c == '.';
    }

    private final int nextWord(String name, int start, boolean isAsciiName) {
        return start < name.length() && Character.isDigit(name.charAt(start)) ? start + 1 : (isAsciiName ? AsciiUtils.INSTANCE.nextWordAscii(name, start) : NameUtilCore.nextWord((String)name, (int)start));
    }

    private final List<MatchedFragment> appendRange(List<MatchedFragment> ranges, MatchedFragment range) {
        if (ranges.isEmpty()) {
            Object[] objectArray = new MatchedFragment[]{range};
            return CollectionsKt.mutableListOf((Object[])objectArray);
        }
        if (!TypeIntrinsics.isMutableList(ranges)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        MatchedFragment last = (MatchedFragment)CollectionsKt.last(ranges);
        if (last.getStartOffset() == range.getEndOffset()) {
            ranges.set(ranges.size() - 1, new MatchedFragment(range.getStartOffset(), last.getEndOffset(), range.getErrorCount() + last.getErrorCount()));
        } else {
            ranges.add(range);
        }
        return ranges;
    }

    @Override
    public int matchingDegree(@NotNull String name, boolean valueStartCaseMatch, @Nullable List<MatchedFragment> fragments) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (fragments == null) {
            return Integer.MIN_VALUE;
        }
        if (fragments.isEmpty()) {
            return 0;
        }
        MatchedFragment first = (MatchedFragment)CollectionsKt.first(fragments);
        boolean startMatch = first.getStartOffset() == 0;
        boolean valuedStartMatch = startMatch && valueStartCaseMatch;
        int errors = 0;
        int matchingCase = 0;
        int p = -1;
        int skippedHumps = 0;
        int nextHumpStart = 0;
        boolean humpStartMatchedUpperCase = false;
        for (MatchedFragment range : fragments) {
            int n = range.getEndOffset();
            for (int i = range.getStartOffset(); i < n; ++i) {
                boolean afterGap = i == range.getStartOffset() && first != range;
                boolean isHumpStart = false;
                while (nextHumpStart <= i) {
                    if (nextHumpStart == i) {
                        isHumpStart = true;
                    } else if (afterGap) {
                        ++skippedHumps;
                    }
                    nextHumpStart = this.nextWord(name, nextHumpStart, false);
                }
                char c = name.charAt(i);
                p = CharArrayUtilKt.indexOf(this.myPattern, c, p + 1, this.myPattern.length, true);
                if (p < 0) break;
                if (isHumpStart) {
                    humpStartMatchedUpperCase = c == this.myPattern[p] && this.isUpperCase[p];
                }
                matchingCase += this.evaluateCaseMatching(valuedStartMatch, p, humpStartMatchedUpperCase, i, afterGap, isHumpStart, c);
            }
            errors += (int)(2000.0 * Math.pow(1.0 * (double)range.getErrorCount() / (double)range.getLength(), 2));
        }
        int startIndex = first.getStartOffset();
        boolean afterSeparator = CharArrayUtilKt.indexOfAny(name, this.myHardSeparators, 0, startIndex) >= 0;
        boolean wordStart = startIndex == 0 || NameUtilCore.isWordStart((String)name, (int)startIndex) && !NameUtilCore.isWordStart((String)name, (int)(startIndex - 1));
        boolean finalMatch = ((MatchedFragment)CollectionsKt.last(fragments)).getEndOffset() == name.length();
        return (wordStart ? 1000 : 0) + matchingCase - fragments.size() + -skippedHumps * 10 - errors + (afterSeparator ? 0 : 2) + (startMatch ? 1 : 0) + (finalMatch ? 1 : 0);
    }

    @Override
    @Deprecated(message="use matchingDegree(String, Boolean, List<MatchedFragment>)", replaceWith=@ReplaceWith(expression="matchingDegree(name, valueStartCaseMatch, fragments.map { MatchedFragment(it.startOffset, it.endOffset) })", imports={}))
    public int matchingDegree(@NotNull String name, boolean valueStartCaseMatch, @Nullable FList<? extends TextRange> fragments) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        FList<? extends TextRange> fList = fragments;
        return this.matchingDegree(name, valueStartCaseMatch, fList != null ? MatchedFragmentKt.undeprecate(fList) : null);
    }

    private final int evaluateCaseMatching(boolean valuedStartMatch, int patternIndex, boolean humpStartMatchedUpperCase, int nameIndex, boolean afterGap, boolean isHumpStart, char nameChar) {
        return afterGap && isHumpStart && this.isLowerCase[patternIndex] ? -10 : (nameChar == this.myPattern[patternIndex] ? (this.isUpperCase[patternIndex] ? 50 : (nameIndex == 0 && valuedStartMatch ? 150 : (isHumpStart ? 1 : 0))) : (isHumpStart ? -1 : (this.isLowerCase[patternIndex] && humpStartMatchedUpperCase ? -1 : 0)));
    }

    @Override
    @Nullable
    public List<MatchedFragment> match(@NotNull String name) {
        List<MatchedFragment> list;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (name.length() >= this.myMinNameLength) {
            boolean ascii = AsciiUtils.INSTANCE.isAscii(name);
            list = new Session(name, false, ascii).matchingFragments();
            if (list == null) {
                list = new Session(name, true, ascii).matchingFragments();
            }
        } else {
            list = null;
        }
        return list;
    }

    @Override
    @Deprecated(message="use match(String)", replaceWith=@ReplaceWith(expression="match(name)", imports={}))
    @Nullable
    public FList<TextRange> matchingFragments(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List<MatchedFragment> list = this.match(name);
        return list != null ? MatchedFragmentKt.deprecated(list) : null;
    }

    private final boolean isWildcard(char ch) {
        return ch == ' ' || ch == '*';
    }

    @NonNls
    @NotNull
    public String toString() {
        return "TypoTolerantMatcher{myPattern=" + this.getPattern() + ", myMatchingMode=" + this.myMatchingMode + "}";
    }

    private final Character leftMiss(char aChar) {
        boolean isUpperCase = AsciiUtils.INSTANCE.isUpperAscii(aChar);
        char lc = isUpperCase ? AsciiUtils.INSTANCE.toLowerAscii(aChar) : aChar;
        char[][] cArray = this.keyboard;
        int n = ((Object[])cArray).length;
        for (int i = 0; i < n; ++i) {
            char[] line = cArray[i];
            int n2 = line.length;
            for (int j = 0; j < n2; ++j) {
                char c = line[j];
                if (c != lc) continue;
                return j > 0 ? Character.valueOf(isUpperCase ? AsciiUtils.INSTANCE.toUpperAscii(line[j - 1]) : line[j - 1]) : null;
            }
        }
        return null;
    }

    private final Character rightMiss(char aChar) {
        boolean isUpperCase = AsciiUtils.INSTANCE.isUpperAscii(aChar);
        char lc = isUpperCase ? AsciiUtils.INSTANCE.toLowerAscii(aChar) : aChar;
        char[][] cArray = this.keyboard;
        int n = ((Object[])cArray).length;
        for (int i = 0; i < n; ++i) {
            char[] line = cArray[i];
            int n2 = line.length;
            for (int j = 0; j < n2; ++j) {
                char c = line[j];
                if (c != lc) continue;
                return j + 1 < line.length ? Character.valueOf(isUpperCase ? AsciiUtils.INSTANCE.toUpperAscii(line[j + 1]) : line[j + 1]) : null;
            }
        }
        return null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/psi/codeStyle/TypoTolerantMatcher$Error;", "", "TypoError", "SwapError", "MissError", "Lcom/intellij/psi/codeStyle/TypoTolerantMatcher$Error$MissError;", "Lcom/intellij/psi/codeStyle/TypoTolerantMatcher$Error$SwapError;", "Lcom/intellij/psi/codeStyle/TypoTolerantMatcher$Error$TypoError;", "intellij.platform.util.text.matching"})
    private static sealed interface Error {

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0083\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u00d6\u0081\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/psi/codeStyle/TypoTolerantMatcher$Error$MissError;", "Lcom/intellij/psi/codeStyle/TypoTolerantMatcher$Error;", "missedChar", "", "<init>", "(C)V", "getMissedChar", "()C", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.util.text.matching"})
        public static final class MissError
        implements Error {
            private final char missedChar;

            public MissError(char missedChar) {
                this.missedChar = missedChar;
            }

            public final char getMissedChar() {
                return this.missedChar;
            }

            public final char component1() {
                return this.missedChar;
            }

            @NotNull
            public final MissError copy(char missedChar) {
                return new MissError(missedChar);
            }

            public static /* synthetic */ MissError copy$default(MissError missError, char c, int n, Object object) {
                if ((n & 1) != 0) {
                    c = missError.missedChar;
                }
                return missError.copy(c);
            }

            @NotNull
            public String toString() {
                return "MissError(missedChar=" + this.missedChar + ")";
            }

            public int hashCode() {
                return Character.hashCode(this.missedChar);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MissError)) {
                    return false;
                }
                MissError missError = (MissError)other;
                return this.missedChar == missError.missedChar;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/psi/codeStyle/TypoTolerantMatcher$Error$SwapError;", "Lcom/intellij/psi/codeStyle/TypoTolerantMatcher$Error;", "<init>", "()V", "intellij.platform.util.text.matching"})
        public static final class SwapError
        implements Error {
            @NotNull
            public static final SwapError INSTANCE = new SwapError();

            private SwapError() {
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0083\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u00d6\u0081\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/psi/codeStyle/TypoTolerantMatcher$Error$TypoError;", "Lcom/intellij/psi/codeStyle/TypoTolerantMatcher$Error;", "correctChar", "", "<init>", "(C)V", "getCorrectChar", "()C", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.util.text.matching"})
        public static final class TypoError
        implements Error {
            private final char correctChar;

            public TypoError(char correctChar) {
                this.correctChar = correctChar;
            }

            public final char getCorrectChar() {
                return this.correctChar;
            }

            public final char component1() {
                return this.correctChar;
            }

            @NotNull
            public final TypoError copy(char correctChar) {
                return new TypoError(correctChar);
            }

            public static /* synthetic */ TypoError copy$default(TypoError typoError, char c, int n, Object object) {
                if ((n & 1) != 0) {
                    c = typoError.correctChar;
                }
                return typoError.copy(c);
            }

            @NotNull
            public String toString() {
                return "TypoError(correctChar=" + this.correctChar + ")";
            }

            public int hashCode() {
                return Character.hashCode(this.correctChar);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TypoError)) {
                    return false;
                }
                TypoError typoError = (TypoError)other;
                return this.correctChar == typoError.correctChar;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0004J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0004J\u0016\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0004J\u0018\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\rH\u0002J\u001c\u0010 \u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u001bH\u0002J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u0011\u001a\u00020\u0004J\u000e\u0010$\u001a\u00020#2\u0006\u0010\u0011\u001a\u00020\u0004J\u0010\u0010%\u001a\u0004\u0018\u00010\u00152\u0006\u0010&\u001a\u00020\u0004J\u000e\u0010'\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004J\u000e\u0010(\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u000fR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/psi/codeStyle/TypoTolerantMatcher$ErrorState;", "", "myBase", "myDeriveIndex", "", "<init>", "(Lcom/intellij/psi/codeStyle/TypoTolerantMatcher$ErrorState;I)V", "myAffected", "Ljava/util/BitSet;", "Lcom/intellij/util/text/matching/BitSet;", "myAllAffectedAfter", "myErrors", "", "Lcom/intellij/psi/codeStyle/TypoTolerantMatcher$ErrorWithIndex;", "myPattern", "", "deriveFrom", "index", "addError", "", "error", "Lcom/intellij/psi/codeStyle/TypoTolerantMatcher$Error;", "updateAffected", "countErrors", "start", "end", "getChar", "", "pattern", "applyErrors", "upToIndex", "applyError", "insert", "element", "affects", "", "localAffects", "getError", "i", "numMisses", "length", "intellij.platform.util.text.matching"})
    @SourceDebugExtension(value={"SMAP\nTypoTolerantMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypoTolerantMatcher.kt\ncom/intellij/psi/codeStyle/TypoTolerantMatcher$ErrorState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,902:1\n1#2:903\n*E\n"})
    private static final class ErrorState {
        @Nullable
        private final ErrorState myBase;
        private final int myDeriveIndex;
        @Nullable
        private BitSet myAffected;
        private int myAllAffectedAfter;
        @Nullable
        private List<ErrorWithIndex> myErrors;
        @Nullable
        private char[] myPattern;

        public ErrorState(@Nullable ErrorState myBase, int myDeriveIndex) {
            this.myBase = myBase;
            this.myDeriveIndex = myDeriveIndex;
            this.myAllAffectedAfter = Integer.MAX_VALUE;
        }

        public /* synthetic */ ErrorState(ErrorState errorState, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                errorState = null;
            }
            if ((n2 & 2) != 0) {
                n = 0;
            }
            this(errorState, n);
        }

        @NotNull
        public final ErrorState deriveFrom(int index) {
            return new ErrorState(this, index);
        }

        public final void addError(int index, @NotNull Error error) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                List list = this.myErrors;
                if (list == null) {
                    List list2;
                    List it = list2 = (List)new ArrayList();
                    boolean bl = false;
                    this.myErrors = it;
                    list = list2;
                }
                List errors = list;
                ErrorWithIndex errorWithIndex = new ErrorWithIndex(index, error);
                errors.add((ErrorWithIndex)errorWithIndex);
                this.updateAffected(index, error);
                if (this.myPattern == null) break block1;
                char[] it = this.myPattern;
                boolean bl = false;
                this.myPattern = this.applyError(it, errorWithIndex);
            }
        }

        private final void updateAffected(int index, Error error) {
            BitSet bitSet = this.myAffected;
            if (bitSet == null) {
                BitSet bitSet2;
                BitSet it = bitSet2 = new BitSet();
                boolean bl = false;
                this.myAffected = it;
                bitSet = bitSet2;
            }
            BitSet affected = bitSet;
            affected.set(index);
            Error error2 = error;
            if (error2 instanceof Error.SwapError) {
                affected.set(index + 1);
            } else if (error2 instanceof Error.MissError) {
                this.myAllAffectedAfter = Math.min(index, this.myAllAffectedAfter);
            } else if (!(error2 instanceof Error.TypoError)) {
                throw new NoWhenBranchMatchedException();
            }
        }

        public final int countErrors(int start, int end) {
            int errors = 0;
            if (this.myBase != null && start < this.myDeriveIndex) {
                errors += this.myBase.countErrors(start, this.myDeriveIndex);
            }
            if (this.myErrors != null) {
                for (ErrorWithIndex error : this.myErrors) {
                    int n = error.getIndex();
                    boolean bl = start <= n ? n < end : false;
                    if (!bl) continue;
                    ++errors;
                }
            }
            return errors;
        }

        public final char getChar(@NotNull char[] pattern, int index) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            char[] cArray = this.myPattern;
            if (this.myPattern == null) {
                char[] cArray2;
                char[] cArray3 = Arrays.copyOf(pattern, pattern.length);
                Intrinsics.checkNotNullExpressionValue((Object)cArray3, (String)"copyOf(...)");
                char[] it = cArray2 = this.applyErrors(cArray3, Integer.MAX_VALUE);
                boolean bl = false;
                this.myPattern = it;
                cArray = cArray2;
            }
            char[] pattern2 = cArray;
            return pattern2[index];
        }

        @NotNull
        public final char[] applyErrors(@NotNull char[] pattern, int upToIndex) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            char[] result = pattern;
            if (this.myBase != null) {
                result = this.myBase.applyErrors(pattern, Math.min(this.myDeriveIndex, upToIndex));
            }
            if (this.myErrors != null) {
                for (ErrorWithIndex error : this.myErrors) {
                    if (error.getIndex() >= upToIndex) continue;
                    result = this.applyError(result, error);
                }
            }
            return result;
        }

        private final char[] applyError(char[] pattern, ErrorWithIndex error) {
            char[] cArray;
            Error e = error.getError();
            if (e instanceof Error.TypoError) {
                pattern[error.getIndex()] = ((Error.TypoError)e).getCorrectChar();
                cArray = pattern;
            } else if (e instanceof Error.SwapError) {
                int index = error.getIndex();
                char c = pattern[index];
                pattern[index] = pattern[index + 1];
                pattern[index + 1] = c;
                cArray = pattern;
            } else if (e instanceof Error.MissError) {
                cArray = this.insert(pattern, error.getIndex(), ((Error.MissError)e).getMissedChar());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return cArray;
        }

        private final char[] insert(char[] $this$insert, int index, char element) {
            char[] cArray;
            if ($this$insert.length == index) {
                cArray = ArraysKt.plus((char[])$this$insert, (char)element);
            } else {
                char[] cArray2;
                char[] destination = cArray2 = new char[$this$insert.length + 1];
                boolean bl = false;
                ArraysKt.copyInto((char[])$this$insert, (char[])destination, (int)0, (int)0, (int)index);
                destination[index] = element;
                ArraysKt.copyInto$default((char[])$this$insert, (char[])destination, (int)(index + 1), (int)index, (int)0, (int)8, null);
                cArray = cArray2;
            }
            return cArray;
        }

        public final boolean affects(int index) {
            return this.localAffects(index) || this.myBase != null && this.myBase.affects(index);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean localAffects(int index) {
            if (index >= this.myAllAffectedAfter) return true;
            if (this.myAffected == null) return false;
            BitSet bitSet = this.myAffected;
            Intrinsics.checkNotNull((Object)bitSet);
            if (!bitSet.get(index)) return false;
            return true;
        }

        @Nullable
        public final Error getError(int i) {
            if (this.myErrors != null) {
                BitSet bitSet = this.myAffected;
                Intrinsics.checkNotNull((Object)bitSet);
                if (bitSet.get(i)) {
                    for (ErrorWithIndex error : this.myErrors) {
                        if (error.getIndex() != i) continue;
                        return error.getError();
                    }
                }
            }
            if (this.myBase != null && this.myDeriveIndex > i) {
                return this.myBase.getError(i);
            }
            return null;
        }

        public final int numMisses(int end) {
            int numMisses = 0;
            if (this.myErrors != null && end > 0) {
                for (ErrorWithIndex error : this.myErrors) {
                    if (error.getIndex() >= end || !(error.getError() instanceof Error.MissError)) continue;
                    ++numMisses;
                }
            }
            ErrorState errorState = this.myBase;
            return numMisses + (errorState != null ? errorState.numMisses(this.myDeriveIndex) : 0);
        }

        public final int length(@NotNull char[] pattern) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            if (this.myPattern != null) {
                Intrinsics.checkNotNull((Object)this.myPattern);
                return this.myPattern.length;
            }
            return pattern.length + this.numMisses(Integer.MAX_VALUE);
        }

        public ErrorState() {
            this(null, 0, 3, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/psi/codeStyle/TypoTolerantMatcher$ErrorWithIndex;", "", "index", "", "error", "Lcom/intellij/psi/codeStyle/TypoTolerantMatcher$Error;", "<init>", "(ILcom/intellij/psi/codeStyle/TypoTolerantMatcher$Error;)V", "getIndex", "()I", "getError", "()Lcom/intellij/psi/codeStyle/TypoTolerantMatcher$Error;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.util.text.matching"})
    private static final class ErrorWithIndex {
        private final int index;
        @NotNull
        private final Error error;

        public ErrorWithIndex(int index, @NotNull Error error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            this.index = index;
            this.error = error;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final Error getError() {
            return this.error;
        }

        public final int component1() {
            return this.index;
        }

        @NotNull
        public final Error component2() {
            return this.error;
        }

        @NotNull
        public final ErrorWithIndex copy(int index, @NotNull Error error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            return new ErrorWithIndex(index, error);
        }

        public static /* synthetic */ ErrorWithIndex copy$default(ErrorWithIndex errorWithIndex, int n, Error error, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = errorWithIndex.index;
            }
            if ((n2 & 2) != 0) {
                error = errorWithIndex.error;
            }
            return errorWithIndex.copy(n, error);
        }

        @NotNull
        public String toString() {
            return "ErrorWithIndex(index=" + this.index + ", error=" + this.error + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.index);
            result = result * 31 + this.error.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ErrorWithIndex)) {
                return false;
            }
            ErrorWithIndex errorWithIndex = (ErrorWithIndex)other;
            if (this.index != errorWithIndex.index) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.error, (Object)errorWithIndex.error);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/psi/codeStyle/TypoTolerantMatcher$Fragment;", "", "length", "", "errorState", "Lcom/intellij/psi/codeStyle/TypoTolerantMatcher$ErrorState;", "<init>", "(ILcom/intellij/psi/codeStyle/TypoTolerantMatcher$ErrorState;)V", "getLength", "()I", "getErrorState", "()Lcom/intellij/psi/codeStyle/TypoTolerantMatcher$ErrorState;", "intellij.platform.util.text.matching"})
    private static final class Fragment {
        private final int length;
        @NotNull
        private final ErrorState errorState;

        public Fragment(int length, @NotNull ErrorState errorState) {
            Intrinsics.checkNotNullParameter((Object)errorState, (String)"errorState");
            this.length = length;
            this.errorState = errorState;
        }

        public final int getLength() {
            return this.length;
        }

        @NotNull
        public final ErrorState getErrorState() {
            return this.errorState;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\rH\u0002J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u0016\u0010\u0014\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0015\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0016\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0017\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aJ&\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J0\u0010 \u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J0\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010%\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010&\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J0\u0010'\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010*\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010-\u001a\u00020\u000fH\u0002J(\u0010.\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010/\u001a\u00020,H\u0002J \u00100\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J6\u00101\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u00102\u001a\u00020\r2\u0006\u00103\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ6\u00104\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u00105\u001a\u00020\r2\u0006\u00103\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u00106\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ&\u00107\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u00108\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u00109\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010:\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010;\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010<\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010=\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010>\u001a\u00020\r2\u0006\u0010?\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010@\u001a\u00020\r2\u0006\u0010?\u001a\u00020\r2\u0006\u0010A\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/intellij/psi/codeStyle/TypoTolerantMatcher$Session;", "", "myName", "", "myTypoAware", "", "isAsciiName", "<init>", "(Lcom/intellij/psi/codeStyle/TypoTolerantMatcher;Ljava/lang/String;ZZ)V", "myAllowTypos", "charAt", "", "i", "", "errorState", "Lcom/intellij/psi/codeStyle/TypoTolerantMatcher$ErrorState;", "isWildcard", "patternIndex", "equalsIgnoreCase", "nameChar", "isLowerCase", "isUpperCase", "isDigit", "isWordSeparator", "patternLength", "matchingFragments", "", "Lcom/intellij/util/text/matching/MatchedFragment;", "matchWildcards", "nameIndex", "isTrailingSpacePattern", "isUpperCaseOrDigit", "matchSkippingWords", "allowSpecialChars", "findNextPatternCharOccurrence", "startAt", "wordStartsOnly", "seemsLikeFragmentStart", "nextOccurrence", "charEquals", "isIgnoreCase", "allowTypos", "matchFragment", "maxMatchingFragment", "Lcom/intellij/psi/codeStyle/TypoTolerantMatcher$Fragment;", "baseErrorState", "matchInsideFragment", "fragment", "isMiddleMatch", "findLongestMatchingPrefix", "fragmentLength", "minFragment", "improveCamelHumps", "maxFragment", "isUppercasePatternVsLowercaseNameChar", "findUppercaseMatchFurther", "isFirstCharMatching", "hasCase", "isPatternChar", "c", "indexOfWordStart", "startFrom", "indexOfIgnoreCase", "fromIndex", "indexIgnoringCaseAscii", "p", "intellij.platform.util.text.matching"})
    @SourceDebugExtension(value={"SMAP\nTypoTolerantMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypoTolerantMatcher.kt\ncom/intellij/psi/codeStyle/TypoTolerantMatcher$Session\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,902:1\n1#2:903\n*E\n"})
    private final class Session {
        @NotNull
        private final String myName;
        private final boolean myTypoAware;
        private final boolean isAsciiName;
        private final boolean myAllowTypos;

        public Session(String myName, boolean myTypoAware, boolean isAsciiName) {
            Intrinsics.checkNotNullParameter((Object)myName, (String)"myName");
            this.myName = myName;
            this.myTypoAware = myTypoAware;
            this.isAsciiName = isAsciiName;
            this.myAllowTypos = this.myTypoAware && this.isAsciiName;
        }

        private final char charAt(int i, ErrorState errorState) {
            return errorState.affects(i) ? errorState.getChar(TypoTolerantMatcher.this.myPattern, i) : TypoTolerantMatcher.this.myPattern[i];
        }

        private final boolean isWildcard(int patternIndex) {
            return (0 <= patternIndex ? patternIndex < TypoTolerantMatcher.this.myPattern.length : false) && TypoTolerantMatcher.this.isWildcard(TypoTolerantMatcher.this.myPattern[patternIndex]);
        }

        private final boolean equalsIgnoreCase(int patternIndex, ErrorState errorState, char nameChar) {
            if (errorState.affects(patternIndex)) {
                char patternChar = errorState.getChar(TypoTolerantMatcher.this.myPattern, patternIndex);
                return AsciiUtils.INSTANCE.toLowerAscii(patternChar) == nameChar || AsciiUtils.INSTANCE.toUpperAscii(patternChar) == nameChar;
            }
            return TypoTolerantMatcher.this.toLowerCase[patternIndex] == nameChar || TypoTolerantMatcher.this.toUpperCase[patternIndex] == nameChar;
        }

        public final boolean isLowerCase(int i, @NotNull ErrorState errorState) {
            Intrinsics.checkNotNullParameter((Object)errorState, (String)"errorState");
            return errorState.affects(i) ? AsciiUtils.INSTANCE.isLowerAscii(errorState.getChar(TypoTolerantMatcher.this.myPattern, i)) : TypoTolerantMatcher.this.isLowerCase[i];
        }

        public final boolean isUpperCase(int i, @NotNull ErrorState errorState) {
            Intrinsics.checkNotNullParameter((Object)errorState, (String)"errorState");
            return errorState.affects(i) ? AsciiUtils.INSTANCE.isUpperAscii(errorState.getChar(TypoTolerantMatcher.this.myPattern, i)) : TypoTolerantMatcher.this.isUpperCase[i];
        }

        public final boolean isDigit(int i, @NotNull ErrorState errorState) {
            Intrinsics.checkNotNullParameter((Object)errorState, (String)"errorState");
            return errorState.affects(i) ? Character.isDigit(errorState.getChar(TypoTolerantMatcher.this.myPattern, i)) : Character.isDigit(TypoTolerantMatcher.this.myPattern[i]);
        }

        public final boolean isWordSeparator(int i, @NotNull ErrorState errorState) {
            Intrinsics.checkNotNullParameter((Object)errorState, (String)"errorState");
            return errorState.affects(i) ? TypoTolerantMatcher.this.isWordSeparator(errorState.getChar(TypoTolerantMatcher.this.myPattern, i)) : TypoTolerantMatcher.this.isWordSeparator[i];
        }

        public final int patternLength(@NotNull ErrorState errorState) {
            Intrinsics.checkNotNullParameter((Object)errorState, (String)"errorState");
            return errorState.length(TypoTolerantMatcher.this.myPattern);
        }

        @Nullable
        public final List<MatchedFragment> matchingFragments() {
            int length = this.myName.length();
            if (length < TypoTolerantMatcher.this.myMinNameLength) {
                return null;
            }
            if (this.myTypoAware && !this.isAsciiName) {
                return null;
            }
            if (!this.myTypoAware) {
                int patternIndex = 0;
                if (!(TypoTolerantMatcher.this.myMeaningfulCharacters.length == 0)) {
                    char c;
                    String string = this.myName;
                    int n = string.length();
                    for (int i = 0; i < n && ((c = string.charAt(i)) != TypoTolerantMatcher.this.myMeaningfulCharacters[patternIndex] && c != TypoTolerantMatcher.this.myMeaningfulCharacters[patternIndex + 1] || (patternIndex += 2) < TypoTolerantMatcher.this.myMeaningfulCharacters.length); ++i) {
                    }
                }
                if (patternIndex < TypoTolerantMatcher.this.myMinNameLength * 2) {
                    return null;
                }
            }
            List<MatchedFragment> list = this.matchWildcards(0, 0, new ErrorState(null, 0, 3, null));
            return list != null ? CollectionsKt.asReversed(list) : null;
        }

        @Nullable
        public final List<MatchedFragment> matchWildcards(int patternIndex, int nameIndex, @NotNull ErrorState errorState) {
            Intrinsics.checkNotNullParameter((Object)errorState, (String)"errorState");
            int patternIndex2 = patternIndex;
            if (nameIndex < 0) {
                return null;
            }
            if (!this.isWildcard(patternIndex2)) {
                return patternIndex2 == this.patternLength(errorState) ? CollectionsKt.emptyList() : this.matchFragment(patternIndex2, nameIndex, errorState);
            }
            while (this.isWildcard(++patternIndex2)) {
            }
            if (patternIndex2 == this.patternLength(errorState)) {
                List list;
                if (this.isTrailingSpacePattern(errorState) && nameIndex != this.myName.length() && (patternIndex2 < 2 || !this.isUpperCaseOrDigit(patternIndex2 - 2, errorState))) {
                    int spaceIndex = StringsKt.indexOf$default((CharSequence)this.myName, (char)' ', (int)nameIndex, (boolean)false, (int)4, null);
                    if (spaceIndex >= 0) {
                        Object[] objectArray = new MatchedFragment[]{new MatchedFragment(spaceIndex, spaceIndex + 1, 0)};
                        list = CollectionsKt.mutableListOf((Object[])objectArray);
                    } else {
                        list = null;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                return list;
            }
            List<MatchedFragment> list = this.matchFragment(patternIndex2, nameIndex, errorState);
            if (list == null) {
                list = this.matchSkippingWords(patternIndex2, nameIndex, true, errorState);
            }
            return list;
        }

        private final boolean isTrailingSpacePattern(ErrorState errorState) {
            return this.isPatternChar(this.patternLength(errorState) - 1, ' ', errorState);
        }

        private final boolean isUpperCaseOrDigit(int patternIndex, ErrorState errorState) {
            return this.isUpperCase(patternIndex, errorState) || this.isDigit(patternIndex, errorState);
        }

        private final List<MatchedFragment> matchSkippingWords(int patternIndex, int nameIndex, boolean allowSpecialChars, ErrorState errorState) {
            List<MatchedFragment> ranges;
            boolean wordStartsOnly = !this.isPatternChar(patternIndex - 1, '*', errorState) && !this.isWordSeparator(patternIndex, errorState);
            int nameIndex2 = nameIndex;
            int maxFoundLength = 0;
            while (true) {
                int fragmentLength;
                if ((nameIndex2 = this.findNextPatternCharOccurrence(nameIndex2, patternIndex, allowSpecialChars, wordStartsOnly, errorState)) < 0) {
                    return null;
                }
                Fragment fragment = this.seemsLikeFragmentStart(patternIndex, nameIndex2, errorState) ? this.maxMatchingFragment(patternIndex, nameIndex2, errorState) : null;
                if (fragment == null || (fragmentLength = fragment.getLength()) <= maxFoundLength && (nameIndex2 + fragmentLength != this.myName.length() || !this.isTrailingSpacePattern(errorState))) continue;
                if (!this.isMiddleMatch(patternIndex, nameIndex2, errorState)) {
                    maxFoundLength = fragmentLength;
                }
                if ((ranges = this.matchInsideFragment(patternIndex, nameIndex2, fragment)) != null) break;
            }
            return ranges;
        }

        private final int findNextPatternCharOccurrence(int startAt, int patternIndex, boolean allowSpecialChars, boolean wordStartsOnly, ErrorState errorState) {
            int next = wordStartsOnly ? this.indexOfWordStart(patternIndex, startAt, errorState) : this.indexOfIgnoreCase(startAt + 1, patternIndex, errorState);
            return !allowSpecialChars && !TypoTolerantMatcher.this.myHasSeparators && !TypoTolerantMatcher.this.myMixedCase && CharArrayUtilKt.indexOfAny(this.myName, TypoTolerantMatcher.this.myHardSeparators, startAt, next) != -1 ? -1 : (!allowSpecialChars && TypoTolerantMatcher.this.myHasDots && !this.isPatternChar(patternIndex - 1, '.', errorState) && CharArrayUtilKt.indexOf(this.myName, '.', startAt, next, false) != -1 ? -1 : next);
        }

        private final boolean seemsLikeFragmentStart(int patternIndex, int nextOccurrence, ErrorState errorState) {
            return !this.isUpperCase(patternIndex, errorState) || Character.isUpperCase(this.myName.charAt(nextOccurrence)) || NameUtilCore.isWordStart((String)this.myName, (int)nextOccurrence) || !TypoTolerantMatcher.this.myMixedCase && TypoTolerantMatcher.this.myMatchingMode != MatchingMode.MATCH_CASE;
        }

        private final boolean charEquals(int patternIndex, int nameIndex, boolean isIgnoreCase, boolean allowTypos, ErrorState errorState) {
            char nextNameChar;
            Character rightMiss;
            char nameChar;
            char patternChar = this.charAt(patternIndex, errorState);
            if (patternChar == (nameChar = this.myName.charAt(nameIndex)) || isIgnoreCase && this.equalsIgnoreCase(patternIndex, errorState, nameChar)) {
                return true;
            }
            if (!this.myAllowTypos || !allowTypos) {
                return false;
            }
            if (errorState.countErrors(0, patternIndex) > 0) {
                return false;
            }
            Error prevError = errorState.getError(patternIndex - 1);
            if (Intrinsics.areEqual((Object)prevError, (Object)Error.SwapError.INSTANCE)) {
                return false;
            }
            Character leftMiss = TypoTolerantMatcher.this.leftMiss(patternChar);
            if (leftMiss != null) {
                char c = nameChar;
                if (leftMiss.charValue() == c || isIgnoreCase && (AsciiUtils.INSTANCE.toLowerAscii(leftMiss.charValue()) == nameChar || AsciiUtils.INSTANCE.toUpperAscii(leftMiss.charValue()) == nameChar)) {
                    errorState.addError(patternIndex, new Error.TypoError(leftMiss.charValue()));
                    return true;
                }
            }
            if ((rightMiss = TypoTolerantMatcher.this.rightMiss(patternChar)) != null) {
                char c = nameChar;
                if (rightMiss.charValue() == c || isIgnoreCase && (AsciiUtils.INSTANCE.toLowerAscii(rightMiss.charValue()) == nameChar || AsciiUtils.INSTANCE.toUpperAscii(rightMiss.charValue()) == nameChar)) {
                    errorState.addError(patternIndex, new Error.TypoError(rightMiss.charValue()));
                    return true;
                }
            }
            if (this.patternLength(errorState) > patternIndex + 1 && this.myName.length() > nameIndex + 1) {
                nextNameChar = this.myName.charAt(nameIndex + 1);
                char nextPatternChar = this.charAt(patternIndex + 1, errorState);
                if ((patternChar == nextNameChar || isIgnoreCase && this.equalsIgnoreCase(patternIndex, errorState, nextNameChar)) && (nextPatternChar == nameChar || isIgnoreCase && this.equalsIgnoreCase(patternIndex + 1, errorState, nameChar))) {
                    errorState.addError(patternIndex, Error.SwapError.INSTANCE);
                    return true;
                }
            }
            if (this.myName.length() > nameIndex + 1 && (patternChar == (nextNameChar = this.myName.charAt(nameIndex + 1)) || isIgnoreCase && this.equalsIgnoreCase(patternIndex, errorState, nextNameChar))) {
                errorState.addError(patternIndex, new Error.MissError(nameChar));
                return true;
            }
            return false;
        }

        private final List<MatchedFragment> matchFragment(int patternIndex, int nameIndex, ErrorState errorState) {
            List<MatchedFragment> list;
            Fragment fragment;
            Fragment fragment2 = fragment = this.maxMatchingFragment(patternIndex, nameIndex, errorState);
            if (fragment2 != null) {
                Fragment it = fragment2;
                boolean bl = false;
                list = this.matchInsideFragment(patternIndex, nameIndex, it);
            } else {
                list = null;
            }
            return list;
        }

        private final Fragment maxMatchingFragment(int patternIndex, int nameIndex, ErrorState baseErrorState) {
            ErrorState errorState = baseErrorState.deriveFrom(patternIndex);
            if (!this.isFirstCharMatching(nameIndex, patternIndex, errorState)) {
                return null;
            }
            boolean ignoreCase = TypoTolerantMatcher.this.myMatchingMode != MatchingMode.MATCH_CASE;
            int i = 1;
            while (nameIndex + i < this.myName.length() && patternIndex + i < this.patternLength(errorState)) {
                if (!this.charEquals(patternIndex + i, nameIndex + i, ignoreCase, true, errorState)) {
                    if (!this.isDigit(patternIndex + i, errorState) || !this.isDigit(patternIndex + i - 1, errorState)) break;
                    return null;
                }
                ++i;
            }
            return new Fragment(i, errorState);
        }

        private final List<MatchedFragment> matchInsideFragment(int patternIndex, int nameIndex, Fragment fragment) {
            int minFragment = this.isMiddleMatch(patternIndex, nameIndex, fragment.getErrorState()) ? 3 : 1;
            List<MatchedFragment> list = this.improveCamelHumps(patternIndex, nameIndex, fragment.getLength(), minFragment, fragment.getErrorState());
            if (list == null) {
                list = this.findLongestMatchingPrefix(patternIndex, nameIndex, fragment.getLength(), minFragment, fragment.getErrorState());
            }
            return list;
        }

        private final boolean isMiddleMatch(int patternIndex, int nameIndex, ErrorState errorState) {
            return this.isPatternChar(patternIndex - 1, '*', errorState) && !this.isWildcard(patternIndex + 1) && Character.isLetterOrDigit(this.myName.charAt(nameIndex)) && !NameUtilCore.isWordStart((String)this.myName, (int)nameIndex);
        }

        @Nullable
        public final List<MatchedFragment> findLongestMatchingPrefix(int patternIndex, int nameIndex, int fragmentLength, int minFragment, @NotNull ErrorState errorState) {
            Intrinsics.checkNotNullParameter((Object)errorState, (String)"errorState");
            if (patternIndex + fragmentLength >= this.patternLength(errorState)) {
                List list;
                int errors = errorState.countErrors(patternIndex, patternIndex + fragmentLength);
                if (errors == fragmentLength) {
                    list = null;
                } else {
                    Object[] objectArray = new MatchedFragment[]{new MatchedFragment(nameIndex, nameIndex + fragmentLength, errors)};
                    list = CollectionsKt.mutableListOf((Object[])objectArray);
                }
                return list;
            }
            for (int i = fragmentLength; i >= minFragment || this.isWildcard(patternIndex + i); --i) {
                List<MatchedFragment> ranges;
                ErrorState derivedErrorState = errorState.deriveFrom(patternIndex + i);
                List<MatchedFragment> list = ranges = this.isWildcard(patternIndex + i) ? this.matchWildcards(patternIndex + i, nameIndex + i, derivedErrorState) : this.matchSkippingWords(patternIndex + i, nameIndex + i, false, derivedErrorState);
                if (ranges == null) continue;
                int errors = errorState.countErrors(patternIndex, patternIndex + i);
                return errors == i ? null : TypoTolerantMatcher.this.appendRange(ranges, new MatchedFragment(nameIndex, nameIndex + i, errors));
            }
            return null;
        }

        @Nullable
        public final List<MatchedFragment> improveCamelHumps(int patternIndex, int nameIndex, int maxFragment, int minFragment, @NotNull ErrorState errorState) {
            Intrinsics.checkNotNullParameter((Object)errorState, (String)"errorState");
            for (int i = minFragment; i < maxFragment; ++i) {
                List<MatchedFragment> ranges;
                if (!this.isUppercasePatternVsLowercaseNameChar(patternIndex + i, nameIndex + i, errorState) || (ranges = this.findUppercaseMatchFurther(patternIndex + i, nameIndex + i, errorState.deriveFrom(patternIndex + i))) == null) continue;
                int errors = errorState.countErrors(patternIndex, patternIndex + i);
                return errors == i ? null : TypoTolerantMatcher.this.appendRange(ranges, new MatchedFragment(nameIndex, nameIndex + i, errors));
            }
            return null;
        }

        public final boolean isUppercasePatternVsLowercaseNameChar(int patternIndex, int nameIndex, @NotNull ErrorState errorState) {
            Intrinsics.checkNotNullParameter((Object)errorState, (String)"errorState");
            return this.isUpperCase(patternIndex, errorState) && !this.charEquals(patternIndex, nameIndex, false, false, errorState);
        }

        @Nullable
        public final List<MatchedFragment> findUppercaseMatchFurther(int patternIndex, int nameIndex, @NotNull ErrorState errorState) {
            Intrinsics.checkNotNullParameter((Object)errorState, (String)"errorState");
            int nextWordStart = this.indexOfWordStart(patternIndex, nameIndex, errorState);
            return this.matchWildcards(patternIndex, nextWordStart, errorState.deriveFrom(patternIndex));
        }

        public final boolean isFirstCharMatching(int nameIndex, int patternIndex, @NotNull ErrorState errorState) {
            boolean ignoreCase;
            Intrinsics.checkNotNullParameter((Object)errorState, (String)"errorState");
            if (nameIndex >= this.myName.length()) {
                return false;
            }
            boolean bl = ignoreCase = TypoTolerantMatcher.this.myMatchingMode != MatchingMode.MATCH_CASE;
            if (!this.charEquals(patternIndex, nameIndex, ignoreCase, true, errorState)) {
                return false;
            }
            return TypoTolerantMatcher.this.myMatchingMode != MatchingMode.FIRST_LETTER || patternIndex != 0 && (patternIndex != 1 || !this.isWildcard(0)) || !this.hasCase(patternIndex, errorState) || this.isUpperCase(patternIndex, errorState) == Character.isUpperCase(this.myName.charAt(0));
        }

        private final boolean hasCase(int patternIndex, ErrorState errorState) {
            return this.isUpperCase(patternIndex, errorState) || this.isLowerCase(patternIndex, errorState);
        }

        public final boolean isPatternChar(int patternIndex, char c, @NotNull ErrorState errorState) {
            Intrinsics.checkNotNullParameter((Object)errorState, (String)"errorState");
            return patternIndex >= 0 && patternIndex < this.patternLength(errorState) && this.charAt(patternIndex, errorState) == c;
        }

        public final int indexOfWordStart(int patternIndex, int startFrom, @NotNull ErrorState errorState) {
            Intrinsics.checkNotNullParameter((Object)errorState, (String)"errorState");
            if (startFrom >= this.myName.length() || TypoTolerantMatcher.this.myMixedCase && this.isLowerCase(patternIndex, errorState) && (patternIndex <= 0 || !this.isWordSeparator(patternIndex - 1, errorState))) {
                return -1;
            }
            int nextWordStart = startFrom;
            do {
                if ((nextWordStart = TypoTolerantMatcher.this.nextWord(this.myName, nextWordStart, this.isAsciiName)) < this.myName.length()) continue;
                return -1;
            } while (!this.charEquals(patternIndex, nextWordStart, true, true, errorState));
            return nextWordStart;
        }

        public final int indexOfIgnoreCase(int fromIndex, int patternIndex, @NotNull ErrorState errorState) {
            Intrinsics.checkNotNullParameter((Object)errorState, (String)"errorState");
            char p = this.charAt(patternIndex, errorState);
            if (this.isAsciiName && AsciiUtils.INSTANCE.isAscii(p)) {
                int i = this.indexIgnoringCaseAscii(fromIndex, p);
                if (i != -1) {
                    return i;
                }
                if (this.myAllowTypos) {
                    Integer rightMiss;
                    Integer n;
                    Integer n2;
                    Integer leftMiss;
                    Integer n3;
                    Integer n4;
                    int n5;
                    Character c = TypoTolerantMatcher.this.leftMiss(p);
                    if (c != null) {
                        char it = c.charValue();
                        n5 = 0;
                        n4 = this.indexIgnoringCaseAscii(fromIndex, it);
                    } else {
                        n4 = null;
                    }
                    Integer it = n3 = n4;
                    boolean bl = false;
                    Integer n6 = it;
                    n5 = -1;
                    Integer n7 = leftMiss = n6 == null || n6 != n5 ? n3 : null;
                    if (n7 != null) {
                        return n7;
                    }
                    Character c2 = TypoTolerantMatcher.this.rightMiss(p);
                    if (c2 != null) {
                        char it2 = c2.charValue();
                        boolean bl2 = false;
                        n2 = this.indexIgnoringCaseAscii(fromIndex, it2);
                    } else {
                        n2 = null;
                    }
                    Integer it3 = n = n2;
                    boolean bl3 = false;
                    Integer n8 = it3;
                    int n9 = -1;
                    Integer n10 = rightMiss = n8 == null || n8 != n9 ? n : null;
                    if (rightMiss != null) {
                        return rightMiss;
                    }
                }
                return -1;
            }
            return StringsKt.indexOf((CharSequence)this.myName, (char)p, (int)fromIndex, (boolean)true);
        }

        public final int indexIgnoringCaseAscii(int fromIndex, char p) {
            char pUpper = AsciiUtils.INSTANCE.toUpperAscii(p);
            char pLower = AsciiUtils.INSTANCE.toLowerAscii(p);
            int n = this.myName.length();
            for (int i = fromIndex; i < n; ++i) {
                char c = this.myName.charAt(i);
                if (c != p && AsciiUtils.INSTANCE.toUpperAscii(c) != pUpper && AsciiUtils.INSTANCE.toLowerAscii(c) != pLower) continue;
                return i;
            }
            return -1;
        }
    }
}

