/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.debug.util.connection;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.remote.RemoteConfigurationType;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.kotlin.jupyter.debug.util.DebugSessionConfig;
import com.intellij.kotlin.jupyter.debug.util.connection.DebugEnvironmentData;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.protocol.startup.PortsGeneratingKt;
import org.jetbrains.kotlinx.jupyter.protocol.startup.PortsGenerator;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u00020\u0017*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019J.\u0010\u001a\u001a\u00020\u001b*\u00020\u00052\b\b\u0001\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u0010R\u000e\u0010 \u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lcom/intellij/kotlin/jupyter/debug/util/connection/DebugConnectionUtility;", "", "<init>", "()V", "buildExecutionEnvironment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "Lcom/intellij/openapi/project/Project;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "buildRunnerSettings", "Lcom/intellij/debugger/impl/GenericDebuggerRunnerSettings;", "transport", "", "debugPort", "", "local", "", "buildDebugEnvironment", "Lcom/intellij/kotlin/jupyter/debug/util/connection/DebugEnvironmentData;", "project", "config", "Lcom/intellij/kotlin/jupyter/debug/util/DebugSessionConfig;", "buildRemoteRunProfileState", "Lcom/intellij/execution/configurations/RunProfileState;", "remoteConnection", "Lcom/intellij/execution/configurations/RemoteConnection;", "attachDebuggerCreateSession", "Lcom/intellij/debugger/impl/DebuggerSession;", "sessionName", "debugEnvironment", "Lcom/intellij/debugger/DebugEnvironment;", "isHeadlessMode", "minimumDebugPort", "maximumDebugPort", "debugPortsGenerator", "Lorg/jetbrains/kotlinx/jupyter/protocol/startup/PortsGenerator;", "getDebugPortsGenerator", "()Lorg/jetbrains/kotlinx/jupyter/protocol/startup/PortsGenerator;", "intellij.kotlin.jupyter.debug"})
public final class DebugConnectionUtility {
    @NotNull
    public static final DebugConnectionUtility INSTANCE = new DebugConnectionUtility();
    public static final int minimumDebugPort = 5000;
    public static final int maximumDebugPort = 65536;

    private DebugConnectionUtility() {
    }

    @NotNull
    public final ExecutionEnvironment buildExecutionEnvironment(@NotNull Project $this$buildExecutionEnvironment, @NotNull RunnerSettings runnerSettings) {
        Intrinsics.checkNotNullParameter((Object)$this$buildExecutionEnvironment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)runnerSettings, (String)"runnerSettings");
        Executor executor = DefaultDebugExecutor.getDebugExecutorInstance();
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getDebugExecutorInstance(...)");
        return ExecutionEnvironmentBuilder.build$default((ExecutionEnvironmentBuilder)new ExecutionEnvironmentBuilder($this$buildExecutionEnvironment, executor).runnerSettings(runnerSettings).runProfile((RunProfile)new RemoteConfiguration($this$buildExecutionEnvironment, (ConfigurationFactory)RemoteConfigurationType.getInstance())), null, (int)1, null);
    }

    @NotNull
    public final GenericDebuggerRunnerSettings buildRunnerSettings(int transport, @NotNull String debugPort, boolean local) {
        GenericDebuggerRunnerSettings genericDebuggerRunnerSettings;
        Intrinsics.checkNotNullParameter((Object)debugPort, (String)"debugPort");
        GenericDebuggerRunnerSettings $this$buildRunnerSettings_u24lambda_u240 = genericDebuggerRunnerSettings = new GenericDebuggerRunnerSettings();
        boolean bl = false;
        $this$buildRunnerSettings_u24lambda_u240.setTransport(transport);
        $this$buildRunnerSettings_u24lambda_u240.setLocal(local);
        $this$buildRunnerSettings_u24lambda_u240.setDebugPort(debugPort);
        return genericDebuggerRunnerSettings;
    }

    public static /* synthetic */ GenericDebuggerRunnerSettings buildRunnerSettings$default(DebugConnectionUtility debugConnectionUtility, int n, String string, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return debugConnectionUtility.buildRunnerSettings(n, string, bl);
    }

    @Nullable
    public final DebugEnvironmentData buildDebugEnvironment(@NotNull Project project, @NotNull DebugSessionConfig config) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        GenericDebuggerRunnerSettings runnerSettings = this.buildRunnerSettings(config.getTransport(), String.valueOf(config.getPort()), config.isLocal());
        ExecutionEnvironment executionEnvironment = this.buildExecutionEnvironment(project, (RunnerSettings)runnerSettings);
        RemoteConnection remoteConnection = new RemoteConnection(true, "127.0.0.1", String.valueOf(config.getPort()), false);
        RunProfileState runProfileState = this.buildRemoteRunProfileState(executionEnvironment, remoteConnection);
        DefaultDebugEnvironment debugEnvironment = new DefaultDebugEnvironment(executionEnvironment, runProfileState, remoteConnection, true);
        return new DebugEnvironmentData(executionEnvironment, (DebugEnvironment)debugEnvironment);
    }

    @NotNull
    public final RunProfileState buildRemoteRunProfileState(@NotNull ExecutionEnvironment $this$buildRemoteRunProfileState, @NotNull RemoteConnection remoteConnection) {
        Intrinsics.checkNotNullParameter((Object)$this$buildRemoteRunProfileState, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)remoteConnection, (String)"remoteConnection");
        return (RunProfileState)new RemoteState(remoteConnection, $this$buildRemoteRunProfileState){
            final /* synthetic */ RemoteConnection $remoteConnection;
            final /* synthetic */ ExecutionEnvironment $this_buildRemoteRunProfileState;
            {
                this.$remoteConnection = $remoteConnection;
                this.$this_buildRemoteRunProfileState = $receiver;
            }

            public RemoteConnection getRemoteConnection() {
                return this.$remoteConnection;
            }

            public ExecutionResult execute(Executor executor, ProgramRunner<?> runner) {
                Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
                Intrinsics.checkNotNullParameter(runner, (String)"runner");
                RunProfileState runProfileState = this.$this_buildRemoteRunProfileState.getState();
                return runProfileState != null ? runProfileState.execute(executor, runner) : null;
            }
        };
    }

    @NotNull
    public final DebuggerSession attachDebuggerCreateSession(@NotNull ExecutionEnvironment $this$attachDebuggerCreateSession, @Nls @NotNull String sessionName, @NotNull Project project, @NotNull DebugEnvironment debugEnvironment, boolean isHeadlessMode) {
        Intrinsics.checkNotNullParameter((Object)$this$attachDebuggerCreateSession, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sessionName, (String)"sessionName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)debugEnvironment, (String)"debugEnvironment");
        DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx((Project)project).attachVirtualMachine(debugEnvironment);
        Intrinsics.checkNotNull((Object)debuggerSession);
        DebuggerSession debugSession = debuggerSession;
        XDebugProcessStarter starter2 = new XDebugProcessStarter(debugSession){
            final /* synthetic */ DebuggerSession $debugSession;
            {
                this.$debugSession = $debugSession;
            }

            public XDebugProcess start(XDebugSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                JavaDebugProcess javaDebugProcess = JavaDebugProcess.create((XDebugSession)session, (DebuggerSession)this.$debugSession);
                Intrinsics.checkNotNullExpressionValue((Object)javaDebugProcess, (String)"create(...)");
                return (XDebugProcess)javaDebugProcess;
            }
        };
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project).newSessionBuilder(starter2).sessionName(sessionName).environment($this$attachDebuggerCreateSession).showTab(!isHeadlessMode).startSession().getSession();
        if (isHeadlessMode) {
            xDebugSession.setBreakpointMuted(true);
        }
        return debugSession;
    }

    public static /* synthetic */ DebuggerSession attachDebuggerCreateSession$default(DebugConnectionUtility debugConnectionUtility, ExecutionEnvironment executionEnvironment, String string, Project project, DebugEnvironment debugEnvironment, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return debugConnectionUtility.attachDebuggerCreateSession(executionEnvironment, string, project, debugEnvironment, bl);
    }

    @NotNull
    public final PortsGenerator getDebugPortsGenerator() {
        return PortsGeneratingKt.create((PortsGenerator.Companion)PortsGenerator.Companion, (int)5000, (int)65536);
    }
}

