/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.recentFiles.frontend;

import com.intellij.ide.actions.SwitcherImplementationChoserKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.platform.recentFiles.frontend.Switcher;
import com.intellij.platform.recentFiles.frontend.SwitcherVirtualFile;
import com.intellij.ui.components.JBList;
import javax.swing.JList;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/recentFiles/frontend/SwitcherProblemAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "forward", "", "<init>", "(Z)V", "getForward", "()Z", "getFileList", "Lcom/intellij/ui/components/JBList;", "Lcom/intellij/platform/recentFiles/frontend/SwitcherVirtualFile;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getErrorIndex", "", "list", "Ljavax/swing/JList;", "(Ljavax/swing/JList;)Ljava/lang/Integer;", "update", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "intellij.platform.recentFiles.frontend"})
@SourceDebugExtension(value={"SMAP\nSwitcherActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwitcherActions.kt\ncom/intellij/platform/recentFiles/frontend/SwitcherProblemAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,252:1\n1#2:253\n*E\n"})
public abstract class SwitcherProblemAction
extends DumbAwareAction
implements ActionRemoteBehaviorSpecification.Frontend {
    private final boolean forward;

    public SwitcherProblemAction(boolean forward) {
        this.forward = forward;
    }

    public final boolean getForward() {
        return this.forward;
    }

    private final JBList<SwitcherVirtualFile> getFileList(AnActionEvent event) {
        JBList<SwitcherVirtualFile> jBList;
        Switcher.SwitcherPanel switcherPanel = (Switcher.SwitcherPanel)((Object)Switcher.INSTANCE.getSWITCHER_KEY().get((UserDataHolder)event.getProject()));
        if (switcherPanel != null) {
            Switcher.SwitcherPanel it = switcherPanel;
            boolean bl = false;
            jBList = it.getPinned() ? it.getFiles$intellij_platform_recentFiles_frontend() : null;
        } else {
            jBList = null;
        }
        return jBList;
    }

    private final Integer getErrorIndex(JList<SwitcherVirtualFile> list) {
        int n;
        ListModel<SwitcherVirtualFile> listModel = list.getModel();
        if (listModel == null) {
            return null;
        }
        ListModel<SwitcherVirtualFile> model = listModel;
        int size = model.getSize();
        if (size <= 0) {
            return null;
        }
        IntRange range = RangesKt.until((int)0, (int)size);
        if (this.forward) {
            it = list.getLeadSelectionIndex();
            boolean bl = false;
            n = range.getFirst() <= it && it < range.getLast() ? it + 1 : range.getFirst();
        } else {
            it = list.getLeadSelectionIndex();
            boolean bl = false;
            n = range.getFirst() < it && it <= range.getLast() ? it - 1 : range.getLast();
        }
        int start = n;
        int i = range.getFirst();
        int n2 = range.getLast();
        if (i <= n2) {
            while (true) {
                int n3;
                if (this.forward) {
                    it = start + i;
                    boolean bl = false;
                    n3 = it > range.getLast() ? it - size : it;
                } else {
                    it = start - i;
                    boolean bl = false;
                    n3 = it < range.getFirst() ? it + size : it;
                }
                int index = n3;
                SwitcherVirtualFile switcherVirtualFile = model.getElementAt(index);
                boolean bl = switcherVirtualFile != null ? switcherVirtualFile.getHasProblems() : false;
                if (bl) {
                    return index;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return null;
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (SwitcherImplementationChoserKt.shouldUseFallbackSwitcher()) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        event.getPresentation().setEnabledAndVisible(this.getFileList(event) != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        JBList<SwitcherVirtualFile> jBList = this.getFileList(event);
        if (jBList == null) {
            return;
        }
        JBList<SwitcherVirtualFile> list = jBList;
        Integer n = this.getErrorIndex((JList)list);
        if (n == null) {
            return;
        }
        int index = n;
        list.setSelectedIndex(index);
        list.ensureIndexIsVisible(index);
    }
}

