/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor.fonts;

import com.intellij.application.options.colors.FontGlyphHashCache;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.JBR;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 .2\u00020\u0001:\u0001.B&\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u0006H\u0002J\u000e\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cJ\u001a\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\b\u0010 \u001a\u00020\u0016H\u0002J\b\u0010!\u001a\u00020\u0016H\u0002J\b\u0010\"\u001a\u00020\u0016H\u0002J\b\u0010#\u001a\u00020\u0016H\u0002J\b\u0010$\u001a\u00020\u0016H\u0002J\u0010\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\rH\u0002J\u0018\u0010'\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)H\u0002J \u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020)H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/application/options/editor/fonts/FontDiffPopup;", "", "firstFont", "Ljava/awt/Font;", "secondFont", "previewText", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Ljava/awt/Font;Ljava/awt/Font;Ljava/lang/String;)V", "tooltipPanel", "Ljavax/swing/JPanel;", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "isOverPopup", "", "initialShowScheduled", "showTimer", "Ljavax/swing/Timer;", "hideTimer", "dismissTimer", "dispose", "", "grayLabel", "Ljavax/swing/JLabel;", "text", "installOn", "owner", "Ljavax/swing/JComponent;", "createTooltipTextArea", "Ljavax/swing/JTextArea;", "f", "cancelShowTimer", "cancelHideTimer", "cancelDismissTimer", "hidePopup", "scheduleHide", "installPopupHoverTracking", "p", "showPopup", "eventPoint", "Ljava/awt/Point;", "scheduleShow", "delayMs", "", "point", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nFontDiffPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontDiffPopup.kt\ncom/intellij/application/options/editor/fonts/FontDiffPopup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,241:1\n1#2:242\n*E\n"})
public final class FontDiffPopup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Font firstFont;
    @NotNull
    private final Font secondFont;
    @NotNull
    private final String previewText;
    private JPanel tooltipPanel;
    @Nullable
    private JBPopup popup;
    private boolean isOverPopup;
    private boolean initialShowScheduled;
    @Nullable
    private Timer showTimer;
    @Nullable
    private Timer hideTimer;
    @Nullable
    private Timer dismissTimer;
    @NotNull
    private static final List<String> programmingLigatures;

    private FontDiffPopup(Font firstFont, Font secondFont, String previewText) {
        this.firstFont = firstFont;
        this.secondFont = secondFont;
        this.previewText = previewText;
    }

    public final void dispose() {
        this.hidePopup();
        this.cancelShowTimer();
        this.cancelHideTimer();
        this.cancelDismissTimer();
    }

    private final JLabel grayLabel(@NlsContexts.Label String text2) {
        JLabel jLabel;
        JLabel $this$grayLabel_u24lambda_u240 = jLabel = new JLabel(text2);
        boolean bl = false;
        $this$grayLabel_u24lambda_u240.setForeground(UIUtil.getContextHelpForeground());
        return jLabel;
    }

    public final void installOn(@NotNull JComponent owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (StringsKt.isBlank((CharSequence)this.previewText)) {
            return;
        }
        JTextArea text1 = this.createTooltipTextArea(this.previewText, this.firstFont);
        JTextArea text2 = this.createTooltipTextArea(this.previewText, this.secondFont);
        JBPanel jBPanel = BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> FontDiffPopup.installOn$lambda$0(this, text1, text2, arg_0))).withBorder(JBUI.Borders.empty((Insets)UIUtil.PANEL_REGULAR_INSETS));
        Intrinsics.checkNotNullExpressionValue((Object)jBPanel, (String)"withBorder(...)");
        this.tooltipPanel = (JPanel)jBPanel;
        MouseAdapter mouseListener2 = new MouseAdapter(this, owner){
            final /* synthetic */ FontDiffPopup this$0;
            final /* synthetic */ JComponent $owner;
            {
                this.this$0 = $receiver;
                this.$owner = $owner;
            }

            public void mouseEntered(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (FontDiffPopup.access$getPopup$p(this.this$0) != null) {
                    JBPopup jBPopup = FontDiffPopup.access$getPopup$p(this.this$0);
                    Intrinsics.checkNotNull((Object)jBPopup);
                    if (jBPopup.isVisible()) {
                        JBPopup jBPopup2 = FontDiffPopup.access$getPopup$p(this.this$0);
                        Intrinsics.checkNotNull((Object)jBPopup2);
                        if (!jBPopup2.isDisposed()) {
                            JBPopup jBPopup3 = FontDiffPopup.access$getPopup$p(this.this$0);
                            Intrinsics.checkNotNull((Object)jBPopup3);
                            jBPopup3.cancel();
                            FontDiffPopup.access$setPopup$p(this.this$0, null);
                        }
                    }
                }
                FontDiffPopup.access$setInitialShowScheduled$p(this.this$0, true);
                int n = Registry.Companion.intValue("ide.tooltip.initialReshowDelay", 500);
                Point point = e.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                FontDiffPopup.access$scheduleShow(this.this$0, n, this.$owner, point);
            }

            public void mouseExited(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FontDiffPopup.access$scheduleHide(this.this$0);
            }

            public void mouseMoved(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!FontDiffPopup.access$getInitialShowScheduled$p(this.this$0)) {
                    int n = Registry.Companion.intValue("ide.tooltip.reshowDelay", 500);
                    Point point = e.getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                    FontDiffPopup.access$scheduleShow(this.this$0, n, this.$owner, point);
                }
            }
        };
        owner.addMouseListener(mouseListener2);
        owner.addMouseMotionListener(mouseListener2);
        owner.addHierarchyListener(arg_0 -> FontDiffPopup.installOn$lambda$1(owner, this, arg_0));
    }

    private final JTextArea createTooltipTextArea(@Nls String text2, Font f) {
        JTextArea jTextArea;
        JTextArea $this$createTooltipTextArea_u24lambda_u240 = jTextArea = new JTextArea(text2);
        boolean bl = false;
        $this$createTooltipTextArea_u24lambda_u240.setEditable(false);
        $this$createTooltipTextArea_u24lambda_u240.setOpaque(false);
        $this$createTooltipTextArea_u24lambda_u240.setLineWrap(false);
        $this$createTooltipTextArea_u24lambda_u240.setFont(f.deriveFont(UISettingsUtils.Companion.getInstance().scaleFontSize((float)f.getSize())));
        $this$createTooltipTextArea_u24lambda_u240.setBorder((Border)JBUI.Borders.empty());
        return jTextArea;
    }

    private final void cancelShowTimer() {
        Timer timer = this.showTimer;
        if (timer != null) {
            timer.stop();
        }
        this.showTimer = null;
    }

    private final void cancelHideTimer() {
        Timer timer = this.hideTimer;
        if (timer != null) {
            timer.stop();
        }
        this.hideTimer = null;
    }

    private final void cancelDismissTimer() {
        Timer timer = this.dismissTimer;
        if (timer != null) {
            timer.stop();
        }
        this.dismissTimer = null;
    }

    private final void hidePopup() {
        this.initialShowScheduled = false;
        this.cancelShowTimer();
        this.cancelDismissTimer();
        JBPopup jBPopup = this.popup;
        if (jBPopup != null) {
            JBPopup jBPopup2;
            JBPopup $this$hidePopup_u24lambda_u240 = jBPopup2 = jBPopup;
            boolean bl = false;
            if (!$this$hidePopup_u24lambda_u240.isDisposed() && $this$hidePopup_u24lambda_u240.isVisible()) {
                $this$hidePopup_u24lambda_u240.cancel();
            }
        }
        this.popup = null;
    }

    /*
     * WARNING - void declaration
     */
    private final void scheduleHide() {
        void $this$scheduleHide_u24lambda_u241;
        Timer timer;
        this.cancelHideTimer();
        Timer timer2 = timer = new Timer(Registry.Companion.intValue("ide.tooltip.initialDelay.highlighter", 500), arg_0 -> FontDiffPopup.scheduleHide$lambda$0(this, arg_0));
        FontDiffPopup fontDiffPopup = this;
        boolean bl = false;
        $this$scheduleHide_u24lambda_u241.setRepeats(false);
        $this$scheduleHide_u24lambda_u241.start();
        fontDiffPopup.hideTimer = timer;
    }

    private final void installPopupHoverTracking(JBPopup p) {
        MouseAdapter listener2 = new MouseAdapter(this){
            final /* synthetic */ FontDiffPopup this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseEntered(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FontDiffPopup.access$setOverPopup$p(this.this$0, true);
                FontDiffPopup.access$cancelHideTimer(this.this$0);
            }

            public void mouseExited(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FontDiffPopup.access$setOverPopup$p(this.this$0, false);
                FontDiffPopup.access$scheduleHide(this.this$0);
            }
        };
        p.getContent().addMouseListener(listener2);
    }

    private final void showPopup(JComponent owner, Point eventPoint) {
        JBPopup p;
        if (this.popup != null) {
            JBPopup jBPopup = this.popup;
            Intrinsics.checkNotNull((Object)jBPopup);
            if (jBPopup.isVisible()) {
                JBPopup jBPopup2 = this.popup;
                Intrinsics.checkNotNull((Object)jBPopup2);
                if (!jBPopup2.isDisposed()) {
                    return;
                }
            }
        }
        JBPopupFactory jBPopupFactory = JBPopupFactory.getInstance();
        JPanel jPanel = this.tooltipPanel;
        if (jPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tooltipPanel");
            jPanel = null;
        }
        ComponentPopupBuilder builder = jBPopupFactory.createComponentPopupBuilder((JComponent)jPanel, null).setRequestFocus(false).setFocusable(false).setResizable(false).setMovable(false).setCancelOnClickOutside(true).setCancelOnOtherWindowOpen(true).setCancelOnWindowDeactivation(true);
        JBPopup jBPopup = builder.createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        this.popup = p = jBPopup;
        Component component2 = owner;
        JPanel jPanel2 = this.tooltipPanel;
        if (jPanel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tooltipPanel");
            jPanel2 = null;
        }
        Point pointOnComponent = HelpTooltip.Alignment.CURSOR.getPointFor(component2, jPanel2.getPreferredSize(), eventPoint);
        p.show(new RelativePoint((Component)owner, pointOnComponent));
        this.installPopupHoverTracking(p);
    }

    /*
     * WARNING - void declaration
     */
    private final void scheduleShow(int delayMs, JComponent owner, Point point) {
        void $this$scheduleShow_u24lambda_u241;
        Timer timer;
        this.initialShowScheduled = true;
        this.cancelShowTimer();
        Timer timer2 = timer = new Timer(delayMs, arg_0 -> FontDiffPopup.scheduleShow$lambda$0(this, owner, point, arg_0));
        FontDiffPopup fontDiffPopup = this;
        boolean bl = false;
        $this$scheduleShow_u24lambda_u241.setRepeats(false);
        $this$scheduleShow_u24lambda_u241.start();
        fontDiffPopup.showTimer = timer;
    }

    private static final Unit installOn$lambda$0$0(JTextArea $text1, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$text1);
        return Unit.INSTANCE;
    }

    private static final Unit installOn$lambda$0$1(JTextArea $text2, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$text2);
        return Unit.INSTANCE;
    }

    private static final Unit installOn$lambda$0(FontDiffPopup this$0, JTextArea $text1, JTextArea $text2, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = ApplicationBundle.message((String)"settings.editor.font.diff.popup.default", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(this$0.grayLabel(string), (Function1<? super Row, Unit>)((Function1)arg_0 -> FontDiffPopup.installOn$lambda$0$0($text1, arg_0)));
        String string2 = ApplicationBundle.message((String)"settings.editor.font.diff.popup.variant", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(this$0.grayLabel(string2), (Function1<? super Row, Unit>)((Function1)arg_0 -> FontDiffPopup.installOn$lambda$0$1($text2, arg_0)));
        return Unit.INSTANCE;
    }

    private static final void installOn$lambda$1(JComponent $owner, FontDiffPopup this$0, HierarchyEvent it) {
        if (!$owner.isDisplayable()) {
            this$0.dispose();
        }
    }

    private static final void scheduleHide$lambda$0(FontDiffPopup this$0, ActionEvent it) {
        this$0.hidePopup();
    }

    private static final void scheduleShow$lambda$0(FontDiffPopup this$0, JComponent $owner, Point $point, ActionEvent it) {
        this$0.cancelShowTimer();
        this$0.showPopup($owner, $point);
    }

    public static final /* synthetic */ JBPopup access$getPopup$p(FontDiffPopup $this) {
        return $this.popup;
    }

    public static final /* synthetic */ void access$setPopup$p(FontDiffPopup $this, JBPopup jBPopup) {
        $this.popup = jBPopup;
    }

    public static final /* synthetic */ void access$setInitialShowScheduled$p(FontDiffPopup $this, boolean bl) {
        $this.initialShowScheduled = bl;
    }

    public static final /* synthetic */ void access$scheduleShow(FontDiffPopup $this, int delayMs, JComponent owner, Point point) {
        $this.scheduleShow(delayMs, owner, point);
    }

    public static final /* synthetic */ void access$scheduleHide(FontDiffPopup $this) {
        $this.scheduleHide();
    }

    public static final /* synthetic */ boolean access$getInitialShowScheduled$p(FontDiffPopup $this) {
        return $this.initialShowScheduled;
    }

    public static final /* synthetic */ void access$setOverPopup$p(FontDiffPopup $this, boolean bl) {
        $this.isOverPopup = bl;
    }

    public static final /* synthetic */ void access$cancelHideTimer(FontDiffPopup $this) {
        $this.cancelHideTimer();
    }

    public static final /* synthetic */ List access$getProgrammingLigatures$cp() {
        return programmingLigatures;
    }

    public /* synthetic */ FontDiffPopup(Font firstFont, Font secondFont, String previewText, DefaultConstructorMarker $constructor_marker) {
        this(firstFont, secondFont, previewText);
    }

    static {
        Object[] objectArray = new String[]{"==", "===", "!=", "!==", "!~", "<>", "<=", ">=", "<=>", "->", "=>", "<-", "<--", "-->", "<->", "->>", "<<-", "|->", "~>", "<~", "<~>", "<~~", "~~>", "&&", "||", "!!", "??", "?.", "?:", "<<", ">>", ">>>", "<<<", ":=", "::=", "+=", "-=", "*=", "/=", "//=", "%=", "&=", "|=", "||=", "^=", "//", "///", "/*", "*/", "/**", "<!--", "{-", "-}", "\\\\", "::", ":::", "..", ".-", "...", "..=", "..-", "..<", ":-", "-:-", ":>:", ":<:", ".=", "++", "+++", "--", "**", "***", "%%", "##", "###", "<*>", "<$>", "<+>", "<<=", ">>=", "=<<", "~=", "=~", "[|", "|]", "/\\", "\\/", "|>", "<|", "<|>", "{|", "|}", "[<", ">]", "{.", ".}", "[]", "()", "{}", "</", "/>", "<?", "?>", "<%", "%>", "#[", "#(", "#![", "@_", "__", "0x"};
        programmingLigatures = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000f\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/application/options/editor/fonts/FontDiffPopup$Companion;", "", "<init>", "()V", "programmingLigatures", "", "", "diffForFeatures", "Lcom/intellij/application/options/editor/fonts/FontDiffPopup;", "fontGlyphCache", "Lcom/intellij/application/options/colors/FontGlyphHashCache;", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "previewChars", "features", "", "(Lcom/intellij/application/options/colors/FontGlyphHashCache;Lcom/intellij/openapi/editor/colors/EditorColorsScheme;Ljava/lang/String;[Ljava/lang/String;)Lcom/intellij/application/options/editor/fonts/FontDiffPopup;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nFontDiffPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontDiffPopup.kt\ncom/intellij/application/options/editor/fonts/FontDiffPopup$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,241:1\n1046#2,10:242\n1198#2:252\n1199#2:254\n1056#2:255\n1#3:253\n777#4:256\n873#4:257\n1786#4,3:258\n874#4:261\n*S KotlinDebug\n*F\n+ 1 FontDiffPopup.kt\ncom/intellij/application/options/editor/fonts/FontDiffPopup$Companion\n*L\n216#1:242,10\n216#1:252\n216#1:254\n216#1:255\n216#1:253\n223#1:256\n223#1:257\n227#1:258,3\n223#1:261\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final FontDiffPopup diffForFeatures(@NotNull FontGlyphHashCache fontGlyphCache, @NotNull EditorColorsScheme scheme, @NotNull String previewChars, String ... features) {
            Intrinsics.checkNotNullParameter((Object)fontGlyphCache, (String)"fontGlyphCache");
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            Intrinsics.checkNotNullParameter((Object)previewChars, (String)"previewChars");
            Intrinsics.checkNotNullParameter((Object)features, (String)"features");
            base = JBR.getFontExtensions().deriveFontWithFeatures(scheme.getFont(EditorFontType.PLAIN), new String[0]);
            derivedFont = JBR.getFontExtensions().deriveFontWithFeatures(scheme.getFont(EditorFontType.PLAIN), Arrays.copyOf(features, features.length));
            Intrinsics.checkNotNull((Object)base);
            baseKey = fontGlyphCache.computeCaches(base, (CharSequence)previewChars);
            Intrinsics.checkNotNull((Object)derivedFont);
            derivedKey = fontGlyphCache.computeCaches(derivedFont, (CharSequence)previewChars);
            var10_9 = previewChars;
            $i$f$mapNotNull = false;
            var12_12 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            for (var17_21 = 0; var17_21 < $this$forEach$iv$iv$iv.length(); ++var17_21) {
                element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv.charAt(var17_21);
                $i$a$-forEach-StringsKt___StringsKt$mapNotNullTo$1$iv$iv = false;
                char = element$iv$iv;
                $i$a$-mapNotNull-FontDiffPopup$Companion$diffForFeatures$previewText$1 = false;
                if ((fontGlyphCache.getGlyphCache(baseKey, char) != fontGlyphCache.getGlyphCache(derivedKey, char) ? Character.valueOf(char) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                $i$a$-let-StringsKt___StringsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            previewText = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            fontGlyphCache.computeLigatureCaches(base, FontDiffPopup.access$getProgrammingLigatures$cp());
            fontGlyphCache.computeLigatureCaches(derivedFont, FontDiffPopup.access$getProgrammingLigatures$cp());
            $i$f$mapNotNull = FontDiffPopup.access$getProgrammingLigatures$cp();
            $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                block7: {
                    ligature = (String)element$iv$iv;
                    $i$a$-filter-FontDiffPopup$Companion$diffForFeatures$ligatures$1 = false;
                    $this$diffForFeatures_u24lambda_u241_u240 = fontGlyphCache;
                    $i$a$-run-FontDiffPopup$Companion$diffForFeatures$ligatures$1$1 = false;
                    c1 = $this$diffForFeatures_u24lambda_u241_u240.getLigatureCache(baseKey, ligature);
                    c2 = $this$diffForFeatures_u24lambda_u241_u240.getLigatureCache(derivedKey, ligature);
                    if (c1 == null || c2 == null) ** GOTO lbl-1000
                    $this$all$iv = ArraysKt.zip((int[])c1, (int[])c2);
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        v0 = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            it = (Pair)element$iv;
                            $i$a$-all-FontDiffPopup$Companion$diffForFeatures$ligatures$1$1$1 = false;
                            if (((Number)it.getFirst()).intValue() != ((Number)it.getSecond()).intValue()) continue;
                            v0 = false;
                            break block7;
                        }
                        v0 = true;
                    }
                }
                if (v0) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            ligatures = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            previewText = ((CharSequence)previewText).length() == 0 != false ? ligatures : previewText + " " + ligatures;
            return new FontDiffPopup(base, derivedFont, previewText, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

