/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.EditableSchemesCombo;
import com.intellij.application.options.schemes.SchemeNameGenerator;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.NonTrivialActionGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.Groups;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSchemesPanel<T extends Scheme, InfoComponent extends JComponent>
extends JPanel {
    private EditableSchemesCombo<T> mySchemesCombo;
    private AbstractSchemeActions<T> myActions;
    private JComponent myToolbar;
    InfoComponent myInfoComponent;
    private JPanel myActionLinkContainer;
    private static final Color HINT_FOREGROUND = JBColor.GRAY;
    private static final Color ERROR_MESSAGE_FOREGROUND = Color.RED;
    protected static final int DEFAULT_VGAP = 8;
    private JSeparator mySettingsPanelSeparator;

    AbstractSchemesPanel() {
        this(8);
    }

    AbstractSchemesPanel(int vGap) {
        this.setLayout(new BoxLayout(this, 3));
        this.createUIComponents(vGap);
    }

    private void createUIComponents(int vGap) {
        JComponent bottomComponent;
        JPanel controlsPanel = this.createControlsPanel();
        this.add(controlsPanel);
        JComponent topComponent = this.createTopComponent();
        if (topComponent != null) {
            this.add(topComponent);
        }
        if ((bottomComponent = this.createBottomComponent()) != null) {
            this.add(bottomComponent);
        }
        this.mySettingsPanelSeparator = new JSeparator();
        this.add(this.mySettingsPanelSeparator);
        if (vGap > 0) {
            this.add(Box.createVerticalGlue());
            this.add(Box.createRigidArea((Dimension)new JBDimension(0, vGap)));
        }
    }

    public void setSeparatorVisible(boolean visible) {
        this.mySettingsPanelSeparator.setVisible(visible);
    }

    protected JComponent createTopComponent() {
        return null;
    }

    @Nullable
    protected JComponent createBottomComponent() {
        return null;
    }

    @NotNull
    private JPanel createControlsPanel() {
        JPanel controlsPanel = new JPanel();
        controlsPanel.setLayout(new BoxLayout(controlsPanel, 2));
        controlsPanel.setOpaque(false);
        String label2 = this.getComboBoxLabel();
        if (label2 != null) {
            controlsPanel.add(new JLabel(label2));
            controlsPanel.add(Box.createRigidArea((Dimension)new JBDimension(10, 0)));
        }
        this.myActions = this.createSchemeActions();
        this.mySchemesCombo = new EditableSchemesCombo(this);
        this.mySchemesCombo.setComboBoxAccessibleName(label2 != null ? label2 : this.getSchemeTypeName());
        controlsPanel.add(this.mySchemesCombo.getComponent());
        ActionToolbar toolbar2 = this.createToolbar();
        toolbar2.setTargetComponent(this.mySchemesCombo.getComponent());
        this.myToolbar = toolbar2.getComponent();
        this.myToolbar.setOpaque(false);
        controlsPanel.add(Box.createRigidArea((Dimension)new JBDimension(4, 0)));
        controlsPanel.add(this.myToolbar);
        controlsPanel.add(Box.createRigidArea((Dimension)new JBDimension(9, 0)));
        this.myActionLinkContainer = new JPanel();
        this.myActionLinkContainer.setLayout(new BoxLayout(this.myActionLinkContainer, 2));
        controlsPanel.add(this.myActionLinkContainer);
        this.updateActionLinkContainer();
        ContextHelpLabel contextHelpLabel = this.createContextHelpLabel();
        if (contextHelpLabel != null) {
            controlsPanel.add((Component)contextHelpLabel);
            controlsPanel.add(Box.createRigidArea((Dimension)new JBDimension(9, 0)));
        }
        this.myInfoComponent = this.createInfoComponent();
        controlsPanel.add((Component)this.myInfoComponent);
        controlsPanel.add(Box.createHorizontalGlue());
        this.updateComboboxMaximumSize();
        JPanel jPanel = controlsPanel;
        if (jPanel == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.getParent() != null) {
            this.updateComboboxMaximumSize();
        }
    }

    private void updateComboboxMaximumSize() {
        JComponent combobox = this.mySchemesCombo.getComponent();
        Dimension preferredSize = combobox.getPreferredSize();
        combobox.setMaximumSize(preferredSize);
        Container container = combobox.getParent();
        if (container != null) {
            container.setMaximumSize(new Dimension(container.getMaximumSize().width, preferredSize.height));
        }
        this.myToolbar.setMaximumSize(new Dimension(JBUIScale.scale((int)22), preferredSize.height));
    }

    private void updateActionLinkContainer() {
        ActionLink actionLink;
        this.myActionLinkContainer.removeAll();
        JLabel commentLabel = this.createActionLinkCommentLabel();
        if (commentLabel != null) {
            this.myActionLinkContainer.add(commentLabel);
            this.myActionLinkContainer.add(Box.createRigidArea((Dimension)new JBDimension(4, 0)));
        }
        if ((actionLink = this.createActionLink()) != null) {
            this.myActionLinkContainer.add((Component)actionLink);
            this.myActionLinkContainer.add(Box.createRigidArea((Dimension)new JBDimension(4, 0)));
        }
    }

    @NotNull
    private ActionToolbar createToolbar() {
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)new ShowSchemesActionsListAction(this.myActions));
        ActionToolbar toolbar2 = ActionManager.getInstance().createActionToolbar("SchemesPanelToolbar", (ActionGroup)group2, true);
        toolbar2.setReservePlaceAutoPopupIcon(false);
        JComponent toolbarComponent = toolbar2.getComponent();
        toolbarComponent.setBorder((Border)JBUI.Borders.empty());
        ActionToolbar actionToolbar2 = toolbar2;
        if (actionToolbar2 == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(1);
        }
        return actionToolbar2;
    }

    public final JComponent getToolbar() {
        return this.myToolbar;
    }

    @NotNull
    protected abstract AbstractSchemeActions<T> createSchemeActions();

    public final T getSelectedScheme() {
        return this.mySchemesCombo.getSelectedScheme();
    }

    public void selectScheme(@Nullable T scheme) {
        this.mySchemesCombo.selectScheme(scheme);
    }

    @Nullable
    private ContextHelpLabel createContextHelpLabel() {
        String text2 = this.getContextHelpLabelText();
        if (text2 == null) {
            return null;
        }
        return ContextHelpLabel.create((String)text2);
    }

    public final void resetSchemes(@NotNull Collection<? extends T> schemes) {
        if (schemes == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(2);
        }
        this.mySchemesCombo.resetSchemes(schemes);
    }

    public final void resetGroupedSchemes(@NotNull Groups<? extends T> schemeGroups) {
        if (schemeGroups == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(3);
        }
        this.mySchemesCombo.resetGroupedSchemes(schemeGroups);
    }

    public void disposeUIResources() {
        this.removeAll();
    }

    final void editCurrentSchemeName(@NotNull BiConsumer<? super T, ? super String> newSchemeNameConsumer) {
        Object currentScheme;
        if (newSchemeNameConsumer == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(4);
        }
        if ((currentScheme = this.getSelectedScheme()) != null) {
            String currentName = currentScheme.getName();
            this.mySchemesCombo.startEdit(currentName, this.getModel().isProjectScheme(currentScheme), newName -> {
                if (!newName.equals(currentName)) {
                    newSchemeNameConsumer.accept((Object)currentScheme, (String)newName);
                }
            });
        }
    }

    public final void editNewSchemeName(@NotNull String preferredName, boolean isProjectScheme, @NotNull Consumer<? super String> nameConsumer) {
        if (preferredName == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(5);
        }
        if (nameConsumer == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(6);
        }
        String name2 = SchemeNameGenerator.getUniqueName(preferredName, schemeName -> this.getModel().containsScheme((String)schemeName, isProjectScheme));
        this.mySchemesCombo.startEdit(name2, isProjectScheme, nameConsumer);
    }

    public final void cancelEdit() {
        this.mySchemesCombo.cancelEdit();
    }

    public final void showInfo(@NotNull @Nls String message, @NotNull MessageType messageType) {
        if (message == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(7);
        }
        if (messageType == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(8);
        }
        this.myToolbar.setVisible(false);
        this.showMessage(message, messageType);
    }

    protected abstract void showMessage(@NlsContexts.Label @Nullable String var1, @NotNull MessageType var2);

    final void clearInfo() {
        this.myToolbar.setVisible(true);
        this.clearMessage();
    }

    protected abstract void clearMessage();

    @NotNull
    public final AbstractSchemeActions<T> getActions() {
        AbstractSchemeActions<T> abstractSchemeActions = this.myActions;
        if (abstractSchemeActions == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(9);
        }
        return abstractSchemeActions;
    }

    @NotNull
    protected abstract InfoComponent createInfoComponent();

    @Nullable
    protected ActionLink createActionLink() {
        return null;
    }

    @Nullable
    protected JLabel createActionLinkCommentLabel() {
        return null;
    }

    @Nullable
    @Nls
    protected String getContextHelpLabelText() {
        return null;
    }

    @NlsContexts.Label
    @Nullable
    protected String getComboBoxLabel() {
        return this.getSchemeTypeName() + ":";
    }

    @NotNull
    @Nls
    protected String getSchemeTypeName() {
        String string = ApplicationBundle.message((String)"editbox.scheme.type.name", (Object[])new Object[0]);
        if (string == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public abstract SchemesModel<T> getModel();

    public final void updateOnCurrentSettingsChange() {
        this.mySchemesCombo.updateSelected();
    }

    protected int getIndent(@NotNull T scheme) {
        if (scheme == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(11);
        }
        return 0;
    }

    protected abstract boolean supportsProjectSchemes();

    protected abstract boolean highlightNonDefaultSchemes();

    protected boolean hideDeleteActionIfUnavailable() {
        return true;
    }

    public abstract boolean useBoldForNonRemovableSchemes();

    public void showStatus(@NlsContexts.PopupContent @NotNull String message, @NotNull MessageType messageType) {
        if (message == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(12);
        }
        if (messageType == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(13);
        }
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, messageType.getDefaultIcon(), messageType.getPopupBackground(), null);
        balloonBuilder.setFadeoutTime(5000L);
        Balloon balloon = balloonBuilder.createBalloon();
        Point pointOnComponent = new Point(this.myToolbar.getWidth() / 4, this.myToolbar.getHeight() / 4);
        balloon.show(new RelativePoint((Component)this.myToolbar, pointOnComponent), Balloon.Position.above);
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)balloon);
    }

    protected static void showMessage(@NlsContexts.Label @Nullable String message, @NotNull MessageType messageType, @NotNull JLabel infoComponent) {
        if (messageType == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(14);
        }
        if (infoComponent == null) {
            AbstractSchemesPanel.$$$reportNull$$$0(15);
        }
        infoComponent.setText(message);
        Color foreground = messageType == MessageType.INFO ? HINT_FOREGROUND : (messageType == MessageType.ERROR ? ERROR_MESSAGE_FOREGROUND : messageType.getTitleForeground());
        infoComponent.setForeground(foreground);
    }

    @Override
    public void setEnabled(boolean enabled2) {
        boolean oldEnabled = this.isEnabled();
        super.setEnabled(enabled2);
        this.mySchemesCombo.setEnabled(enabled2);
        if (oldEnabled != this.isEnabled()) {
            this.updateActionLinkContainer();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 11, 12, 13, 14, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/schemes/AbstractSchemesPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeGroups";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSchemeNameConsumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferredName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameConsumer";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createControlsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemesPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemeTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetSchemes";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetGroupedSchemes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "editCurrentSchemeName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "editNewSchemeName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showInfo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getIndent";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showStatus";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 11, 12, 13, 14, 15 -> new IllegalArgumentException(string);
        };
    }

    private static final class ShowSchemesActionsListAction
    extends NonTrivialActionGroup
    implements DumbAware {
        private final AbstractSchemeActions<?> mySchemeActions;

        ShowSchemesActionsListAction(AbstractSchemeActions<?> schemeActions) {
            this.setPopup(true);
            this.mySchemeActions = schemeActions;
            this.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
            this.getTemplatePresentation().setText(IdeBundle.messagePointer((String)"action.presentation.AbstractSchemesPanel.text", (Object[])new Object[0]));
            this.getTemplatePresentation().setDescription(IdeBundle.messagePointer((String)"action.presentation.AbstractSchemesPanel.description", (Object[])new Object[0]));
            this.getTemplatePresentation().setPerformGroup(true);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = this.mySchemeActions.getActions().toArray(EMPTY_ARRAY);
            if (anActionArray == null) {
                ShowSchemesActionsListAction.$$$reportNull$$$0(0);
            }
            return anActionArray;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowSchemesActionsListAction.$$$reportNull$$$0(1);
            }
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)this, e.getDataContext(), true, null, Integer.MAX_VALUE);
            popup2.setShowSubmenuOnHover(true);
            HelpTooltip.setMasterPopup((Component)e.getInputEvent().getComponent(), (JBPopup)popup2);
            Component component2 = e.getInputEvent().getComponent();
            if (component2 instanceof ActionButtonComponent) {
                popup2.showUnderneathOf(component2);
            } else {
                popup2.showInCenterOf(component2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/schemes/AbstractSchemesPanel$ShowSchemesActionsListAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemesPanel$ShowSchemesActionsListAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

