/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.google.gson.stream.JsonWriter;
import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.ITNReporter;
import com.intellij.diagnostic.hprof.action.AnalysisRunnableKt;
import com.intellij.diagnostic.report.HeapReportProperties;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0010\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\nH\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/diagnostic/HeapDumpAnalysisSupport;", "", "<init>", "()V", "getPrivacyPolicyUrl", "", "uploadReport", "", "reportText", "heapReportProperties", "Lcom/intellij/diagnostic/report/HeapReportProperties;", "parentComponent", "Ljava/awt/Component;", "checkPendingSnapshot", "", "saveSnapshotForAnalysis", "hprofPath", "Ljava/nio/file/Path;", "reportProperties", "analysisFailed", "heapProperties", "analysisComplete", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nHeapDumpAnalysisSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeapDumpAnalysisSupport.kt\ncom/intellij/diagnostic/HeapDumpAnalysisSupport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public class HeapDumpAnalysisSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getPrivacyPolicyUrl() {
        return "https://www.jetbrains.com/company/privacy.html";
    }

    public void uploadReport(@NotNull String reportText, @NotNull HeapReportProperties heapReportProperties, @NotNull Component parentComponent) {
        block0: {
            Attachment attachment;
            Intrinsics.checkNotNullParameter((Object)reportText, (String)"reportText");
            Intrinsics.checkNotNullParameter((Object)heapReportProperties, (String)"heapReportProperties");
            Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
            String text2 = AnalysisRunnableKt.getHeapDumpReportText(reportText, heapReportProperties);
            Attachment $this$uploadReport_u24lambda_u240 = attachment = new Attachment("report.txt", text2);
            boolean bl = false;
            $this$uploadReport_u24lambda_u240.setIncluded(true);
            Attachment attachment2 = attachment;
            attachment2.setIncluded(true);
            IdeaLoggingEvent event = new IdeaLoggingEvent("Heap analysis results", (Throwable)new OutOfMemoryError(), CollectionsKt.listOf((Object)attachment2), null, null);
            ITNReporter iTNReporter = (ITNReporter)((Object)ErrorReportSubmitter.EP_NAME.findExtension(ITNReporter.class));
            if (iTNReporter == null) break block0;
            IdeaLoggingEvent[] ideaLoggingEventArray = new IdeaLoggingEvent[]{event};
            iTNReporter.submit(ideaLoggingEventArray, null, parentComponent, (Consumer<? super SubmittedReportInfo>)((Consumer)arg_0 -> HeapDumpAnalysisSupport.uploadReport$lambda$2(HeapDumpAnalysisSupport::uploadReport$lambda$1, arg_0)));
        }
    }

    public boolean checkPendingSnapshot() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSnapshotForAnalysis(@NotNull Path hprofPath, @NotNull HeapReportProperties reportProperties) {
        Intrinsics.checkNotNullParameter((Object)hprofPath, (String)"hprofPath");
        Intrinsics.checkNotNullParameter((Object)reportProperties, (String)"reportProperties");
        Object object = new String[]{"pending-snapshot.json"};
        Path jsonPath = Path.of(PathManager.getSystemPath(), object);
        Intrinsics.checkNotNull((Object)jsonPath);
        object = jsonPath;
        OpenOption[] openOptionArray = new OpenOption[]{};
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        object = (Closeable)new JsonWriter((Writer)new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n));
        object2 = null;
        try {
            JsonWriter it = (JsonWriter)object;
            boolean bl = false;
            it.beginObject();
            it.name("path").value(((Object)hprofPath).toString());
            it.name("reason").value(reportProperties.getReason().toString());
            it.name("liveStats").value(reportProperties.getLiveStats());
            JsonWriter jsonWriter = it.endObject();
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    public void analysisFailed(@NotNull HeapReportProperties heapProperties) {
        Intrinsics.checkNotNullParameter((Object)heapProperties, (String)"heapProperties");
    }

    public void analysisComplete(@NotNull HeapReportProperties heapProperties) {
        Intrinsics.checkNotNullParameter((Object)heapProperties, (String)"heapProperties");
    }

    private static final Unit uploadReport$lambda$1(SubmittedReportInfo it) {
        return Unit.INSTANCE;
    }

    private static final void uploadReport$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/diagnostic/HeapDumpAnalysisSupport$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/diagnostic/HeapDumpAnalysisSupport;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nHeapDumpAnalysisSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeapDumpAnalysisSupport.kt\ncom/intellij/diagnostic/HeapDumpAnalysisSupport$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,106:1\n42#2,3:107\n*S KotlinDebug\n*F\n+ 1 HeapDumpAnalysisSupport.kt\ncom/intellij/diagnostic/HeapDumpAnalysisSupport$Companion\n*L\n25#1:107,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HeapDumpAnalysisSupport getInstance() {
            boolean $i$f$service = false;
            Class<HeapDumpAnalysisSupport> serviceClass$iv = HeapDumpAnalysisSupport.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (HeapDumpAnalysisSupport)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

