/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.KnownFolders;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.Shell32Util;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowsDefenderChecker {
    private static final Logger LOG = Logger.getInstance(WindowsDefenderChecker.class);
    private static final String IGNORE_STATUS_CHECK = "ignore.virus.scanning.warn.message";
    private static final String HELPER_SCRIPT_NAME = "defender-exclusions.ps1";
    private static final int WMIC_COMMAND_TIMEOUT_MS = 10000;
    private static final int POWERSHELL_COMMAND_TIMEOUT_MS = 60000;
    private static final ExtensionPointName<Extension> EP_NAME = ExtensionPointName.create((String)"com.intellij.defender.config");
    private final Map<Path, @Nullable ProjectStatus> myProjectPaths = Collections.synchronizedMap(new HashMap());
    private static final int FSCTL_QUERY_PERSISTENT_VOLUME_STATE = 590396;
    private static final int PERSISTENT_VOLUME_STATE_DEV_VOLUME = 8192;
    private static final int PERSISTENT_VOLUME_STATE_TRUSTED_VOLUME = 16384;

    public static WindowsDefenderChecker getInstance() {
        return (WindowsDefenderChecker)ApplicationManager.getApplication().getService(WindowsDefenderChecker.class);
    }

    public final boolean isStatusCheckIgnored(@Nullable Project project2) {
        return !Registry.is((String)"ide.check.windows.defender.rules") || PropertiesComponent.getInstance().isTrueValue(IGNORE_STATUS_CHECK) || project2 != null && PropertiesComponent.getInstance((Project)project2).isTrueValue(IGNORE_STATUS_CHECK);
    }

    public final void ignoreStatusCheck(@Nullable Project project2, boolean ignore) {
        PropertiesComponent component2;
        WindowsDefenderChecker.logCaller("ignore=" + ignore + " scope=" + String.valueOf(project2 == null ? "global" : project2));
        PropertiesComponent propertiesComponent = component2 = project2 == null ? PropertiesComponent.getInstance() : PropertiesComponent.getInstance((Project)project2);
        if (ignore) {
            component2.setValue(IGNORE_STATUS_CHECK, true);
        } else {
            component2.unsetValue(IGNORE_STATUS_CHECK);
        }
    }

    @ApiStatus.Internal
    public final void markProjectPath(@NotNull Path projectPath, boolean skip) {
        if (projectPath == null) {
            WindowsDefenderChecker.$$$reportNull$$$0(0);
        }
        this.myProjectPaths.put(projectPath, skip ? ProjectStatus.SKIPPED : null);
    }

    @ApiStatus.Internal
    @RequiresBackgroundThread
    @Nullable
    final ProjectStatus isAlreadyProcessed(@NotNull Project project2) {
        if (project2 == null) {
            WindowsDefenderChecker.$$$reportNull$$$0(1);
        }
        ThreadingAssertions.assertBackgroundThread();
        Path projectPath = WindowsDefenderChecker.getProjectPath(project2);
        if (projectPath != null && this.myProjectPaths.containsKey(projectPath)) {
            while (!project2.isDisposed() && this.myProjectPaths.get(projectPath) == null) {
                TimeoutUtil.sleep((long)100L);
            }
            ProjectStatus status2 = this.myProjectPaths.remove(projectPath);
            if (status2 == ProjectStatus.SUCCEED) {
                PropertiesComponent.getInstance((Project)project2).setValue(IGNORE_STATUS_CHECK, true);
            }
            return status2;
        }
        return null;
    }

    @Nullable
    private static Path getProjectPath(Project project2) {
        String basePath = project2.getBasePath();
        if (basePath != null) {
            return Path.of(basePath, new String[0]);
        }
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project2);
        return projectDir != null && projectDir.isInLocalFileSystem() ? projectDir.toNioPath() : null;
    }

    @Nullable
    public final Boolean isRealTimeProtectionEnabled() {
        if (!JnaLoader.isLoaded()) {
            LOG.debug("isRealTimeProtectionEnabled: JNA is not loaded");
            return null;
        }
        try {
            WinNT.HRESULT comInit = Ole32.INSTANCE.CoInitializeEx(null, 2);
            if (LOG.isDebugEnabled()) {
                LOG.debug("CoInitializeEx: " + String.valueOf(comInit));
            }
            WbemcliUtil.WmiQuery avQuery = new WbemcliUtil.WmiQuery("Root\\SecurityCenter2", "AntivirusProduct", AntivirusProduct.class);
            WbemcliUtil.WmiResult avResult = avQuery.execute(10000);
            if (LOG.isDebugEnabled()) {
                LOG.debug(avQuery.getWmiClassName() + ": " + avResult.getResultCount());
            }
            for (int i2 = 0; i2 < avResult.getResultCount(); ++i2) {
                Integer intState;
                boolean enabled2;
                String s;
                Object name2 = avResult.getValue((Enum)AntivirusProduct.DisplayName, i2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("DisplayName[" + i2 + "]: " + String.valueOf(name2) + " (" + name2.getClass().getName() + ")");
                }
                if (!(name2 instanceof String) || !(s = (String)name2).contains("Windows Defender") && !s.contains("Microsoft Defender")) continue;
                Object state2 = avResult.getValue((Enum)AntivirusProduct.ProductState, i2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ProductState: " + String.valueOf(state2) + " (" + state2.getClass().getName() + ")");
                }
                boolean bl = enabled2 = state2 instanceof Integer && ((intState = (Integer)state2) & 0x1000) != 0;
                if (enabled2) break;
                return false;
            }
            WbemcliUtil.WmiQuery statusQuery = new WbemcliUtil.WmiQuery("Root\\Microsoft\\Windows\\Defender", "MSFT_MpComputerStatus", MpComputerStatus.class);
            WbemcliUtil.WmiResult statusResult = statusQuery.execute(10000);
            if (LOG.isDebugEnabled()) {
                LOG.debug(statusQuery.getWmiClassName() + ": " + statusResult.getResultCount());
            }
            if (statusResult.getResultCount() != 1) {
                return false;
            }
            Object rtProtection = statusResult.getValue((Enum)MpComputerStatus.RealTimeProtectionEnabled, 0);
            if (LOG.isDebugEnabled()) {
                LOG.debug("RealTimeProtectionEnabled: " + String.valueOf(rtProtection) + " (" + rtProtection.getClass().getName() + ")");
            }
            return Boolean.TRUE.equals(rtProtection);
        }
        catch (COMException e) {
            if (e.matchesErrorCode(-2147217394)) {
                return false;
            }
            Object message = "WMI Microsoft Defender check failed";
            WinNT.HRESULT hresult = e.getHresult();
            if (hresult != null) {
                message = (String)message + " [0x" + Integer.toHexString(hresult.intValue()) + "]";
            }
            LOG.warn((String)message, (Throwable)e);
            return null;
        }
        catch (Exception e) {
            LOG.warn("WMI Microsoft Defender check failed", (Throwable)e);
            return null;
        }
    }

    public final boolean isUntrustworthyLocation(@NotNull Path path) {
        String tempVar;
        if (path == null) {
            WindowsDefenderChecker.$$$reportNull$$$0(2);
        }
        if ((tempVar = System.getenv("TEMP")) != null && path.startsWith(Path.of(tempVar, new String[0]))) {
            return true;
        }
        Path downloadDir = null;
        if (JnaLoader.isLoaded()) {
            try {
                downloadDir = Path.of(Shell32Util.getKnownFolderPath((Guid.GUID)KnownFolders.FOLDERID_Downloads), new String[0]);
            }
            catch (Exception e) {
                LOG.warn("download dir detection failed", (Throwable)e);
            }
        }
        if (downloadDir == null) {
            downloadDir = Path.of(System.getProperty("user.home"), "Downloads");
        }
        return path.startsWith(downloadDir);
    }

    @NotNull
    public final List<Path> getPathsToExclude(@NotNull Project project2) {
        if (project2 == null) {
            WindowsDefenderChecker.$$$reportNull$$$0(3);
        }
        Set<Path> paths = this.doGetPathsToExclude(project2, null);
        Path projectPath = WindowsDefenderChecker.getProjectPath(project2);
        if (projectPath != null) {
            paths.add(projectPath);
        }
        return new ArrayList<Path>(paths);
    }

    @NotNull
    public final List<Path> getPathsToExclude(@Nullable Project project2, @NotNull Path projectPath) {
        if (projectPath == null) {
            WindowsDefenderChecker.$$$reportNull$$$0(4);
        }
        Set<Path> paths = this.doGetPathsToExclude(project2, projectPath);
        paths.add(projectPath);
        return new ArrayList<Path>(paths);
    }

    private Set<Path> doGetPathsToExclude(@Nullable Project project2, @Nullable Path projectPath) {
        TreeSet<Path> paths = new TreeSet<Path>();
        paths.add(PathManager.getSystemDir());
        EP_NAME.forEachExtensionSafe(ext -> paths.addAll(ext.getPaths(project2, projectPath)));
        return paths;
    }

    /*
     * Loose catch block
     */
    @NotNull
    public final List<Path> filterDevDrivePaths(@NotNull List<Path> paths) {
        if (paths == null) {
            WindowsDefenderChecker.$$$reportNull$$$0(5);
        }
        if (paths.isEmpty()) {
            List<Path> list2 = paths;
            if (list2 == null) {
                WindowsDefenderChecker.$$$reportNull$$$0(6);
            }
            return list2;
        }
        if (!JnaLoader.isLoaded()) {
            LOG.debug("filterDevDrivePaths: JNA is not loaded");
            List<Path> list3 = paths;
            if (list3 == null) {
                WindowsDefenderChecker.$$$reportNull$$$0(7);
            }
            return list3;
        }
        Long buildNumber = SystemInfo.getWinBuildNumber();
        if (buildNumber == null || buildNumber < 22621L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("DevDrive feature is not supported on " + buildNumber);
            }
            List<Path> list4 = paths;
            if (list4 == null) {
                WindowsDefenderChecker.$$$reportNull$$$0(8);
            }
            return list4;
        }
        FILE_FS_PERSISTENT_VOLUME_INFORMATION volInfo = new FILE_FS_PERSISTENT_VOLUME_INFORMATION();
        List<Path> list5 = paths.stream().filter(path -> !WindowsDefenderChecker.isOnDevDrive(path, volInfo)).toList();
        volInfo.close();
        List<Path> list6 = list5;
        if (list6 == null) {
            WindowsDefenderChecker.$$$reportNull$$$0(9);
        }
        return list6;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        volInfo.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.warn("DevDrive detection failed", (Throwable)e);
                    List<Path> list7 = paths;
                    if (list7 == null) {
                        WindowsDefenderChecker.$$$reportNull$$$0(10);
                    }
                    return list7;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isOnDevDrive(Path path, FILE_FS_PERSISTENT_VOLUME_INFORMATION volInfo) {
        WinNT.HANDLE handle2 = Kernel32.INSTANCE.CreateFile(path.toString(), 128, 3, null, 3, 0x2000000, null);
        if (handle2 == WinBase.INVALID_HANDLE_VALUE) {
            int err = Kernel32.INSTANCE.GetLastError();
            LOG.warn("CreateFile(" + String.valueOf(path) + "): " + err + ": " + Kernel32Util.formatMessageFromLastErrorCode((int)err));
            return false;
        }
        try {
            volInfo.FlagMask = 24576;
            volInfo.Version = 1;
            volInfo.write();
            if (Kernel32.INSTANCE.DeviceIoControl(handle2, 590396, volInfo.getPointer(), volInfo.size(), volInfo.getPointer(), volInfo.size(), null, null)) {
                volInfo.read();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.valueOf(path) + ": 0x" + Integer.toHexString(volInfo.VolumeFlags));
                }
                boolean err = volInfo.VolumeFlags == 24576;
                return err;
            }
            if (LOG.isDebugEnabled()) {
                int err = Kernel32.INSTANCE.GetLastError();
                LOG.debug("DeviceIoControl(" + String.valueOf(path) + "): " + err + ": " + Kernel32Util.formatMessageFromLastErrorCode((int)err));
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Kernel32.INSTANCE.CloseHandle(handle2);
        }
    }

    public final boolean excludeProjectPaths(@NotNull Project project2, @NotNull List<Path> paths) {
        if (project2 == null) {
            WindowsDefenderChecker.$$$reportNull$$$0(11);
        }
        if (paths == null) {
            WindowsDefenderChecker.$$$reportNull$$$0(12);
        }
        return this.doExcludeProjectPaths(project2, null, paths);
    }

    @ApiStatus.Internal
    public final boolean excludeProjectPaths(@Nullable Project project2, @NotNull Path projectPath, @NotNull List<Path> paths) {
        if (projectPath == null) {
            WindowsDefenderChecker.$$$reportNull$$$0(13);
        }
        if (paths == null) {
            WindowsDefenderChecker.$$$reportNull$$$0(14);
        }
        return this.doExcludeProjectPaths(project2, projectPath, paths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doExcludeProjectPaths(@Nullable Project project2, @Nullable Path projectPath, List<Path> paths) {
        WindowsDefenderChecker.logCaller("paths=" + String.valueOf(paths) + " project=" + String.valueOf(project2 != null ? project2 : projectPath));
        ProjectStatus result2 = ProjectStatus.FAILED;
        try {
            Path script = PathManager.findBinFile((String)HELPER_SCRIPT_NAME);
            if (script == null) {
                LOG.info("'defender-exclusions.ps1' is missing from '" + String.valueOf(PathManager.getBinDir()) + "'");
                boolean bl = false;
                return bl;
            }
            File psh = PathEnvironmentVariableUtil.findInPath((String)"powershell.exe");
            if (psh == null) {
                psh = PathEnvironmentVariableUtil.findInPath((String)"pwsh.exe");
            }
            if (psh == null) {
                LOG.info("no 'powershell.exe' or 'pwsh.exe' on " + PathEnvironmentVariableUtil.getPathVariableValue());
                boolean bl = false;
                return bl;
            }
            Path pshPath = psh.toPath();
            boolean sane = Stream.of("SystemRoot", "ProgramFiles").map(System::getenv).anyMatch(val -> val != null && pshPath.startsWith((String)val));
            if (!sane) {
                LOG.info("suspicious 'powershell.exe' location: " + String.valueOf(psh));
                boolean bl = false;
                return bl;
            }
            String scriptlet = "(Get-AuthenticodeSignature '" + script.toString().replace("'", "''") + "').Status";
            ProcessBuilder command = new ProcessBuilder(psh.getPath(), "-NoProfile", "-NonInteractive", "-Command", scriptlet);
            long start2 = System.nanoTime();
            ProcessOutput output = WindowsDefenderChecker.run(command, Charset.defaultCharset());
            if (output.getExitCode() != 0) {
                WindowsDefenderChecker.logProcessError("validation failed", command, start2, output);
                boolean bl = false;
                return bl;
            }
            String status2 = output.getStdout().trim();
            if ("NotSigned".equals(status2) && ApplicationInfo.getInstance().getBuild().isSnapshot()) {
                LOG.info("allowing unsigned helper in dev. build " + String.valueOf(ApplicationInfo.getInstance().getBuild()));
            } else if (!"Valid".equals(status2)) {
                LOG.info("validation failed: status='" + status2 + "'");
                boolean bl = false;
                return bl;
            }
            Path launcher = PathManager.findBinFileWithException((String)"launcher.exe");
            command = new ProcessBuilder(Stream.concat(Stream.of(launcher.toString(), psh.getPath(), "-ExecutionPolicy", "Bypass", "-NoProfile", "-NonInteractive", "-File", script.toString()), paths.stream().map(Path::toString)).toList());
            start2 = System.nanoTime();
            output = WindowsDefenderChecker.run(command, StandardCharsets.UTF_8);
            if (output.getExitCode() != 0) {
                WindowsDefenderChecker.logProcessError("exclusion failed", command, start2, output);
                boolean bl = false;
                return bl;
            }
            LOG.info("OK; script output:\n" + output.getStdout().trim());
            if (project2 != null) {
                PropertiesComponent.getInstance((Project)project2).setValue(IGNORE_STATUS_CHECK, true);
            }
            result2 = ProjectStatus.SUCCEED;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (project2 == null) {
                this.myProjectPaths.put(projectPath, result2);
            }
        }
    }

    private static ProcessOutput run(ProcessBuilder command, Charset charset) throws IOException {
        Path tempDir = NioFiles.createDirectories((Path)PathManager.getTempDir());
        command.environment().put("PSModulePath", "");
        command.redirectErrorStream(true);
        command.directory(tempDir.toFile());
        return new CapturingProcessHandler(command.start(), charset, "PowerShell").runProcess(60000);
    }

    private static void logProcessError(String prefix, ProcessBuilder command, long start2, ProcessOutput output) {
        long t = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start2);
        LOG.info(prefix + ":\n[" + output.getExitCode() + ", " + t + "ms] " + String.valueOf(command.command()) + "\noutput: " + output.getStdout().trim());
    }

    private static void logCaller(String prefix) {
        EnumSet<StackWalker.Option> options2 = EnumSet.of(StackWalker.Option.SHOW_HIDDEN_FRAMES, StackWalker.Option.SHOW_REFLECT_FRAMES);
        String trace = StackWalker.getInstance(options2).walk(stack -> stack.skip(1L).limit(10L).map(frame -> "  " + String.valueOf(frame.toStackTraceElement())).collect(Collectors.joining("\n", prefix + "; called from:\n", "\n  ...")));
        LOG.info(trace);
    }

    @NotNull
    public String getConfigurationInstructionsUrl() {
        return "https://intellij.com/antivirus-impact-on-build-speed";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 1: 
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/WindowsDefenderChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/WindowsDefenderChecker";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDevDrivePaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "markProjectPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAlreadyProcessed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUntrustworthyLocation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPathsToExclude";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterDevDrivePaths";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "excludeProjectPaths";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    static enum ProjectStatus {
        SKIPPED,
        SUCCEED,
        FAILED;

    }

    private static enum AntivirusProduct {
        DisplayName,
        ProductState;

    }

    private static enum MpComputerStatus {
        RealTimeProtectionEnabled;

    }

    @Structure.FieldOrder(value={"VolumeFlags", "FlagMask", "Version", "Reserved"})
    @ApiStatus.Internal
    public static final class FILE_FS_PERSISTENT_VOLUME_INFORMATION
    extends Structure
    implements AutoCloseable {
        public int VolumeFlags;
        public int FlagMask;
        public int Version;
        public int Reserved;

        @Override
        public void close() {
            Pointer pointer = this.getPointer();
            if (pointer instanceof Memory) {
                Memory m = (Memory)pointer;
                m.close();
            }
        }
    }

    public static interface Extension {
        @NotNull
        public Collection<Path> getPaths(@Nullable Project var1, @Nullable Path var2);
    }
}

