/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.openapi.application.WriteDelayDiagnostics;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/diagnostic/WriteDelayDiagnosticsHandlerImpl;", "Lcom/intellij/openapi/application/WriteDelayDiagnostics$WriteDelayDiagnosticsHandler;", "<init>", "()V", "count", "", "totalTime", "maxTime", "delaysMap", "", "registerWrite", "", "waitTime", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nWriteDelayDiagnosticsHandlerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WriteDelayDiagnosticsHandlerImpl.kt\ncom/intellij/diagnostic/WriteDelayDiagnosticsHandlerImpl\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,66:1\n614#2:67\n1342#2,2:68\n*S KotlinDebug\n*F\n+ 1 WriteDelayDiagnosticsHandlerImpl.kt\ncom/intellij/diagnostic/WriteDelayDiagnosticsHandlerImpl\n*L\n43#1:67\n45#1:68,2\n*E\n"})
public final class WriteDelayDiagnosticsHandlerImpl
implements WriteDelayDiagnostics.WriteDelayDiagnosticsHandler {
    private long count;
    private long totalTime;
    private long maxTime;
    @NotNull
    private final Map<Long, Long> delaysMap = new LinkedHashMap();

    public WriteDelayDiagnosticsHandlerImpl() {
        Meter meter = TelemetryManager.Companion.getInstance().getMeter(PlatformScopesKt.PlatformMetrics);
        ObservableLongMeasurement countObservableCounter = meter.counterBuilder("writeAction.count").setDescription("Number of write actions run").buildObserver();
        ObservableLongMeasurement timeObservableCounter = meter.counterBuilder("writeAction.wait.ms").setDescription("Total time waiting for the write lock").setUnit("ms").buildObserver();
        ObservableLongMeasurement maxTimeObservableGauge = meter.gaugeBuilder("writeAction.max.wait.ms").ofLongs().setDescription("Max time waiting for the write lock").setUnit("ms").buildObserver();
        ObservableLongMeasurement medianTimeObservableGauge = meter.gaugeBuilder("writeAction.median.wait.ms").ofLongs().setDescription("Median time waiting for the write lock, step 100 ms").setUnit("ms").buildObserver();
        ObservableMeasurement[] observableMeasurementArray = new ObservableMeasurement[]{timeObservableCounter, maxTimeObservableGauge, medianTimeObservableGauge};
        meter.batchCallback(() -> WriteDelayDiagnosticsHandlerImpl._init_$lambda$0(this, countObservableCounter, timeObservableCounter, maxTimeObservableGauge, medianTimeObservableGauge), (ObservableMeasurement)countObservableCounter, observableMeasurementArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerWrite(long waitTime) {
        WriteDelayDiagnosticsHandlerImpl writeDelayDiagnosticsHandlerImpl = this;
        synchronized (writeDelayDiagnosticsHandlerImpl) {
            boolean bl = false;
            long l = this.count;
            this.count = l + 1L;
            this.totalTime += waitTime;
            if (this.maxTime < waitTime) {
                this.maxTime = waitTime;
            }
            long timeBucket = this.totalTime / (long)100;
            this.delaysMap.put(timeBucket, ((Number)this.delaysMap.getOrDefault(timeBucket, 0L)).longValue() + 1L);
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final boolean lambda$0$0$1(Ref.LongRef $currentCount, WriteDelayDiagnosticsHandlerImpl this$0, Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $currentCount.element < this$0.count / (long)2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void _init_$lambda$0(WriteDelayDiagnosticsHandlerImpl this$0, ObservableLongMeasurement $countObservableCounter, ObservableLongMeasurement $timeObservableCounter, ObservableLongMeasurement $maxTimeObservableGauge, ObservableLongMeasurement $medianTimeObservableGauge) {
        WriteDelayDiagnosticsHandlerImpl writeDelayDiagnosticsHandlerImpl = this$0;
        synchronized (writeDelayDiagnosticsHandlerImpl) {
            void $this$forEach$iv;
            Sequence $this$sortedBy$iv;
            boolean bl = false;
            $countObservableCounter.record(this$0.count);
            $timeObservableCounter.record(this$0.totalTime);
            $maxTimeObservableGauge.record(this$0.maxTime);
            Ref.LongRef currentCount = new Ref.LongRef();
            long medianValue = 0L;
            Sequence sequence = CollectionsKt.asSequence((Iterable)this$0.delaysMap.entrySet());
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = SequencesKt.takeWhile((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = (Long)it.getKey();
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Long)it.getKey()));
                }
            }), arg_0 -> WriteDelayDiagnosticsHandlerImpl.lambda$0$0$1(currentCount, this$0, arg_0));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl2 = false;
                medianValue = ((Number)it.getKey()).longValue() * (long)100;
                currentCount.element += ((Number)it.getValue()).longValue();
            }
            $medianTimeObservableGauge.record(medianValue);
            Unit unit = Unit.INSTANCE;
        }
    }
}

